/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.lang.reflect.Constructor;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorCreator;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroupState;

final class EditorState
implements EditorInfo {
    private static final String KEY_XSCROLL_MIN = "xScrollMin";
    private static final String KEY_XSCROLL_MAX = "xScrollMax";
    private static final String KEY_XSCROLL_EXT = "xScrollExtent";
    private static final String KEY_XSCROLL_POS = "xScrollPos";
    private static final String KEY_YSCROLL_MIN = "yScrollMin";
    private static final String KEY_YSCROLL_MAX = "yScrollMax";
    private static final String KEY_YSCROLL_EXT = "yScrollExtent";
    private static final String KEY_YSCROLL_POS = "yScrollPos";
    private SplitPaneState _parentSplitPaneState;
    private final EditorAddin _editorAddin;
    private Editor _editor;
    private boolean _enabled = true;
    private Component _focusedComponent;
    private int _xScrollMin;
    private int _xScrollMax;
    private int _xScrollExtent;
    private int _xScrollPos;
    private int _yScrollMin;
    private int _yScrollMax;
    private int _yScrollExtent;
    private int _yScrollPos;
    private StructuredPropertyAccess _layoutInfo;

    public EditorState(SplitPaneState parent, EditorAddin editorAddin) {
        this._parentSplitPaneState = parent;
        this._editorAddin = editorAddin;
    }

    SplitPaneState getParentSplitPaneState() {
        return this._parentSplitPaneState;
    }

    public EditorAddin getEditorAddin() {
        return this._editorAddin;
    }

    public Editor getEditor() {
        return this._editor;
    }

    private Editor giveUpEditor() {
        Editor ret = this.getEditor();
        this.setEditor(null);
        return ret;
    }

    public Editor getOrCreateEditor(Context context) {
        Editor ret = this.getEditor();
        if (ret != null || (ret = this.createEditor(context)) != null) {
            // empty if block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Editor createEditor(Context context) {
        Editor editor;
        block14: {
            editor = null;
            Editor stolenEditor = this.stealEditor();
            if (stolenEditor != null) {
                editor = stolenEditor;
                this.setEditor(stolenEditor);
                return editor;
            }
            try {
                EditorAddin editorAddin = this.getEditorAddin();
                if (editorAddin instanceof EditorCreator) {
                    try {
                        editor = ((EditorCreator)editorAddin).createEditor(context);
                        editor.setEditorAddin(editorAddin);
                    }
                    catch (Exception e) {
                        FeedbackManager.reportException((String)("Failed to create an instance of editor " + editorAddin.getClass().getName()), (Throwable)e);
                    }
                } else {
                    Class editorClass = editorAddin.getEditorClass();
                    try {
                        Constructor ctor = editorClass.getDeclaredConstructor(new Class[0]);
                        ctor.setAccessible(true);
                        editor = (Editor)ctor.newInstance(new Object[0]);
                        editor.setEditorAddin(editorAddin);
                    }
                    catch (Exception e2) {
                        FeedbackManager.reportException((String)("Failed to create an instance of editor " + editorClass.getName()), (Throwable)e2);
                    }
                }
                if (editor == null) break block14;
                try {
                    editor.setContext(context);
                }
                catch (Exception e) {
                    FeedbackManager.reportException((String)("Problem setting editor context. Failed to open editor " + editor.getClass().getName()), (Throwable)e);
                    Editor e2 = null;
                    if (editor == null) return e2;
                    Node node = context.getNode();
                    String nodeLabel = node != null ? node.getShortLabel() : editor.getTabLabel();
                    return e2;
                }
            }
            catch (Throwable throwable) {
                if (editor == null) throw throwable;
                Node node = context.getNode();
                String nodeLabel = node != null ? node.getShortLabel() : editor.getTabLabel();
                throw throwable;
            }
            EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
            try {
                editorManager.initPreferredLayoutInfo(editor, context);
            }
            catch (Exception e) {
                FeedbackManager.reportException((String)("Problem activating preferred layout for editor " + editor.getClass().getName()), (Throwable)e);
            }
            if (this.openEditor(editor)) break block14;
            Editor editor2 = null;
            if (editor == null) return editor2;
            Node node = context.getNode();
            String nodeLabel = node != null ? node.getShortLabel() : editor.getTabLabel();
            return editor2;
        }
        if (editor == null) return editor;
        Node node = context.getNode();
        String nodeLabel = node != null ? node.getShortLabel() : editor.getTabLabel();
        return editor;
    }

    private Editor stealEditor() {
        Editor ret = null;
        if (!this.isSplittable()) {
            TabGroupState parentTabGroupState;
            EditorAddin editorAddin = this.getEditorAddin();
            SplitPaneState parentSplitPaneState = this.getParentSplitPaneState();
            if (parentSplitPaneState != null && (parentTabGroupState = parentSplitPaneState.getParentTabGroupState()) != null) {
                int splitPaneStateCount = parentTabGroupState.getSplitPaneStateCount();
                for (int i = 0; ret == null && i < splitPaneStateCount; ++i) {
                    SplitPaneState splitPaneState = parentTabGroupState.getSplitPaneState(i);
                    int editorStateCount = splitPaneState.getEditorStateCount();
                    for (int j = 0; ret == null && j < editorStateCount; ++j) {
                        EditorState editorState = splitPaneState.getEditorState(j);
                        if (editorState == this || editorState.getEditorAddin() != editorAddin) continue;
                        ret = editorState.giveUpEditor();
                    }
                }
            }
        }
        return ret;
    }

    public boolean match(EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        switch (editorCriteria.getType()) {
            case 11: {
                ret = this.equals(editorCriteria.getEditorInfo());
                break;
            }
            case 3: {
                ret = editorCriteria.getEditor().equals(this._editor);
                break;
            }
            case 10: {
                if (this._editor == null) break;
                Class criteria2 = editorCriteria.getEditorClass();
                ret = criteria2 == null || criteria2.equals(this._editor.getClass());
            }
        }
        return ret;
    }

    boolean openEditor(Editor editor) {
        boolean ret = true;
        try {
            if (editor != null) {
                editor.open();
                if (this._layoutInfo != null) {
                    this.applyLayoutInfo(editor, this._layoutInfo);
                    this._layoutInfo = null;
                }
            }
            EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
            if (this._editor != null) {
                editorManager.whenEditorClosed(this._editor);
                this._editor.close();
            }
            this.setEditor(editor);
            if (this._editor != null) {
                editorManager.whenEditorOpened(this._editor);
            }
        }
        catch (OpenAbortedException e) {
            ret = false;
        }
        catch (RuntimeException e) {
            ret = false;
            FeedbackManager.reportException((String)"Failed to open editor:", (Throwable)e);
        }
        return ret;
    }

    private void setEditor(Editor editor) {
        this._editor = editor;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this._enabled) {
            this._enabled = enabled;
            SplitPaneState parentSplitPaneState = this.getParentSplitPaneState();
            parentSplitPaneState.whenEditorStateChanges(this);
        }
    }

    public Component getFocusedComponent() {
        return this._focusedComponent;
    }

    public void setFocusedComponent(Component focusedComponent) {
        this._focusedComponent = focusedComponent;
    }

    public int getXScrollPos() {
        return this._xScrollPos;
    }

    public int getXScrollExtent() {
        return this._xScrollExtent;
    }

    public int getXScrollMax() {
        return this._xScrollMax;
    }

    public int getXScrollMin() {
        return this._xScrollMin;
    }

    public void setXScrollExtent(int xScrollExtent) {
        this._xScrollExtent = xScrollExtent;
    }

    public void setXScrollMax(int xScrollMax) {
        this._xScrollMax = xScrollMax;
    }

    public void setXScrollMin(int xScrollMin) {
        this._xScrollMin = xScrollMin;
    }

    public void setXScrollPos(int xScrollPos) {
        this._xScrollPos = xScrollPos;
    }

    public int getYScrollPos() {
        return this._yScrollPos;
    }

    public void setYScrollPos(int yScrollPos) {
        this._yScrollPos = yScrollPos;
    }

    public int getYScrollExtent() {
        return this._yScrollExtent;
    }

    public int getYScrollMax() {
        return this._yScrollMax;
    }

    public int getYScrollMin() {
        return this._yScrollMin;
    }

    public void setYScrollExtent(int yScrollExtent) {
        this._yScrollExtent = yScrollExtent;
    }

    public void setYScrollMax(int yScrollMax) {
        this._yScrollMax = yScrollMax;
    }

    public void setYScrollMin(int yScrollMin) {
        this._yScrollMin = yScrollMin;
    }

    private static EditorManagerImpl getEditorManager() {
        return EditorManagerImpl.getInstance();
    }

    private EditorPathImpl getPath() {
        EditorPathImpl editorPath = new EditorPathImpl();
        EditorState.getEditorManager().searchEditor(editorPath, new EditorCriteriaImpl(this));
        return editorPath;
    }

    private TabGroupState getTabGroupState() {
        return this.getPath().getTabGroupState();
    }

    private Node getNode() {
        return this.getTabGroupState().getContext().getNode();
    }

    public Editor _getEditor() {
        return this._editor;
    }

    public String _getShortLabel() {
        String ret = null;
        Node node = this.getNode();
        if (node != null) {
            ret = node.getShortLabel();
        }
        return ret;
    }

    public String _getLongLabel() {
        String ret = null;
        Node node = this.getNode();
        if (node != null) {
            ret = node.getLongLabel();
        }
        return ret;
    }

    public Icon _getIcon() {
        Icon ret = null;
        Node node = this.getNode();
        if (node != null) {
            ret = node.getIcon();
        }
        return ret;
    }

    void dump(String indent, boolean isActive) {
        String isActiveLabel = isActive ? "*" : "";
        String addinName = this._editorAddin.getClass().getName();
        String editorClassName = this._editor != null ? " - " + this._editor.getClass().getName() : "";
        System.out.println(indent + "EditorState - " + isActiveLabel + addinName + editorClassName);
    }

    public boolean isSplittable() {
        return this.getEditorAddin().isDuplicable();
    }

    void saveStateInfo(StructuredPropertyAccess node) {
        int xScrollMin = this.getXScrollMin();
        int xScrollMax = this.getXScrollMax();
        int xScrollExtent = this.getXScrollExtent();
        int xScrollPos = this.getXScrollPos();
        node.setProperty(KEY_XSCROLL_MIN, Integer.toString(xScrollMin));
        node.setProperty(KEY_XSCROLL_MAX, Integer.toString(xScrollMax));
        node.setProperty(KEY_XSCROLL_EXT, Integer.toString(xScrollExtent));
        node.setProperty(KEY_XSCROLL_POS, Integer.toString(xScrollPos));
        int yScrollMin = this.getYScrollMin();
        int yScrollMax = this.getYScrollMax();
        int yScrollExtent = this.getYScrollExtent();
        int yScrollPos = this.getYScrollPos();
        node.setProperty(KEY_YSCROLL_MIN, Integer.toString(yScrollMin));
        node.setProperty(KEY_YSCROLL_MAX, Integer.toString(yScrollMax));
        node.setProperty(KEY_YSCROLL_EXT, Integer.toString(yScrollExtent));
        node.setProperty(KEY_YSCROLL_POS, Integer.toString(yScrollPos));
        Editor editor = this.getEditor();
        if (editor != null) {
            editor.saveSettings(node);
        }
    }

    void loadStateInfo(StructuredPropertyAccess node) {
        if (this._editor == null) {
            this._layoutInfo = node;
        } else {
            this.applyLayoutInfo(this._editor, node);
        }
    }

    StructuredPropertyAccess getStateInfo() {
        return this._layoutInfo;
    }

    private void applyLayoutInfo(Editor editor, StructuredPropertyAccess layoutInfo) {
        int xScrollMin = Integer.parseInt(layoutInfo.getProperty(KEY_XSCROLL_MIN, "0"));
        int xScrollMax = Integer.parseInt(layoutInfo.getProperty(KEY_XSCROLL_MAX, "1000"));
        int xScrollExtent = Integer.parseInt(layoutInfo.getProperty(KEY_XSCROLL_EXT, "1000"));
        int xScrollPos = Integer.parseInt(layoutInfo.getProperty(KEY_XSCROLL_POS, "0"));
        this.setXScrollMin(xScrollMin);
        this.setXScrollMax(xScrollMax);
        this.setXScrollExtent(xScrollExtent);
        this.setXScrollPos(xScrollPos);
        int yScrollMin = Integer.parseInt(layoutInfo.getProperty(KEY_YSCROLL_MIN, "0"));
        int yScrollMax = Integer.parseInt(layoutInfo.getProperty(KEY_YSCROLL_MAX, "1000"));
        int yScrollExtent = Integer.parseInt(layoutInfo.getProperty(KEY_YSCROLL_EXT, "1000"));
        int yScrollPos = Integer.parseInt(layoutInfo.getProperty(KEY_YSCROLL_POS, "0"));
        this.setYScrollMin(yScrollMin);
        this.setYScrollMax(yScrollMax);
        this.setYScrollExtent(yScrollExtent);
        this.setYScrollPos(yScrollPos);
        editor.loadSettings(layoutInfo);
    }
}

