/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;

final class EditorAddinRegistry {
    private final Map _registry = new HashMap();
    private final ArrayList _dynamicRegistry = new ArrayList();
    private final HashMap _registeredAddins = new HashMap();
    private final HashSet _registeredEditors = new HashSet();
    private final Set _registeredClasses = new HashSet();

    EditorAddinRegistry() {
    }

    void unregister(EditorAddin editorAddin) {
        Set keySet = this._registry.keySet();
        ArrayList keys = new ArrayList(keySet);
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            List list = (List)this._registry.get(key);
            for (int j = list.size() - 1; j >= 0; --j) {
                EditorAddin registeredAddin = (EditorAddin)list.get(j);
                if (!editorAddin.equals(registeredAddin)) continue;
                list.remove(j);
            }
            if (!list.isEmpty()) continue;
            this._registry.remove(key);
        }
        this.removeFromRegistry(editorAddin);
    }

    void extend(EditorAddin editorAddin, Class[] types) {
        boolean isDefault = editorAddin.isDefault();
        for (int i = 0; i < types.length; ++i) {
            ArrayList<EditorAddin> list = (ArrayList<EditorAddin>)this._registry.get(types[i]);
            if (list == null) {
                list = new ArrayList<EditorAddin>(5);
                list.add(editorAddin);
                this._registry.put(types[i], list);
                this._registeredClasses.add(types[i]);
                continue;
            }
            if (list.contains(editorAddin)) continue;
            if (isDefault) {
                list.add(0, editorAddin);
                continue;
            }
            list.add(editorAddin);
        }
        this.addToRegistry(editorAddin);
    }

    void registerDynamic(EditorAddin editorAddin) {
        this._dynamicRegistry.add(editorAddin);
        this.addToRegistry(editorAddin);
    }

    void unregisterDynamic(EditorAddin editorAddin) {
        this._dynamicRegistry.remove(editorAddin);
        this.removeFromRegistry(editorAddin);
    }

    List getStaticAddins(Class elementClass) {
        return this.getAddinsImpl(elementClass, null);
    }

    Set getStaticElementTypes() {
        return Collections.unmodifiableSet(this._registeredClasses);
    }

    List getAddins(Element element) {
        List addins = this.getAddinsImpl(element.getClass(), element);
        return addins;
    }

    private List getAddinsImpl(Class elementClass, Element element) {
        EditorAddin editorAddin;
        int i;
        final HashMap<EditorAddin, Float> addins = new HashMap<EditorAddin, Float>();
        List staticAddins = this.getStaticAddinsImpl(elementClass);
        for (i = 0; i < staticAddins.size(); ++i) {
            editorAddin = (EditorAddin)staticAddins.get(i);
            addins.put(editorAddin, new Float(0.5 - (double)i * 0.01));
        }
        for (i = 0; element != null && i < this._dynamicRegistry.size(); ++i) {
            float editorWeight;
            editorAddin = (EditorAddin)this._dynamicRegistry.get(i);
            if (addins.containsKey(editorAddin) || Float.isNaN(editorWeight = editorAddin.getEditorWeight(element))) continue;
            addins.put(editorAddin, new Float(editorWeight));
        }
        ArrayList addinList = new ArrayList(addins.keySet());
        Collections.sort(addinList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Float value1 = (Float)addins.get(o1);
                Float value2 = (Float)addins.get(o2);
                return Float.compare(value2.floatValue(), value1.floatValue());
            }
        });
        return addinList;
    }

    boolean hasAddins(Element element) {
        boolean ret = false;
        if (this.hasStaticAddins(element)) {
            ret = true;
        } else {
            for (int i = 0; i < this._dynamicRegistry.size(); ++i) {
                EditorAddin editorAddin = (EditorAddin)this._dynamicRegistry.get(i);
                float editorWeight = editorAddin.getEditorWeight(element);
                if (Float.isNaN(editorWeight)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private boolean hasStaticAddins(Element element) {
        boolean ret = false;
        Class<?> cls = element.getClass();
        List list = (List)this._registry.get(cls);
        if (list != null) {
            ret = true;
        } else {
            for (Class<?> superCls = cls.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
                list = (List)this._registry.get(superCls);
                if (list == null || list.size() == 0) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private List getStaticAddinsImpl(Class cls) {
        List list = (List)this._registry.get(cls);
        if (list == null) {
            for (Class superCls = cls.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
                list = (List)this._registry.get(superCls);
                if (list == null || list.size() == 0) continue;
                this._registry.put(cls, list);
                break;
            }
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    Class getRegisteredElementType(Class cls) {
        if (this._registry.containsKey(cls)) {
            return cls;
        }
        for (Class superCls = cls.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
            if (!this._registry.containsKey(superCls)) continue;
            return superCls;
        }
        return null;
    }

    void dumpRegisteredEditors() {
        HashMap allNodeTypes = new HashMap();
        System.out.println("-------------------- Registered editors");
        for (Class nodeClass : this._registry.keySet()) {
            System.out.println(nodeClass.getName());
            List lst = (List)this._registry.get(nodeClass);
            for (int i = 0; i < lst.size(); ++i) {
                EditorAddin editorAddin = (EditorAddin)lst.get(i);
                Class editorClass = editorAddin.getEditorClass();
                System.out.println("    " + editorAddin.getMenuSpecification().label + " = " + editorClass.getName());
            }
            this.buildNodeTree(nodeClass, allNodeTypes);
        }
        System.out.println("-------------------- Node hierarchy");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)allNodeTypes.get(Object.class);
        this.recDumpTree(root, "");
    }

    private DefaultMutableTreeNode buildNodeTree(Class cls, HashMap allNodeTypes) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodeTypes.get(cls);
        if (node == null) {
            node = new DefaultMutableTreeNode(cls);
            if (cls != Object.class) {
                Class superclass = cls.getSuperclass();
                DefaultMutableTreeNode parentNode = this.buildNodeTree(superclass, allNodeTypes);
                parentNode.add(node);
            }
            allNodeTypes.put(cls, node);
        }
        return node;
    }

    private void recDumpTree(DefaultMutableTreeNode parent, String level) {
        Class cls = (Class)parent.getUserObject();
        System.out.println(level + cls.getName());
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            this.recDumpTree(child, level + "  ");
        }
    }

    private void addToRegistry(EditorAddin editorAddin) {
        Class<?> editorAddinClass = editorAddin.getClass();
        String editorAddinClassName = editorAddinClass.getName();
        this._registeredAddins.put(editorAddinClassName, editorAddin);
        Class editorClass = editorAddin.getEditorClass();
        this._registeredEditors.add(editorClass);
    }

    private void removeFromRegistry(EditorAddin editorAddin) {
        Class<?> editorAddinClass = editorAddin.getClass();
        String editorAddinClassName = editorAddinClass.getName();
        this._registeredAddins.remove(editorAddinClassName);
        Class editorClass = editorAddin.getEditorClass();
        this._registeredEditors.remove(editorClass);
    }

    EditorAddin getRegisteredEditorAddin(String editorAddinClassName) {
        return (EditorAddin)this._registeredAddins.get(editorAddinClassName);
    }

    boolean isEditorRegistered(Class editorClass) {
        boolean ret = this._registeredEditors.contains(editorClass);
        return ret;
    }

    EditorAddin getEditorAddin(Class editorClass) {
        if (this.isEditorRegistered(editorClass)) {
            Iterator i;
            Set set = this._registeredAddins.keySet();
            Iterator iterator = i = set != null ? set.iterator() : null;
            if (i != null) {
                while (i.hasNext()) {
                    Object key = i.next();
                    EditorAddin addin = (EditorAddin)this._registeredAddins.get(key);
                    if (addin == null || addin.getEditorClass() != editorClass) continue;
                    return addin;
                }
            }
        }
        return null;
    }
}

