/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.border.Border;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.ide.Ide;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.editor.Editor;
import oracle.ide.util.BitField;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.controls.RolloverButton;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.shutter.MouseActivationController;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.docking.shutter.ShutterTabListener;
import oracle.ideimpl.util.DropFileUtil;
import oracle.ideimpl.window.WindowingConstants;
import oracle.javatools.util.ModelUtil;

public final class ShutterTab
extends RolloverButton
implements DropTargetListener,
MouseListener,
MouseMotionListener,
TitleChangeListener {
    private static final Border[] BORDER_SCHEME = new Border[]{RolloverButton.BORDER_DOWN, RolloverButton.BORDER_LINE, RolloverButton.BORDER_UP};
    private static final int LPAD_SELECTED = 6;
    private static final int RPAD_SELECTED = 18;
    private static final int LPAD_UNSELECTED = 6;
    private static final int RPAD_UNSELECTED = 6;
    private static final int GAP_ICON_TEXT = 2;
    private final TitledPanel _titledPanel;
    private transient Dimension _maxItemSize;
    private transient Dimension[] _iconSizes;
    private transient Rectangle[] _textRects;
    private transient Rectangle[] _itemBounds;
    private transient DropTargetListener _dropTargetListener;
    private DockPanel dockPanelForOrientation;
    private ShutterTabListener shutterTabListener;
    private boolean forAutoExpansion;
    private boolean dockableInSelectedTab;
    private TitledPanel dockedTitledPanel;
    private static ActiveViewListener shutterPanelDismisser = null;

    public void dockPanelForOrientation(DockPanel newValue) {
        this.dockPanelForOrientation = newValue;
    }

    public ShutterTab(TitledPanel titledPanel, boolean forAutoExpansion) {
        this(titledPanel);
        this.forAutoExpansion = forAutoExpansion;
    }

    public ShutterTab(TitledPanel titledPanel) {
        this._titledPanel = titledPanel;
        this.setBorderScheme(BORDER_SCHEME);
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        new DropTarget(this, 2, this);
    }

    String getOrientation() {
        ShutterMargin margin = this.getShutterMargin();
        if (margin != null) {
            return margin.getOrientation();
        }
        return null;
    }

    TitledPanel getTitledPanel() {
        return this._titledPanel;
    }

    boolean isClient(Dockable dockable) {
        return this._titledPanel.isClient(dockable);
    }

    void setSelectedHolder(DockableHolder holder) {
        Dockable dockable = holder.getDockable();
        int clientPos = this._titledPanel.getClientPos(dockable);
        this.setSelectedIndex(clientPos);
        MouseActivationController activationController = ShutterManager.getInstance().getMouseActivationController();
        activationController.raiseInHolder(this, this.getDockableHolder(new Point(5, 5)));
    }

    void refresh() {
        this.revalidate();
    }

    public void setDockableInSelectedTab(boolean dockableInSelectedTab) {
        this.dockableInSelectedTab = dockableInSelectedTab;
    }

    public void setDockedTitledPanel(TitledPanel dockedTitledPanel) {
        this.dockedTitledPanel = dockedTitledPanel;
    }

    void raisePanel(TitledPanelHolder holder, int flags) {
        if (holder == null) {
            return;
        }
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin != null) {
            this.setSelectedHolder(holder);
            shutterMargin.raiseFloatPanel(holder, flags);
            this.setSelected(flags != 0);
        } else {
            boolean fireDockableShownEvent;
            ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
            if (shutterPanel.isClientAccessible(holder)) {
                return;
            }
            this.setSelectedHolder(holder);
            int orientation = 0;
            if (this.dockPanelForOrientation != null) {
                orientation = DockStationImpl.getInstance().getPanelOrientation(this.dockPanelForOrientation);
            }
            boolean bl = fireDockableShownEvent = !this.forAutoExpansion || !this.dockableInSelectedTab;
            if (this.forAutoExpansion) {
                holder.getDockable().beforeAutoExpanding();
            }
            shutterPanel.showPanel(holder, orientation, flags, fireDockableShownEvent, this.forAutoExpansion, this.dockedTitledPanel);
        }
        if (shutterPanelDismisser != null) {
            Ide.getMainWindow().removeActiveViewListener(shutterPanelDismisser);
        }
        shutterPanelDismisser = new ShutterPanelDismisser(holder);
        Ide.getMainWindow().addActiveViewListener(shutterPanelDismisser);
    }

    private DockPanel findDockPanel(Component c) {
        if (c == null) {
            return null;
        }
        Container parent = c.getParent();
        if (parent instanceof DockPanel) {
            return (DockPanel)parent;
        }
        return this.findDockPanel(parent);
    }

    public void retractPanel(int flags) {
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        boolean fireDockableHiddenEvent = !this.forAutoExpansion;
        shutterPanel.hidePanel(flags, fireDockableHiddenEvent);
        this.setSelected(false);
        if (this.shutterTabListener != null) {
            this.shutterTabListener.shutterPanelHidden(shutterPanel.getSize(), shutterPanel.isResizedByUser(), flags, shutterPanel.getOrientation());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            Graphics2D g = (Graphics2D)this.getGraphics();
            Font font = this.getFont();
            if (g != null && font != null) {
                this._maxItemSize = this.calculateItemDimensions(g, font);
                this._itemBounds = this.calculateItemBounds();
                Dimension d = this.getDefaultSize();
                this.setPreferredSize(d);
                return d;
            }
            return new Dimension(10, 10);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setPreferredSize(null);
    }

    @Override
    protected void paintComponent(Graphics gAWT) {
        int labelHeight;
        boolean isVertical;
        Graphics2D g = (Graphics2D)gAWT.create();
        int width = this.getWidth();
        int height = this.getHeight();
        this.updateItemBounds(width, height);
        Insets insets = this.getInsets();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        if (isVertical = this.isVertical()) {
            g.rotate(Math.toRadians(90.0));
            g.translate(0, -width);
            labelHeight = width;
        } else {
            labelHeight = height;
        }
        Font font = this.getFont();
        g.setFont(font);
        for (int i = 0; i < this._titledPanel.getClientCount(); ++i) {
            int x;
            if (!this._titledPanel.isClientVisible(i)) continue;
            TitledPanelHolder holder = this._titledPanel.getHolder(i);
            Dockable dockable = holder.getDockable();
            Rectangle itemRect = this._itemBounds[i];
            int n = x = isVertical ? itemRect.y : itemRect.x;
            if (x == 0) {
                x += isVertical ? insets.top : insets.left;
            } else {
                g.setColor(WindowingConstants.CONTROL_SHADOW_COLOR);
                g.drawLine(x, 0, x, labelHeight);
                ++x;
            }
            boolean isSelected = i == this.getSelectedIndex();
            Dimension iconSize = this._iconSizes[i];
            x += isSelected ? 6 : 6;
            if (iconSize.width > 0) {
                Icon icon = dockable.getTabIcon();
                icon.paintIcon(this, g, x, (labelHeight - iconSize.height) / 2);
                x += iconSize.width;
            }
            if (!isSelected) continue;
            if (iconSize.width > 0) {
                x += 2;
            }
            Rectangle textRect = this._textRects[i];
            String text = dockable.getTabName();
            g.setColor(this.getForeground());
            GraphicUtils.drawString((Graphics)g, (String)text, (int)(x + textRect.x), (int)((labelHeight - textRect.height) / 2 - textRect.y));
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        MouseActivationController activationController = ShutterManager.getInstance().getMouseActivationController();
        TitledPanelHolder holder = this.getDockableHolder(dtde.getLocation());
        activationController.dragEnter(this, holder);
        this._dropTargetListener = this.getDropTargetListener(holder);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dragEnter(dtde);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dragExit(dte);
            this._dropTargetListener = null;
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        TitledPanelHolder holder = this.getDockableHolder(dtde.getLocation());
        MouseActivationController activationController = ShutterManager.getInstance().getMouseActivationController();
        activationController.dragOver(this, holder);
        this._dropTargetListener = this.getDropTargetListener(holder, dtde);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dragOver(dtde);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        TitledPanelHolder holder = this.getDockableHolder(dtde.getLocation());
        this._dropTargetListener = this.getDropTargetListener(holder);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.drop(dtde);
        } else {
            dtde.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        TitledPanelHolder holder = this.getDockableHolder(dtde.getLocation());
        this._dropTargetListener = this.getDropTargetListener(holder, dtde);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dropActionChanged(dtde);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int modifiers = e.getModifiers();
        if (!BitField.isSet((int)modifiers, (int)16)) {
            MouseActivationController activationController = ShutterManager.getInstance().getMouseActivationController();
            activationController.mouseEntered(this, this.getDockableHolder(e.getPoint()));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        MouseActivationController activationController = ShutterManager.getInstance().getMouseActivationController();
        activationController.mouseExited(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MouseActivationController activationController = ShutterManager.getInstance().getMouseActivationController();
        activationController.mousePressed(this, this.getDockableHolder(e.getPoint()));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseActivationController activationController = ShutterManager.getInstance().getMouseActivationController();
        activationController.mouseMoved(this, this.getDockableHolder(e.getPoint()));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void titleChange(TitleChangeEvent e) {
        this.invalidate();
    }

    private boolean isVertical() {
        String orientation = this.getOrientation();
        return orientation == "West" || orientation == "East";
    }

    private int getSelectedIndex() {
        return this._titledPanel.getSelectedIndex();
    }

    private void setSelectedIndex(int index) {
        if (index != this.getSelectedIndex()) {
            this._titledPanel.setSelectedIndex(index);
            this.revalidate();
        }
    }

    private ShutterMargin getShutterMargin() {
        Container parent = this.getParent();
        if (parent instanceof ShutterMargin) {
            return (ShutterMargin)parent;
        }
        return null;
    }

    private DropTargetListener getDropTargetListener(DockableHolder holder) {
        DropTargetListener dropTargetListener = holder.getDockable().getTabDropListener();
        return dropTargetListener != null ? dropTargetListener : DropFileUtil.getDefaultDropFileListener();
    }

    private DropTargetListener getDropTargetListener(DockableHolder holder, DropTargetDragEvent dtde) {
        DropTargetListener dropTargetListener = this.getDropTargetListener(holder);
        if (dropTargetListener != this._dropTargetListener) {
            if (this._dropTargetListener != null) {
                this._dropTargetListener.dragExit(dtde);
            }
            if (dropTargetListener != null) {
                dropTargetListener.dragEnter(dtde);
            }
        }
        return dropTargetListener;
    }

    private TitledPanelHolder getDockableHolder(Point pt) {
        if (this._itemBounds != null) {
            for (int i = 0; i < this._itemBounds.length; ++i) {
                Rectangle r = this._itemBounds[i];
                if (r == null || !r.contains(pt)) continue;
                return this._titledPanel.getHolder(i);
            }
        }
        return this._titledPanel.getSelectedHolder();
    }

    private Dimension getDefaultSize() {
        int count = this._titledPanel.getClientCount();
        int height = this._maxItemSize.height;
        int width = 0;
        for (int i = 0; i < count; ++i) {
            if (!this._titledPanel.isClientVisible(i)) continue;
            if (width != 0) {
                ++width;
            }
            width += this.getItemWidth(i);
        }
        boolean isVertical = this.isVertical();
        if (isVertical) {
            int tmp = width;
            width = height;
            height = tmp;
        }
        Insets insets = this.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    private int getItemWidth(int i) {
        if (i == this.getSelectedIndex()) {
            return 6 + this._maxItemSize.width + 18;
        }
        Dimension iconSize = this._iconSizes[i];
        return 6 + (iconSize.width > 0 ? iconSize.width : this._maxItemSize.height) + 6;
    }

    private void updateItemBounds(int actualWidth, int actualHeight) {
        Dimension preferredSize = this.getPreferredSize();
        if (preferredSize.width != actualWidth || preferredSize.height != actualHeight) {
            this._maxItemSize.width += actualWidth - preferredSize.width;
            this._maxItemSize.height += actualHeight - preferredSize.height;
            this._itemBounds = this.calculateItemBounds();
        }
    }

    private Rectangle[] calculateItemBounds() {
        int i;
        int count = this._titledPanel.getClientCount();
        boolean isVertical = this.isVertical();
        Insets insets = this.getInsets();
        int lastVisible = -1;
        for (int i2 = 0; i2 < count; ++i2) {
            if (!this._titledPanel.isClientVisible(i2)) continue;
            lastVisible = i2;
        }
        Rectangle[] itemRects = new Rectangle[count];
        int height = isVertical ? insets.left + this._maxItemSize.height + insets.right : insets.top + this._maxItemSize.height + insets.bottom;
        int width = 0;
        for (i = 0; i < count; ++i) {
            boolean visible = this._titledPanel.isClientVisible(i);
            int w = 0;
            if (visible) {
                w = width == 0 ? (w += isVertical ? insets.top : insets.left) : ++w;
                w += this.getItemWidth(i);
                if (i == lastVisible) {
                    w += isVertical ? insets.bottom : insets.right;
                }
            }
            itemRects[i] = new Rectangle(width, 0, w, height);
            width += w;
        }
        if (isVertical) {
            for (i = 0; i < count; ++i) {
                Rectangle r = itemRects[i];
                int x = r.x;
                r.x = r.y;
                r.y = x;
                int w = r.width;
                r.width = r.height;
                r.height = w;
            }
        }
        return itemRects;
    }

    private Dimension calculateItemDimensions(Graphics2D g, Font font) {
        int count = this._titledPanel.getClientCount();
        this._iconSizes = new Dimension[count];
        this._textRects = new Rectangle[count];
        FontRenderContext frc = g.getFontRenderContext();
        int maxVisibleWidth = 0;
        int maxVisibleHeight = 0;
        for (int i = 0; i < count; ++i) {
            Rectangle textRect;
            TitledPanelHolder holder = this._titledPanel.getHolder(i);
            Dockable dockable = holder.getDockable();
            Icon icon = dockable.getTabIcon();
            Dimension iconSize = new Dimension();
            if (icon != null) {
                iconSize.width = icon.getIconWidth();
                iconSize.height = icon.getIconHeight();
            }
            this._iconSizes[i] = iconSize;
            String text = dockable.getTabName();
            if (ModelUtil.hasLength((String)text)) {
                Rectangle2D rText = font.getStringBounds(text, frc);
                textRect = rText.getBounds();
            } else {
                textRect = new Rectangle();
            }
            this._textRects[i] = textRect;
            if (!this._titledPanel.isClientVisible(i)) continue;
            int width = iconSize.width + textRect.width;
            if (iconSize.width > 0 && textRect.width > 0) {
                width += 2;
            }
            maxVisibleWidth = Math.max(width, maxVisibleWidth);
            maxVisibleHeight = Math.max(iconSize.height, maxVisibleHeight);
            maxVisibleHeight = Math.max(textRect.height, maxVisibleHeight);
        }
        return new Dimension(maxVisibleWidth, maxVisibleHeight);
    }

    public void setShutterTabListener(ShutterTabListener newshutterTabListener) {
        this.shutterTabListener = newshutterTabListener;
    }

    public ShutterTabListener getShutterTabListener() {
        return this.shutterTabListener;
    }

    final class ShutterPanelDismisser
    implements ActiveViewListener {
        private final Dockable hostedDockable;

        public ShutterPanelDismisser(TitledPanelHolder holder) {
            assert (holder != null);
            this.hostedDockable = holder.getDockable();
        }

        public void activeViewChanged(ActiveViewEvent e) {
            View oldView = e.getOldView();
            if (this.hostedDockable.equals(oldView) && e.getNewView() instanceof Editor) {
                ShutterTab.this.retractPanel(0);
                ShutterManager.getInstance().getMouseActivationController().reset();
                Ide.getMainWindow().removeActiveViewListener(shutterPanelDismisser);
            }
        }
    }
}

