/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.controls.PentaLayout;
import oracle.ide.util.BitField;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.IdeImplArb;

public class PentaLayoutConfigPanel
extends JPanel {
    private PentaLayout _pentaLayout;
    private JButton _butNorthTakesWest;
    private JButton _butWestTakesNorth;
    private JButton _butNorthTakesEast;
    private JButton _butEastTakesNorth;
    private JButton _butSouthTakesWest;
    private JButton _butWestTakesSouth;
    private JButton _butSouthTakesEast;
    private JButton _butEastTakesSouth;
    private JPanel _nortCenter;
    private JPanel _southCenter;
    private JPanel _westCenter;
    private JPanel _eastCenter;
    private ArrayList _buttonControlers = new ArrayList(4);

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setBounds(100, 100, 500, 500);
        final PentaLayoutConfigPanel contentPane = new PentaLayoutConfigPanel(0);
        frame.setContentPane(contentPane);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                byte style = contentPane.getStyle();
                System.out.println("Result:" + style + " = " + Integer.toBinaryString(style));
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public PentaLayoutConfigPanel(byte initialStyle) {
        super(new BorderLayout());
        this._pentaLayout = new PentaLayout(initialStyle, 0, 0);
        JLabel windowLayoutLabel = new JLabel();
        this.add((Component)windowLayoutLabel, "North");
        this._butNorthTakesWest = this.createButton(IdeImplArb.getIcon(63));
        this._butWestTakesNorth = this.createButton(IdeImplArb.getIcon(64));
        String windowLayoutString = IdeImplArb.getString(59);
        ResourceUtils.resLabel((JLabel)windowLayoutLabel, (Component)this._butNorthTakesWest, (String)windowLayoutString);
        ButtonControler buttonControler = new ButtonControler(this._butNorthTakesWest, this._butWestTakesNorth, 8, windowLayoutLabel);
        this._buttonControlers.add(buttonControler);
        this._butNorthTakesEast = this.createButton(IdeImplArb.getIcon(65));
        this._butEastTakesNorth = this.createButton(IdeImplArb.getIcon(60));
        buttonControler = new ButtonControler(this._butNorthTakesEast, this._butEastTakesNorth, 4, null);
        this._buttonControlers.add(buttonControler);
        this._butSouthTakesWest = this.createButton(IdeImplArb.getIcon(67));
        this._butWestTakesSouth = this.createButton(IdeImplArb.getIcon(62));
        buttonControler = new ButtonControler(this._butSouthTakesWest, this._butWestTakesSouth, 2, null);
        this._buttonControlers.add(buttonControler);
        this._butSouthTakesEast = this.createButton(IdeImplArb.getIcon(61));
        this._butEastTakesSouth = this.createButton(IdeImplArb.getIcon(66));
        buttonControler = new ButtonControler(this._butEastTakesSouth, this._butSouthTakesEast, 1, null);
        this._buttonControlers.add(buttonControler);
        JPanel pentaLayoutPanel = new JPanel();
        pentaLayoutPanel.setLayout((LayoutManager)this._pentaLayout);
        JPanel panel = this.createBorderPanel();
        panel.add((Component)this._butWestTakesNorth, "West");
        panel.add((Component)this._butEastTakesNorth, "East");
        this._nortCenter = this.createCenterPanel();
        panel.add((Component)this._nortCenter, "Center");
        pentaLayoutPanel.add((Component)panel, PentaLayout.NORTH);
        panel = this.createBorderPanel();
        panel.add((Component)this._butWestTakesSouth, "West");
        panel.add((Component)this._butEastTakesSouth, "East");
        this._southCenter = this.createCenterPanel();
        panel.add((Component)this._southCenter, "Center");
        pentaLayoutPanel.add((Component)panel, PentaLayout.SOUTH);
        panel = this.createBorderPanel();
        panel.add((Component)this._butNorthTakesWest, "North");
        panel.add((Component)this._butSouthTakesWest, "South");
        this._westCenter = this.createCenterPanel();
        panel.add((Component)this._westCenter, "Center");
        pentaLayoutPanel.add((Component)panel, PentaLayout.WEST);
        panel = this.createBorderPanel();
        panel.add((Component)this._butNorthTakesEast, "North");
        panel.add((Component)this._butSouthTakesEast, "South");
        this._eastCenter = this.createCenterPanel();
        panel.add((Component)this._eastCenter, "Center");
        pentaLayoutPanel.add((Component)panel, PentaLayout.EAST);
        JPanel editorPanel = new JPanel();
        pentaLayoutPanel.add((Component)editorPanel, PentaLayout.CENTER);
        editorPanel.setBackground(null);
        pentaLayoutPanel.setBackground(Color.WHITE);
        this.add((Component)pentaLayoutPanel, "Center");
    }

    @Override
    public void doLayout() {
        Dimension prefSizes = new Dimension();
        this.getSize(prefSizes);
        prefSizes.width /= 6;
        prefSizes.height /= 6;
        this._butNorthTakesWest.setPreferredSize(prefSizes);
        this._butWestTakesNorth.setPreferredSize(prefSizes);
        this._butNorthTakesEast.setPreferredSize(prefSizes);
        this._butEastTakesNorth.setPreferredSize(prefSizes);
        this._butSouthTakesWest.setPreferredSize(prefSizes);
        this._butWestTakesSouth.setPreferredSize(prefSizes);
        this._butSouthTakesEast.setPreferredSize(prefSizes);
        this._butEastTakesSouth.setPreferredSize(prefSizes);
        this._nortCenter.setPreferredSize(prefSizes);
        this._southCenter.setPreferredSize(prefSizes);
        this._westCenter.setPreferredSize(prefSizes);
        this._eastCenter.setPreferredSize(prefSizes);
        super.doLayout();
    }

    private JPanel createBorderPanel() {
        JPanel panel = new JPanel(new BorderLayout(){

            @Override
            public void layoutContainer(Container target) {
                super.layoutContainer(target);
            }
        });
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel.setBackground(null);
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel centerPanel = new JPanel();
        centerPanel.setBackground(null);
        return centerPanel;
    }

    private JButton createButton(Icon icon) {
        JButton ret = new JButton(icon);
        ret.setOpaque(false);
        ret.setContentAreaFilled(false);
        ret.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        return ret;
    }

    public byte getStyle() {
        return this._pentaLayout.getStyle();
    }

    public void setStyle(byte style) {
        this._pentaLayout.setStyle(style);
        for (int i = 0; i < this._buttonControlers.size(); ++i) {
            ButtonControler buttonControler = (ButtonControler)this._buttonControlers.get(i);
            buttonControler.updateButtons();
        }
    }

    class ButtonControler
    implements ActionListener {
        private JButton _button1;
        private JButton _button2;
        private int _myByte;
        private JLabel _label;

        public ButtonControler(JButton button1, JButton button2, byte myByte, JLabel label) {
            this._button1 = button1;
            this._button2 = button2;
            this._myByte = myByte;
            this._label = label;
            this._button1.addActionListener(this);
            this._button2.addActionListener(this);
            this.updateButtons();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            byte style = PentaLayoutConfigPanel.this.getStyle();
            byte newStyle = (byte)(style ^ this._myByte);
            PentaLayoutConfigPanel.this.setStyle(newStyle);
            this.updateButtons();
        }

        private void updateButtons() {
            byte style = PentaLayoutConfigPanel.this.getStyle();
            boolean isMyByteSet = BitField.isSet((int)style, (int)this._myByte);
            if (isMyByteSet) {
                this.swapButtons(this._button1, this._button2);
            } else {
                this.swapButtons(this._button2, this._button1);
            }
        }

        private void swapButtons(JButton hideButton, final JButton showButton) {
            boolean restoreFocus = hideButton.hasFocus();
            if (restoreFocus) {
                FocusManager.getCurrentManager().clearGlobalFocusOwner();
            }
            hideButton.setVisible(false);
            showButton.setVisible(true);
            if (this._label != null) {
                this._label.setLabelFor(showButton);
            }
            if (restoreFocus) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        showButton.requestFocus();
                    }
                });
            }
        }
    }
}

