/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.Version;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FloatingToolWindow;
import oracle.ide.controls.PentaLayout;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableFactory2;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerModel;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MultiMap;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.AbstractPinnable;
import oracle.ide.view.View;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.docking.ClientLayoutData;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationListener;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockableDragContextImpl;
import oracle.ideimpl.docking.DockableHolderImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.DockableSelector;
import oracle.ideimpl.docking.DockingConfigOptions;
import oracle.ideimpl.docking.DrawerModelImpl;
import oracle.ideimpl.docking.FactoriesRegistry;
import oracle.ideimpl.docking.FloatDockWindow;
import oracle.ideimpl.docking.SidePort;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.TitledPanelXMLDockLayoutPersistence;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.javatools.controls.SplashScreen;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

@FeedbackApi(value="docking")
public final class DockStationImpl
extends DockStation
implements Controller,
ControllerProvider,
ChangeListener {
    static final String FM_API_NAME = "docking";
    private static final boolean DEBUG_PRINT_EVENTS = false;
    private static final boolean DEBUG_PRINT = false;
    private static DockStationImpl _instance;
    private final DockStationListener _dockStationListener = new DockStationListener();
    private final MultiMap<Dockable, DockableListener> _dockableListeners = new MultiMap();
    private final FactoriesRegistry _factoryRegistry = new FactoriesRegistry();
    private final Map<String, Dockable> viewCache = new HashMap<String, Dockable>(20);
    private PentaLayout _pentaLayout;
    private final List<DockPanelHost> _dockPanelHosts = new ArrayList<DockPanelHost>(5);
    private JFrame _frame;
    private boolean _bIsUIVisible = false;
    private ArrayList<FloatDockWindow> _floatToShow;
    private int _nDockableEventContext;
    private VisibilityLayout _currentVisibilityLayout;
    private Layout _currentLayout;
    private boolean _printInvalidDockingOperations = false;
    private ActiveViewHandlerImpl _activeViewHandler;
    private Container _topPanel;
    private SidePort[] _sidePorts;
    private List<UndockedDockable> undockedDockables;

    public static DockStationImpl createInstance() {
        return new DockStationImpl();
    }

    public static DockStationImpl getInstance() {
        if (_instance == null) {
            _instance = DockStationImpl.createInstance();
        }
        return _instance;
    }

    private DockStationListener getLayoutListener() {
        return this._dockStationListener;
    }

    public void registerDockableFactory(String viewTypeId, DockableFactory factory) {
        this.registerDockableFactory(viewTypeId, factory, 1000.0);
    }

    public void registerDockableFactory(String viewTypeId, DockableFactory factory, double priority) {
        this._factoryRegistry.registerDockableFactory(viewTypeId, factory, priority);
        if (!this._bIsUIVisible) {
            return;
        }
        List<Dockable> knownDockables = this.getAllDockables();
        factory.install();
        List<Dockable> newDockables = this.getAllDockables();
        newDockables.removeAll(knownDockables);
        if (!newDockables.isEmpty()) {
            this.setDefaultState(newDockables, this._currentLayout);
        }
    }

    public void unregisterDockableFactory(String viewTypeId) {
        this._factoryRegistry.unregisterDockableFactory(viewTypeId);
    }

    public void addDockableListener(DockableListener l, Dockable d) {
        this._dockableListeners.add((Object)d, (Object)l);
    }

    public void removeDockableListener(DockableListener l, Dockable d) {
        this._dockableListeners.remove((Object)d, (Object)l);
    }

    public void initialize() {
        this.initializeDefaultPreferences();
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            layouts.addLayoutListener("DockStation", (LayoutListener)this.getLayoutListener());
        }
    }

    private void initializeDefaultPreferences() {
        DockingConfigOptions dockingConfigOptions = DockingConfigOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        this.forCompatibilityOnly(dockingConfigOptions);
        this.stateChanged(null);
        dockingConfigOptions.addChangeListener(this);
    }

    private void forCompatibilityOnly(DockingConfigOptions dockingConfigOptions) {
        Ide.getSettings().putLegacyData("DockingConfigOptions", (Copyable)dockingConfigOptions);
    }

    public void install(JFrame frame, Container topPanel, JComponent centerPanel) {
        this.initTopPanel(frame, topPanel, centerPanel);
        this.initSidePorts(topPanel);
    }

    private void initTopPanel(JFrame frame, Container topPanel, JComponent centerPanel) {
        this._topPanel = topPanel;
        this.setApplicationFrame(frame);
        this._pentaLayout = new PentaLayout(15, 0, 0);
        this._topPanel.setLayout((LayoutManager)this._pentaLayout);
        this._topPanel.add((Component)centerPanel, PentaLayout.CENTER);
    }

    private void initSidePorts(Container topPanel) {
        this._sidePorts = new SidePort[4];
        for (int i = 0; i < this._sidePorts.length; ++i) {
            this._sidePorts[i] = this.registeredSidePort(topPanel, i);
        }
    }

    private SidePort registeredSidePort(Container container, int side) {
        SidePort s = new SidePort(container, side);
        this.registerDockPanelHost(s);
        return s;
    }

    public void setPentaLayoutStyle(byte style) {
        this._pentaLayout.setStyle(style);
        this._topPanel.invalidate();
        this._topPanel.validate();
    }

    public boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            if (!dockPanelHost.getDockablePath(path, criteria)) continue;
            return this.setDockPanelHostToPath(path, dockPanelHost);
        }
        return false;
    }

    private boolean setDockPanelHostToPath(DockablePath path, DockPanelHost dockPanelHost) {
        path.setDockPanelHost(dockPanelHost);
        return true;
    }

    public boolean isDockableVisible(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return false;
        }
        TitledPanel titledPanel = path.getTitledPanel();
        return titledPanel.isClientAccessible(dockable);
    }

    public boolean isDockableVisible(String viewId) {
        ViewId id = new ViewId(viewId);
        Dockable dockable = this.getDockable(id);
        return this.isDockableVisible(dockable);
    }

    public int getDockableStatus(Dockable dockable) {
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return 0;
        }
        return 1 | path.getTitledPanel().getDockableStatus(dockable);
    }

    public boolean isDockableAccessible(Dockable dockable) {
        if (dockable == null) {
            return false;
        }
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return false;
        }
        return path.getTitledPanel().isClientAccessible(dockable);
    }

    public void dock(Dockable dockable, DockingParam dockingParam) {
        this.dock(dockable, dockingParam, 0);
    }

    void dock(Dockable dockable, DockingParam dockingParam, int flags) {
        if (this._printInvalidDockingOperations && !BitField.isSet((int)dockingParam.getOrientation(), (int)8)) {
            String msg = "Attempt to dock a window during a layout switch";
            FeedbackManager.reportAPIException((String)msg, (Throwable)new IllegalStateException(), (String)FM_API_NAME);
        }
        if (dockingParam.isFloating()) {
            this.dockFloating(dockable, dockingParam, flags);
            return;
        }
        this.dockAsDocked(dockable, dockingParam, flags);
    }

    private void dockFloating(Dockable dockable, DockingParam dockingParam, int flags) {
        TitledPanel titledPanel = DockStationImpl.wrap(dockable, false, flags);
        titledPanel.getHolder(dockable).setFloatOnTop(dockingParam.isFloatOnTop());
        Rectangle screenPosition = dockingParam.getFloatingPosition();
        FloatDockWindow floatDockWindow = this.dockFloat(titledPanel, screenPosition.getLocation(), screenPosition.getSize());
        dockingParam.setFloatingToolWindow((FloatingToolWindow)floatDockWindow);
    }

    private void dockAsDocked(Dockable dockable, DockingParam dockingParam, int flags) {
        int orientation = dockingParam.getOrientation();
        Dockable reference = dockingParam.getReference();
        if (reference == null) {
            this._dockAtAbsolutePosition(dockable, orientation, flags);
            return;
        }
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(reference))) {
            this.dockWithAlternatePosition(dockable, dockingParam, flags);
            return;
        }
        TitledPanel titledPanel = path.getTitledPanel();
        if (BitField.isSet((int)orientation, (int)8)) {
            DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)reference;
            int hostedPosition = BitField.unset((int)orientation, (int)8);
            this.hostDrawerPanel(drawerDockableWindow, dockable, hostedPosition);
            return;
        }
        switch (orientation) {
            case 4: {
                TitledPanelHolder holder = new TitledPanelHolder(dockable);
                titledPanel.addClient(holder, flags);
                break;
            }
            default: {
                DockLayoutConstraint dc = new DockLayoutConstraint(titledPanel, orientation, dockingParam.getExtents(), null);
                TitledPanel tpNew = DockStationImpl.wrap(dockable, false, flags);
                DockPanel dockPanel = path.getDockPanel();
                dockPanel.dock(tpNew, dc);
            }
        }
    }

    private void dockWithAlternatePosition(Dockable dockable, DockingParam dockingParam, int flags) {
        int alternateOrientation = dockingParam.getAlternateOrientation();
        if (alternateOrientation != -1) {
            this._dockAtAbsolutePosition(dockable, alternateOrientation, flags);
        } else if (this.undockedDockables != null) {
            this.undockedDockables.add(new UndockedDockable(dockable, dockingParam, flags));
        } else {
            throw new IllegalArgumentException("Unable to dock " + dockable + " with params " + dockingParam + " and flags " + flags);
        }
    }

    private void hostDrawerPanel(DrawerDockableWindow reference, Dockable dockable, int hostedPosition) {
        DrawerModelImpl model = (DrawerModelImpl)reference.getModel();
        int index = hostedPosition == 0 ? 0 : model.size();
        model.add((DockableWindow)dockable, DrawerModel.State.VISIBLE, index);
    }

    private void _dockAtAbsolutePosition(Dockable dockable, int orientation, int flags) {
        if (orientation > 3) {
            throw new IllegalArgumentException("invalid orientation " + orientation + " in " + dockable);
        }
        int nInvertOrient = DockLayoutUtil.isHorz(orientation) ? 2 : 0;
        DockLayoutConstraint dlc = new DockLayoutConstraint(nInvertOrient |= 1, dockable.getSite().size);
        DockPanel dp = this._sidePorts[orientation].getDockPanel();
        this._dock(dockable, dp, dlc, false, flags);
    }

    public void undock(Dockable dockable) {
        this.undock(dockable, 0);
    }

    protected void undock(Dockable dockable, int flags) {
        DockablePath path = new DockablePath();
        if (this.getDockablePath(path, new DockableCriteria(dockable))) {
            this.undock(path, flags);
        }
    }

    void undock(DockablePath path, int flags) {
        path.getTitledPanel().removeClient(path.getDockable(), flags);
    }

    public void setDockableVisible(String strViewId, boolean bVisible) {
        ViewId viewId = new ViewId(strViewId);
        Dockable dockable = this.getDockable(viewId);
        if (dockable == null && bVisible) {
            dockable = this.createDockable(viewId);
        }
        if (dockable != null) {
            this.setDockableVisible(dockable, bVisible, 0);
        }
    }

    public void setDockableVisible(Dockable dockable, boolean bVisible) {
        this.setDockableVisible(dockable, bVisible, 0);
    }

    void setDockableVisible(Dockable dockable, boolean bVisible, int flags) {
        DockablePath path = new DockablePath();
        DockableCriteria criteria = new DockableCriteria(dockable);
        if (this.getDockablePath(path, criteria)) {
            this.setDockableVisible(path, bVisible, flags);
            return;
        }
        if (!this._bIsUIVisible) {
            return;
        }
        if (!bVisible) {
            return;
        }
        if (Version.DEBUG_BUILD == 1) {
            new IllegalArgumentException("Dockable " + dockable + " not found. Using default position.").printStackTrace();
        }
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(0);
        this.dock(dockable, dockingParam, flags);
        if (this.getDockablePath(path, criteria)) {
            this.setDockableVisible(path, bVisible, flags);
        }
    }

    void setDockableVisible(DockablePath dockablePath, boolean bVisible, int flags) {
        DockableHolderImpl holder;
        JComponent c;
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        if (mainWindow.getMaximizedWindowType() != 0 && (c = (holder = dockablePath.getLastHolder()).getComponent()) != null && !c.isShowing()) {
            mainWindow.restore();
        }
        dockablePath.getDockPanelHost().setDockableVisible(dockablePath, bVisible, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Dockable dockable) {
        this.addDockableEventContext(20);
        try {
            this.closeDockable(dockable, 20);
        }
        finally {
            this.removeDockableEventContext(20);
        }
    }

    public void saveLayout(PropertyAccess pa) {
        this.saveVisibilityLayout(this._currentVisibilityLayout);
        this.saveKnownFactories();
        this.savePositions();
    }

    private void savePositions() {
        DefaultStructuredPropertyAccess propertyAccess = new DefaultStructuredPropertyAccess(null);
        TitledPanelXMLDockLayoutPersistence persistence = new TitledPanelXMLDockLayoutPersistence();
        int start = this.saveMainPortPosition((StructuredPropertyAccess)propertyAccess, persistence);
        this.saveFloatingWindowsPosition(start, (StructuredPropertyAccess)propertyAccess, persistence);
        LayoutsImpl.getInstance().setDockablePositions((StructuredPropertyAccess)propertyAccess);
    }

    private int saveMainPortPosition(StructuredPropertyAccess propertyAccess, XMLDockLayoutPersistence persistence) {
        int i;
        for (i = 0; i < this._sidePorts.length; ++i) {
            SidePort sidePort = this._sidePorts[i];
            try {
                StructuredPropertyAccess sidePortLayout = sidePort.saveLayout(persistence);
                propertyAccess.appendChild(sidePortLayout);
                continue;
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        return i;
    }

    private void saveFloatingWindowsPosition(int start, StructuredPropertyAccess propertyAccess, XMLDockLayoutPersistence persistence) {
        for (int i = start; i < this._dockPanelHosts.size(); ++i) {
            DockPanelHost host = this._dockPanelHosts.get(i);
            try {
                StructuredPropertyAccess hostLayout = host.saveLayout(persistence);
                propertyAccess.appendChild(hostLayout);
                continue;
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    private void saveKnownFactories() {
        ArrayList<String> dockableFactoriesNames = this._factoryRegistry.getDockableFactoriesNames();
        String[] factoryNames = dockableFactoriesNames.toArray(new String[dockableFactoriesNames.size()]);
        LayoutsImpl.getInstance().setKnownDockableFactories(factoryNames);
    }

    void closeDockable(Dockable dockable, int flags) {
        JComponent clientRemoved;
        DockablePath path = new DockablePath();
        if (!this.getDockablePath(path, new DockableCriteria(dockable))) {
            return;
        }
        boolean wasFocused = false;
        KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = currentKeyboardFocusManager.getPermanentFocusOwner();
        if (c != null && (clientRemoved = path.getLastHolder().getComponent()) != null && clientRemoved.isAncestorOf(c)) {
            currentKeyboardFocusManager.clearGlobalFocusOwner();
            wasFocused = true;
        }
        if (BitField.isSet((int)dockable.getType(), (int)1)) {
            if (dockable.getUniqueName() != null && dockable.getUniqueName().equals("ExplorerWindow.SingletonExplorerWindow") || dockable.getUniqueName().equals("InspectorWindow.SingletonInspectorWindow")) {
                this.setDockableVisible(dockable, false, flags);
            } else {
                this.undock(path, flags);
                TitledPanel titledPanel = path.getTitledPanel();
                if (titledPanel.getClientCount() == 0) {
                    titledPanel.getDockPanel().remove(titledPanel);
                }
            }
        } else {
            this.setDockableVisible(dockable, false, flags);
        }
        if (wasFocused) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    public TitledPanel _dock(Dockable dockable, DockPanel dp, DockLayoutConstraint dlc, boolean bVisible, int flags) {
        TitledPanel tpNew = DockStationImpl.wrap(dockable, bVisible, flags);
        if (tpNew != null) {
            this._dock(tpNew, dp, dlc);
        }
        return tpNew;
    }

    private DockStationImpl() {
    }

    private List<DockablePath> getDockablePaths() {
        ArrayList<DockablePath> dockablePaths = new ArrayList<DockablePath>();
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            dockPanelHost.getDockablePaths(dockablePaths);
        }
        return dockablePaths;
    }

    private void setApplicationFrame(JFrame frame) {
        this._frame = frame;
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        this._frame.getLayeredPane().add((Component)shutterPanel, (Object)50);
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandler) {
        this._activeViewHandler = activeViewHandler;
        for (SidePort sidePort : this._sidePorts) {
            sidePort.setActiveViewHandler(activeViewHandler);
        }
    }

    ActiveViewHandlerImpl getActiveViewHandler() {
        return this._activeViewHandler;
    }

    public int getPanelOrientation(DockPanel dp) {
        for (int i = 0; i < this._sidePorts.length; ++i) {
            if (!this._sidePorts[i].getDockablePath(new DockablePath(), new DockableCriteria(dp))) continue;
            return i;
        }
        return -1;
    }

    SidePort getSidePort(int orientation) {
        return this._sidePorts[orientation];
    }

    public Dockable getActiveDockable() {
        DockablePath path = new DockablePath();
        return this.getActiveDockablePath(path) ? path.getDockable() : null;
    }

    private boolean getActiveDockablePath(DockablePath dockablePath) {
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            if (!dockPanelHost.getActiveDockablePath(dockablePath)) continue;
            dockablePath.setDockPanelHost(dockPanelHost);
            return true;
        }
        return false;
    }

    private boolean activateDockable(DockablePath dockablePath) {
        if (!dockablePath.getTitledPanel().isClientAccessible(dockablePath.getDockable())) {
            return false;
        }
        return dockablePath.getDockPanelHost().activateDockable(dockablePath);
    }

    public boolean activateDockable(Dockable dockable) {
        if (this.getActiveDockable() == dockable) {
            return true;
        }
        this.setDockableVisible(dockable, true, 0);
        DockablePath path = new DockablePath();
        if (this.getDockablePath(path, new DockableCriteria(dockable))) {
            return this.activateDockable(path);
        }
        return false;
    }

    public boolean activateAnyDockable() {
        return this.activateFirstDockable();
    }

    private boolean activateNextDockable(boolean bNext) {
        DockablePath dockablePath;
        DockablePath activeDockablePath = new DockablePath();
        if (!this.getActiveDockablePath(activeDockablePath)) {
            return false;
        }
        LinkedList<DockablePath> dockableList = new LinkedList<DockablePath>();
        for (DockablePath dockablePath2 : this.getDockablePaths()) {
            if (!this.isDockableVisible(dockablePath2.getDockable())) continue;
            dockableList.addLast(dockablePath2);
        }
        if (dockableList.size() < 1) {
            return false;
        }
        while (!(dockablePath = (DockablePath)dockableList.getFirst()).equals(activeDockablePath)) {
            dockableList.removeFirst();
            dockableList.addLast(dockablePath);
        }
        DockableSelector dockableSelector = DockableSelector.getInstance();
        if (bNext) {
            if (dockableSelector.sizeOfDisplayables() > 1) {
                dockableSelector.selectNext(dockableList);
                return true;
            }
            return false;
        }
        if (dockableSelector.sizeOfDisplayables() > 1) {
            dockableSelector.selectPrevious(dockableList);
            return true;
        }
        return false;
    }

    public List<DockablePath> getVisibleDockablePaths() {
        LinkedList<DockablePath> dockableList = new LinkedList<DockablePath>();
        for (DockablePath dockablePath : this.getDockablePaths()) {
            if (!this.isDockableVisible(dockablePath.getDockable())) continue;
            dockableList.addLast(dockablePath);
        }
        return dockableList;
    }

    private boolean activateFirstDockable() {
        DockablePath dockablePath;
        int i;
        List<DockablePath> dockables = this.getDockablePaths();
        int n = dockables.size();
        for (i = 0; i < n; ++i) {
            dockablePath = dockables.get(i);
            if (!this.isVisible(dockablePath) || !this.activateDockable(dockablePath)) continue;
            return true;
        }
        for (i = 0; i < n; ++i) {
            dockablePath = dockables.get(i);
            if (!this.isMinimized(dockablePath) || !this.activateDockable(dockablePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isVisible(DockablePath path) {
        return BitField.isSet((int)this.status(path), (int)32);
    }

    private boolean isMinimized(DockablePath path) {
        return BitField.isSet((int)this.status(path), (int)4);
    }

    private int status(DockablePath path) {
        return path.getTitledPanel().getDockableStatus(path.getDockable());
    }

    private static void fireDockableEvent(List<DockableListener> list, DockableEvent e) {
        if (list == null) {
            return;
        }
        int eventID = e.getID();
        for (DockableListener dl : list) {
            switch (eventID) {
                case 1: {
                    dl.dockableHidden(e);
                    break;
                }
                case 0: {
                    dl.dockableShown(e);
                }
            }
        }
    }

    public void fireDockableEvent(DockableEvent e) {
        Dockable dockable = e.getSource();
        DockStationImpl.fireDockableEvent(this._dockableListeners.get((Object)dockable), e);
        DockStationImpl.fireDockableEvent(this._dockableListeners.get(null), e);
    }

    private static String getContextName(int flags) {
        String contextName = (BitField.isSet((int)flags, (int)1) ? "LAYOUT_CHANGE " : "") + (BitField.isSet((int)flags, (int)2) ? "LAYOUT_INSTALL " : "") + (BitField.isSet((int)flags, (int)4) ? "USER_ACTION " : "") + (BitField.isSet((int)flags, (int)8) ? "DRAG " : "") + (BitField.isSet((int)flags, (int)16) ? "TOGGLE " : "");
        return contextName;
    }

    public void addDockableEventContext(int nContext) {
        this._nDockableEventContext |= nContext;
    }

    public void removeDockableEventContext(int nContext) {
        this._nDockableEventContext &= ~nContext;
    }

    private int getDockableEventContext() {
        return this._nDockableEventContext;
    }

    private static Component prepareToRemove(TitledPanel tp) {
        Component cRestoreFocus;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, tp)) {
            cRestoreFocus = focusOwner;
            IdeUtil.moveFocusAway();
        } else {
            cRestoreFocus = null;
        }
        return cRestoreFocus;
    }

    void _dock(TitledPanel tpDocked, DockPanel dpTarget, DockLayoutConstraint dlc) {
        final Component cRestoreFocus = DockStationImpl.prepareToRemove(tpDocked);
        dpTarget.dock(tpDocked, dlc);
        if (cRestoreFocus != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.tryToRestoreFocus((Component)cRestoreFocus);
                }
            });
        }
        dpTarget.revalidate();
    }

    private static TitledPanel wrap(Dockable dockable, boolean bVisible, int flags) {
        TitledPanel tp = new TitledPanel();
        if (!bVisible) {
            tp.setVisible(false);
        }
        tp.addClient(dockable, bVisible, flags);
        return tp;
    }

    static void transferClients(TitledPanel tpFrom, TitledPanel tpTo, int flags) {
        Container dpFrom = tpFrom.getParent();
        Container dpTo = tpTo.getParent();
        TitledPanelHolder selectedHolder = tpFrom.getSelectedHolder();
        Dockable selectedDockable = selectedHolder.getDockable();
        tpTo.transferClients(tpFrom, flags);
        tpTo.activateDockable(selectedDockable);
        Container dpSource = tpFrom.getParent();
        dpSource.remove(tpFrom);
        dpFrom.validate();
        dpTo.validate();
    }

    FloatDockWindow dockFloat(TitledPanel tp, Point pt) {
        return this.dockFloat(tp, pt, null);
    }

    private FloatDockWindow dockFloat(TitledPanel tp, Point pt, Dimension dimension) {
        boolean bVisible = tp.isVisible();
        FloatDockWindow floatDockWindow = new FloatDockWindow(this._frame);
        Dimension dPrefSize = tp.getPrefDockedSize();
        DockLayoutConstraint dlc = new DockLayoutConstraint(0, dPrefSize);
        floatDockWindow.dock(tp, dlc);
        floatDockWindow.createWindowUI();
        Dimension dFloatSize = dimension == null ? tp.getPrefFloatSize() : dimension;
        floatDockWindow.adjustClientSize(dFloatSize, false);
        Window fdwGui = floatDockWindow.getGUI();
        fdwGui.setVisible(false);
        fdwGui.setSize(dFloatSize);
        if (pt != null) {
            fdwGui.setLocation(pt);
        } else {
            GraphicsUtils.centerWindowOnComponent((Window)fdwGui, (Component)this._frame);
        }
        if (bVisible) {
            this.setFloatVisible(floatDockWindow, true);
        }
        return floatDockWindow;
    }

    void registerDockPanelHost(DockPanelHost dph) {
        this._dockPanelHosts.add(dph);
    }

    void unregisterDockPanelHost(DockPanelHost dph) {
        this._dockPanelHosts.remove(dph);
    }

    DockInsertionPoint getDockInsertionAt(Point pt) {
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        int maximizedWindowType = mainWindow.getMaximizedWindowType();
        if (maximizedWindowType != 0) {
            return null;
        }
        DockInsertionPoint dipRet = null;
        double nMinDist = 2.147483647E9;
        Point ptLocal = new Point();
        boolean bMinIsFloat = false;
        int nDPH = this._dockPanelHosts.size();
        for (int i = 0; i < nDPH; ++i) {
            DockPanelHost dph = this._dockPanelHosts.get(i);
            DockInsertionPoint dip = dph.getDockInsertionAt(pt);
            if (dip == null) continue;
            Point ptAnchor = dip.getAnchor();
            double nDist = ptLocal.distanceSq(ptAnchor);
            boolean bThisIsFloat = dph instanceof FloatDockWindow;
            if (!(nDist < nMinDist) && (!bThisIsFloat || bMinIsFloat)) continue;
            nMinDist = nDist;
            dipRet = dip;
            bMinIsFloat = bThisIsFloat;
        }
        return dipRet;
    }

    Dockable loadDockable(PropertyAccess layout, String strViewId) {
        Dockable ret = null;
        Dockable dockable = this.findDockable(new ViewId(strViewId));
        if (dockable != null) {
            try {
                dockable.loadLayout(layout);
                ret = dockable;
            }
            catch (Throwable e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        return ret;
    }

    void saveViewData(Dockable dockable) {
        if (this._currentLayout != null) {
            DefaultStructuredPropertyAccess pa = ClientLayoutData.newViewStorage();
            try {
                dockable.saveLayout((PropertyAccess)pa);
                if (pa.hasAttributes() || pa.hasChildNodes()) {
                    ClientLayoutData.addOrReplaceViewStorage(dockable, (StructuredPropertyAccess)pa, this._currentLayout);
                }
            }
            catch (Throwable e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    void loadViewData(Dockable dockable) {
        StructuredPropertyAccess pa;
        if (this._currentLayout != null && (pa = ClientLayoutData.findStructuredPropertyAccess(dockable, this._currentLayout)) != null) {
            try {
                dockable.loadLayout((PropertyAccess)pa);
            }
            catch (Throwable e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return this.viewCache.get(viewId.getId());
    }

    public Dockable findDockable(ViewId viewId) {
        Dockable dockable = this.getDockable(viewId);
        if (dockable == null) {
            dockable = this.createDockable(viewId);
        }
        return dockable;
    }

    public DockableDragContext createDockableDragContext(DockableDragSource dockableDragSource) {
        return new DockableDragContextImpl(dockableDragSource);
    }

    private Dockable createDockable(ViewId viewId) {
        DockableFactory factory = this.lookupFactory(viewId);
        if (factory == null) {
            return null;
        }
        String key = this.getClass().getName() + ".createDockable." + viewId;
        Dockable dockable = factory.getDockable(viewId);
        SplashScreen.log((String)" dockable loaded");
        return dockable;
    }

    public DockableFactory lookupFactory(ViewId viewId) {
        return this._factoryRegistry.getFactory(viewId.getType());
    }

    protected void addToCache(Dockable dockable) {
        this.viewCache.put(dockable.getUniqueName(), dockable);
    }

    protected void removeFromCache(Dockable dockable) {
        this.removeFromCache(dockable.getUniqueName());
    }

    protected void removeFromCache(String uniqueName) {
        boolean bIsInLayoutChange;
        boolean bl = bIsInLayoutChange = (this.getDockableEventContext() & 1) != 0;
        if (!bIsInLayoutChange) {
            this.viewCache.remove(uniqueName);
        }
    }

    protected DrawerModel createDrawerModel(DrawerDockableWindow drawerDockableWindow) {
        return new DrawerModelImpl(drawerDockableWindow);
    }

    void loadLayout(Layout layout) {
        if (layout instanceof IdeLayout) {
            IdeLayout ideLayout = (IdeLayout)layout;
            layout = ideLayout.getActiveLayout();
        } else {
            System.out.println("DockStationImpl.loadLayout: This time, the layout is of type " + layout.getClass().getName());
        }
        if (this._currentLayout != null) {
            this.onLayoutChange(layout);
        } else {
            this.tellMeWhenIdeIsUp();
            LayoutsImpl layouts = LayoutsImpl.getInstance();
            if (layouts.hasDockableFactoryNode()) {
                this.onStartup(layout);
            } else {
                this.onFreshInstall(layout);
            }
        }
        this.dumpAllDockables();
    }

    public void restoreViewsToFactorySettings() {
        List<Dockable> allDockables = this.getAllDockables();
        for (Dockable dockable : allDockables) {
            this.undock(dockable);
        }
        this.reinstallFactories(this.getRegisteredFactories());
    }

    public void loadCurrentLayout(View lastActiveView, Editor currentEditor, Context context) {
        String lastActiveViewId = null;
        Context newContext = null;
        if (context != null) {
            newContext = new Context(context);
        }
        Dockable toActivate = null;
        ArrayList<Dockable> toRaise = new ArrayList<Dockable>();
        for (Dockable d : this.getAllDockables()) {
            this.setDefaultState(d, this._currentLayout);
            boolean showing = DockUtil.isShowingByDefault((Dockable)d, (Layout)this._currentLayout);
            if (!showing) continue;
            if (this.shouldActivate(d, lastActiveViewId)) {
                toActivate = d;
            }
            this.setContext(d, newContext);
            if (!DockUtil.isRaisedByDefault((Dockable)d, (Layout)this._currentLayout)) continue;
            toRaise.add(d);
        }
        for (Dockable d : toRaise) {
            this.raise(d);
        }
        if (toActivate != null) {
            this.activateDockable(toActivate);
        }
        this.activateEditor(lastActiveView, currentEditor, lastActiveViewId);
    }

    private boolean shouldActivate(Dockable dockable, String lastActiveViewId) {
        String dockableId;
        return dockable instanceof View && ModelUtil.areEqual((Object)lastActiveViewId, (Object)(dockableId = ((View)dockable).getId()));
    }

    private void setContext(Dockable dockable, Context context) {
        if (dockable instanceof AbstractPinnable) {
            ((AbstractPinnable)dockable).setContext(context);
        }
    }

    private void activateEditor(View lastActiveView, Editor currentEditor, String lastActiveViewId) {
        if (lastActiveView != currentEditor || currentEditor == null) {
            return;
        }
        List editors = EditorManager.getEditorManager().getAllEditors();
        for (Object e : editors) {
            Editor editor;
            if (!(e instanceof Editor) || !ModelUtil.areEqual((Object)(editor = (Editor)e).getId(), (Object)lastActiveViewId)) continue;
            editor.show();
            editor.getGUI().requestFocusInWindow();
            editor.activate();
            break;
        }
    }

    private void raise(Dockable dockable) {
        this.setDockableVisible(dockable, false);
        this.setDockableVisible(dockable, true);
    }

    private void reinstallFactories(List<String> factories) {
        int count = factories.size();
        for (int i = 0; i < count; ++i) {
            String viewTypeId = factories.get(i);
            DockableFactory dockableFactory = this._factoryRegistry.getFactory(viewTypeId);
            boolean shouldReinstall = true;
            if (dockableFactory instanceof DockableFactory2) {
                shouldReinstall = ((DockableFactory2)dockableFactory).canReinstall();
            }
            if (!shouldReinstall) continue;
            try {
                dockableFactory.install();
                continue;
            }
            catch (Throwable t) {
                FeedbackManager.reportException((Throwable)t);
            }
        }
    }

    private void onFreshInstall(Layout layout) {
        this._currentLayout = layout;
        this._currentVisibilityLayout = DockStationImpl.getVisibilityLayout(layout);
        List<String> allRegisteredFactories = this.getRegisteredFactories();
        this.installFactories(allRegisteredFactories);
        List<Dockable> dockables = this.getAllDockables();
        this.setDefaultState(dockables, layout);
    }

    private void onStartup(Layout layout) {
        this._currentLayout = layout;
        this._currentVisibilityLayout = DockStationImpl.getVisibilityLayout(layout);
        List<Dockable> knownDockables = this.getAllDockables();
        List<String> newFactories = this.getNewFactories();
        List<Dockable> newDockables = null;
        if (!newFactories.isEmpty()) {
            this.onFreshInstall(layout);
        } else {
            this.loadExistingPositions();
        }
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            dockPanelHost.loadVisibilityLayout(this._currentVisibilityLayout, true, 0);
        }
        if (newDockables != null) {
            this.setDefaultState(newDockables, this._currentLayout);
        }
    }

    private void loadExistingPositions() {
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        StructuredPropertyAccess dockablePositions = layouts.getDockablePositions();
        if (dockablePositions != null) {
            TitledPanelXMLDockLayoutPersistence xmlDockLayoutPersistence = new TitledPanelXMLDockLayoutPersistence();
            this.loadValidLayout(xmlDockLayoutPersistence, dockablePositions);
        }
    }

    private void onLayoutChange(Layout newLayout) {
        VisibilityLayout toVisibilityLayout = DockStationImpl.getVisibilityLayout(newLayout);
        VisibilityLayout fromVisibilityLayout = this._currentVisibilityLayout;
        this._currentLayout = newLayout;
        this.switchVisibilityLayout(fromVisibilityLayout, toVisibilityLayout, newLayout);
        this._currentVisibilityLayout = toVisibilityLayout;
    }

    private void setDefaultState(List<Dockable> dockables, Layout layout) {
        for (Dockable dockable : dockables) {
            this.setDefaultState(dockable, layout);
        }
    }

    private void setDefaultState(Dockable dockable, Layout layout) {
        try {
            DockablePath dockablePath;
            boolean show = DockUtil.isShowingByDefault((Dockable)dockable, (Layout)layout);
            boolean minimize = DockUtil.isMinimizedByDefault((Dockable)dockable, (Layout)layout);
            if ((minimize || show) && this.getDockablePath(dockablePath = new DockablePath(), new DockableCriteria(dockable))) {
                List<DockableHolderImpl> dockableHolders = dockablePath.getDockableHolders();
                for (int i = 0; i < dockableHolders.size() - 1; ++i) {
                    DockableHolderImpl dockableHolder = dockableHolders.get(i);
                    Dockable dockable_i = dockableHolder.getDockable();
                    show &= DockUtil.isShowingByDefault((Dockable)dockable_i, (Layout)layout);
                    minimize = DockUtil.isMinimizedByDefault((Dockable)dockable_i, (Layout)layout);
                }
                if (minimize) {
                    TitledPanel titledPanel = dockablePath.getTitledPanel();
                    titledPanel.minimize(false, 0);
                }
                if (show) {
                    this.setDockableVisible(dockable, true, 0);
                }
            }
        }
        catch (Throwable e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    private List<Dockable> getAllDockables() {
        List<DockablePath> dockablePaths = this.getDockablePaths();
        ArrayList<Dockable> allDockables = new ArrayList<Dockable>();
        for (DockablePath dockablePath : dockablePaths) {
            Dockable dockable = dockablePath.getDockable();
            allDockables.add(dockable);
        }
        return allDockables;
    }

    private List<String> getNewFactories() {
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        String[] knownDockableFactories = layouts.getKnownDockableFactories();
        List<String> knownList = Arrays.asList(knownDockableFactories);
        List<String> registeredDockableFactoriesNames = this.getRegisteredFactories();
        registeredDockableFactoriesNames.removeAll(knownList);
        return registeredDockableFactoriesNames;
    }

    private List<String> getRegisteredFactories() {
        ArrayList<String> registeredDockableFactoriesNames = this._factoryRegistry.getDockableFactoriesNames();
        return registeredDockableFactoriesNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installFactories(List<String> factories) {
        this.undockedDockables = new ArrayList<UndockedDockable>();
        try {
            int count = factories.size();
            for (int i = 0; i < count; ++i) {
                String viewTypeId = factories.get(i);
                DockableFactory dockableFactory = this._factoryRegistry.getFactory(viewTypeId);
                try {
                    String msg = "Installed " + dockableFactory.getClass().getName();
                    String key = "installFactories";
                    dockableFactory.install();
                    continue;
                }
                catch (Throwable t) {
                    FeedbackManager.reportException((Throwable)t);
                }
            }
            while (!this.undockedDockables.isEmpty()) {
                List<UndockedDockable> lastUndockedDockables = this.undockedDockables;
                this.undockedDockables = new ArrayList<UndockedDockable>();
                for (UndockedDockable dockable : lastUndockedDockables) {
                    try {
                        String viewId;
                        Dockable reference = dockable.param.getReference();
                        if (reference instanceof View && (reference = this.viewCache.get(viewId = ((View)reference).getId())) != null) {
                            dockable.param.setReference(reference);
                        }
                        this.dockAsDocked(dockable.dockable, dockable.param, dockable.flags);
                    }
                    catch (Throwable t) {
                        FeedbackManager.reportException((Throwable)t);
                    }
                }
                if (this.undockedDockables.size() != lastUndockedDockables.size()) continue;
                break;
            }
            if (!this.undockedDockables.isEmpty()) {
                StringBuilder builder = new StringBuilder("Unable to dock:");
                for (UndockedDockable dockable : this.undockedDockables) {
                    builder.append("\n  ");
                    builder.append(dockable);
                }
                throw new IllegalArgumentException(builder.toString());
            }
        }
        finally {
            this.undockedDockables = null;
        }
    }

    private void dumpAllDockables() {
    }

    private void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        visibilityLayout.clear();
        for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
            dockPanelHost.saveVisibilityLayout(visibilityLayout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchVisibilityLayout(VisibilityLayout oldVisibilityLayout, VisibilityLayout newVisibilityLayout, Layout layout) {
        this.addDockableEventContext(1);
        try {
            String[] newDockableIDs;
            this._printInvalidDockingOperations = true;
            for (String dockableName : newDockableIDs = VisibilityLayout.getNewDockables(oldVisibilityLayout, newVisibilityLayout)) {
                int dockableType;
                boolean isGlobal;
                ViewId viewId = new ViewId(dockableName);
                Dockable dockable = this.getDockable(viewId);
                if (dockable == null || (isGlobal = BitField.isSet((int)(dockableType = dockable.getType()), (int)32))) continue;
                boolean isVisible = DockUtil.isShowingByDefault((Dockable)dockable, (Layout)layout);
                boolean isMinimized = DockUtil.isMinimizedByDefault((Dockable)dockable, (Layout)layout);
                boolean isRaised = DockUtil.isRaisedByDefault((Dockable)dockable, (Layout)layout);
                newVisibilityLayout.setVisible(dockableName, isVisible);
                newVisibilityLayout.setMinimized(dockableName, isMinimized);
                newVisibilityLayout.setRaised(dockableName, isRaised);
            }
            for (DockPanelHost dockPanelHost : this._dockPanelHosts) {
                dockPanelHost.loadVisibilityLayout(newVisibilityLayout, false, 1);
            }
        }
        finally {
            this._printInvalidDockingOperations = false;
            this.removeDockableEventContext(1);
        }
    }

    private static VisibilityLayout getVisibilityLayout(Layout layout) {
        String layoutName = layout.getName();
        LayoutsImpl layouts = LayoutsImpl.getInstance();
        VisibilityLayout visibilityLayout = layouts.getVisibilityLayout(layoutName);
        return visibilityLayout;
    }

    private void loadValidLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess layoutNode) {
        String key = this.getClass().getName() + ".loadValidLayout";
        PerformanceLogger.get().startTiming(key);
        for (SidePort sidePort : this._sidePorts) {
            String panelName = sidePort.getPanelName();
            StructuredPropertyAccess dcpElement = layoutNode.getChildNode(panelName);
            try {
                sidePort.loadLayout(layoutPersistence, dcpElement);
            }
            catch (Throwable e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        Iterator childNodes = layoutNode.getChildNodes();
        while (childNodes.hasNext()) {
            StructuredPropertyAccess element = (StructuredPropertyAccess)childNodes.next();
            if (!"panel".equals(element.getName())) continue;
            try {
                FloatDockWindow fdw = new FloatDockWindow(this._frame);
                fdw.loadLayout(layoutPersistence, element);
            }
            catch (Throwable e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        PerformanceLogger.get().stopTiming(key, "Loaded layout");
    }

    void setFloatVisible(FloatDockWindow fdw, boolean bVisible) {
        if (!this._bIsUIVisible) {
            if (bVisible) {
                if (this._floatToShow == null) {
                    this._floatToShow = new ArrayList(3);
                }
                this._floatToShow.add(fdw);
            } else if (this._floatToShow != null) {
                this._floatToShow.remove(fdw);
            }
        } else {
            fdw.getGUI().setVisible(bVisible);
        }
    }

    static void transfer(TitledPanel titledPanel, DockPanel dockPanelTarget, DockLayoutConstraint dlc) {
        DockPanel dockPanelSource = titledPanel.getDockPanel();
        if (dockPanelSource != null) {
            int clientCount = titledPanel.getClientCount();
            ArrayList<TitledPanelHolder> dockableHoldersToMove = new ArrayList<TitledPanelHolder>(clientCount);
            for (int i = 0; i < clientCount; ++i) {
                TitledPanelHolder holder = titledPanel.getHolder(i);
                Dockable dockable = holder.getDockable();
                int dockableStatus = titledPanel.getDockableStatus(dockable);
                if (!BitField.isSet((int)dockableStatus, (int)2) || !BitField.isSet((int)dockableStatus, (int)8)) continue;
                dockableHoldersToMove.add(holder);
            }
            if (dockableHoldersToMove.size() == clientCount) {
                dockPanelSource.remove(titledPanel);
                dockPanelSource.revalidate();
            } else {
                TitledPanel newTitledPanel = new TitledPanel();
                for (TitledPanelHolder dockableHolder : dockableHoldersToMove) {
                    Dockable dockable = dockableHolder.getDockable();
                    titledPanel.removeClient(dockable, 0);
                    TitledPanelHolder newDockableHolder = new TitledPanelHolder(dockable);
                    Boolean floatOnTop = dockableHolder.getFloatOnTop();
                    newDockableHolder.setFloatOnTop(floatOnTop);
                    int pagePos = newTitledPanel.addClient(newDockableHolder, 0);
                    newTitledPanel.setClientVisible(pagePos, true, 0);
                }
                titledPanel = newTitledPanel;
            }
        }
        dockPanelTarget.add((Component)titledPanel, dlc);
        dockPanelTarget.revalidate();
    }

    public void floatPanel(TitledPanel titledPanel, Point pt) {
        TitledPanelHolder selectedHolder = titledPanel.getSelectedHolder();
        Dockable selectedDockable = selectedHolder.getDockable();
        this.dockFloat(titledPanel, pt);
        if (selectedDockable != null) {
            this.activateDockable(selectedDockable);
        }
    }

    private void tellMeWhenIdeIsUp() {
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void mainWindowOpened(IdeEvent e) {
                DockStationImpl.this.ideIsUp();
                Ide.removeIdeListener((IdeListener)this);
            }
        });
    }

    private void ideIsUp() {
        if (this._floatToShow != null) {
            for (FloatDockWindow fdw : this._floatToShow) {
                Window gui = fdw.getGUI();
                gui.setVisible(true);
            }
        }
        this._bIsUIVisible = true;
        this._floatToShow = null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: {
                this.activateNextDockable(true);
                break;
            }
            case 43: {
                this.activateNextDockable(false);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        switch (action.getCommandId()) {
            case 42: 
            case 43: {
                action.setEnabled(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        DockingConfigOptions dockingConfigOptions = DockingConfigOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        this.setPentaLayoutStyle(dockingConfigOptions.getStyle());
    }

    public Controller getController() {
        return this;
    }

    public DividerControlledPanel getDividerControlledPanel(int orientation) {
        SidePort sidePort = this._sidePorts[orientation];
        DividerControlledPanel dividerControlledPanel = sidePort.getDividerControlledPanel();
        return dividerControlledPanel;
    }

    DockPanelHost[] getAllDockPanelHosts() {
        return this._dockPanelHosts.toArray(new DockPanelHost[this._dockPanelHosts.size()]);
    }

    public List<Dockable> getAdjacentDockables(Dockable target) {
        ArrayList<Dockable> dockables = new ArrayList<Dockable>();
        DockablePath path = new DockablePath();
        if (this.getDockablePath(path, new DockableCriteria(target))) {
            ArrayList<DockablePath> allPaths = new ArrayList<DockablePath>();
            path.getTitledPanel().getDockablePaths(allPaths);
            for (DockablePath p : allPaths) {
                Dockable dockable = p.getDockable();
                if (dockable == target) continue;
                dockables.add(dockable);
            }
        }
        return dockables;
    }

    private class UndockedDockable {
        private Dockable dockable;
        private DockingParam param;
        private int flags;

        public UndockedDockable(Dockable dockable, DockingParam param, int flags) {
            this.dockable = dockable;
            this.param = param;
            this.flags = flags;
        }

        public String toString() {
            return this.dockable + " [" + this.param + ", flags " + this.flags + "]";
        }
    }
}

