/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableContainer;
import oracle.ide.docking.DockableHolder;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.TitledContainer;
import oracle.ideimpl.controls.OneLineBorder;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.controls.Handlebar;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractTitledPanel
extends JPanel
implements DockableContainer,
ActionListener,
MouseInputListener,
TitledContainer {
    private static final int BUTTON_POS_PAD = 0;
    private static final int BUTTON_POS_CLOSE = 1;
    private static final int BUTTON_POS_MINIMIZE_RESTORE = 2;
    private static final Dimension BUTTON_PAD_SIZE = new Dimension(3, 3);
    protected Handlebar _handlebar;
    protected Component _buttonPad;
    protected AbstractButton _buttonClose;
    protected AbstractButton _buttonPin;
    private DoubleClickTrigger _titleTrigger = new DoubleClickTrigger();
    protected static boolean _bDraging;
    protected static Point _ptStart;
    protected static final int DRAGSTART;

    protected abstract JPopupMenu getTitleContextMenu();

    protected abstract void whenSystemMenuClose(TitledPanelHolder var1);

    protected void systemMenuMoveFloating() {
    }

    protected void systemMenuSizeFloating() {
    }

    protected abstract void whenMinimize(int var1);

    protected abstract void whenMaximize(int var1);

    protected abstract void whenRestore(int var1, DockableHolder var2);

    protected abstract void whenClose(int var1);

    protected abstract void systemMenuSizeDocked();

    protected void systemMenuMoveDocked() {
    }

    protected abstract void whenSystemMenuFloat(DockableHolder var1);

    protected void whenSystemMenuDock() {
    }

    protected abstract boolean isMinimized();

    protected abstract boolean isMinimizable();

    protected abstract boolean isMaximized();

    protected abstract boolean isMaximizable();

    protected abstract boolean isFloating();

    protected abstract boolean canMove();

    protected abstract boolean canSize();

    protected abstract TitledPanelHolder getSelectedHolder();

    private static int getDragStart() {
        String defValue = "20";
        String property = Ide.getProperty((String)"docking.dragThreshold", (String)"20");
        int ret = 5;
        try {
            ret = Integer.parseInt(property);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret * ret;
    }

    protected AbstractTitledPanel() {
        super(new BorderLayout());
    }

    Handlebar getHandlebar() {
        return this._handlebar;
    }

    protected void createTitle() {
        this._handlebar = new Handlebar();
        this._handlebar.addMouseListener(this);
        this._handlebar.addMouseMotionListener(this);
        OneLineBorder oneLineBorder = new OneLineBorder(2, IdeConstants.COLOR_IDE_LINES);
        this._handlebar.setBorder(oneLineBorder);
    }

    protected final void createUIMap() {
        InputMap im = this.getInputMap(1);
        ActionMap am = this.getActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        AbstractTitledPanelAction a = new AbstractTitledPanelAction("aEditor");
        im.put(ks, a);
        am.put(a, a);
        ks = KeyStroke.getKeyStroke(45, 8);
        a = new AbstractTitledPanelAction("showSysMenu");
        im.put(ks, a);
        am.put(a, a);
        ks = AbstractTitledPanel.getClosePanelKeyStroke();
        a = new AbstractTitledPanelAction("sysClose");
        im.put(ks, a);
        am.put(a, a);
    }

    protected static KeyStroke getClosePanelKeyStroke() {
        return KeyStroke.getKeyStroke(27, 1);
    }

    protected void titleMousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showTitleContextMenu(e);
        }
    }

    protected void titleMouseDragged(MouseEvent e) {
    }

    protected void titleMouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showTitleContextMenu(e);
        }
    }

    protected void showTitleContextMenu(MouseEvent e) {
        JPopupMenu popup = this.getTitleContextMenu();
        if (popup != null) {
            Point showPoint = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)popup, (MouseEvent)e);
            popup.show(e.getComponent(), showPoint.x, showPoint.y);
        }
    }

    private AbstractButton addButton(int pos, Icon icon, String tooltip) {
        SmallSquareButton button = new SmallSquareButton(icon, tooltip);
        button.setOpaque(false);
        button.addActionListener((ActionListener)this);
        this.getHandlebar().addButton(button, pos);
        return button;
    }

    private void removeButton(int pos) {
        this.getHandlebar().removeButton(pos);
    }

    protected void adjustButtons(Dockable selectedDockable) {
        String tooltip;
        if (this._buttonPad == null) {
            this._buttonPad = Box.createRigidArea(BUTTON_PAD_SIZE);
            this.getHandlebar().add(this._buttonPad, new Integer(0));
        }
        if (this._buttonClose == null) {
            tooltip = IdeArb.getString((int)465);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 1);
            String keyStrokeText = KeyUtil.toString((KeyStroke)keyStroke);
            String tooltipWithText = tooltip + " (" + keyStrokeText + ")";
            this._buttonClose = this.addButton(1, OracleIcons.getIcon((String)"extras/small_close.gif"), tooltipWithText);
        }
        if (this.isMinimizable() || this.isMaximizable()) {
            if (this._buttonPin == null) {
                if (this.isMinimized() || this.isMaximized()) {
                    tooltip = IdeImplArb.getString(58);
                    this._buttonPin = this.addButton(2, OracleIcons.getIcon((String)"extras/restore.gif"), tooltip);
                } else {
                    tooltip = IdeImplArb.getString(56);
                    this._buttonPin = this.addButton(2, OracleIcons.getIcon((String)"extras/minimize.gif"), tooltip);
                }
            }
        } else if (this._buttonPin != null) {
            this.removeButton(2);
            this._buttonPin = null;
        }
    }

    protected void adjustTitle(Dockable dockable) {
        String sTitle = dockable.getTitleName();
        this.setTitle(sTitle);
        this.setIcon(dockable.getTabIcon());
    }

    private void setTitle(String title) {
        this._handlebar.setTitle(title);
    }

    private void setIcon(Icon icon) {
        this._handlebar.setIcon(icon);
    }

    boolean isActive() {
        return this._handlebar.isActive();
    }

    private Action createAction(String cmd, int arbKey, DockableHolder holder, boolean enabled) {
        String s = IdeImplArb.getString(arbKey);
        AbstractTitledPanelAction a = new AbstractTitledPanelAction(cmd, StringUtils.stripMnemonic((String)s));
        a.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)s));
        if (holder != null) {
            a.putValue("selectedHolder", holder);
        }
        a.setEnabled(enabled);
        return a;
    }

    protected JPopupMenu createSystemMenu(DockableHolder selectedHolder) {
        KeyStroke key;
        String s;
        String cmd;
        JPopupMenu popup = new JPopupMenu();
        boolean isFloating = this.isFloating();
        if (this.isMaximizable() || this.isMinimizable()) {
            popup.add(this.createAction("restore", 46, selectedHolder, this.isMaximized() || this.isMinimized()));
        }
        if (isFloating) {
            popup.add(this.createAction("dock", 47, null, true));
        }
        popup.add(this.createAction(isFloating ? "moveFloat" : "moveDocked", 48, null, this.canMove()));
        popup.add(this.createAction(isFloating ? "sizeFloat" : "sizeDocked", 49, null, this.canSize()));
        if (!isFloating) {
            popup.add(this.createAction("float", 50, selectedHolder, true));
        }
        popup.add(this.createAction("minimize", 51, null, this.isMinimizable() && !this.isMinimized()));
        popup.add(this.createAction("maximize", 52, null, this.isMaximizable() && !this.isMaximized()));
        popup.add(new JSeparator());
        if (selectedHolder != null) {
            cmd = "sysClose";
            s = IdeImplArb.getString(53);
            key = AbstractTitledPanel.getClosePanelKeyStroke();
        } else {
            cmd = "close";
            s = IdeImplArb.getString(44);
            key = null;
        }
        AbstractTitledPanelAction a = new AbstractTitledPanelAction(cmd, StringUtils.stripMnemonic((String)s));
        a.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)s));
        a.putValue("AcceleratorKey", key);
        a.putValue("selectedHolder", selectedHolder);
        popup.add(a);
        return popup;
    }

    protected void whenShowSystemMenu() {
        Component f;
        TitledPanelHolder holder = this.getSelectedHolder();
        JPopupMenu popup = this.createSystemMenu(holder);
        Component src = this;
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null && (f = w.getFocusOwner()) != null) {
            src = f;
        }
        Point pt = this.getLocationOnScreen();
        Insets insets = this.getInsets();
        pt.x += insets.left;
        if (this._handlebar != null) {
            pt.y += this._handlebar.getHeight();
        }
        pt = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)popup, (int)pt.x, (int)pt.y);
        SwingUtilities.convertPointFromScreen(pt, src);
        popup.show(src, pt.x, pt.y);
    }

    private static void whenActivateEditors() {
        EditorManager em = EditorManager.getEditorManager();
        em.activateCurrentEditorFrame();
        Ide.getMainWindow().toFront();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._buttonClose) {
            this.whenClose(20);
        } else if (source == this._buttonPin) {
            if (this.isMinimized() || this.isMaximized()) {
                this.whenRestore(4, this.getSelectedHolder());
            } else {
                this.whenMinimize(4);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this._titleTrigger.isDoubleClick(e) && this.isMaximizable()) {
            if (this.isMaximized()) {
                this.whenRestore(4, this.getSelectedHolder());
            } else {
                this.whenMaximize(4);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.titleMousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.titleMouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.titleMouseDragged(e);
    }

    public void containerActivated(boolean isActive) {
        this._handlebar.setActive(isActive);
    }

    private String getTitle() {
        return this._handlebar.getTitle();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    static {
        _ptStart = new Point();
        DRAGSTART = AbstractTitledPanel.getDragStart();
    }

    protected class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        protected MyAccessibleContext() {
            super(AbstractTitledPanel.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return AbstractTitledPanel.this.getTitle();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }
    }

    protected class AbstractTitledPanelAction
    extends AbstractAction {
        public static final String CMD_CLOSE = "close";
        public static final String CMD_SHOW_SYS_MENU = "showSysMenu";
        public static final String CMD_ACTIVATE_EDITOR = "aEditor";
        public static final String CMD_SYS_MENU_CLOSE = "sysClose";
        public static final String CMD_SYS_MENU_MINIMIZE = "minimize";
        public static final String CMD_SYS_MENU_MAXIMIZE = "maximize";
        public static final String CMD_SYS_MENU_RESTORE = "restore";
        public static final String CMD_SYS_MENU_DOCK = "dock";
        public static final String CMD_SYS_MENU_FLOAT = "float";
        public static final String CMD_SYS_MOVE_DOCKED = "moveDocked";
        public static final String CMD_SYS_SIZE_DOCKED = "sizeDocked";
        public static final String CMD_SYS_MOVE_FLOAT = "moveFloat";
        public static final String CMD_SYS_SIZE_FLOAT = "sizeFloat";
        public static final String SELECTED_HOLDER_KEY = "selectedHolder";

        AbstractTitledPanelAction(String sCmd) {
            this.init(sCmd);
        }

        AbstractTitledPanelAction(String sCmd, String sName) {
            super(sName);
            this.init(sCmd);
        }

        AbstractTitledPanelAction(String sCmd, String sName, Icon icon) {
            super(sName, icon);
            this.init(sCmd);
        }

        private void init(String sCmd) {
            this.putValue("ActionCommandKey", sCmd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            DockStationImpl dockStation = DockStationImpl.getInstance();
            dockStation.addDockableEventContext(4);
            try {
                String sActionCommand;
                TitledPanelHolder selectedHolder = (TitledPanelHolder)this.getValue(SELECTED_HOLDER_KEY);
                if (selectedHolder == null) {
                    selectedHolder = AbstractTitledPanel.this.getSelectedHolder();
                }
                if ((sActionCommand = (String)this.getValue("ActionCommandKey")) == CMD_CLOSE) {
                    AbstractTitledPanel.this.whenClose(20);
                } else if (sActionCommand == CMD_SHOW_SYS_MENU) {
                    AbstractTitledPanel.this.whenShowSystemMenu();
                } else if (sActionCommand == CMD_ACTIVATE_EDITOR) {
                    AbstractTitledPanel.whenActivateEditors();
                } else if (sActionCommand == CMD_SYS_MENU_CLOSE) {
                    AbstractTitledPanel.this.whenSystemMenuClose(selectedHolder);
                } else if (sActionCommand == CMD_SYS_MENU_MINIMIZE) {
                    AbstractTitledPanel.this.whenMinimize(4);
                } else if (sActionCommand == CMD_SYS_MENU_MAXIMIZE) {
                    AbstractTitledPanel.this.whenMaximize(4);
                } else if (sActionCommand == CMD_SYS_MENU_RESTORE) {
                    AbstractTitledPanel.this.whenRestore(4, selectedHolder);
                } else if (sActionCommand == CMD_SYS_MENU_DOCK) {
                    AbstractTitledPanel.this.whenSystemMenuDock();
                } else if (sActionCommand == CMD_SYS_MENU_FLOAT) {
                    AbstractTitledPanel.this.whenSystemMenuFloat(selectedHolder);
                } else if (sActionCommand == CMD_SYS_MOVE_DOCKED) {
                    AbstractTitledPanel.this.systemMenuMoveDocked();
                } else if (sActionCommand == CMD_SYS_SIZE_DOCKED) {
                    AbstractTitledPanel.this.systemMenuSizeDocked();
                } else if (sActionCommand == CMD_SYS_MOVE_FLOAT) {
                    AbstractTitledPanel.this.systemMenuMoveFloating();
                } else if (sActionCommand == CMD_SYS_SIZE_FLOAT) {
                    AbstractTitledPanel.this.systemMenuSizeFloating();
                }
            }
            finally {
                dockStation.removeDockableEventContext(4);
            }
        }
    }
}

