/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Image;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ide.extension.Extension;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.IconDescription;
import javax.ide.util.MissingIconException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeMainWindow;
import oracle.ide.IdeUIManager;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.keyboard.IdeInputMapUIResource;
import oracle.ide.layout.Layouts;
import oracle.ide.migration.MigrationManager;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullSecurityManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.IdeUIManagerImpl;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.ProductHook;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.extension.AddinManagerImpl;
import oracle.ideimpl.help.AboutPropertiesPage;
import oracle.ideimpl.help.AboutVersionPage;
import oracle.ideimpl.jsr198.ToolbarManagerImpl;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.migration.MigrationManagerImpl;
import oracle.ideimpl.migration.UserDataHandler;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.jndi.Names;

public class DefaultIdeCore
extends IdeCore {
    public DefaultIdeCore(IdeArgs args) {
        super(args);
    }

    public DefaultIdeCore(IdeArgs args, String id) {
        this(args);
        this.productID = id;
    }

    protected void initializeLookAndFeel() {
        if (this.isHeadless()) {
            return;
        }
        IdeUIManager uiManager = this.createUIManager(Names.newInitialContext());
        if (uiManager != null) {
            EnvironOptions environOptions = Ide.getEnvironOptions();
            String lookAndFeel = environOptions.getLafClass();
            String lookAndFeelTheme = environOptions.getLafThemeClass();
            uiManager.setLookAndFeel(lookAndFeel, lookAndFeelTheme);
        }
        IdeInputMapUIResource.replaceInputMapUIResources();
    }

    protected SecurityManager getSecurityManager() {
        if (this.isHeadless()) {
            return new NullSecurityManager();
        }
        return super.getSecurityManager();
    }

    protected AddinManager getAddinManager() {
        InitialContext ic = Names.newInitialContext();
        this.createMigrationManager(ic);
        return this.createAddinManager(ic);
    }

    protected Addin[] createCoreModules() {
        return this.createCoreModules(Names.newInitialContext());
    }

    protected Addin[] createCoreModules(InitialContext ic) {
        if (this.isHeadless()) {
            return new Addin[0];
        }
        return new Addin[]{this.createToolbarManager(ic), this.createMainWindow(ic), this.createDockStation(ic), this.createEditorManager(ic), this.createLayouts(ic)};
    }

    protected final void installAboutBox(AboutBoxFactory factory) {
        factory.addPage(AboutVersionPage.class);
        factory.addPage(AboutPropertiesPage.class);
    }

    private ProductInformation getProductInformation() {
        ProductHook hook = (ProductHook)ExtensionRegistry.getExtensionRegistry().getHook(ProductHook.NAME);
        hook.finish();
        return ProductInformation.getProductInformation();
    }

    protected void brandMainWindow() {
        if (this.isHeadless()) {
            return;
        }
        ProductInformation productInfo = this.getProductInformation();
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            IdeUtil.setProgramName((String)productInfo.getName());
            mainWindow.updateTitle();
            ArrayList<Image> images = new ArrayList<Image>();
            DefaultIdeCore.addToImagesList(productInfo.getIcon(), images);
            for (IconDescription iconDesc : productInfo.getAdditionalIcons()) {
                DefaultIdeCore.addToImagesList(iconDesc, images);
            }
            mainWindow.setBrandingIcons(images);
            if (images.size() > 0) {
                mainWindow.setMainIcon((Image)images.get(0));
            }
        }
    }

    private static boolean addToImagesList(IconDescription idesc, List<Image> images) {
        try {
            if (idesc != null && idesc.getURL() != null) {
                ImageIcon icon = new ImageIcon(idesc.getURL());
                images.add(icon.getImage());
            }
            return true;
        }
        catch (MissingIconException missingIconException) {
            return false;
        }
    }

    protected String getProductNameFromBranding() {
        return this.getProductInformation().getName();
    }

    protected String getProductShortNameFromBranding() {
        return this.getProductInformation().getShortName();
    }

    protected void initAboutBoxModel() {
        if (this.isHeadless()) {
            return;
        }
        AboutBoxModel model = new AboutBoxModel(){

            public Icon getBannerImage() {
                try {
                    return DefaultIdeCore.this.getOptionalIcon(DefaultIdeCore.this.getProductInformation().getBannerImage());
                }
                catch (MissingIconException mie) {
                    return null;
                }
            }

            public Icon getHeaderImage() {
                try {
                    return DefaultIdeCore.this.getOptionalIcon(DefaultIdeCore.this.getProductInformation().getImage());
                }
                catch (MissingIconException mie) {
                    return null;
                }
            }
        };
        model.setProductName(this.getProductInformation().getName());
        model.setCopyrightMessage(this.getProductInformation().getCopyright());
        int lastDot = Ide.getProductVersion().lastIndexOf(46);
        String version = lastDot == -1 ? Ide.getProductVersion() : Ide.getProductVersion().substring(0, lastDot);
        model.setVersionString(IdeArb.format((int)462, (Object)this.getProductInformation().getEditionName(), (Object)version));
        model.setBuildString(IdeArb.format((int)463, (Object)Version.BUILD_LABEL));
        model.setDialogTitle(Ide.getProgramName());
        model.setProductVersion(version);
        AboutBoxFactory.getAboutBoxFactory().setModel(model);
    }

    private Icon getOptionalIcon(IconDescription icon) throws MissingIconException {
        if (icon != null) {
            URL url = icon.getURL();
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        return null;
    }

    protected void copyExtensionUserData() {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        UserDataHandler userDataHook = (UserDataHandler)extReg.getHook(UserDataHandler.ELEMENT);
        for (Extension extension : extReg.getExtensions()) {
            try {
                Collection uris;
                if (!extReg.isNewlyInstalled(extension.getID())) continue;
                URL destinationURL = extReg.getSystemDirectory(extension.getID());
                if (!URLFileSystem.mkdirs((URL)destinationURL)) {
                    // empty if block
                }
                if ((uris = userDataHook.getUserDataURIs(extension.getID())) == null) continue;
                for (URI uri : uris) {
                    try {
                        URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                        this.copyURL(url, destinationURL);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            catch (RuntimeException re) {
                System.err.println("Failed to copy user data for extension " + extension.getID());
                re.printStackTrace();
            }
        }
    }

    private void copyURL(URL source, URL destination) throws IOException {
        String entry = JarUtil.getJarEntry((URL)source);
        URL dest = URLFactory.newURL((URL)destination, (String)entry);
        if (URLFileSystem.isDirectory((URL)source)) {
            this.copyDirectoryRecursive(source, URLFileSystem.getParent((URL)dest));
        } else {
            URLFileSystem.copy((URL)source, (URL)dest);
        }
    }

    private void copyDirectoryRecursive(URL source, URL destination) throws IOException {
        String fileName = URLFileSystem.getFileName((URL)source);
        if (URLFileSystem.isDirectory((URL)source)) {
            URL destURL = URLFactory.newDirURL((URL)destination, (String)fileName);
            URLFileSystem.mkdirs((URL)destURL);
            URL[] children = URLFileSystem.list((URL)source);
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectoryRecursive(children[i], destURL);
            }
        } else {
            URL destURL = URLFactory.newURL((URL)destination, (String)fileName);
            URLFileSystem.copy((URL)source, (URL)destURL);
        }
    }

    private IdeMainWindow createMainWindow(InitialContext ic) {
        PerformanceLogger.get().startTiming("oracle.ideimpl.DefaultIdeCore.createMainWindow0");
        MainWindowImpl mainWindow = new MainWindowImpl();
        MainWindow.setMainWindow((Context)ic, (MainWindow)mainWindow, (int)1);
        PerformanceLogger.get().stopTiming("oracle.ideimpl.DefaultIdeCore.createMainWindow0", "Created main window");
        return mainWindow;
    }

    protected ToolbarManager createToolbarManager(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        ToolbarManagerImpl mgr = new ToolbarManagerImpl();
        ToolbarManager.setToolbarManager((ToolbarManager)mgr);
        return mgr;
    }

    protected DockStation createDockStation(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        DockStationImpl dockStation = DockStationImpl.getInstance();
        DockStation.setDockStation((DockStation)dockStation);
        return dockStation;
    }

    protected IdeUIManager createUIManager(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        IdeUIManagerImpl uiManager = IdeUIManagerImpl.getInstance();
        IdeUIManager.setUIManager((IdeUIManager)uiManager);
        return uiManager;
    }

    protected MigrationManager createMigrationManager(InitialContext ic) {
        MigrationManager migrationMgr = MigrationManagerImpl.getInstance();
        MigrationManager.setMigrationManager((MigrationManager)migrationMgr);
        return migrationMgr;
    }

    protected AddinManager createAddinManager(InitialContext ic) {
        AddinManager addinMan = AddinManagerImpl.createInstance();
        AddinManager.setAddinManager((AddinManager)addinMan);
        return addinMan;
    }

    protected EditorManager createEditorManager(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        EditorManagerImpl editorMgr = EditorManagerImpl.createInstance();
        EditorManager.setEditorManager((EditorManager)editorMgr);
        return editorMgr;
    }

    protected Layouts createLayouts(InitialContext ic) {
        if (this.isHeadless()) {
            return null;
        }
        LayoutsImpl layouts = LayoutsImpl.createInstance();
        Layouts.setLayouts((Layouts)layouts);
        return layouts;
    }
}

