/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Window;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.AuthenticationPrompt;

public class IdeAuthenticator
extends Authenticator {
    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication proxyAuth;
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && (proxyAuth = this.getProxyAuthentication()) != null) {
            return proxyAuth;
        }
        PasswordAuthentication userInfoAuth = this.getUserInfoAuthentication();
        if (userInfoAuth != null) {
            return userInfoAuth;
        }
        AuthenticationPromptRunner runner = new AuthenticationPromptRunner();
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return runner.getPasswordAuthentication();
    }

    private PasswordAuthentication getProxyAuthentication() {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (proxyOptions.getUseProxyAuthentication().booleanValue()) {
            String host1 = this.getRequestingHost();
            String host2 = proxyOptions.getProxyHost();
            int port1 = this.getRequestingPort();
            int port2 = Integer.parseInt(proxyOptions.getProxyPort());
            if (host1.equalsIgnoreCase(host2) && port1 == port2) {
                return new PasswordAuthentication(proxyOptions.getProxyUserName(), proxyOptions.getProxyPassword().toCharArray());
            }
        }
        return null;
    }

    private PasswordAuthentication getUserInfoAuthentication() {
        String userInfo;
        PasswordAuthentication userInfoAuth = null;
        URL url = this.getRequestingURL();
        if (url != null && (userInfo = url.getUserInfo()) != null) {
            int i = userInfo.indexOf(58);
            String username = i == -1 ? userInfo : userInfo.substring(0, i);
            String password = i == -1 ? "" : userInfo.substring(i + 1);
            userInfoAuth = new PasswordAuthentication(username, password.toCharArray());
        }
        return userInfoAuth;
    }

    private final class AuthenticationPromptRunner
    implements Runnable {
        private PasswordAuthentication authentication;

        private AuthenticationPromptRunner() {
        }

        @Override
        public void run() {
            AuthenticationPrompt prompt = new AuthenticationPrompt(IdeAuthenticator.this.getRequestingHost(), IdeAuthenticator.this.getRequestingPort(), IdeAuthenticator.this.getRequestingProtocol(), IdeAuthenticator.this.getRequestingPrompt());
            if (prompt.runDialog(this.getParentWindow())) {
                this.authentication = new PasswordAuthentication(prompt.getUserName(), prompt.getPassword());
            }
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }

        private Window getParentWindow() {
            Window window = IdeUtil.findActiveModalWindow();
            return window != null ? window : IdeUtil.getMainWindow();
        }
    }
}

