/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.OpenDocumentException;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.DefaultPrintWriter;
import oracle.ide.util.ExecUtil;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.webbrowser.BrowserOptions;
import oracle.javatools.util.EnvironmentVariables;

public final class BrowserRunner
extends oracle.ide.webbrowser.BrowserRunner {
    private static String osName = System.getProperty("os.name", "Windows").toLowerCase();
    private static final String OLD_DEFAULT_BROWSER_KEY = "Software\\Classes\\htmlfile\\shell\\open\\command";
    private static final String DEFAULT_BROWSER_KEY = "Software\\Classes\\http\\shell\\open\\command";
    private static String unixBrowser = System.getProperty("UNIX_WEB_BROWSER");
    private static final Object UNIX_BROWSER_LOCK = new Object();

    @Override
    public void runBrowserOnURL(URL url, File htmlFile, PrintWriter printWriter) {
        try {
            this.runBrowserOnURLImpl(url, htmlFile, printWriter);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void runBrowserOnURLV2(URL url, File htmlFile, PrintWriter printWriter) throws Exception {
        this.runBrowserOnURLImpl(url, htmlFile, printWriter);
    }

    static boolean isPlatformWindows() {
        return File.separatorChar == '\\';
    }

    static boolean isPlatformWindowsMe() {
        return osName.startsWith("windows me");
    }

    static boolean isPlatformMac() {
        return osName.startsWith("mac") || osName.startsWith("darwin");
    }

    private void runBrowserOnURLImpl(URL url, File htmlFile, PrintWriter printWriter) throws Exception {
        IdeSettings ideSettings = Ide.getSettings();
        BrowserOptions opts = (BrowserOptions)((Object)ideSettings.getData("WebBrowserOptions"));
        String cmdLine = opts != null ? opts.getBrowserCmdLine(url) : null;
        BrowserRunner.runBrowser(cmdLine, url, htmlFile, printWriter);
    }

    private static void runBrowser(String browserCmd, URL url, File htmlFile, PrintWriter printWriter) throws Exception {
        String targetURLStr = BrowserRunner.getPlatformTargetURLString(url);
        if (ModelUtil.hasLength((String)browserCmd)) {
            BrowserRunner.runBrowserCommand(browserCmd, targetURLStr, printWriter);
        } else if (BrowserRunner.isPlatformWindows()) {
            String windowsDefaultBrowserPath = BrowserRunner.getWindowsDefaultBrowserPath();
            if (windowsDefaultBrowserPath != null) {
                int index = windowsDefaultBrowserPath.indexOf("%1");
                if (index != -1) {
                    windowsDefaultBrowserPath = windowsDefaultBrowserPath.substring(0, index) + targetURLStr + windowsDefaultBrowserPath.substring(index + 2);
                    targetURLStr = "";
                }
                BrowserRunner.runBrowserCommand(windowsDefaultBrowserPath, targetURLStr, printWriter);
            } else {
                BrowserRunner.runBrowserOnWindows(targetURLStr, htmlFile, printWriter);
            }
        } else if (BrowserRunner.isPlatformMac()) {
            BrowserRunner.runBrowserOnMac(targetURLStr, printWriter);
        } else {
            BrowserRunner.runBrowserOnUnix(targetURLStr, printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getKeyValue(String key, boolean useUserHive) {
        block18: {
            String string;
            RegistryKey softwareKey = null;
            try {
                RegistryKey keyHive;
                RegistryKey registryKey = keyHive = useUserHive ? NativeHandler.getRegistry().getCurrentUserKey() : NativeHandler.getRegistry().getLocalMachineKey();
                if (keyHive == null) {
                    String string2 = null;
                    return string2;
                }
                softwareKey = keyHive.openKey(key, 131097L);
                if (softwareKey == null) break block18;
                string = softwareKey.getStringValue(null);
            }
            catch (Exception e) {
                break block18;
            }
            finally {
                if (softwareKey != null) {
                    try {
                        softwareKey.close();
                    }
                    catch (RegistryException e) {}
                }
            }
            return string;
        }
        return null;
    }

    private static String getWindowsDefaultBrowserPath() {
        String defaultBrowserPath = BrowserRunner.getKeyValue(DEFAULT_BROWSER_KEY, true);
        if (defaultBrowserPath == null) {
            defaultBrowserPath = BrowserRunner.getKeyValue(DEFAULT_BROWSER_KEY, false);
        }
        if (defaultBrowserPath == null) {
            defaultBrowserPath = BrowserRunner.getKeyValue(OLD_DEFAULT_BROWSER_KEY, false);
        }
        return defaultBrowserPath;
    }

    private static String getPlatformTargetURLString(URL url) {
        String targetURLStr = BrowserRunner.isPlatformWindows() ? ("file".equalsIgnoreCase(url.getProtocol()) ? URLFileSystem.toDisplayString((URL)url) : URLFileSystem.toEncodedString((URL)url, (String)"UTF-8")) : (BrowserRunner.isPlatformMac() ? URLFileSystem.toDisplayString((URL)url) : URLFileSystem.toEncodedString((URL)url, (String)"UTF-8"));
        return targetURLStr;
    }

    private static void runBrowserCommand(String browserCmd, String targetURLStr, PrintWriter printWriter) throws Exception {
        ArrayList<String> execCmdList = new ArrayList<String>(5);
        String[] a = IdeUtil.convertStringToStringArray((String)browserCmd, (boolean)true, (boolean)true);
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            execCmdList.add(a[i]);
        }
        BrowserRunner.runBrowserCommandImpl(execCmdList, targetURLStr, printWriter);
    }

    private static void runBrowserOnWindows(String targetURLStr, File htmlFile, PrintWriter printWriter) throws Exception {
        String browserTargetURLStr = htmlFile != null ? htmlFile.getAbsolutePath() : targetURLStr;
        try {
            NativeHandler.openDocument((String)browserTargetURLStr);
            return;
        }
        catch (OpenDocumentException e) {
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        ArrayList<String> execCmdList = new ArrayList<String>(5);
        if (BrowserRunner.isPlatformWindowsMe()) {
            String iePath = Ide.getProperty((String)"WindowMe.BrowserPath");
            if (iePath == null) {
                iePath = "\"C:\\Program Files\\Internet explorer\\iexplore.exe\"";
            }
            System.out.println("Windows ME Browser Path used is: " + iePath);
            execCmdList.add(iePath);
            if (htmlFile != null) {
                browserTargetURLStr = "\"" + htmlFile.getAbsolutePath() + "\"";
            }
        } else {
            execCmdList.add("cmd.exe");
            execCmdList.add("/c");
            execCmdList.add("start");
            execCmdList.add("\"Oracle9i JDeveloper\"");
            if (htmlFile != null) {
                browserTargetURLStr = "\"" + htmlFile.getAbsolutePath() + "\"";
            }
        }
        BrowserRunner.runBrowserCommandImpl(execCmdList, browserTargetURLStr, printWriter);
    }

    private static void runBrowserOnMac(String targetURLStr, PrintWriter printWriter) {
        try {
            Class<?> classMRJFileUtils = Class.forName("com.apple.mrj.MRJFileUtils");
            Method method = classMRJFileUtils.getMethod("openURL", String.class);
            Object[] methodArgs = new Object[]{targetURLStr};
            method.invoke(null, methodArgs);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            t.printStackTrace(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runBrowserOnUnix(String targetURLStr, PrintWriter printWriter) throws Exception {
        if (unixBrowser == null) {
            Object object = UNIX_BROWSER_LOCK;
            synchronized (object) {
                if (unixBrowser == null) {
                    BrowserRunner.findAndRunBrowserOnUnix(targetURLStr, printWriter);
                    return;
                }
            }
        }
        BrowserRunner.runBrowserOnUnix(unixBrowser, targetURLStr, printWriter);
    }

    private static void findAndRunBrowserOnUnix(String targetURLStr, PrintWriter printWriter) throws Exception {
        String browser = EnvironmentVariables.getVariable((String)"BROWSER");
        if (browser == null) {
            browser = "htmlview:firefox:netscape:mozilla:opera";
        }
        String[] browsers = browser.split(":");
        for (int i = 0; i < browsers.length; ++i) {
            String current = browsers[i];
            try {
                BrowserRunner.runBrowserOnUnix(current, targetURLStr, printWriter);
                unixBrowser = current;
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (unixBrowser == null) {
            throw new IOException("A default web browser could not be found.");
        }
    }

    private static void runBrowserOnUnix(String browser, String targetURLStr, PrintWriter printWriter) throws Exception {
        String marker = "_jdevmarker_";
        browser = browser.replaceAll("%%", "_jdevmarker_");
        browser = browser.replaceAll("%c", ":");
        Matcher matcher = Pattern.compile("%s").matcher(browser);
        boolean foundS = matcher.find();
        if (foundS) {
            browser = matcher.replaceAll(targetURLStr);
        }
        browser = browser.replaceAll("_jdevmarker_", "%");
        if (foundS) {
            Process process = Runtime.getRuntime().exec(browser);
            BrowserRunner.handleOutput(process, printWriter);
        } else {
            ArrayList<String> execCmdList = new ArrayList<String>(5);
            execCmdList.add(browser);
            BrowserRunner.runBrowserCommandImpl(execCmdList, targetURLStr, printWriter);
        }
    }

    private static void runBrowserCommandImpl(ArrayList execCmdList, String targetURLStr, PrintWriter printWriter) throws Exception {
        execCmdList.add(targetURLStr);
        String[] cmdArray = BrowserRunner.toCommandArray(execCmdList);
        Process process = Runtime.getRuntime().exec(cmdArray);
        BrowserRunner.handleOutput(process, printWriter);
    }

    private static void handleOutput(Process process, PrintWriter printWriter) throws Exception {
        ProcessOutput poErr = new ProcessOutput(process.getErrorStream(), printWriter);
        new Thread((Runnable)poErr, "BrowserProcessErr").start();
        ProcessOutput poOut = new ProcessOutput(process.getInputStream(), printWriter);
        new Thread((Runnable)poOut, "BrowserProcessOut").start();
    }

    private static String[] toCommandArray(ArrayList cmdList) {
        String[] cmdArray = cmdList.toArray(new String[cmdList.size()]);
        return ExecUtil.cleanUpCommand((String[])cmdArray);
    }

    private static final class ProcessOutput
    implements Runnable {
        private BufferedReader _in;
        private PrintWriter _printWriter;

        ProcessOutput(InputStream in, PrintWriter printWriter) throws IOException {
            this._in = new BufferedReader(new InputStreamReader(in));
            this._printWriter = printWriter != null ? printWriter : new DefaultPrintWriter();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line;
                while ((line = this._in.readLine()) != null) {
                    this._printWriter.println(line);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (this._in != null) {
                    try {
                        this._in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

