/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.config.Preferences;
import oracle.ide.webbrowser.Cookie;
import oracle.ideimpl.webbrowser.WocPreferences;
import oracle.javatools.data.PropertyStorage;

public final class WOCAuthenticator {
    private static final String AUTH_SERVER_DEFAULT = "https://profile.oracle.com/jsp/reg/loginHandler.jsp";
    private static final String URL_ENCODING = "UTF-8";
    private String _authServerUrl = "https://profile.oracle.com/jsp/reg/loginHandler.jsp";

    public void setAuthenticationServerUrl(URL url) {
        this._authServerUrl = url.toString();
    }

    public PasswordAuthentication getRememberedAuthentication() {
        WocPreferences prefs = WocPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
        if (prefs.getOTNData() == null) {
            return null;
        }
        return new PasswordAuthentication(prefs.getUser().trim(), prefs.getOTNData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationToken logIn(PasswordAuthentication credentials) throws IOException {
        String username = credentials.getUserName();
        String password = new String(credentials.getPassword());
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String ipAddress = localHost.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            throw new IllegalStateException("Localhost appears to be an unknown host: " + uhe.getMessage());
        }
        HttpURLConnection conn = null;
        try {
            String keyName;
            StringBuffer urlString = new StringBuffer(this._authServerUrl);
            urlString.append("?username=");
            urlString.append(URLEncoder.encode(username, URL_ENCODING));
            urlString.append("&password=");
            urlString.append(URLEncoder.encode(password, URL_ENCODING));
            urlString.append("&redirectUrl=");
            urlString.append(URLEncoder.encode("www.oracle.com", URL_ENCODING));
            urlString.append("&failedUrl=");
            urlString.append(URLEncoder.encode("http://profile.oracle.com/invalidURL", URL_ENCODING));
            urlString.append("&globalId=");
            URL newURL = new URL(urlString.toString());
            conn = (HttpURLConnection)newURL.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 302) {
                throw new IOException("Unable to authenticate with OTN.");
            }
            ArrayList<Cookie> retreivedCookies = new ArrayList<Cookie>();
            boolean authenticated = false;
            int i = 1;
            while ((keyName = conn.getHeaderFieldKey(i)) != null) {
                String value = conn.getHeaderField(i);
                if ("Set-Cookie".equals(keyName)) {
                    Cookie cookie = new Cookie();
                    cookie.parse(value);
                    retreivedCookies.add(cookie);
                    if (cookie.getCookieName() != null && cookie.getCookieName().startsWith("ORA_UCM")) {
                        authenticated = true;
                    }
                }
                ++i;
            }
            if (authenticated) {
                AuthenticationToken authenticationToken = new AuthenticationToken(retreivedCookies);
                return authenticationToken;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public static void endorse(URLConnection conn, AuthenticationToken token) {
        if (conn == null) {
            throw new NullPointerException("conn is null");
        }
        if (token == null) {
            throw new NullPointerException("token is null");
        }
        String existingCookies = conn.getRequestProperty("Cookie");
        if (existingCookies == null) {
            existingCookies = "";
        }
        StringBuffer allCookies = new StringBuffer(existingCookies);
        if ((existingCookies = existingCookies.trim()).length() > 0 && ';' != existingCookies.charAt(existingCookies.length() - 1)) {
            allCookies.append(";");
        }
        Iterator i = token.getCookies().iterator();
        while (i.hasNext()) {
            Cookie cookie = (Cookie)i.next();
            allCookies.append(cookie.toSimpleString());
            if (!i.hasNext()) continue;
            allCookies.append(";");
        }
        conn.setRequestProperty("Cookie", allCookies.toString());
    }

    public static final class AuthenticationToken {
        private final List _cookies;

        private AuthenticationToken(List cookies) {
            this._cookies = cookies;
        }

        private List getCookies() {
            return this._cookies;
        }
    }
}

