/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl;

import java.io.File;
import java.security.cert.X509Certificate;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PromptUserPassword2;
import org.tigris.subversion.javahl.PromptUserPassword3;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSH;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSL;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordUser;

class JavaHLAuthenticationProvider
implements ISVNAuthenticationProvider {
    private static final String ADAPTER_DEFAULT_PROMPT_CLASS = "org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter$DefaultPromptUserPassword";
    private PromptUserPassword myPrompt;

    public JavaHLAuthenticationProvider(PromptUserPassword prompt) {
        this.myPrompt = prompt;
    }

    @Override
    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        String userName;
        if ("svn.ssh".equals(kind) && this.myPrompt instanceof PromptUserPasswordSSH) {
            int port;
            PromptUserPasswordSSH prompt4 = (PromptUserPasswordSSH)this.myPrompt;
            String userName2 = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : JavaHLAuthenticationProvider.getUserName(null, url);
            int n = port = url != null ? url.getPort() : -1;
            if (prompt4.promptSSH(realm, userName2, port, authMayBeStored)) {
                String password = prompt4.getPassword();
                String keyPath = prompt4.getSSHPrivateKeyPath();
                String passphrase = prompt4.getSSHPrivateKeyPassphrase();
                userName2 = JavaHLAuthenticationProvider.getUserName(prompt4.getUsername(), url);
                if ("".equals(passphrase)) {
                    passphrase = null;
                }
                if ((port = prompt4.getSSHPort()) < 0 && url != null) {
                    port = url.getPort();
                }
                if (port < 0) {
                    port = 22;
                }
                boolean save = prompt4.userAllowedSave();
                if (keyPath != null && !"".equals(keyPath)) {
                    return new SVNSSHAuthentication(userName2, new File(keyPath), passphrase, port, save, url, false);
                }
                if (password != null) {
                    return new SVNSSHAuthentication(userName2, password, port, save, url, false);
                }
            }
            return null;
        }
        if ("svn.ssl.client-passphrase".equals(kind) && this.myPrompt instanceof PromptUserPasswordSSL) {
            PromptUserPasswordSSL prompt4 = (PromptUserPasswordSSL)this.myPrompt;
            if (prompt4.promptSSL(realm, authMayBeStored)) {
                String cert = prompt4.getSSLClientCertPath();
                String password = prompt4.getSSLClientCertPassword();
                if (cert != null) {
                    if ("".equals(password)) {
                        password = null;
                    }
                    boolean save = prompt4.userAllowedSave();
                    return new SVNSSLAuthentication(new File(cert), password, save, url, false);
                }
            }
            return null;
        }
        if ("svn.ssh".equals(kind) && previousAuth == null) {
            String keyPath = System.getProperty("svnkit.ssh2.key", System.getProperty("javasvn.ssh2.key"));
            String userName3 = JavaHLAuthenticationProvider.getUserName(System.getProperty("svnkit.ssh2.username", System.getProperty("javasvn.ssh2.username")), url);
            String passPhrase = System.getProperty("svnkit.ssh2.passphrase", System.getProperty("javasvn.ssh2.passphrase"));
            if (userName3 == null) {
                return null;
            }
            if (keyPath != null && previousAuth == null) {
                return new SVNSSHAuthentication(userName3, new File(keyPath), passPhrase, -1, true, url, false);
            }
        } else {
            if ("svn.username".equals(kind)) {
                String userName4;
                String string = userName4 = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : JavaHLAuthenticationProvider.getUserName(null, url);
                if (this.myPrompt instanceof PromptUserPasswordUser) {
                    PromptUserPasswordUser prompt3 = (PromptUserPasswordUser)this.myPrompt;
                    if (prompt3.promptUser(realm, userName4, authMayBeStored)) {
                        return new SVNUserNameAuthentication(prompt3.getUsername(), prompt3.userAllowedSave(), url, false);
                    }
                    return this.getDefaultUserNameCredentials(userName4);
                }
                if (this.myPrompt instanceof PromptUserPassword3) {
                    PromptUserPassword3 prompt3 = (PromptUserPassword3)this.myPrompt;
                    if (prompt3.prompt(realm, userName4, authMayBeStored)) {
                        return new SVNUserNameAuthentication(prompt3.getUsername(), prompt3.userAllowedSave(), url, false);
                    }
                    return this.getDefaultUserNameCredentials(userName4);
                }
                if (this.myPrompt.prompt(realm, userName4)) {
                    return new SVNUserNameAuthentication(this.myPrompt.getUsername(), false, url, false);
                }
                return this.getDefaultUserNameCredentials(userName4);
            }
            if (!"svn.simple".equals(kind)) {
                return null;
            }
        }
        String string = userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : JavaHLAuthenticationProvider.getUserName(null, url);
        if (this.myPrompt instanceof PromptUserPassword3) {
            PromptUserPassword3 prompt3 = (PromptUserPassword3)this.myPrompt;
            if (prompt3.prompt(realm, userName, authMayBeStored)) {
                if ("svn.ssh".equals(kind)) {
                    int portNumber = previousAuth instanceof SVNSSHAuthentication ? ((SVNSSHAuthentication)previousAuth).getPortNumber() : -1;
                    return new SVNSSHAuthentication(prompt3.getUsername(), prompt3.getPassword(), portNumber, prompt3.userAllowedSave(), url, false);
                }
                return new SVNPasswordAuthentication(prompt3.getUsername(), prompt3.getPassword(), prompt3.userAllowedSave(), url, false);
            }
        } else if (this.myPrompt.prompt(realm, userName)) {
            if ("svn.ssh".equals(kind)) {
                return new SVNSSHAuthentication(userName, this.myPrompt.getPassword(), -1, true, url, false);
            }
            return new SVNPasswordAuthentication(this.myPrompt.getUsername(), this.myPrompt.getPassword(), true, url, false);
        }
        return null;
    }

    private SVNAuthentication getDefaultUserNameCredentials(String userName) {
        if (ADAPTER_DEFAULT_PROMPT_CLASS.equals(this.myPrompt.getClass().getName())) {
            return new SVNUserNameAuthentication(userName, false, null, false);
        }
        return null;
    }

    @Override
    public int acceptServerAuthentication(SVNURL url, String realm, Object serverAuth, boolean resultMayBeStored) {
        if (serverAuth != null && this.myPrompt instanceof PromptUserPassword2) {
            PromptUserPassword2 sslPrompt = (PromptUserPassword2)this.myPrompt;
            Object object = serverAuth = serverAuth instanceof X509Certificate ? SVNSSLUtil.getServerCertificatePrompt((X509Certificate)serverAuth, realm, url.getHost()) : serverAuth;
            if (serverAuth == null) {
                serverAuth = "Unsupported certificate type '" + (serverAuth != null ? serverAuth.getClass().getName() : "null") + "'";
            }
            return sslPrompt.askTrustSSLServer(serverAuth.toString(), resultMayBeStored);
        }
        return 2;
    }

    private static String getUserName(String userName, SVNURL url) {
        if (userName == null || "".equals(userName.trim())) {
            String string = userName = url != null ? url.getUserInfo() : null;
        }
        if (userName == null || "".equals(userName.trim())) {
            userName = System.getProperty("user.name");
        }
        return userName;
    }
}

