/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNChecksumInputStream
extends InputStream {
    public static final String MD5_ALGORITHM = "MD5";
    private InputStream mySource;
    private MessageDigest myDigest;
    private byte[] myDigestResult;
    private boolean myCloseSource;
    private boolean myReadToEnd;
    private boolean myStreamIsFinished;

    public SVNChecksumInputStream(InputStream source, String algorithm, boolean closeSource, boolean readToEnd) {
        this.mySource = source;
        this.myCloseSource = closeSource;
        this.myReadToEnd = readToEnd;
        algorithm = algorithm == null ? MD5_ALGORITHM : algorithm;
        try {
            this.myDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long skippedN = 0L;
        int r = -1;
        while ((r = this.read()) != -1 && n-- > 0L) {
            ++skippedN;
        }
        if (r == -1) {
            this.myStreamIsFinished = true;
        }
        return skippedN;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.mySource.read(b, off, len);
        if (r >= 0) {
            this.myDigest.update(b, off, r);
        } else {
            this.myStreamIsFinished = true;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.mySource.read(b);
        if (r >= 0) {
            this.myDigest.update(b, 0, r);
        } else {
            this.myStreamIsFinished = true;
        }
        return r;
    }

    @Override
    public int read() throws IOException {
        int r = this.mySource.read();
        if (r >= 0) {
            this.myDigest.update((byte)(r & 0xFF));
        } else {
            this.myStreamIsFinished = true;
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        if (this.myReadToEnd && !this.myStreamIsFinished) {
            byte[] buffer = new byte[16384];
            while (this.read(buffer) != -1) {
            }
            this.myStreamIsFinished = true;
        }
        if (this.myCloseSource) {
            this.mySource.close();
        }
        this.myDigestResult = this.myDigest.digest();
    }

    public String getDigest() {
        return SVNFileUtil.toHexDigest(this.myDigestResult);
    }
}

