/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14Factory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea15Factory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea16Factory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc.admin.SVNXMLAdminAreaFactory;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNAdminAreaFactory
implements Comparable {
    public static final int WC_FORMAT_13 = 4;
    public static final int WC_FORMAT_14 = 8;
    public static final int WC_FORMAT_15 = 9;
    public static final int WC_FORMAT_16 = 10;
    private static final Collection ourFactories = new TreeSet();
    private static boolean ourIsUpgradeEnabled = Boolean.valueOf(System.getProperty("svnkit.upgradeWC", System.getProperty("javasvn.upgradeWC", "true")));
    private static ISVNAdminAreaFactorySelector ourSelector;
    private static ISVNAdminAreaFactorySelector ourDefaultSelector;

    public static void setUpgradeEnabled(boolean enabled) {
        ourIsUpgradeEnabled = enabled;
    }

    public static boolean isUpgradeEnabled() {
        return ourIsUpgradeEnabled;
    }

    public static void setSelector(ISVNAdminAreaFactorySelector selector) {
        ourSelector = selector;
    }

    public static ISVNAdminAreaFactorySelector getSelector() {
        return ourSelector != null ? ourSelector : ourDefaultSelector;
    }

    public static int checkWC(File path, boolean useSelector) throws SVNException {
        return SVNAdminAreaFactory.checkWC(path, useSelector, Level.FINE);
    }

    public static int checkWC(File path, boolean useSelector, Level logLevel) throws SVNException {
        Collection enabledFactories = ourFactories;
        if (useSelector) {
            enabledFactories = SVNAdminAreaFactory.getSelector().getEnabledFactories(path, enabledFactories, false);
        }
        SVNErrorMessage error = null;
        int version = -1;
        for (SVNAdminAreaFactory factory : enabledFactories) {
            block8: {
                try {
                    version = factory.doCheckWC(path, logLevel);
                    if (version == 0) {
                        return version;
                    }
                    if (version > factory.getSupportedVersion()) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "This client is too old to work with working copy ''{0}''; please get a newer Subversion client", path);
                        SVNErrorManager.error(err, SVNLogType.WC);
                        break block8;
                    }
                    if (version >= factory.getSupportedVersion()) break block8;
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Working copy format of {0} is too old ({1}); please check out your working copy again", new Object[]{path, new Integer(version)});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                catch (SVNException e) {
                    if (error != null) {
                        error.setChildErrorMessage(e.getErrorMessage());
                        continue;
                    }
                    error = e.getErrorMessage();
                    continue;
                }
            }
            return version;
        }
        if (error == null) {
            error = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
        }
        SVNErrorManager.error(error, logLevel, SVNLogType.WC);
        return 0;
    }

    public static SVNAdminArea open(File path, Level logLevel) throws SVNException {
        SVNErrorMessage error = null;
        int wcFormatVersion = -1;
        Collection enabledFactories = SVNAdminAreaFactory.getSelector().getEnabledFactories(path, ourFactories, false);
        File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
        File entriesFile = new File(adminDir, "entries");
        if (adminDir.isDirectory() && entriesFile.isFile()) {
            for (SVNAdminAreaFactory factory : enabledFactories) {
                SVNAdminArea adminArea;
                block7: {
                    try {
                        wcFormatVersion = factory.getVersion(path);
                        if (wcFormatVersion > factory.getSupportedVersion()) {
                            error = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "This client is too old to work with working copy ''{0}''; please get a newer Subversion client", path);
                            SVNErrorManager.error(error, SVNLogType.WC);
                            break block7;
                        }
                        if (wcFormatVersion >= factory.getSupportedVersion()) break block7;
                        error = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Working copy format of {0} is too old ({1}); please check out your working copy again", new Object[]{path, new Integer(wcFormatVersion)});
                        SVNErrorManager.error(error, SVNLogType.WC);
                    }
                    catch (SVNException e) {
                        if (error != null) {
                            error.setChildErrorMessage(e.getErrorMessage());
                            continue;
                        }
                        error = e.getErrorMessage();
                        continue;
                    }
                }
                if ((adminArea = factory.doOpen(path, wcFormatVersion)) == null) continue;
                adminArea.setWorkingCopyFormatVersion(wcFormatVersion);
                return adminArea;
            }
        }
        if (error == null) {
            error = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
        }
        SVNErrorManager.error(error, logLevel, SVNLogType.WC);
        return null;
    }

    public static SVNAdminArea upgrade(SVNAdminArea area) throws SVNException {
        Collection enabledFactories;
        if (SVNAdminAreaFactory.isUpgradeEnabled() && !ourFactories.isEmpty() && !(enabledFactories = SVNAdminAreaFactory.getSelector().getEnabledFactories(area.getRoot(), ourFactories, true)).isEmpty()) {
            SVNAdminAreaFactory newestFactory = (SVNAdminAreaFactory)enabledFactories.iterator().next();
            SVNAdminArea newArea = newestFactory.doChangeWCFormat(area);
            if (newArea != null && newArea != area && newArea.getWCAccess() != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(newArea.getRoot(), SVNNodeKind.DIR, null, -1L, SVNEventAction.UPGRADE, null, null, null);
                newArea.getWCAccess().handleEvent(event, -1.0);
            }
            area = newArea;
        }
        return area;
    }

    public static SVNAdminArea changeWCFormat(SVNAdminArea adminArea, int format) throws SVNException {
        SVNAdminAreaFactory factory = SVNAdminAreaFactory.getAdminAreaFactory(format);
        SVNAdminArea newArea = factory.doChangeWCFormat(adminArea);
        if (newArea != null && newArea != adminArea && newArea.getWCAccess() != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(newArea.getRoot(), SVNNodeKind.DIR, null, -1L, SVNEventAction.UPGRADE, null, null, null);
            newArea.getWCAccess().handleEvent(event, -1.0);
        }
        adminArea = newArea;
        return adminArea;
    }

    private static SVNAdminAreaFactory getAdminAreaFactory(int wcFormat) throws SVNException {
        if (wcFormat == 4) {
            return new SVNXMLAdminAreaFactory();
        }
        if (wcFormat == 8) {
            return new SVNAdminArea14Factory();
        }
        if (wcFormat == 9) {
            return new SVNAdminArea15Factory();
        }
        if (wcFormat == 10) {
            return new SVNAdminArea16Factory();
        }
        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT), SVNLogType.DEFAULT);
        return null;
    }

    private static int readFormatVersion(File adminDir) throws SVNException {
        SVNErrorMessage error = null;
        int version = -1;
        Collection enabledFactories = SVNAdminAreaFactory.getSelector().getEnabledFactories(adminDir.getParentFile(), ourFactories, false);
        for (SVNAdminAreaFactory factory : enabledFactories) {
            try {
                version = factory.getVersion(adminDir);
            }
            catch (SVNException e) {
                error = e.getErrorMessage();
                continue;
            }
            return version;
        }
        if (error == null) {
            error = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", adminDir);
        }
        SVNErrorManager.error(error, SVNLogType.WC);
        return -1;
    }

    public static void createVersionedDirectory(File path, String url, String rootURL, String uuid, long revNumber, SVNDepth depth) throws SVNException {
        Collection enabledFactories;
        if (!(ourFactories.isEmpty() || SVNAdminAreaFactory.checkAdminAreaExists(path, url, revNumber) || (enabledFactories = SVNAdminAreaFactory.getSelector().getEnabledFactories(path, ourFactories, true)).isEmpty())) {
            SVNAdminAreaFactory newestFactory = (SVNAdminAreaFactory)enabledFactories.iterator().next();
            newestFactory.doCreateVersionedDirectory(path, url, rootURL, uuid, revNumber, depth);
        }
    }

    public static void createVersionedDirectory(File path, SVNURL url, SVNURL rootURL, String uuid, long revNumber, SVNDepth depth) throws SVNException {
        SVNAdminAreaFactory.createVersionedDirectory(path, url != null ? url.toString() : null, rootURL != null ? rootURL.toString() : null, uuid, revNumber, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkAdminAreaExists(File dir, String url, long revision) throws SVNException {
        File adminDir = new File(dir, SVNFileUtil.getAdminDirectoryName());
        if (adminDir.exists() && !adminDir.isDirectory()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' is not a directory", dir);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (!adminDir.exists()) {
            return false;
        }
        boolean wcExists = false;
        try {
            SVNAdminAreaFactory.readFormatVersion(adminDir);
            wcExists = true;
        }
        catch (SVNException svne) {
            return false;
        }
        if (wcExists) {
            SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
            SVNAdminArea adminArea = null;
            SVNEntry entry = null;
            try {
                adminArea = wcAccess.open(dir, false, 0);
                entry = adminArea.getVersionedEntry(adminArea.getThisDirName(), false);
            }
            finally {
                wcAccess.closeAdminArea(dir);
            }
            if (!entry.isScheduledForDeletion()) {
                SVNErrorMessage err;
                if (entry.getRevision() != revision) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Revision {0} doesn''t match existing revision {1} in ''{2}''", new Object[]{new Long(revision), new Long(entry.getRevision()), dir});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (!url.equals(entry.getURL())) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL ''{0}'' doesn''t match existing URL ''{1}'' in ''{2}''", new Object[]{url, entry.getURL(), dir});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }
        return wcExists;
    }

    public abstract int getSupportedVersion();

    protected abstract int getVersion(File var1) throws SVNException;

    protected abstract SVNAdminArea doOpen(File var1, int var2) throws SVNException;

    protected abstract SVNAdminArea doChangeWCFormat(SVNAdminArea var1) throws SVNException;

    protected abstract void doCreateVersionedDirectory(File var1, String var2, String var3, String var4, long var5, SVNDepth var7) throws SVNException;

    protected abstract int doCheckWC(File var1, Level var2) throws SVNException;

    protected static void registerFactory(SVNAdminAreaFactory factory) {
        if (factory != null) {
            ourFactories.add(factory);
        }
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof SVNAdminAreaFactory)) {
            return -1;
        }
        int version = ((SVNAdminAreaFactory)o).getSupportedVersion();
        return this.getSupportedVersion() > version ? -1 : (this.getSupportedVersion() < version ? 1 : 0);
    }

    static {
        ourDefaultSelector = new DefaultSelector();
        SVNAdminAreaFactory.registerFactory(new SVNAdminArea16Factory());
        SVNAdminAreaFactory.registerFactory(new SVNAdminArea15Factory());
        SVNAdminAreaFactory.registerFactory(new SVNAdminArea14Factory());
        SVNAdminAreaFactory.registerFactory(new SVNXMLAdminAreaFactory());
    }

    private static class DefaultSelector
    implements ISVNAdminAreaFactorySelector {
        private DefaultSelector() {
        }

        @Override
        public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
            return factories;
        }
    }
}

