/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCancellableEditor
implements ISVNEditor {
    private ISVNEditor myDelegate;
    private ISVNCanceller myCancel;
    private ISVNDebugLog myLog;

    public static ISVNEditor newInstance(ISVNEditor editor, ISVNCanceller cancel, ISVNDebugLog log) {
        if (cancel != null) {
            return new SVNCancellableEditor(editor, cancel, log);
        }
        return editor;
    }

    private SVNCancellableEditor(ISVNEditor delegate, ISVNCanceller cancel, ISVNDebugLog log) {
        this.myDelegate = delegate;
        this.myCancel = cancel;
        this.myLog = log == null ? SVNDebugLog.getDefaultLog() : log;
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.targetRevision(revision);
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "root");
        this.myDelegate.openRoot(revision);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "del " + path);
        this.myDelegate.deleteEntry(path, revision);
    }

    @Override
    public void absentDir(String path) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "absent dir " + path);
        this.myDelegate.absentDir(path);
    }

    @Override
    public void absentFile(String path) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "absent file " + path);
        this.myDelegate.absentFile(path);
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "add dir " + path);
        this.myDelegate.addDir(path, copyFromPath, copyFromRevision);
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "open dir " + path);
        this.myDelegate.openDir(path, revision);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "change dir prop " + name + " = " + SVNPropertyValue.getPropertyAsString(value));
        this.myDelegate.changeDirProperty(name, value);
    }

    @Override
    public void closeDir() throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "close dir");
        this.myDelegate.closeDir();
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "add file " + path);
        this.myDelegate.addFile(path, copyFromPath, copyFromRevision);
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "open file " + path);
        this.myDelegate.openFile(path, revision);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "apply delta " + path);
        this.myDelegate.applyTextDelta(path, baseChecksum);
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.myLog.logFine(SVNLogType.WC, "delta chunk " + path);
        return this.myDelegate.textDeltaChunk(path, diffWindow);
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        this.myLog.logFine(SVNLogType.WC, "delta end " + path);
        this.myDelegate.textDeltaEnd(path);
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "change file prop " + name + " = " + SVNPropertyValue.getPropertyAsString(value));
        this.myDelegate.changeFileProperty(path, name, value);
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "close file " + path);
        this.myDelegate.closeFile(path, textChecksum);
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.logFine(SVNLogType.WC, "close edit");
        return this.myDelegate.closeEdit();
    }

    @Override
    public void abortEdit() throws SVNException {
        this.myLog.logFine(SVNLogType.WC, "abort edit");
        this.myDelegate.abortEdit();
    }
}

