/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDate
extends Date {
    private static final long serialVersionUID = 4845L;
    public static final SVNDate NULL = new SVNDate(0L, 0);
    private static final Calendar CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("GMT"), new Locale("en", "US"));
    static final DateFormat SVN_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final DateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'000Z'");
    private static final DateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private static final DateFormat CUSTOM_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z (EE, d MMM yyyy)", Locale.getDefault());
    private static final DateFormat HUMAN_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'ZZZZ' ('E', 'dd' 'MMM' 'yyyy')'");
    private static final DateFormat SHORT_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'");
    private static final DateFormat CONSOLE_DIFF_DATE_FORMAT = new SimpleDateFormat("EEE' 'MMM' 'dd' 'HH:mm:ss' 'yyyy");
    private static final DateFormat CONSOLE_LONG_DATE_FORMAT = new SimpleDateFormat("MM' 'dd'  'yyyy");
    private static final DateFormat CONSOLE_SHORT_DATE_FORMAT = new SimpleDateFormat("MM' 'dd'  'HH:mm");
    public static final char[] DATE_SEPARATORS = new char[]{'-', '-', 'T', ':', ':', '.', 'Z'};
    private int myMicroSeconds;

    private SVNDate(long time, int micro) {
        super((1000L * time + (long)micro) / 1000L);
        this.myMicroSeconds = micro >= 0 ? micro % 1000 : 1000 + micro % 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format() {
        StringBuffer formatted = new StringBuffer();
        DateFormat dateFormat = SVN_FORMAT;
        synchronized (dateFormat) {
            SVN_FORMAT.format(this, formatted, new FieldPosition(0));
        }
        int m1 = this.myMicroSeconds % 10;
        int m2 = this.myMicroSeconds / 10 % 10;
        int m3 = this.myMicroSeconds / 100;
        formatted.append(m3);
        formatted.append(m2);
        formatted.append(m1);
        formatted.append('Z');
        return formatted.toString();
    }

    public static String formatDate(Date date) {
        return SVNDate.formatDate(date, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, boolean formatZeroDate) {
        if (date == null) {
            return null;
        }
        if (!formatZeroDate && date.getTime() == 0L) {
            return null;
        }
        if (date instanceof SVNDate) {
            SVNDate extendedDate = (SVNDate)date;
            return extendedDate.format();
        }
        DateFormat dateFormat = ISO8601_FORMAT;
        synchronized (dateFormat) {
            return ISO8601_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatRFC1123Date(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = RFC1123_FORMAT;
        synchronized (dateFormat) {
            return RFC1123_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatHumanDate(Date date, ISVNOptions options) {
        DateFormat df = HUMAN_FORMAT;
        if (options != null && options.getKeywordDateFormat() != null) {
            df = options.getKeywordDateFormat();
        }
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            return df.format(date != null ? date : NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatShortDate(Date date) {
        DateFormat dateFormat = SHORT_FORMAT;
        synchronized (dateFormat) {
            return SHORT_FORMAT.format(date != null ? date : NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatCustomDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CUSTOM_FORMAT;
        synchronized (dateFormat) {
            return CUSTOM_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatConsoleDiffDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CONSOLE_DIFF_DATE_FORMAT;
        synchronized (dateFormat) {
            return CONSOLE_DIFF_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatConsoleLongDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CONSOLE_LONG_DATE_FORMAT;
        synchronized (dateFormat) {
            return CONSOLE_LONG_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatConsoleShortDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CONSOLE_SHORT_DATE_FORMAT;
        synchronized (dateFormat) {
            return CONSOLE_SHORT_DATE_FORMAT.format(date);
        }
    }

    public static SVNDate parseDate(String str) {
        if (str == null) {
            return NULL;
        }
        try {
            return SVNDate.parseDatestamp(str);
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, th);
            return NULL;
        }
    }

    public static Date parseDateString(String str) throws SVNException {
        try {
            return SVNDate.parseDatestamp(str);
        }
        catch (SVNException svne) {
            throw svne;
        }
        catch (Throwable th) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_DATE);
            SVNErrorManager.error(err, th, SVNLogType.DEFAULT);
            return NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNDate parseDatestamp(String str) throws SVNException {
        String segment;
        if (str == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_DATE);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        int index = 0;
        int startIndex = 0;
        int[] result = new int[7];
        int microseconds = 0;
        int timeZoneInd = -1;
        for (int charIndex = 0; index < DATE_SEPARATORS.length && charIndex < str.length(); ++charIndex) {
            if (str.charAt(charIndex) == '-') {
                if (index > 1) {
                    timeZoneInd = charIndex;
                }
            } else if (str.charAt(charIndex) == '+') {
                timeZoneInd = charIndex;
            }
            if (str.charAt(charIndex) != DATE_SEPARATORS[index] && (index != 5 || str.charAt(charIndex) != DATE_SEPARATORS[index + 1])) continue;
            if (index == 5 && str.charAt(charIndex) == DATE_SEPARATORS[index + 1]) {
                ++index;
            }
            if ((segment = str.substring(startIndex, charIndex)).length() == 0) {
                result[index] = 0;
            } else if (index + 1 < DATE_SEPARATORS.length) {
                result[index] = Integer.parseInt(segment);
            } else {
                result[index] = Integer.parseInt(segment.substring(0, Math.min(3, segment.length())));
                if (segment.length() > 3) {
                    microseconds = Integer.parseInt(segment.substring(3));
                }
            }
            startIndex = charIndex + 1;
            ++index;
        }
        if (index < DATE_SEPARATORS.length) {
            segment = str.substring(startIndex);
            result[index] = segment.length() == 0 ? 0 : Integer.parseInt(segment);
        }
        int year = result[0];
        int month = result[1];
        int date = result[2];
        int hour = result[3];
        int min = result[4];
        int sec = result[5];
        int ms = result[6];
        String timeZoneId = null;
        if (timeZoneInd != -1 && timeZoneInd < str.length() - 1 && str.indexOf(90) == -1 && str.indexOf(122) == -1) {
            timeZoneId = "GMT" + str.substring(timeZoneInd);
        }
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.clear();
            TimeZone oldTimeZone = null;
            if (timeZoneId != null) {
                oldTimeZone = CALENDAR.getTimeZone();
                CALENDAR.setTimeZone(TimeZone.getTimeZone(timeZoneId));
            } else if (str.indexOf(90) == -1 && str.indexOf(122) == -1) {
                oldTimeZone = CALENDAR.getTimeZone();
                CALENDAR.setTimeZone(TimeZone.getDefault());
            }
            CALENDAR.set(year, month - 1, date, hour, min, sec);
            CALENDAR.set(14, ms);
            SVNDate resultDate = new SVNDate(CALENDAR.getTimeInMillis(), microseconds);
            if (oldTimeZone != null) {
                CALENDAR.setTimeZone(oldTimeZone);
            }
            return resultDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseDateAsMilliseconds(String str) {
        if (str == null) {
            return -1L;
        }
        int index = 0;
        int startIndex = 0;
        int[] result = new int[7];
        for (int charIndex = 0; index < DATE_SEPARATORS.length && charIndex < str.length(); ++charIndex) {
            if (str.charAt(charIndex) != DATE_SEPARATORS[index]) continue;
            String segment = str.substring(startIndex, charIndex);
            if (segment.length() == 0) {
                result[index] = 0;
            } else {
                if (index + 1 < DATE_SEPARATORS.length) {
                    try {
                        result[index] = Integer.parseInt(segment);
                    }
                    catch (NumberFormatException nfe) {
                        return -1L;
                    }
                }
                try {
                    result[index] = Integer.parseInt(segment.substring(0, Math.min(3, segment.length())));
                }
                catch (NumberFormatException nfe) {
                    return -1L;
                }
            }
            startIndex = charIndex + 1;
            ++index;
        }
        int year = result[0];
        int month = result[1];
        int date = result[2];
        int hour = result[3];
        int min = result[4];
        int sec = result[5];
        int ms = result[6];
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.clear();
            CALENDAR.set(year, month - 1, date, hour, min, sec);
            CALENDAR.set(14, ms);
            return CALENDAR.getTimeInMillis();
        }
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myMicroSeconds;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SVNDate) {
            SVNDate date = (SVNDate)obj;
            return this.getTime() == date.getTime() && this.myMicroSeconds == date.myMicroSeconds;
        }
        return super.equals(obj);
    }

    @Override
    public boolean before(Date when) {
        if (super.equals(when) && when instanceof SVNDate) {
            return this.myMicroSeconds < ((SVNDate)when).myMicroSeconds;
        }
        return super.before(when);
    }

    @Override
    public boolean after(Date when) {
        if (super.equals(when) && when instanceof SVNDate) {
            return this.myMicroSeconds > ((SVNDate)when).myMicroSeconds;
        }
        return super.after(when);
    }

    @Override
    public int compareTo(Date anotherDate) {
        int result = super.compareTo(anotherDate);
        if (result == 0 && anotherDate instanceof SVNDate) {
            SVNDate date = (SVNDate)anotherDate;
            return this.myMicroSeconds < date.myMicroSeconds ? -1 : (this.myMicroSeconds == date.myMicroSeconds ? 0 : 1);
        }
        return result;
    }

    public long getTimeInMicros() {
        return 1000L * this.getTime() + (long)this.myMicroSeconds;
    }

    static {
        SVN_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        ISO8601_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        RFC1123_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        HUMAN_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        SHORT_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        CUSTOM_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

