/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVDeltaHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVFileRevisionHandler
extends BasicDAVDeltaHandler {
    private static final DAVElement REVISION_PROPERTY = DAVElement.getElement("svn:", "rev-prop");
    private static final DAVElement FILE_REVISION = DAVElement.getElement("svn:", "file-rev");
    private static final DAVElement SET_PROPERTY = DAVElement.getElement("svn:", "set-prop");
    private static final DAVElement DELETE_PROPERTY = DAVElement.getElement("svn:", "remove-prop");
    private static final DAVElement MERGED_REVISION = DAVElement.getElement("svn:", "merged-revision");
    private ISVNFileRevisionHandler myFileRevisionsHandler;
    private String myPath;
    private long myRevision;
    private SVNProperties myProperties;
    private SVNProperties myPropertiesDelta;
    private String myPropertyName;
    private String myPropertyEncoding;
    private boolean myIsMergedRevision;
    private int myCount;

    public static StringBuffer generateFileRevisionsRequest(StringBuffer xmlBuffer, long startRevision, long endRevision, String path, boolean includeMergedRevisions) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "file-revs-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        if (startRevision >= 0L) {
            SVNXMLUtil.openCDataTag("S", "start-revision", String.valueOf(startRevision), xmlBuffer);
        }
        if (endRevision >= 0L) {
            SVNXMLUtil.openCDataTag("S", "end-revision", String.valueOf(endRevision), xmlBuffer);
        }
        if (includeMergedRevisions) {
            SVNXMLUtil.openXMLTag("S", "include-merged-revisions", 4, null, xmlBuffer);
        }
        SVNXMLUtil.openCDataTag("S", "path", path, xmlBuffer);
        SVNXMLUtil.addXMLFooter("S", "file-revs-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVFileRevisionHandler(ISVNFileRevisionHandler handler) {
        this.myFileRevisionsHandler = handler;
        this.myCount = 0;
        this.init();
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == FILE_REVISION) {
            String revString;
            this.myIsMergedRevision = false;
            this.myPath = attrs.getValue("path");
            if (this.myPath == null) {
                this.missingAttributeError(element, "path");
            }
            if ((revString = attrs.getValue("rev")) == null) {
                this.missingAttributeError(element, "rev");
            }
            try {
                this.myRevision = Long.parseLong(revString);
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
        } else if (element == REVISION_PROPERTY || element == SET_PROPERTY || element == DELETE_PROPERTY) {
            this.myPropertyName = attrs.getValue("name");
            if (this.myPropertyName == null) {
                this.missingAttributeError(element, "name");
            }
            this.myPropertyEncoding = attrs.getValue("encoding");
        } else if (element == TX_DELTA) {
            if (this.myPath != null && this.myFileRevisionsHandler != null) {
                if (this.myProperties == null) {
                    this.myProperties = new SVNProperties();
                }
                if (this.myPropertiesDelta == null) {
                    this.myPropertiesDelta = new SVNProperties();
                }
                SVNFileRevision revision = new SVNFileRevision(this.myPath, this.myRevision, this.myProperties, this.myPropertiesDelta, this.myIsMergedRevision);
                this.myFileRevisionsHandler.openRevision(revision);
                this.myProperties = null;
                this.myPropertiesDelta = null;
                this.myPath = null;
                this.myFileRevisionsHandler.applyTextDelta(this.myPath, null);
            }
            this.setDeltaProcessing(true);
        } else if (element == MERGED_REVISION) {
            this.myIsMergedRevision = true;
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == FILE_REVISION) {
            if (this.myPath != null && this.myFileRevisionsHandler != null) {
                if (this.myProperties == null) {
                    this.myProperties = new SVNProperties();
                }
                if (this.myPropertiesDelta == null) {
                    this.myPropertiesDelta = new SVNProperties();
                }
                SVNFileRevision revision = new SVNFileRevision(this.myPath, this.myRevision, this.myProperties, this.myPropertiesDelta);
                this.myFileRevisionsHandler.openRevision(revision);
            }
            if (this.myFileRevisionsHandler != null) {
                this.myFileRevisionsHandler.closeRevision(this.myPath);
            }
            this.myPath = null;
            this.myProperties = null;
            this.myPropertiesDelta = null;
            this.myPropertyEncoding = null;
            this.myPropertyName = null;
        } else if (element == TX_DELTA) {
            this.setDeltaProcessing(false);
            ++this.myCount;
        } else if (element == REVISION_PROPERTY) {
            if (this.myProperties == null) {
                this.myProperties = new SVNProperties();
            }
            this.myProperties.put(this.myPropertyName, cdata != null ? cdata.toString() : "");
            this.myPropertyName = null;
        } else if (element == SET_PROPERTY) {
            if (this.myPropertiesDelta == null) {
                this.myPropertiesDelta = new SVNProperties();
            }
            if (this.myPropertyName != null) {
                if ("base64".equals(this.myPropertyEncoding)) {
                    StringBuffer sb = SVNBase64.normalizeBase64(cdata);
                    byte[] buffer = this.allocateBuffer(sb.length());
                    int length = SVNBase64.base64ToByteArray(sb, buffer);
                    SVNPropertyValue value = SVNPropertyValue.create(this.myPropertyName, buffer, 0, length);
                    this.myPropertiesDelta.put(this.myPropertyName, value);
                } else {
                    this.myPropertiesDelta.put(this.myPropertyName, cdata.toString());
                }
            }
            this.myPropertyName = null;
            this.myPropertyEncoding = null;
        } else if (element == DELETE_PROPERTY) {
            if (this.myPropertiesDelta == null) {
                this.myPropertiesDelta = new SVNProperties();
            }
            if (this.myPropertyName != null) {
                this.myPropertiesDelta.put(this.myPropertyName, (byte[])null);
            }
            this.myPropertyEncoding = null;
            this.myPropertyName = null;
        }
    }

    public int getEntriesCount() {
        return this.myCount;
    }

    @Override
    protected ISVNDeltaConsumer getDeltaConsumer() {
        return this.myFileRevisionsHandler;
    }

    @Override
    protected String getCurrentPath() {
        return this.myPath;
    }

    private void missingAttributeError(DAVElement element, String attr) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing attribute ''{0}'' on element {1}", new Object[]{attr, element});
        SVNErrorManager.error(err, SVNLogType.NETWORK);
    }
}

