/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.media;

import de.regnis.q.sequence.core.QSequenceCancelledException;
import de.regnis.q.sequence.core.QSequenceCanceller;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.media.QSequenceCachableMedia;
import de.regnis.q.sequence.media.QSequenceCachableMediaLeftGetter;
import de.regnis.q.sequence.media.QSequenceCachableMediaRightGetter;
import de.regnis.q.sequence.media.QSequenceCachingMediaSymbolMap;
import de.regnis.q.sequence.media.QSequenceIntMedia;

public class QSequenceCachingMedia
extends QSequenceIntMedia {
    private final QSequenceCachingMediaSymbolMap symbolMap;
    private final int[] leftSymbols;
    private final int[] rightSymbols;

    public QSequenceCachingMedia(QSequenceCachableMedia media, QSequenceCanceller canceller) throws QSequenceException {
        super(canceller);
        this.symbolMap = new QSequenceCachingMediaSymbolMap(media.getLeftLength() + media.getRightLength());
        this.leftSymbols = this.symbolMap.createSymbols(media, new QSequenceCachableMediaLeftGetter());
        this.rightSymbols = this.symbolMap.createSymbols(media, new QSequenceCachableMediaRightGetter());
    }

    @Override
    public int getLeftLength() {
        return this.leftSymbols.length;
    }

    @Override
    public int getRightLength() {
        return this.rightSymbols.length;
    }

    @Override
    public boolean equals(int leftIndex, int rightIndex) throws QSequenceCancelledException {
        this.checkCancelled();
        return this.leftSymbols[leftIndex] == this.rightSymbols[rightIndex];
    }

    @Override
    public int getSymbolCount() {
        return this.symbolMap.getSymbolCount();
    }

    @Override
    public int[] getLeftSymbols() {
        return this.leftSymbols;
    }

    @Override
    public int[] getRightSymbols() {
        return this.rightSymbols;
    }
}

