/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineFileSystemCacheSegments;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineReader;
import de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import java.io.IOException;
import java.io.InputStream;

final class QSequenceLineFileSystemCache
implements QSequenceLineCache {
    private final QSequenceLineRAData data;
    private final QSequenceLineSimplifier simplifier;
    private final QSequenceLineFileSystemCacheSegments segments;
    private int lineCount;

    public static QSequenceLineFileSystemCache create(QSequenceLineRAData data, QSequenceLineTempDirectoryFactory tempDirectoryFactory, int maximumBytesInMemory, int maximumSegmentSize, QSequenceLineSimplifier simplifier) throws IOException {
        QSequenceLineFileSystemCache cache = new QSequenceLineFileSystemCache(data, tempDirectoryFactory, maximumBytesInMemory, maximumSegmentSize, simplifier);
        QSequenceLineReader reader = new QSequenceLineReader();
        InputStream stream = data.read(0L, data.length());
        reader.read(stream, cache, simplifier);
        stream.close();
        return cache;
    }

    private QSequenceLineFileSystemCache(QSequenceLineRAData data, QSequenceLineTempDirectoryFactory tempDirectoryFactory, int maximumBytesInMemory, int maximumSegmentSize, QSequenceLineSimplifier simplifier) {
        this.data = data;
        this.simplifier = simplifier;
        this.segments = new QSequenceLineFileSystemCacheSegments(tempDirectoryFactory, maximumBytesInMemory, maximumSegmentSize);
    }

    @Override
    public void close() throws IOException {
        this.segments.close();
    }

    @Override
    public void addLine(QSequenceLine line) throws IOException {
        if (this.lineCount >= Integer.MAX_VALUE) {
            throw new IOException("Too many lines.");
        }
        this.segments.setFromLengthHash(this.lineCount, line.getFrom(), line.getContentLength(), line.getCompareHash());
        ++this.lineCount;
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public QSequenceLine getLine(int index) throws IOException {
        long from = this.segments.getFrom(index);
        int length = this.segments.getLength(index);
        byte[] bytes = new byte[length];
        this.data.get(bytes, from, length);
        return new QSequenceLine(from, bytes, this.simplifier);
    }

    @Override
    public int getLineHash(int index) throws IOException {
        return this.segments.getHash(index);
    }
}

