/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.extendedtype;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.extendedtype.BasicBinaryType;

public class BlobType
extends BasicBinaryType<Blob> {
    private static final Logger theLogger = Logger.getLogger(BlobType.class.getPackage().getName());

    public BlobType(Blob blob) {
        super(blob);
    }

    public BlobType() {
        this(null);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BlobType blobType = new BlobType();
        blobType.loadFromURL = this.loadFromURL;
        blobType.in = this.in;
        blobType.out = this.out;
        blobType._value = this._value;
        blobType._isNULL = this._isNULL;
        return blobType;
    }

    @Override
    public long length() throws Exception {
        if (this._value == null) {
            return 0L;
        }
        return ((Blob)this._value).length();
    }

    public void duplicate() throws SQLException {
        if (this._value != null) {
            this.in = ((Blob)this._value).getBinaryStream();
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        Blob blob = (Blob)this._value;
        InputStream inputStream = null;
        URL uRL = null;
        if (this._value == null) {
            uRL = this.getLoadFromURL();
            if (uRL == null) {
                return null;
            }
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            inputStream = ((Blob)this._value).getBinaryStream();
        }
        return inputStream;
    }

    public InputStream getCharStream() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToDb(Connection connection, String string, String string2, String string3, String string4, boolean bl, List<String> list) throws SQLException, IOException {
        PreparedStatement preparedStatement = null;
        if (this.loadFromURL != null) {
            this.in = this.loadFromURL.openStream();
            if (this.in != null) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer.append("UPDATE " + string + " SET " + string2 + " = ? WHERE ROWID='" + string3 + "'");
                list.add(stringBuffer.toString().replace("?", "(BLOB)"));
                try {
                    preparedStatement = connection.prepareStatement(stringBuffer.toString());
                    preparedStatement.setBlob(1, this.in);
                    int n = preparedStatement.executeUpdate();
                    if (n == 1) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                catch (SQLException sQLException) {
                }
                finally {
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE " + string + " SET " + string2 + "= null" + " WHERE ROWID='" + string3 + "'");
            list.add(stringBuffer.toString());
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            int n = preparedStatement.executeUpdate();
            return n == 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToDisk(String string, String string2, String string3, String string4, boolean bl) throws SQLException, IOException {
        if (this._value == null) {
            theLogger.log(Level.SEVERE, "Unexpected internal error: _value is null");
            return false;
        }
        if (this.out == null) {
            theLogger.log(Level.SEVERE, "Unexpected internal error: out is null");
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = ((Blob)this._value).getBinaryStream();
            byte[] byArray = new byte[131072];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                this.out.write(byArray, 0, n);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, "Read/write failed while saving binary data", iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToStream(String string, String string2, String string3, String string4, boolean bl) throws SQLException, IOException {
        if (this._value == null) {
            theLogger.log(Level.SEVERE, "Unexpected internal error: _value is null");
            return false;
        }
        if (this.out == null) {
            theLogger.log(Level.SEVERE, "Unexpected internal error: out is null");
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = ((Blob)this._value).getBinaryStream();
            byte[] byArray = new byte[131072];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                this.out.write(byArray, 0, n);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, "Read/write failed while saving binary data", iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public void setLoadFromURL(URL uRL) {
        this.loadFromURL = uRL;
        this._value = null;
    }

    public String toString() {
        if (this._value == null) {
            return "(null)";
        }
        return "(BLOB)";
    }
}

