/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.index;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.dialogs.index.IndexEditorPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.IndexObject;

public class IndexInfoPanel
extends BaseInfoPanel
implements ActionListener,
PropertyChangeListener {
    private DBObjectProvider m_prov;
    private Schema[] m_existingSchemas;
    private Schema m_schema;
    private Index m_index;
    private static final String[] SYSTEM_SCHEMA = new String[]{"SYS", "TTREP"};
    private boolean m_userHasEdittedName;
    private BorderLayout m_layMain = new BorderLayout();
    private JMultiLineLabel m_lblTop = new JMultiLineLabel();
    private JPanel m_pnlContext = new JPanel();
    private GridBagLayout m_layCenter = new GridBagLayout();
    private JLabel m_lblOwner = new JLabel();
    private JLabel m_lblTable = new JLabel();
    private SchemaPicker m_cmbTableOwner = new SchemaPicker();
    private SchemaObjectComboBox m_cmbTable = new SchemaObjectComboBox();
    private DBObjectRenderer m_renderer = new DBObjectRenderer();
    IndexEditorPanel m_pnlDetails = new IndexEditorPanel(false);
    private boolean m_listening;

    public IndexInfoPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public String getHeaderTitle() {
        return UIArb.getString((int)519);
    }

    public String getHeaderDescription() {
        return UIArb.getString((int)356);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.setTopLabel(UIArb.getString((int)355));
        this.m_lblTop.setPreferredAspectRatio(0.0f);
        this.m_lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)this.m_lblTop, "North");
        this.m_pnlContext.setLayout(this.m_layCenter);
        this.setOwnerLabel(UIArb.getString((int)108));
        this.setTableLabel(UIArb.getString((int)357));
        this.m_pnlContext.add((Component)this.m_lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlContext.add((Component)this.m_cmbTableOwner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlContext.add((Component)this.m_lblTable, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.m_pnlContext.add((Component)this.m_cmbTable, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_pnlContext, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.m_pnlDetails, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        TimesTenPlugInDatabaseImpl.index_number = 0;
        this.m_prov = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        this.m_index = (Index)traversableContext.find("NewObject");
        Index index = (Index)traversableContext.get("OriginalObject");
        IndexInfoVerifier indexInfoVerifier = (IndexInfoVerifier)traversableContext.find("IndexVerifier");
        this.m_existingSchemas = (Schema[])traversableContext.find("SchemaList");
        if (this.m_schema == null) {
            this.m_schema = (Schema)traversableContext.find("Schema");
        }
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        indexInfoVerifier.setEditable(null == index);
        this.m_pnlDetails.init(this.m_prov, this.m_index.getTable(), indexInfoVerifier, wizardCallbacks, index != null ? index.getTable() : null, true);
        this.init(this.m_index, indexInfoVerifier);
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((Index)traversableContext.find("OriginalObject"), (Index)traversableContext.find("NewObject"), (Schema[])traversableContext.find("SchemaList"), traversableContext.getDirection() != 2);
        this.m_listening = false;
    }

    protected void init(Index index, IndexInfoVerifier indexInfoVerifier) {
        boolean bl = 0 == index.getColumnExpressions().length;
        boolean bl2 = indexInfoVerifier == null || indexInfoVerifier.canAddIndexes();
        this.m_userHasEdittedName = !bl;
        super.init(this.m_prov, (Verifier)indexInfoVerifier);
        this.m_renderer.setProvider(this.m_prov);
        this.m_pnlDetails.setNewIndex(bl);
        this.m_pnlDetails.setIndex(this.m_index);
        Table table = index.getTable();
        Schema schema = index.getSchema();
        if (schema == null) {
            schema = this.m_schema;
        }
        if (bl2) {
            this.m_cmbTableOwner.init(this.m_prov, schema, this.m_existingSchemas);
            for (String string : SYSTEM_SCHEMA) {
                this.m_cmbTableOwner.removeItem((Object)string);
            }
            this.m_cmbTable.init(this.m_prov, schema, new String[]{"TABLE", "MATERIALIZED VIEW"});
            this.m_cmbTableOwner.addActionListener((ActionListener)this);
            this.m_cmbTable.addActionListener((ActionListener)this);
        } else {
            this.m_cmbTableOwner.initWithOneSchema(this.m_prov, schema);
            this.m_cmbTable.initWithOneItem((SchemaObject)table);
        }
        if (table != null) {
            this.m_cmbTable.setSchemaObject((SchemaObject)table);
        }
        this.m_pnlDetails.setTable((Table)this.m_cmbTable.getSchemaObject());
        this.m_lblOwner.setEnabled(bl2);
        this.m_cmbTableOwner.setEnabled(bl2);
        this.m_cmbTableOwner.setEditable(false);
        this.m_lblTable.setEnabled(bl2);
        this.m_cmbTable.setEnabled(bl2);
        this.m_cmbTable.setEditable(false);
        this.m_pnlDetails.updateIndexData(index);
        this.m_pnlDetails.updateButtons();
        this.m_listening = true;
    }

    protected void commit(Index index, Index index2, Schema[] schemaArray, boolean bl) throws TraversalException {
        IndexInfoVerifier indexInfoVerifier = (IndexInfoVerifier)this.getVerifier();
        Table table = (Table)this.m_cmbTable.getSchemaObject();
        Table table2 = (Table)table.copyTo(null, true);
        if (null != index) {
            Index index3 = table2.getIndex(index.getName());
            table2.removeIndex(index3);
        }
        table2.addIndex(index2);
        TimesTenPlugInDatabaseImpl.index_number = 0;
        this.m_pnlDetails.commit();
        if (!bl || indexInfoVerifier != null) {
            // empty if block
        }
    }

    public void setOwnerLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.m_lblOwner, (Component)this.m_cmbTableOwner, (String)string);
    }

    public void setTableLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.m_lblTable, (Component)this.m_cmbTable, (String)string);
    }

    public void setTopLabel(String string) {
        this.m_lblTop.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_listening) {
            Object object = actionEvent.getSource();
            if (object == this.m_cmbTableOwner) {
                Schema schema = null;
                try {
                    schema = this.m_cmbTableOwner.getSchema();
                }
                catch (TraversalException traversalException) {
                    // empty catch block
                }
                if (schema != this.m_schema && !schema.getName().equalsIgnoreCase("SYS")) {
                    this.m_schema = schema;
                    this.m_cmbTable.init(this.m_prov, schema, new String[]{"TABLE", "MATERIALIZED VIEW"});
                }
            } else if (object == this.m_cmbTable) {
                this.updateTableName();
            }
        }
    }

    private void updateTableName() {
        Table table = (Table)this.m_cmbTable.getSchemaObject();
        if (table != null) {
            Table table2 = this.m_index.getTable();
            if (table2 != null && !table2.getName().equalsIgnoreCase(table.getName())) {
                IndexObject[] indexObjectArray = this.m_index.getColumnExpressions();
                for (int i = 0; i < indexObjectArray.length; ++i) {
                    this.m_index.removeColumnExpression(indexObjectArray[i]);
                }
            }
            this.m_index.setTable(table);
            this.m_pnlDetails.setTable(table);
            this.m_pnlDetails.populateColumnExpressions(this.m_index);
            this.m_pnlDetails.populateColumns(this.m_index);
            this.m_pnlDetails.populateIndexType(this.m_index);
            this.m_pnlDetails.updateButtons();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateTableName();
    }
}

