/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.grants;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.dialogs.grants.GrantPrivilegesPanel;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Resource;

public class X10GrantPrivilegesPanel
extends GrantPrivilegesPanel {
    private static final long serialVersionUID = 1L;

    public X10GrantPrivilegesPanel(DBObject dBObject, ObjectActionController.ObjectActionPostProcess objectActionPostProcess) {
        super(dBObject, objectActionPostProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Connection connection = this.getDBObject().getConnection();
        try {
            this.chkAdmin.setEnabled(false);
            SQLComboxModel sQLComboxModel = null;
            Connections.getInstance().lock(connection);
            String string = this.getDBObject().getSchemaName();
            sQLComboxModel = new SQLComboxModel(connection, "select 'PUBLIC' from dual union all select username from all_users where  username not in ('TTREP', 'SYSTEM', 'GRID', 'SYS', '" + string + "') order by 1", (List)null, null);
            this.cbxUsers.setModel(sQLComboxModel);
            this.cbxUsers.setEditable(true);
            String[] stringArray = this.getAvailablePrivileges();
            this.mdlPrivFrom.removeAllElements();
            for (int i = 0; i < stringArray.length; ++i) {
                this.mdlPrivFrom.addElement(stringArray[i]);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((String)this.getDBObject().getConnectionName(), null, (String)"Error updating privileges. ", (SQLException)((SQLException)exception));
            } else {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
    }

    protected String[] getAvailablePrivileges() throws IOException {
        Properties properties = new Properties();
        properties.load(Resource.getResourceAsStream(((Object)((Object)this)).getClass(), (String)"x10privileges.properties"));
        String string = properties.getProperty(this.getDBObject().getObjectType().replace(' ', '_'));
        return string.split(",");
    }
}

