/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;

public class CGCOraTablesDialog
extends JEWTDialog
implements ListSelectionListener,
MouseListener,
ItemListener {
    Object[] _tables;
    DBObject _dbObject;
    JList _dataList;
    DefaultListModel _model;
    HashSet _tablesAdded = new HashSet();
    boolean _showAlltables = false;
    String _rootTable;
    String[] _childTables;
    Stack<Integer> _itemsSelected = null;

    CGCOraTablesDialog(Dialog dialog, String string, DBObject dBObject) {
        super(dialog, string, 3);
        this._dbObject = dBObject;
        this._rootTable = null;
        this._childTables = null;
        this.initTableList();
        String string2 = CGCPanel.theDialog.getDefaultOwner();
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this._tables != null && this._tables.length > 0) {
            String[] stringArray = (String[])this._tables[0];
            String[] stringArray2 = (String[])this._tables[1];
            this._model = new DefaultListModel();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = stringArray[i];
                if (string3.length() > 0) {
                    string2 = string3;
                }
                this._model.add(i, string2 + "." + stringArray2[i]);
            }
            this._dataList = new JList(this._model);
            this._dataList.getSelectionModel().addListSelectionListener(this);
            this._dataList.setVisibleRowCount(28);
            this._dataList.addMouseListener(this);
            JComponent jComponent = new JScrollPane(this._dataList);
            jPanel.add((Component)jComponent, "Center");
            jComponent = new JCheckBox(Messages.getString("CGCOraTablesDialog.showOnlyMyTables"), true);
            ((AbstractButton)jComponent).addItemListener(this);
            jPanel.add((Component)jComponent, "Last");
            this.setOKButtonEnabled(true);
        } else {
            String string4 = "<html><body><b><br>" + Messages.getString("CGCOraTablesDialog.failedToRetriveAnyTablesFromOracle") + "</b><br><br></body></html>";
            JLabel jLabel = new JLabel(string4);
            jPanel.add(jLabel);
            this.setOKButtonEnabled(false);
        }
        this.setContent(jPanel);
        this.setSize(600, 300);
        this.pack();
        this.setPreferredSize(jPanel.getPreferredSize());
    }

    void initTableList() {
        this._tables = CGCPanel.theDialog.getTableList();
        this.setOKButtonEnabled(false);
    }

    void reInitTableList() {
        this.reInitTableList(true);
    }

    void reInitTableList(boolean bl) {
        if (bl) {
            this._tablesAdded.clear();
        }
        this.initTableList();
        if (this._tables != null && this._tables.length > 0) {
            this._model.removeAllElements();
            String[] stringArray = (String[])this._tables[0];
            String[] stringArray2 = (String[])this._tables[1];
            String string = this._dbObject.getDictionary().get("OBJECT_OWNER").toString();
            String string2 = CGCPanel.getGridName(this._dbObject);
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("^MLOG\\$.+");
            stringBuffer.append("|^RUPD\\$_.+");
            stringBuffer.append("|^BIN\\$_.+==\\$\\d+$");
            stringBuffer.append("|^[FT]T_\\d\\d_(");
            stringBuffer.append("\\d*_[LT]");
            stringBuffer.append("|AGENT_STATUS");
            stringBuffer.append("|AR_PARAMS");
            stringBuffer.append("|CACHE_STATS");
            stringBuffer.append("|DATABASES");
            stringBuffer.append("|DB_PARAMS");
            stringBuffer.append("|DDL_L");
            stringBuffer.append("|DDL_TRACKING");
            stringBuffer.append("|SYNC_OBJS");
            stringBuffer.append("|USER_COUNT");
            stringBuffer.append("|REPPEERS");
            stringBuffer.append("|REPACTIVESTANDBY");
            stringBuffer.append("|" + string + "__\\d*CG(");
            stringBuffer.append("GROUPDEFS");
            stringBuffer.append("|NODEID");
            stringBuffer.append("|NODEINFO");
            stringBuffer.append(")");
            if (string2 != null) {
                stringBuffer.append("|" + string2 + "_\\d*CG(");
                stringBuffer.append("GROUPDEFS");
                stringBuffer.append("|NODEID");
                stringBuffer.append("|NODEINFO");
                stringBuffer.append(")");
            }
            stringBuffer.append(")$");
            String string3 = stringBuffer.toString();
            Pattern pattern = Pattern.compile(string3);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this._showAlltables && string.compareTo(stringArray[i]) != 0) continue;
                String string4 = stringArray2[i];
                Matcher matcher = pattern.matcher(string4);
                String string5 = stringArray[i] + "." + string4;
                if (matcher.matches() || this._tablesAdded.contains(string5) || CGCPanel.theDialog.getTablesCacheGroup(string5) != null) continue;
                this._model.addElement(string5);
            }
            this._dataList = new JList(this._model);
        }
        this._rootTable = null;
    }

    String[] getTables() {
        if (this.isCancelled()) {
            return null;
        }
        if (this._itemsSelected == null) {
            return null;
        }
        if (this._itemsSelected.empty()) {
            return null;
        }
        int n = this._itemsSelected.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this._itemsSelected.pop();
            String string = this._model.elementAt(n2).toString();
            this._model.removeElementAt(n2);
            stringArray[i] = string;
            this._tablesAdded.add(string);
        }
        return stringArray;
    }

    void putTable(String string) {
        if (string == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        Object object = this._dbObject.getDictionary().get("OBJECT_OWNER").toString() + ".";
        Enumeration enumeration = this._model.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this._showAlltables && !string2.startsWith((String)object)) continue;
            hashSet.add(string2);
        }
        Object[] objectArray = hashSet.toArray(new Object[hashSet.size()]);
        Arrays.sort(objectArray);
        this._model.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            this._model.addElement(object);
            this._tablesAdded.remove(object);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (bl) {
            return;
        }
        this.setOKButtonEnabled(!listSelectionModel.isSelectionEmpty());
        if (!listSelectionModel.isSelectionEmpty()) {
            listSelectionModel.setSelectionMode(this._rootTable == null ? 0 : 2);
            int n3 = listSelectionModel.getMinSelectionIndex();
            int n4 = listSelectionModel.getMaxSelectionIndex();
            this._itemsSelected = new Stack();
            for (int i = n3; i <= n4; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                this._itemsSelected.push(i);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2 || this._dataList.getSelectionMode() != 0) {
            return;
        }
        mouseEvent.consume();
        this.closeDialog(false);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        boolean bl = itemEvent.getStateChange() == 1;
        this._showAlltables = !bl;
        this.reInitTableList(false);
    }
}

