/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreePanel;

public class CGCJTree
extends JTree {
    private DropTarget _dndTgt;
    private DragSource _dndSrc;
    private CGCTableTreeNode _draggedNode;
    private int _rowMarked = -1;
    private DragSourceContext _srcContext;
    private DragSourceListener dragSrcListener = new DragSourceAdapter(){

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            CGCJTree.this._srcContext = dragSourceDragEvent.getDragSourceContext();
        }
    };
    private DropTargetListener dragTgtListener = new DropTargetAdapter(){

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            try {
                CGCTableTreeNode cGCTableTreeNode = CGCJTree.this.nodeUnderMouse(dropTargetDragEvent);
                if (cGCTableTreeNode == null || cGCTableTreeNode == CGCJTree.this._draggedNode || !cGCTableTreeNode.allowDrop()) {
                    CGCJTree.this._srcContext.setCursor(DragSource.DefaultMoveNoDrop);
                    dropTargetDragEvent.rejectDrag();
                    CGCJTree.this.resetRowMarked();
                    CGCJTree.this.repaint();
                    return;
                }
                CGCJTree.this._srcContext.setCursor(DragSource.DefaultMoveDrop);
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                CGCJTree.this.noteRowMarked(dropTargetDragEvent);
                CGCJTree.this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            CGCTableTreeNode cGCTableTreeNode = CGCJTree.this.nodeUnderMouse(dropTargetDropEvent);
            if (cGCTableTreeNode == null || cGCTableTreeNode == CGCJTree.this._draggedNode) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            try {
                CGCJTree.this.resetRowMarked();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)CGCJTree.this.getModel();
                defaultTreeModel.removeNodeFromParent(CGCJTree.this._draggedNode);
                defaultTreeModel.insertNodeInto(CGCJTree.this._draggedNode, cGCTableTreeNode, cGCTableTreeNode.getChildCount());
                dropTargetDropEvent.dropComplete(true);
                TreePath treePath = new TreePath(CGCJTree.this._draggedNode.getPath());
                CGCJTree.this.setSelectionPath(treePath);
                CGCJTree.this.expandSelectedNode(true);
                CGCJTree.this._draggedNode.setParentTable(cGCTableTreeNode);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    };
    private static Transferable nothing = new StringSelection("");
    private DragGestureListener dgListener = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            CGCTableTreeNode cGCTableTreeNode;
            TreePath treePath = CGCJTree.this.getSelectionPath();
            if (treePath != null && (cGCTableTreeNode = (CGCTableTreeNode)treePath.getLastPathComponent()).allowDrag()) {
                CGCJTree.this._draggedNode = cGCTableTreeNode;
                try {
                    CGCJTree.this._dndSrc.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, nothing, CGCJTree.this.dragSrcListener);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    // empty catch block
                }
            }
        }
    };
    CGCTableTreePanel _gui;

    @Override
    public void setSelectionPath(TreePath treePath) {
        CGCTableTreeNode cGCTableTreeNode = (CGCTableTreeNode)treePath.getLastPathComponent();
        if (cGCTableTreeNode.isTable()) {
            super.setSelectionPath(treePath);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this._gui.treeIsEmpty() ? Messages.getString("CGCJTree.rightClickToAddTables") : null;
    }

    public CGCJTree(CGCTableTreePanel cGCTableTreePanel) {
        this._gui = cGCTableTreePanel;
        this._dndTgt = new DropTarget(this, this.dragTgtListener);
        this._dndSrc = DragSource.getDefaultDragSource();
        this._dndSrc.createDefaultDragGestureRecognizer(this, 2, this.dgListener);
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                int n2 = ((CGCJTree)jTree).getRowMarked();
                if (n == n2) {
                    jLabel.setBorder(new LineBorder(Color.black));
                } else {
                    jLabel.setBorder(BorderFactory.createEmptyBorder());
                }
                return jLabel;
            }
        });
    }

    public final int getRowMarked() {
        return this._rowMarked;
    }

    public final void resetRowMarked() {
        this._rowMarked = -1;
    }

    private void noteRowMarked(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        this._rowMarked = this.getRowForLocation(point.x, point.y);
    }

    private CGCTableTreeNode nodeUnderMouse(DropTargetDropEvent dropTargetDropEvent) {
        return this.nodeUnderMouse(dropTargetDropEvent.getLocation());
    }

    private CGCTableTreeNode nodeUnderMouse(DropTargetDragEvent dropTargetDragEvent) {
        return this.nodeUnderMouse(dropTargetDragEvent.getLocation());
    }

    private CGCTableTreeNode nodeUnderMouse(Point point) {
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        return treePath == null ? null : (CGCTableTreeNode)treePath.getLastPathComponent();
    }

    public void expandTree(boolean bl) {
        try {
            this.expandTree(new TreePath((TreeNode)this.getModel().getRoot()), bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void expandTree(TreeNode treeNode, boolean bl) {
        this.expandTree(new TreePath(this._draggedNode.getPath()), bl);
    }

    public void expandTree(TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                this.expandTree(treePath.pathByAddingChild(enumeration.nextElement()), bl);
            }
        }
        if (bl) {
            this.expandPath(treePath);
        } else {
            this.collapsePath(treePath);
        }
    }

    public void expandSelectedNode(boolean bl) {
        try {
            this.expandTree(this.getSelectionPath(), bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

