/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.SQLDialogHelpProvider;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ActionSqlPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ISqlPromptPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.ide.Ide;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class TTDialog {
    protected DBObject dbObject;
    protected TTJPanel gui;
    protected String dialogTitle;
    protected String helpString;
    protected String confirmMessage;
    protected ObjectActionController.ObjectActionPostProcess oapp;
    protected boolean modal;
    protected Dimension preferredSize = null;
    JEWTDialog _dialog = null;

    public TTDialog(DBObject dBObject, TTJPanel tTJPanel, String string, String string2, String string3, ObjectActionController.ObjectActionPostProcess objectActionPostProcess) {
        this(dBObject, tTJPanel, string, string2, string3, objectActionPostProcess, true, true, null);
    }

    public TTDialog(DBObject dBObject, TTJPanel tTJPanel, String string, String string2, String string3, ObjectActionController.ObjectActionPostProcess objectActionPostProcess, boolean bl) {
        this(dBObject, tTJPanel, string, string2, string3, objectActionPostProcess, bl, true, null);
    }

    public TTDialog(DBObject dBObject, TTJPanel tTJPanel, String string, String string2, String string3, ObjectActionController.ObjectActionPostProcess objectActionPostProcess, boolean bl, boolean bl2, Dimension dimension) {
        this.dbObject = dBObject;
        this.gui = tTJPanel;
        this.dialogTitle = string;
        this.helpString = string2;
        this.confirmMessage = string3;
        this.oapp = objectActionPostProcess;
        this.modal = bl;
        this.preferredSize = dimension;
        if (bl2) {
            this.launch();
        }
    }

    protected ISqlPromptPanel getDialogGUI() {
        return (ISqlPromptPanel)((Object)this.gui);
    }

    public void launch() {
        if (!this.gui.is_applicable()) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Not launched since gui.is_applicable returns false");
            return;
        }
        try {
            this.showDialog();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void showDialog() throws Exception {
        final ISqlPromptPanel iSqlPromptPanel = this.getDialogGUI();
        final ActionSqlPanel actionSqlPanel = new ActionSqlPanel(iSqlPromptPanel);
        JEWTDialog jEWTDialog = TTDialog.showPanelAsTabbedDialog(this.gui.getPanels(actionSqlPanel), this.gui.getTabTitles(), this.dialogTitle, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(final ActionEvent actionEvent) {
                if (iSqlPromptPanel.validateValues()) {
                    final String string = iSqlPromptPanel.getSql();
                    ProgressRunnable progressRunnable = new ProgressRunnable(){

                        protected void doCancel() {
                        }

                        protected Object doWork() throws Exception {
                            try {
                                if (TTDialog.this.processDialog(actionEvent, actionSqlPanel)) {
                                    throw new SQLException();
                                }
                                if (TTDialog.this.oapp != null) {
                                    TTDialog.this.oapp.run();
                                }
                            }
                            catch (SQLException sQLException) {
                                String string3 = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string);
                                String string2 = sQLException.getSQLState();
                                int n = sQLException.getErrorCode();
                                SQLException sQLException2 = new SQLException(string3, string2, n);
                                throw sQLException2;
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                            return null;
                        }
                    };
                    progressRunnable.setTitle(Messages.getString("TimesTen.common.pleaseWait"));
                    progressRunnable.setCancelable(false);
                    boolean bl = true;
                    try {
                        progressRunnable.start(true);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (ProgressException progressException) {
                        bl = false;
                    }
                    finally {
                        if (bl) {
                            if (TTDialog.this.confirmMessage == null) {
                                TTDialog.this.confirmMessage = TTDialog.this.gui.getConfirmMessage();
                            }
                            try {
                                TTDialog.this.dbObject.getConnection().commit();
                            }
                            catch (Exception exception) {}
                            TTDialog.this.processConfirm(actionSqlPanel, TTDialog.this.dbObject.getConnectionName());
                        }
                    }
                }
            }
        }, (HelpProvider)new SQLDialogHelpProvider(this.helpString), null, this.modal, this.preferredSize);
        this.gui.setPDialog(jEWTDialog);
    }

    private String[] getStatements(String string) {
        return string.split(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processStatement(String string, String string2, ActionEvent actionEvent, ActionSqlPanel actionSqlPanel) {
        boolean bl = true;
        Connections.getInstance().getLock(string2).lock();
        PreparedStatement preparedStatement = null;
        ISqlPromptPanel iSqlPromptPanel = this.getDialogGUI();
        try {
            preparedStatement = iSqlPromptPanel.getDbObject().getConnection().prepareStatement(string);
            Connections.getInstance().getLock(string2).unlock();
            if (preparedStatement == null) {
                boolean bl2 = false;
                return bl2;
            }
            Connections.getInstance().getLock(string2).lock();
            Log.log((String)string);
            boolean bl3 = preparedStatement.execute();
            ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)TTSQLExceptionScrubber.cloneScrubbedSQLException(sQLException, iSqlPromptPanel.getSql()));
            bl = false;
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
            bl = false;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
                preparedStatement = null;
            }
            Connections.getInstance().getLock(string2).unlock();
        }
        return bl;
    }

    private boolean processDialog(ActionEvent actionEvent, ActionSqlPanel actionSqlPanel) {
        String string = this.dbObject.getConnectionName();
        String[] stringArray = this.getStatements(actionSqlPanel.getSQL().trim());
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        dBUtil.setRaiseError(true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0 || this.processStatement(stringArray[i], string, actionEvent, actionSqlPanel)) continue;
            return true;
        }
        return false;
    }

    public void processConfirm(ActionSqlPanel actionSqlPanel, String string) {
        String string2;
        PropertyPanel propertyPanel = new PropertyPanel();
        propertyPanel.removeAll();
        ActionSql actionSql = new ActionSql();
        String string3 = Messages.getString("TimesTen.common.confirm");
        string3 = actionSql.manualSubs(string3, actionSqlPanel.getDictionary());
        if (this.confirmMessage.indexOf(35) > -1) {
            string2 = actionSql.manualSubs(this.confirmMessage, actionSqlPanel.getDictionary());
            string2 = actionSql.processPrompts(string2, actionSqlPanel.getPromptPanel().getTextValues(), null);
        } else {
            string2 = this.confirmMessage;
        }
        propertyPanel.addSingleComp(string2);
        UIUtils.showPanelAsDialog((JPanel)propertyPanel, (String)string3, null, (int)1);
    }

    public static Container createRadioButtonGroup(String[] stringArray, int n, ActionListener actionListener) {
        return TTDialog.createRadioButtonGroup(stringArray, n, actionListener, true);
    }

    public static Container createRadioButtonGroup(String[] stringArray, int n, ActionListener[] actionListenerArray) {
        return TTDialog.createRadioButtonGroup(stringArray, n, actionListenerArray, true);
    }

    public static Container createRadioButtonGroup(String[] stringArray, int n, ActionListener actionListener, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, bl ? 0 : 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(stringArray[i]);
            if (i == n) {
                jRadioButton.setSelected(true);
            }
            if (!bl) {
                jRadioButton.setAlignmentX(0.0f);
            }
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            jRadioButton.addActionListener(actionListener);
        }
        return jPanel;
    }

    public static Container createRadioButtonGroup(String[] stringArray, int n, ActionListener[] actionListenerArray, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, bl ? 0 : 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(stringArray[i]);
            if (i == n) {
                jRadioButton.setSelected(true);
            }
            if (!bl) {
                jRadioButton.setAlignmentX(0.0f);
            }
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            jRadioButton.addActionListener(actionListenerArray[i]);
        }
        return jPanel;
    }

    public static JComboBox createMenu(String[] stringArray) {
        return TTDialog.createMenu(stringArray, null, null);
    }

    public static JComboBox createMenu(String[] stringArray, ActionListener actionListener) {
        return TTDialog.createMenu(stringArray, null, actionListener);
    }

    public static JComboBox createMenu(String[] stringArray, String string) {
        return TTDialog.createMenu(stringArray, string, null);
    }

    public static JComboBox createMenu(String[] stringArray, String string, ActionListener actionListener) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        int n = -1;
        if (string != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i])) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                jComboBox.setSelectedIndex(n);
            }
        }
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
        return jComboBox;
    }

    public static void showError(JPanel jPanel, String string) {
        MessageDialog.error((Component)jPanel, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
    }

    public static void showError(String string) {
        TTDialog.showError(null, string);
    }

    public static JEWTDialog showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        return TTDialog.showPanelAsTabbedDialog(jPanelArray, stringArray, string, actionListener, helpProvider, changeListener, true, null);
    }

    public static JEWTDialog showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener, boolean bl, Dimension dimension) {
        boolean bl2 = jPanelArray.length - stringArray.length == 1;
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        for (int i = 0; i < stringArray.length; ++i) {
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            jTabbedPane.addTab(stringArray[i], jPanelArray[i]);
        }
        if (helpProvider != null) {
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)jTabbedPane.getSelectedComponent());
                }
            };
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider2);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        if (bl2) {
            jPanel.add((Component)jPanelArray[jPanelArray.length - 1], "First");
        }
        jPanel.add((Component)jTabbedPane, "Center");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        jEWTDialog.setModal(bl);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            jTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        if (dimension != null) {
            jEWTDialog.setSize(dimension);
        } else {
            jEWTDialog.setPreferredSize(jTabbedPane.getPreferredSize());
        }
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
        return jEWTDialog;
    }

    public static JEWTDialog showPanelAsTabbedDialog_orig(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener, boolean bl, Dimension dimension) {
        boolean bl2 = jPanelArray.length - stringArray.length == 1;
        final CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        for (int i = 0; i < stringArray.length; ++i) {
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            customTabbedPane.addTab((Icon)null, stringArray[i], (Component)jPanelArray[i]);
        }
        if (helpProvider != null) {
            customTabbedPane.putClientProperty((Object)"JEWT.HelpProvider", (Object)helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)customTabbedPane.getActivePanel());
                }
            };
            customTabbedPane.putClientProperty((Object)"JEWT.HelpProvider", (Object)helpProvider2);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        if (bl2) {
            jPanel.add((Component)jPanelArray[jPanelArray.length - 1], "First");
        }
        jPanel.add((Component)customTabbedPane, "Center");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        jEWTDialog.setModal(bl);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            customTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.pack();
        if (dimension != null) {
            jEWTDialog.setSize(dimension);
        }
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
        return jEWTDialog;
    }
}

