/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.PrepareResult;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.ResultSetGridCell;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.timesten.ResultSetCondition;
import oracle.dbtools.raptor.timesten.X10ResultSetTableModel;
import oracle.dbtools.raptor.timesten.extendedtype.BlobType;
import oracle.dbtools.raptor.timesten.extendedtype.VarBinaryType;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class X10ERSTM
extends EditableResultSetTableModel {
    private static Logger theLogger = Logger.getLogger(X10ERSTM.class.getPackage().getName());
    private List<String> theColumnNames = null;
    protected Calendar _calendar = Calendar.getInstance();
    protected boolean _resultSetInvalidFlag;
    private WeakReference<ChangeListener> theChangeListener;

    public synchronized boolean is_resultSetInvalidFlag() {
        return this._resultSetInvalidFlag;
    }

    protected synchronized void set_resultSetInvalidFlag(boolean bl) {
        this._resultSetInvalidFlag = bl;
    }

    public X10ERSTM() {
        this._addRowScnColumn = false;
        this._skipCols.add("ROWID_ALIAS");
    }

    public List<String> getEditableColNames() {
        List list = super.getEditableColNames();
        for (String string : list) {
            System.out.println("Editable column: " + string);
        }
        return list;
    }

    public String getModifiedSql() {
        if (this._sql == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this._expandedSql == null) {
            stringBuilder.append("SELECT ROWID rowid_alias, *");
            stringBuilder.append(" FROM " + this._schemaName + "." + this._tablename);
            this._expandedSql = stringBuilder.toString();
        } else if (this._expandedSql != null) {
            stringBuilder.append(this._rstmsql.getModifiedSql(this._expandedSql));
        } else {
            stringBuilder.append(this._rstmsql.getModifiedSql());
        }
        String string = this.getOrderBy();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(string);
        }
        return RSTMSql.sanitizeSql((String)stringBuilder.toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PreparedStatement prepareStatement() throws SQLException, DBException {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        Connections connections = null;
        DBUtil dBUtil = null;
        List list = this.getBindList();
        Map map = this.getBindMap();
        try {
            String string = this.getModifiedSql();
            assert (ModelUtil.hasLength((String)string));
            preparedStatement = null;
            connection = this.getConnection();
            dBUtil = DBUtil.getInstance((Connection)connection);
            if (this.getBindMap() != null) {
                PrepareResult prepareResult = dBUtil.prepareNonOracleSql(string, map);
                list = prepareResult.getBinds();
            } else if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            connections = Connections.getInstance();
            connections.getLock(connection);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setEscapeProcessing(false);
            DBUtil.bind((PreparedStatement)preparedStatement, (List)list);
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
                catch (DBException dBException) {
                    throw dBException;
                }
            }
            catch (Throwable throwable) {
                connections.unlock(connection);
                throw throwable;
            }
        }
        connections.unlock(connection);
        return preparedStatement;
    }

    protected void init(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject) {
        super.init(string, string2, list, map, dBObject);
        this.initHelper();
    }

    protected void init(String string, String string2, List<?> list, Map<String, ?> map) {
        super.init(string, string2, list, map);
        this.initHelper();
    }

    private void initHelper() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ROWID");
        arrayList.add("ROWID_ALIAS");
        this.setDataIntegrityColumnNames(arrayList);
    }

    public boolean isCellEditorEditable(int n, int n2) {
        return true;
    }

    public void closeModel() {
        super.closeModel();
        this._addRowScnColumn = false;
        this.theColumnNames = null;
    }

    public String getOrderBy() {
        List list = this.getGridColumns();
        return X10ResultSetTableModel.getOrderBy(list);
    }

    protected void fetchNext(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        ResultSetCondition resultSetCondition;
        if (this.allRowsFetched()) {
            return;
        }
        ReentrantLock reentrantLock = Connections.getInstance().getLock(this.getConnectionName());
        if (!reentrantLock.isHeldByCurrentThread()) {
            reentrantLock.lock();
        }
        if (this._data == null) {
            this._data = new ArrayList();
        }
        try {
            if (iRaptorTaskProgressUpdater != null) {
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            if (this._rs == null) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage("Executing: " + this.getModifiedSql());
                }
                this._rs = this.openResultSet();
            }
            resultSetCondition = ResultSetCondition.NO_MORE_ROWS;
            ArrayList<ResultSetGridCell> arrayList = null;
            for (int i = 0; i < n; ++i) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                if (this.is_resultSetInvalidFlag()) {
                    break;
                }
                resultSetCondition = X10ResultSetTableModel.testAndAdvanceResultSet(this._rs);
                if (resultSetCondition == ResultSetCondition.NO_MORE_ROWS) {
                    this._alRowsFetched = true;
                    break;
                }
                if (resultSetCondition == ResultSetCondition.RESET) {
                    this.publishStatusMessage(RSTableMessages.getString((String)"ResultSetTableModel.4") + (Object)((Object)resultSetCondition), null);
                    this.set_resultSetInvalidFlag(true);
                    if (arrayList != null) {
                        arrayList.clear();
                    }
                    break;
                }
                if (this.isVerticalDisplay()) {
                    for (int j = 1; j <= this._rs.getMetaData().getColumnCount(); ++j) {
                        arrayList = new ArrayList<ResultSetGridCell>();
                        arrayList.add(new ResultSetGridCell((Object)this._rs.getMetaData().getColumnName(j), this.getConnectionName()));
                        this.cacheObjectInARow(arrayList, j, this._rs);
                        this.addRow(arrayList);
                    }
                    continue;
                }
                this.addRow(this.fetchRowFromResultSet());
                if (iRaptorTaskProgressUpdater == null) continue;
                iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString((String)"ResultSetTableModel.10"), i));
            }
        }
        catch (SQLException sQLException) {
            this._rstmsql = new RSTMSql(this._sql);
            throw new ExecutionException(sQLException);
        }
        catch (DBException dBException) {
            throw new ExecutionException(dBException);
        }
        finally {
            if (reentrantLock.isHeldByCurrentThread()) {
                reentrantLock.unlock();
            }
        }
        if (resultSetCondition == ResultSetCondition.RESET) {
            this.publishStatusMessage(RSTableMessages.getString((String)"ResultSetTableModel.5"), null);
            this.fireStateChanged();
        }
        if (this.allRowsFetched() && iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(RSTableMessages.getString((String)"ResultSetTableModel.6") + this.getLoadedRowCount());
        } else if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString((String)"ResultSetTableModel.10"), this.getLoadedRowCount()));
        }
        if (iRaptorTaskProgressUpdater != null) {
            this._fetchTime += Float.parseFloat(iRaptorTaskProgressUpdater.getDescriptor().getElapsedTime() + "") / 1000.0f;
        }
    }

    protected void reopenResultSet() {
        try {
            this._data.clear();
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.theChangeListener = new WeakReference<ChangeListener>(changeListener);
    }

    public void removeChangeListener() {
        this.theChangeListener = null;
    }

    private void fireStateChanged() {
        if (this.theChangeListener == null) {
            return;
        }
        ChangeListener changeListener = (ChangeListener)this.theChangeListener.get();
        if (changeListener == null) {
            return;
        }
        changeListener.stateChanged(new ResultSetInvalidEvent((Object)this));
        this.fireTableDataChanged();
    }

    public void refresh() throws ExecutionException {
        super.refresh();
        if (this.is_resultSetInvalidFlag()) {
            if (this._rs != null) {
                try {
                    this._rs.close();
                    this._rs = null;
                    this._data.clear();
                }
                catch (SQLException sQLException) {
                    throw new ExecutionException(sQLException);
                }
            }
            this.set_resultSetInvalidFlag(false);
        }
    }

    protected void cacheObjectInARow(List<ResultSetGridCell> list, int n, ResultSet resultSet) throws SQLException {
        Object object = null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        try {
            object = resultSet.getObject(n);
            if (theLogger.isLoggable(Level.FINEST)) {
                theLogger.log(Level.FINEST, n + ":" + " sql type: " + n2 + " value: " + object + " name: " + resultSet.getMetaData().getColumnName(n) + ", type: " + resultSet.getMetaData().getColumnTypeName(n) + " " + resultSet.getMetaData().getColumnClassName(n) + " " + resultSet.getMetaData().getColumnType(n));
            }
            if (n2 == -3 || n2 == -2 || object instanceof byte[]) {
                list.add(new ResultSetGridCell((Object)new VarBinaryType((byte[])object), this._connName));
            } else if (resultSetMetaData.getColumnTypeName(n).equals("DATE") || object instanceof Date) {
                if (object == null) {
                    list.add(new ResultSetGridCell(object, this._connName));
                    return;
                }
                String string = object.toString();
                String[] stringArray = string.split("\\.");
                string = stringArray[0];
                if (stringArray.length == 1) {
                    list.add(new ResultSetGridCell((Object)string, this._connName));
                } else if (this.isEraBC((Timestamp)object)) {
                    string = "-" + string;
                    list.add(new ResultSetGridCell((Object)string, this._connName));
                } else {
                    list.add(new ResultSetGridCell((Object)string, this._connName));
                }
            } else if (object instanceof Timestamp) {
                if (this.isEraBC((Timestamp)object)) {
                    String string = object.toString();
                    string = "-" + string;
                    list.add(new ResultSetGridCell((Object)string, this._connName));
                } else {
                    list.add(new ResultSetGridCell(object, this._connName));
                }
            } else if (n2 == 2004 || object instanceof Blob) {
                Blob blob = (Blob)object;
                list.add(new ResultSetGridCell((Object)new BlobType(blob), this._connName));
            } else if (n2 == 2005 || object instanceof Clob) {
                Clob clob = (Clob)object;
                if (object != null) {
                    Reader reader = clob.getCharacterStream();
                    StringBuilder stringBuilder = new StringBuilder(65536);
                    char[] cArray = new char[65536];
                    int n3 = 0;
                    while ((n3 = reader.read(cArray)) != -1) {
                        stringBuilder.append(cArray, 0, n3);
                    }
                    list.add(new ResultSetGridCell((Object)stringBuilder.toString(), this._connName));
                } else {
                    list.add(new ResultSetGridCell((Object)clob, this._connName));
                }
            } else {
                super.cacheObjectInARow(list, n, resultSet);
            }
        }
        catch (SQLException sQLException) {
            super.cacheObjectInARow(list, n, resultSet);
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, "Cannot process lob object", iOException);
        }
    }

    private boolean isEraBC(Date date) {
        this._calendar.clear();
        this._calendar.setTimeInMillis(date.getTime());
        return this._calendar.get(0) == 0;
    }

    private boolean isEraBC(Timestamp timestamp) {
        this._calendar.clear();
        this._calendar.setTimeInMillis(timestamp.getTime());
        return this._calendar.get(0) == 0;
    }

    public boolean isColumnSortable(int n) {
        boolean bl = super.isColumnSortable(n);
        if (bl) {
            try {
                Connection connection = this.getConnection();
                String string = this.getConnectionName();
                if (connection == null || string == null) {
                    return false;
                }
                ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails((String)string, (Connection)connection);
                return connectionTypeDetails.isColumnTypeSortable(this.getColumnSqlType(n));
            }
            catch (DBException dBException) {
                return false;
            }
        }
        return false;
    }

    static /* synthetic */ String access$800(X10ERSTM x10ERSTM) {
        return x10ERSTM._schemaName;
    }

    static /* synthetic */ String access$900(X10ERSTM x10ERSTM) {
        return x10ERSTM._tablename;
    }

    static /* synthetic */ boolean access$1000(X10ERSTM x10ERSTM) {
        return x10ERSTM._addRowIdColumn;
    }

    static /* synthetic */ boolean access$1100(X10ERSTM x10ERSTM) {
        return x10ERSTM._addRowScnColumn;
    }

    static /* synthetic */ ResultSet access$1200(X10ERSTM x10ERSTM) {
        return x10ERSTM._rs;
    }

    static /* synthetic */ List access$1300(X10ERSTM x10ERSTM) {
        return x10ERSTM.DATA_INTEGRITY_COLS;
    }

    static /* synthetic */ Connection access$1400(X10ERSTM x10ERSTM) throws DBException {
        return x10ERSTM.getConnection();
    }

    static /* synthetic */ List access$1500(X10ERSTM x10ERSTM) {
        return x10ERSTM.DATA_INTEGRITY_COLS;
    }

    static /* synthetic */ DBObject access$1600(X10ERSTM x10ERSTM) {
        return x10ERSTM._dbObject;
    }

    static /* synthetic */ List access$1700(X10ERSTM x10ERSTM) {
        return x10ERSTM._log;
    }

    static /* synthetic */ Connection access$1800(X10ERSTM x10ERSTM) throws DBException {
        return x10ERSTM.getConnection();
    }

    static /* synthetic */ List access$1900(X10ERSTM x10ERSTM) {
        return x10ERSTM.DATA_INTEGRITY_COLS;
    }

    static /* synthetic */ void access$2000(X10ERSTM x10ERSTM, RaptorGridRowModel raptorGridRowModel, String string) {
        x10ERSTM.setRowId(raptorGridRowModel, string);
    }

    static /* synthetic */ Logger access$2100() {
        return theLogger;
    }

    static /* synthetic */ Connection access$2200(X10ERSTM x10ERSTM) throws DBException {
        return x10ERSTM.getConnection();
    }

    static /* synthetic */ String access$2300(X10ERSTM x10ERSTM, RaptorGridRowModel raptorGridRowModel) {
        return x10ERSTM.getRowId(raptorGridRowModel);
    }

    static /* synthetic */ String access$2400(X10ERSTM x10ERSTM, RaptorGridRowModel raptorGridRowModel) {
        return x10ERSTM.getRowScn(raptorGridRowModel);
    }

    static /* synthetic */ boolean access$2500(X10ERSTM x10ERSTM) {
        return x10ERSTM._addRowScnColumn;
    }

    static /* synthetic */ List access$2600(X10ERSTM x10ERSTM) {
        return x10ERSTM._log;
    }

    static /* synthetic */ List access$2700(X10ERSTM x10ERSTM) {
        return x10ERSTM._log;
    }

    public class X10DataTabGridUpdater
    implements IRaptorGridUpdater {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            int n = 0;
            for (RaptorGridRowModel raptorGridRowModel : list) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                if (raptorGridRowModel.isNew()) continue;
                StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
                String string2 = X10ERSTM.this._schemaName + "." + X10ERSTM.this._tablename;
                stringBuffer.append(string2 + " WHERE ROWID = ");
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
                stringBuffer.append("?");
                stringBuffer2.append(X10ERSTM.this.quote(X10ERSTM.this.getRowId(raptorGridRowModel)));
                X10ERSTM.this._log.add(stringBuffer2.toString());
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = X10ERSTM.this.getConnection().prepareStatement(stringBuffer.toString());
                    preparedStatement.setString(1, X10ERSTM.this.getRowId(raptorGridRowModel));
                    int n2 = preparedStatement.executeUpdate();
                    if (n2 == 1 || n2 != 0) continue;
                    raptorGridRowModel.setError(ConnectionArb.getString((String)"EDITRSM_DELETE_ERR") + System.getProperty("line.separator"));
                    ++n;
                }
                catch (SQLException sQLException) {
                    X10ERSTM.this._log.add(sQLException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    raptorGridRowModel.setError(exception.getLocalizedMessage());
                    ++n;
                }
                finally {
                    try {
                        if (preparedStatement == null) continue;
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return n;
        }

        public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
            return null;
        }

        /*
         * Exception decompiling
         */
        public int insertRows(String var1_1, List<RaptorGridRowModel> var2_2, IRaptorTaskProgressUpdater var3_3, List<String> var4_4) throws SQLException, DBException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            int n = 0;
            for (RaptorGridRowModel raptorGridRowModel : list) {
                Object object;
                int n2;
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                StringBuffer stringBuffer = new StringBuffer("UPDATE ");
                ArrayList<ResultSetGridCell> arrayList = new ArrayList<ResultSetGridCell>();
                String string2 = X10ERSTM.this._schemaName + "." + X10ERSTM.this._tablename;
                stringBuffer.append(string2 + " SET ");
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
                boolean bl = true;
                String string3 = null;
                ResultSetMetaData resultSetMetaData = X10ERSTM.this._rs.getMetaData();
                int n3 = X10ERSTM.this.getGridColumns().size();
                int n4 = n3 - (X10ERSTM.this._addRowIdColumn ? 1 : 0) - (X10ERSTM.this._addRowScnColumn ? 1 : 0);
                int n5 = -1;
                for (n2 = 0; n2 < n3; ++n2) {
                    string3 = X10ERSTM.this.getColumnName(n2);
                    if (X10ERSTM.this.DATA_INTEGRITY_COLS.contains(string3)) continue;
                    ResultSetGridCell resultSetGridCell = (ResultSetGridCell)raptorGridRowModel.getRow().get(n2);
                    object = resultSetGridCell.getCellData();
                    String string4 = resultSetGridCell.getDisplayValue(Integer.MAX_VALUE);
                    boolean bl2 = resultSetGridCell.isUpdated();
                    n5 = X10ERSTM.this.getColumnSqlType(n2);
                    if (object == null || object instanceof ExtendedType && n5 != -2 && n5 != -3 && n5 != 2004 || !bl2) continue;
                    arrayList.add(resultSetGridCell);
                    if (!bl) {
                        stringBuffer.append(", ");
                        stringBuffer2.append(", ");
                    } else {
                        bl = false;
                    }
                    string3 = DBUtil.getInstance((Connection)X10ERSTM.this.getConnection()).addDbQuotes(string3, false);
                    stringBuffer.append(string3 + " = ?");
                    stringBuffer2.append(string3 + " = " + X10ERSTM.this.quote(string4.length() == 0 ? null : string4));
                }
                stringBuffer.append(" WHERE ROWID = ?");
                stringBuffer2.append(" WHERE ROWID = " + X10ERSTM.this.quote(X10ERSTM.this.getRowId(raptorGridRowModel)));
                X10ERSTM.this._log.add(stringBuffer2.toString());
                PreparedStatement preparedStatement = null;
                try {
                    int n6;
                    ResultSetGridCell resultSetGridCell2;
                    preparedStatement = X10ERSTM.this.getConnection().prepareStatement(stringBuffer.toString());
                    int n7 = 1;
                    int n8 = 0;
                    for (ResultSetGridCell resultSetGridCell2 : arrayList) {
                        Object object2 = resultSetGridCell2.getCellData();
                        ResultSetGridColumn resultSetGridColumn = X10ERSTM.this.getGridColumnForCell((RaptorGridCell)resultSetGridCell2);
                        if (object2 == null || resultSetGridColumn == null) continue;
                        String string5 = "unknown";
                        string5 = resultSetGridColumn.getSqlTypeName();
                        int n9 = resultSetGridColumn.getSqlType();
                        try {
                            if (string5 == null) {
                                string5 = "unknown";
                            }
                        }
                        catch (Exception exception) {
                            string5 = "unknown";
                        }
                        if (string5.equals("DATE") || string5.equals("TIMESTAMP")) {
                            if (object2.toString().length() == 0) {
                                preparedStatement.setNull(n7, n9);
                            } else {
                                preparedStatement.setString(n7, object2.toString());
                            }
                        } else if (object2 != null && (string5.equals("BINARY_FLOAT") || string5.equals("NUMBER")) && object2.toString().toLowerCase().endsWith("f")) {
                            preparedStatement.setFloat(n7, Float.parseFloat(object2.toString()));
                        } else if (string5.equals("CLOB")) {
                            preparedStatement.setString(n7, object2.toString());
                        } else if (object2.toString().length() == 0) {
                            preparedStatement.setNull(n7, n9);
                        } else if (n9 == -2 || n9 == -3 || n9 == 2004) {
                            InputStream inputStream = ((ExtendedType)object2).getBinaryStream();
                            preparedStatement.setBinaryStream(n7, inputStream, inputStream.available());
                        } else {
                            preparedStatement.setString(n7, object2.toString());
                        }
                        ++n7;
                        ++n8;
                    }
                    preparedStatement.setString(n7, X10ERSTM.this.getRowId(raptorGridRowModel));
                    ++n7;
                    if (arrayList.size() > 0) {
                        n6 = preparedStatement.executeUpdate();
                        if (n6 == 1) {
                            for (n2 = 0; n2 < n3; ++n2) {
                                string3 = X10ERSTM.this.getColumnName(n2);
                                if (X10ERSTM.this.DATA_INTEGRITY_COLS.contains(string3)) continue;
                                object = ((RaptorGridCell)raptorGridRowModel.getRow().get(n2)).getCellData();
                                n5 = X10ERSTM.this.getColumnSqlType(n2);
                                if (n5 == -2 || n5 == -3 || n5 == 2004 || object == null || !(object instanceof ExtendedType) || (resultSetGridCell2 = (ExtendedType)object).saveToDb(X10ERSTM.this.getConnection(), string2, X10ERSTM.this.getColumnName(n2), X10ERSTM.this.getRowId(raptorGridRowModel), X10ERSTM.this.getRowScn(raptorGridRowModel), X10ERSTM.this._addRowScnColumn, X10ERSTM.this._log)) continue;
                                ++n;
                            }
                            continue;
                        }
                        if (n6 != 0) continue;
                        raptorGridRowModel.setError(ConnectionArb.getString((String)"EDITRSM_UPDATE_ERR") + System.getProperty("line.separator"));
                        ++n;
                        continue;
                    }
                    n6 = 0;
                    for (n2 = 0; n2 < n3; ++n2) {
                        string3 = X10ERSTM.this.getColumnName(n2);
                        if (X10ERSTM.this.DATA_INTEGRITY_COLS.contains(string3)) continue;
                        object = ((RaptorGridCell)raptorGridRowModel.getRow().get(n2)).getCellData();
                        n5 = X10ERSTM.this.getColumnSqlType(n2);
                        if (n5 == -2 || n5 == -3 || n5 == 2004 || object == null || !(object instanceof ExtendedType)) continue;
                        resultSetGridCell2 = (ExtendedType)object;
                        n6 = resultSetGridCell2.saveToDb(X10ERSTM.this.getConnection(), string2, X10ERSTM.this.getColumnName(n2), X10ERSTM.this.getRowId(raptorGridRowModel), X10ERSTM.this.getRowScn(raptorGridRowModel), X10ERSTM.this._addRowScnColumn, X10ERSTM.this._log) ? 1 : 0;
                    }
                    if (n6 != 0) continue;
                    ++n;
                }
                catch (NumberFormatException numberFormatException) {
                    raptorGridRowModel.setError(MessageFormat.format(ConnectionArb.getString((String)"EDITRSM_FORMAT_ERR"), X10ERSTM.this.getColumnName(n2 + 1)));
                    ++n;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    raptorGridRowModel.setError(MessageFormat.format(ConnectionArb.getString((String)"EDITRSM_FORMAT_ERR"), X10ERSTM.this.getColumnName(n2 + 1)));
                    ++n;
                }
                catch (SQLException sQLException) {
                    X10ERSTM.this._log.add(sQLException.getLocalizedMessage());
                    raptorGridRowModel.setError(sQLException.getLocalizedMessage());
                    ++n;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    ++n;
                }
                finally {
                    try {
                        if (preparedStatement == null) continue;
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return n;
        }

        public void setGridInfo(EditableGridInfo editableGridInfo) {
        }
    }

    private class ResultSetInvalidEvent
    extends ChangeEvent {
        public ResultSetInvalidEvent(Object object) {
            super(object);
        }
    }
}

