/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.jdbc.DMDBuilder;

public class TTIndexBuilder
extends DMDBuilder {
    private static final Logger theLogger = Logger.getLogger(TTIndexBuilder.class.getPackage().getName());
    private static final String theParentSQL = "SELECT T.TBLNAME, T.TBLOWNER, T.TBLID FROM SYS.TABLES T, SYS.INDEXES I WHERE I.IXNAME=? AND I.IXOWNER=? AND I.ISPRIMARY=0x00 AND T.TBLID=I.TBLID";
    private static final String theIndexSQL = "SELECT I.IXNAME, I.IXOWNER, I.IXID FROM SYS.TABLES T, SYS.INDEXES I WHERE T.TBLNAME=? AND T.TBLOWNER=? AND I.ISPRIMARY=0x00 AND T.TBLID=I.TBLID";
    private Connections theConnections = Connections.getInstance();
    private long theParentTblId;

    public TTIndexBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string, "INDEX");
    }

    public Index createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Index index = new Index(string, schema);
        index.setID(dBObjectID);
        return index;
    }

    protected void fillInObject(AbstractBuildableObject abstractBuildableObject) throws DBException {
        assert (abstractBuildableObject.getType().equals("INDEX"));
    }

    private SchemaObject getParent(Index index) throws DBException {
        Connection connection = null;
        String string = null;
        String string2 = null;
        ResultSetWrapper resultSetWrapper = null;
        SchemaObject schemaObject = null;
        try {
            connection = this.getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
            this.theConnections.lock(connection);
            ArrayList<String> arrayList = new ArrayList<String>(2);
            arrayList.add(index.getName());
            arrayList.add(index.getSchema().getName());
            resultSetWrapper = dBUtil.executeQuery(theParentSQL, arrayList);
            ResultSet resultSet = resultSetWrapper.getResultSet();
            if (resultSet.next()) {
                string2 = resultSet.getString(1).trim();
                string = resultSet.getString(2).trim();
                this.theParentTblId = resultSet.getLong(3);
                JdbcDatabase jdbcDatabase = this.getDatabase();
                Schema schema = this.getSchema(string);
                if (schema != null && (schemaObject = jdbcDatabase.getObject("TABLE", schema, string2)) == null) {
                    schemaObject = jdbcDatabase.getObject("MATERIALIZED VIEW", schema, string2);
                }
                if (schemaObject == null) {
                    throw new DBException((DBObject)index, "Cannot find parent table for index " + index.getSchema().getName() + "." + index.getName());
                }
                SchemaObject schemaObject2 = schemaObject;
                return schemaObject2;
            }
            SchemaObject schemaObject3 = null;
            return schemaObject3;
        }
        catch (Exception exception) {
            throw new DBException((Throwable)exception);
        }
        finally {
            try {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
            }
            catch (Exception exception) {}
            this.theConnections.unlock(connection);
        }
    }

    void fillInIndexes(SchemaObject schemaObject) throws DBException {
        if (!(schemaObject instanceof Table)) {
            return;
        }
        Table table = (Table)schemaObject;
        String string = schemaObject.getName();
        String string2 = schemaObject.getSchema().getName();
        Connection connection = null;
        ResultSetWrapper resultSetWrapper = null;
        try {
            connection = this.getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            this.theConnections.lock(connection);
            ArrayList<String> arrayList = new ArrayList<String>(2);
            arrayList.add(string);
            arrayList.add(string2);
            resultSetWrapper = dBUtil.executeQuery(theIndexSQL, arrayList);
            ResultSet resultSet = resultSetWrapper.getResultSet();
            TimesTenPlugInDatabaseImpl timesTenPlugInDatabaseImpl = (TimesTenPlugInDatabaseImpl)this.getDatabase();
            int n = 0;
            while (resultSet.next()) {
                String string3 = resultSet.getString(1).trim();
                String string4 = resultSet.getString(2).trim();
                Schema schema = this.getSchema(string4);
                Index index = (Index)timesTenPlugInDatabaseImpl.findObject("INDEX", schema, string3);
                if (index == null) {
                    index = (Index)timesTenPlugInDatabaseImpl.createSchemaObject(string4, string3, "INDEX");
                    timesTenPlugInDatabaseImpl.cacheObject((SystemObject)index, true);
                }
                if (index != null) {
                    this.registerObject((AbstractBuildableObject)index);
                }
                table.addIndex(index);
                ++n;
            }
            if (n == 0) {
                theLogger.log(Level.INFO, "No indexes to build for " + string2 + "." + string);
            }
        }
        catch (Exception exception) {
            throw new DBException((Throwable)exception);
        }
        finally {
            try {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
            }
            catch (Exception exception) {}
            this.theConnections.unlock(connection);
        }
    }
}

