/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.oviewer.table.GridDataEditor;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.X10ERSTM;
import oracle.ide.Ide;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.MessageDialog;

public class TTGridDataEditor
extends GridDataEditor {
    private ChangeListener theChangeListener = new ChangeListener(){
        EditableResultSetTableModel model;
        {
            this.model = TTGridDataEditor.this._grid.getGridModel();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            TTGridDataEditor.this.handleResultSetInvalidEvent();
        }
    };

    private void addResultSetInvalidEventHandler() {
        if (this._grid.getGridModel() instanceof X10ERSTM) {
            X10ERSTM x10ERSTM = (X10ERSTM)this._grid.getGridModel();
            x10ERSTM.addChangeListener(this.theChangeListener);
        }
    }

    private void removeResultSetInvalidEventHandler() {
        if (this._grid.getGridModel() instanceof X10ERSTM) {
            X10ERSTM x10ERSTM = (X10ERSTM)this._grid.getGridModel();
            x10ERSTM.removeChangeListener();
        }
    }

    public void open(boolean bl) {
        super.open(bl);
        this._grid.registerGridUpdater((IRaptorGridUpdater)new X10ERSTM.X10DataTabGridUpdater((X10ERSTM)this._grid.getGridModel()));
        this.addResultSetInvalidEventHandler();
    }

    public void handleResultSetInvalidEvent(boolean bl) {
        try {
            if (this._grid.isChanged()) {
                String string = this._grid.getGridModel().getTableName();
                String string2 = MessageFormat.format(IdeArb.getString((int)217), string);
                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)string, null);
                switch (n) {
                    case 1: {
                        this._grid.save();
                        return;
                    }
                    case -1: 
                    case 0: {
                        this._grid.rollback();
                        return;
                    }
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleResultSetInvalidEvent() {
        try {
            if (this._grid.isChanged()) {
                String string = this._grid.getGridModel().getTableName();
                String string2 = Messages.getString("TTDataGridEditor.invalidresultset.saveprompt");
                boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string2, (String)string, null);
                if (bl) {
                    this._grid.save();
                } else {
                    this._grid.rollback();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void cleanUp() {
        super.cleanUp();
        this.removeResultSetInvalidEventHandler();
    }

    protected void addDbObjectListener() {
    }
}

