/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.controls.grid.ERSTModelHook;
import oracle.dbtools.raptor.controls.grid.RSTModelHook;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.dialogs.SQLExceptionScrubber;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.navigator.AbstractThirdPartyAddin;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlSupport;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.plsql.PLSQLGrants;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.runner.PlSqlWrapperValidator;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.ObjectCheckWrapper;
import oracle.dbtools.raptor.timesten.TTDBEditorFactory;
import oracle.dbtools.raptor.timesten.TTDBUtil;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseFactory;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.X10ERSTM;
import oracle.dbtools.raptor.timesten.X10ResultSetTableModel;
import oracle.dbtools.raptor.timesten.commands.AutoCommit;
import oracle.dbtools.raptor.timesten.commands.BuiltInProcedure;
import oracle.dbtools.raptor.timesten.commands.Describe;
import oracle.dbtools.raptor.timesten.commands.DsSize;
import oracle.dbtools.raptor.timesten.commands.TTAutotraceTreeModel;
import oracle.dbtools.raptor.timesten.commands.TTVersion;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionCreator;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionListener;
import oracle.dbtools.raptor.timesten.controls.celleditor.popups.TTBLOBEditPanel;
import oracle.dbtools.raptor.timesten.controls.celleditor.popups.TTCLOBEditPanel;
import oracle.dbtools.raptor.timesten.controls.celleditor.popups.TTDateTimeEditPanel;
import oracle.dbtools.raptor.timesten.controls.celleditor.popups.TTVarBinaryEditPanel;
import oracle.dbtools.raptor.timesten.format.TimesTenLoaderFormatter;
import oracle.dbtools.raptor.timesten.plsql.PlSqlDDL;
import oracle.dbtools.raptor.timesten.plsql.PlSqlDependencies;
import oracle.dbtools.raptor.timesten.plsql.PlSqlDetails;
import oracle.dbtools.raptor.timesten.plsql.PlSqlReferences;
import oracle.dbtools.raptor.timesten.plsql.TTPlSqlWrapperValidator;
import oracle.dbtools.raptor.timesten.synonym.SynonymDDL;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.net.URLPath;
import oracle.ide.util.MenuSpec;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.property.Metadata;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class TTAddin
extends AbstractThirdPartyAddin {
    private static final Logger theLogger = Logger.getLogger(TTAddin.class.getPackage().getName());
    private static final String JDBC_JAR_REGEX = ".*ttjdbc[56]\\.jar!/$|.*classes1[45]\\.jar!/$";
    private final DBConfig theDbConfig = DBConfig.getInstance();
    public static final String[] TIMESTEN_DRIVERS = new String[]{"com.timesten.jdbc.TimesTenDriver", "com.timesten.jdbc.TimesTenClientDriver"};

    public void initialize() {
        super.initialize();
        DatabaseFactory.registerDatabaseCreator((DatabaseFactory.DatabaseCreator)TimesTenPlugInDatabaseFactory.getInstance());
        URL[] uRLArray = this.theDbConfig.getThirdPartyPath().getEntries();
        URL uRL = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!uRLArray[i].toString().matches(JDBC_JAR_REGEX)) continue;
            theLogger.log(Level.INFO, MessageFormat.format("Found a TimesTen JDBC driver in User Preferences ", uRLArray[i].toString()));
            uRL = uRLArray[i];
            break;
        }
        URLPath uRLPath = URLPath.newURLPathFromString((String)System.getenv("CLASSPATH"));
        URL[] uRLArray2 = uRLPath.getEntries();
        URL uRL2 = null;
        for (int i = 0; i < uRLArray2.length; ++i) {
            if (!uRLArray2[i].toString().matches(JDBC_JAR_REGEX)) continue;
            theLogger.log(Level.INFO, MessageFormat.format("Found a TimesTen JDBC driver ", uRLArray2[i].toString()));
            uRL2 = uRLArray2[i];
            break;
        }
        if (uRL2 == null && uRL == null) {
            return;
        }
        if (!(uRL2 == null || uRL != null && uRL.equals(uRL2))) {
            this.prependJdbcJar(uRL2, uRLArray);
        }
        ViewerAddin.registerPackage((String)"oracle.dbtools.raptor.timesten");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.raptor.timesten");
        CommandRegistry.addListener(BuiltInProcedure.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
        CommandRegistry.addListener(AutoCommit.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
        CommandRegistry.addListener(Describe.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_DESCRIBE);
        CommandRegistry.addListener(DsSize.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
        CommandRegistry.addListener(TTVersion.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
        FormatRegistry.registerFormater((IResultFormatter)new TimesTenLoaderFormatter());
        ObjectCheckWrapper.registerACLObject();
        DBEditorFactoryRegistry.registerDBEditorFactory(TimesTenPlugInDatabaseImpl.class, (DBEditorFactory)TTDBEditorFactory.getInstance());
        Connections.getInstance().addConnectionListener((ConnectionListener)new TimesTenConnectionListener());
        System.setProperty("oracle.dbtools.raptor.timesten.recoverFromClosedCursor", Boolean.toString(true));
        DatabaseProvider.registerConnectionCreator((String)"TimesTen", (ConnectionCreator)new TimesTenConnectionCreator());
        try {
            String[] stringArray = new String[]{"WorksheetSupportRegistry.ActionCommitSupported", "WorksheetSupportRegistry.ActionRollbackSupported"};
            WorksheetFeatures worksheetFeatures = new WorksheetFeatures(Arrays.asList(stringArray)){
                final Constructor<TTAutotraceTreeModel> ctor;
                {
                    this.ctor = TTAutotraceTreeModel.class.getDeclaredConstructor(AutotracePanel.class);
                }

                public Constructor<? extends AutotraceTreeModel> getAutotraceModelConstructor() {
                    return this.ctor;
                }
            };
            WorksheetFeatures.registerFeatures((String)"com.timesten.jdbc.TimesTenDriver", (WorksheetFeatures)worksheetFeatures);
            WorksheetFeatures.registerFeatures((String)"com.timesten.jdbc.TimesTenClientDriver", (WorksheetFeatures)worksheetFeatures);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        DDLRegistry.registerHandler((String)"TimesTen", (String)"FUNCTION", PlSqlDDL.class);
        DDLRegistry.registerHandler((String)"TimesTen", (String)"PROCEDURE", PlSqlDDL.class);
        DDLRegistry.registerHandler((String)"TimesTen", (String)"PACKAGE", PlSqlDDL.class);
        DDLRegistry.registerHandler((String)"TimesTen", (String)"PACKAGE_BODY", PlSqlDDL.class);
        DDLRegistry.registerHandler((String)"TimesTen", (String)"PACKAGE BODY", PlSqlDDL.class);
        DDLRegistry.registerHandler((String)"TimesTen", (String)"SYNONYM", SynonymDDL.class);
        PlSqlRunnerPanel.registerValidator((String)"TimesTen", (PlSqlWrapperValidator)new TTPlSqlWrapperValidator());
        PlSqlSupport.registerQueryFile((String)"TimesTen", (String)"/oracle/dbtools/raptor/timesten/plsql/compiler-source.xml");
        RSTModelHook.registerRSTModel((String)"com.timesten.jdbc.TimesTenDriver", X10ResultSetTableModel.class);
        RSTModelHook.registerRSTModel((String)"com.timesten.jdbc.TimesTenClientDriver", X10ResultSetTableModel.class);
        ERSTModelHook.registerERSTModel((String)"com.timesten.jdbc.TimesTenDriver", X10ERSTM.class);
        ERSTModelHook.registerERSTModel((String)"com.timesten.jdbc.TimesTenClientDriver", X10ERSTM.class);
        this.registerEditor(Messages.getString("TimesTen.ttaddin.grant"), PLSQLGrants.class, 11, 0.5f);
        this.registerEditor(Messages.getString("TimesTen.ttaddin.dependencies"), PlSqlDependencies.class, 11, 0.4f);
        this.registerEditor(Messages.getString("TimesTen.ttaddin.references"), PlSqlReferences.class, 11, 0.3f);
        this.registerEditor(Messages.getString("TimesTen.ttaddin.details"), PlSqlDetails.class, 11, 0.2f);
        ReportAddin.registerReportPackage((String)"oracle/dbtools/raptor/timesten/reports");
        for (String string : TIMESTEN_DRIVERS) {
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)2005, (PopupCellEditor)new TTCLOBEditPanel(), (String)"CLOB");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)12, (PopupCellEditor)new TTCLOBEditPanel(), (String)"VARCHAR2");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)1, (PopupCellEditor)new TTCLOBEditPanel(), (String)"CHAR");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)2011, (PopupCellEditor)new TTCLOBEditPanel(), (String)"NCLOB");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)-15, (PopupCellEditor)new TTCLOBEditPanel(), (String)"NCHAR");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)-9, (PopupCellEditor)new TTCLOBEditPanel(), (String)"NVARCHAR");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)-3, new TTVarBinaryEditPanel(), (String)"VARBINARY");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)-2, new TTVarBinaryEditPanel(), (String)"BINARY");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)91, (PopupCellEditor)new TTDateTimeEditPanel(), (String)"DATE");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)93, (PopupCellEditor)new TTDateTimeEditPanel(), (String)"TIMESTAMP");
            PopupCellEditorFactory.registerPopupEditor((String)string, (int)2004, (PopupCellEditor)new TTBLOBEditPanel(), (String)"BLOB");
        }
        SQLErrorDialog.registerScrubber((SQLExceptionScrubber)TTSQLExceptionScrubber.getInstance());
        Metadata.getInstance().registerProperty("inline", Boolean.class, TimesTenPlugInDatabaseImpl.class, new Class[]{DBObject.class});
    }

    private void prependJdbcJar(URL uRL, URL[] uRLArray) {
        URLPath uRLPath = new URLPath(uRL);
        for (int i = 0; i < uRLArray.length; ++i) {
            if (uRLArray[i].equals(uRL)) {
                theLogger.log(Level.WARNING, "Removing duplicate entry ", new Object[]{uRLArray[i].toString()} + " in CLASSPATH");
                continue;
            }
            uRLPath.add(uRLArray[i]);
        }
        this.theDbConfig.setThirdPartyPath(uRLPath);
        theLogger.log(Level.INFO, MessageFormat.format(Messages.getString("TTAddin.PrependingToUserPrefrences"), uRL.toString()));
    }

    public String getSubType() {
        return "TimesTen";
    }

    private void registerEditor(final String string, final Class<?> clazz, final int n, final float f) {
        EditorAddin editorAddin = new EditorAddin(){

            public Class getEditorClass() {
                return clazz;
            }

            public MenuSpec getMenuSpecification() {
                return new MenuSpec(string, null);
            }

            public float getEditorWeight(Element element) {
                if (element instanceof PlSqlNode) {
                    PlSqlNode plSqlNode = (PlSqlNode)element;
                    String string2 = plSqlNode.getConnectionName();
                    if (Connections.getInstance().isTimesTen(string2)) {
                        try {
                            Connection connection = Connections.getInstance().getConnection(string2);
                            if (connection.getMetaData().getDatabaseMajorVersion() >= n) {
                                return f;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return Float.NaN;
            }
        };
        EditorManager.getEditorManager().registerDynamic(editorAddin);
    }

    static {
        try {
            DBUtil.registerUtilForType((String)"TimesTen", TTDBUtil.class.getDeclaredConstructor(String.class, Connection.class));
            System.out.println("Registered TimesTen");
        }
        catch (Throwable throwable) {
            System.out.println("FAILED to register");
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Logger.getLogger("TTAddin").severe(throwable.getLocalizedMessage());
        }
    }
}

