/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;

public final class AgingInfo {
    public static final String ROOT_TABLE = "ROOT_TABLE";
    public static final String LIFETIME = "LIFETIME";
    public static final String CYCLE = "CYCLE";
    public static final String TIMESTAMP_COLUMN = "TIMESTAMP COLUMN";
    public static final String ALL_TIMESTAMP_COLS = "ALL TIMESTAMP COLS";
    public static final String STATEv = "STATEv";
    public static final String DETAILS = "DETAILS";
    public static final String TYPE = "TYPE";
    public static final String STATE = "STATE";
    public static final String LIFETIME_UNIT = "LIFETIME UNIT";
    public static final String CYCLE_UNIT = "CYCLE UNIT";
    static final String sep = "#";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<String, String> getAgingInfo(DBObject dBObject) throws Exception {
        Statement statement = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        Connection connection = dBObject.getConnection();
        statement = connection.createStatement();
        String[] stringArray = AgingInfo.getRootTable(connection, string, string2);
        if (stringArray != null) {
            hashtable.put(ROOT_TABLE, stringArray[1]);
        } else {
            stringArray = new String[]{string, string2};
        }
        try {
            String[] stringArray2 = AgingInfo.getTimestampDateCols(connection, stringArray[0], stringArray[1]);
            for (int i = 0; i < stringArray2.length && stringArray2[i] != null; ++i) {
                hashtable.put(ALL_TIMESTAMP_COLS + i, stringArray2[i]);
            }
            String string3 = "select T.SYS25, T.SYS47, T.SYS48, T.SYS49, T.SYS50, RTRIM(C.colname) FROM SYS.TABLES T, SYS.COLUMNS C where T.tblid = C.id AND (T.sys45 = C.colnum or T.sys45 = 0) AND rtrim(T.TBLOWNER) = ? AND rtrim(T.TBLNAME) = ?";
            PreparedStatement preparedStatement = TimesTenUtil.prepareStatement(connection, string3);
            preparedStatement.setString(1, stringArray[0]);
            preparedStatement.setString(2, stringArray[1]);
            ResultSet resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            if (bl) {
                int n = resultSet.getInt(1);
                if ((n & 0x800) != 0) {
                    hashtable.put(TYPE, Messages.getString("AgingInfo.usageBased"));
                    String string4 = AgingInfo.getState(resultSet);
                    hashtable.put(STATEv, string4);
                    hashtable.put(STATE, Messages.getString("AgingInfo." + string4));
                    AgingInfo.handleUsageBased(statement, hashtable);
                } else if ((n & 0x1000) != 0) {
                    hashtable.put(TYPE, Messages.getString("AgingInfo.timeBased"));
                    String string5 = AgingInfo.getState(resultSet);
                    hashtable.put(STATEv, string5);
                    hashtable.put(STATE, Messages.getString("AgingInfo." + string5));
                    AgingInfo.handleTimeBased(hashtable, resultSet);
                    if (CGCPanel.allowSecondsLevelTBAging(dBObject)) {
                        AgingInfo.fixupTimeBasedSeconds(dBObject, stringArray[0], stringArray[1], hashtable);
                    }
                    AgingInfo.handleTimeBasedDetails(hashtable);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger("AgingInfo").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixupTimeBasedSeconds(DBObject dBObject, String string, String string2, Hashtable<String, String> hashtable) {
        Connection connection = dBObject.getConnection();
        PreparedStatement preparedStatement = null;
        ArrayList arrayList = new ArrayList();
        try {
            int n;
            int n2;
            String string3 = "CALL ttAgingSecondAdjustmentGet(?,?)";
            preparedStatement = TimesTenUtil.prepareStatement(connection, string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            int n4 = 0;
            resultSet.next();
            n3 = resultSet.getInt(1);
            n4 = resultSet.getInt(2);
            resultSet.close();
            String string4 = AgingInfo.dayHourMinute(3);
            if (n3 > 0) {
                hashtable.put(LIFETIME_UNIT, string4);
                n2 = Integer.parseInt(hashtable.get(LIFETIME));
                n = n2 * 60 + n3 - 60;
                hashtable.put(LIFETIME, n + "");
            }
            if (n4 > 0) {
                hashtable.put(CYCLE_UNIT, string4);
                n2 = Integer.parseInt(hashtable.get(CYCLE));
                n = n2 * 60 + n4 - 60;
                hashtable.put(CYCLE, n + "");
            }
        }
        catch (Exception exception) {
            Logger.getLogger("AgingInfo").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String[] getTimestampDateCols(Connection connection, String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = "SELECT rtrim(C.COLNAME) FROM SYS.TABLES T, SYS.COLUMNS C WHERE T.TBLOWNER = ? AND T.TBLNAME = ?  AND T.TBLID = C.ID AND C.COLTYPE in (31,30,16,14) AND NOT C.COLOPTIONS & 0x04 = 0x04";
        PreparedStatement preparedStatement = TimesTenUtil.prepareStatement(connection, string3);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string4 = resultSet.getString(1);
            arrayList.add(string4.trim());
        }
        resultSet.close();
        return arrayList.toArray(new String[]{""});
    }

    public static String[] getLRUThreshold(DBObject dBObject) {
        String[] stringArray = SimpleQuery.nStringColQuery(dBObject, "CALL ttAgingLRUConfig()", 3);
        String[] stringArray2 = new String[]{"(unknown)", "(unknown)", "(unknown)"};
        try {
            Float f = Float.valueOf(Float.parseFloat(stringArray[1]) * 100.0f);
            Float f2 = Float.valueOf(Float.parseFloat(stringArray[0]) * 100.0f);
            stringArray2[0] = f.toString();
            stringArray2[1] = f2.toString();
            stringArray2[2] = stringArray[2].toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray2;
    }

    private static String[] getRootTable(Connection connection, String string, String string2) throws Exception {
        String string3 = "SELECT ROOT FROM SYS.CACHE_GROUP WHERE CGOWNER = ?  AND CGNAME = ?";
        PreparedStatement preparedStatement = TimesTenUtil.prepareStatement(connection, string3);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            return null;
        }
        long l = resultSet.getLong(1);
        if (resultSet.wasNull()) {
            resultSet.close();
            return null;
        }
        string3 = "SELECT TBLOWNER,TBLNAME FROM SYS.TABLES WHERE TBLID = ?";
        preparedStatement = TimesTenUtil.prepareStatement(connection, string3);
        preparedStatement.setLong(1, l);
        resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            return null;
        }
        String[] stringArray = new String[]{resultSet.getString(1).trim(), resultSet.getString(2).trim()};
        resultSet.close();
        return stringArray;
    }

    private static String getState(ResultSet resultSet) throws Exception {
        int n = resultSet.getInt(1);
        String string = "";
        if ((n & 0x1800) != 0) {
            string = (n & 0x4000) != 0 ? "on" : "off";
        }
        return string;
    }

    private static void handleUsageBased(Statement statement, Hashtable<String, String> hashtable) throws Exception {
        ResultSet resultSet = statement.executeQuery("CALL ttAgingLRUConfig()");
        if (resultSet.next()) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(Messages.getString("LRUConfigPanel.lowUsageThreshold"));
            stringBuffer.append(sep);
            stringBuffer.append(Float.toString(resultSet.getFloat(1)));
            stringBuffer.append(sep);
            stringBuffer.append(Messages.getString("LRUConfigPanel.highUsageThreshold"));
            stringBuffer.append(sep);
            stringBuffer.append(Float.toString(resultSet.getFloat(2)));
            stringBuffer.append(sep);
            stringBuffer.append(Messages.getString("LRUConfigPanel.updateFrequency"));
            stringBuffer.append(sep);
            stringBuffer.append(Integer.toString(resultSet.getInt(3)) + " " + Messages.getString("TimesTen.common.minutes"));
            stringBuffer.append(sep);
            hashtable.put(DETAILS, stringBuffer.toString());
        }
        resultSet.close();
    }

    private static void handleTimeBased(Hashtable<String, String> hashtable, ResultSet resultSet) throws Exception {
        String string = resultSet.getString(6);
        hashtable.put(TIMESTAMP_COLUMN, string);
        int n = resultSet.getInt(2);
        string = Integer.toString(n);
        n = resultSet.getInt(4);
        String string2 = AgingInfo.dayHourMinute(resultSet.getInt(4));
        hashtable.put(LIFETIME, string);
        hashtable.put(LIFETIME_UNIT, string2);
        string = Integer.toString(resultSet.getInt(3));
        string2 = AgingInfo.dayHourMinute(resultSet.getInt(5));
        hashtable.put(CYCLE, string);
        hashtable.put(CYCLE_UNIT, string2);
    }

    private static void handleTimeBasedDetails(Hashtable<String, String> hashtable) {
        String string = hashtable.get(TIMESTAMP_COLUMN);
        String string2 = hashtable.get(LIFETIME);
        String string3 = hashtable.get(LIFETIME_UNIT);
        String string4 = hashtable.get(CYCLE);
        String string5 = hashtable.get(CYCLE_UNIT);
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(Messages.getString("ReplicationSubscriberDetails.timestampColumn"));
        stringBuffer.append(sep);
        stringBuffer.append(string);
        stringBuffer.append(sep);
        stringBuffer.append(Messages.getString("AgingInfo.lifeTime"));
        stringBuffer.append(sep);
        stringBuffer.append(string2 + " " + string3);
        stringBuffer.append(sep);
        stringBuffer.append(Messages.getString("AgingInfo.cycle"));
        stringBuffer.append(sep);
        stringBuffer.append(string4 + " " + string5);
        stringBuffer.append(sep);
        hashtable.put(DETAILS, stringBuffer.toString());
    }

    private static String dayHourMinute(int n) {
        if (n == 0) {
            return Messages.getString("TimesTen.common.days");
        }
        if (n == 1) {
            return Messages.getString("TimesTen.common.hours");
        }
        if (n == 2) {
            return Messages.getString("TimesTen.common.minutes");
        }
        if (n == 3) {
            return Messages.getString("TimesTen.common.seconds");
        }
        return "";
    }
}

