/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.servlet;

import ilog.views.util.servlet.IlvDefaultPopupMenuEncoder;
import ilog.views.util.servlet.IlvMenuFactory;
import ilog.views.util.servlet.IlvPopupMenuEncoder;
import ilog.views.util.servlet.internal.IlvPopupMenuUtil;
import ilog.views.util.servlet.model.IlvMenu;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class IlvPopupMenuServletSupport {
    public static final String SERVLET_ACTION_NAME = "popupmenuclicked";
    public static final String REQUEST_TYPE = "popupmenurequested";
    private ServletContext a = null;
    private IlvMenuFactory b;
    public static final String MENU_SESSION_KEY = "ilog.views.util.servlet.RootMenu";

    public abstract void installListeners();

    public abstract void removeListeners();

    public boolean handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getParameter("request");
        if (string == null || !string.equals(REQUEST_TYPE)) {
            return false;
        }
        Point point = IlvPopupMenuUtil.readPointFromRequest(httpServletRequest);
        IlvMenuFactory ilvMenuFactory = this.getMenuFactory(httpServletRequest);
        if (ilvMenuFactory == null) {
            throw new ServletException("There's no popup menu factory defined.");
        }
        String string2 = this.getMenuModelId(httpServletRequest);
        Object object = this.getGraphicComponent(httpServletRequest);
        if (object == null) {
            throw new ServletException((Throwable)new NullPointerException());
        }
        this.prepareComponent(httpServletRequest, object);
        Object object2 = this.getSelectedObject(httpServletRequest, point.x, point.y);
        IlvMenu ilvMenu = this.createMenu(httpServletRequest, ilvMenuFactory, object, object2, string2);
        this.savePopupMenuModelInSession(httpServletRequest, ilvMenu);
        httpServletResponse.setContentType("text/javascript");
        httpServletResponse.setHeader("pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.println("{ 'left':" + point.x + ",");
        servletOutputStream.println("'top':" + point.y + ",");
        servletOutputStream.print("'menu': ");
        PrintWriter printWriter = new PrintWriter((OutputStream)servletOutputStream);
        IlvPopupMenuEncoder ilvPopupMenuEncoder = this.getMenuEncoder(httpServletRequest);
        ilvPopupMenuEncoder.writeMenu(ilvMenu, printWriter);
        servletOutputStream.println("}");
        return true;
    }

    protected void prepareComponent(HttpServletRequest httpServletRequest, Object object) throws ServletException {
    }

    protected IlvMenu createMenu(HttpServletRequest httpServletRequest, IlvMenuFactory ilvMenuFactory, Object object, Object object2, String string) throws ServletException {
        return this.createMenu(ilvMenuFactory, object, object2, string);
    }

    protected IlvMenu createMenu(IlvMenuFactory ilvMenuFactory, Object object, Object object2, String string) throws ServletException {
        return ilvMenuFactory.createMenu(object, object2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePopupMenuModelInSession(HttpServletRequest httpServletRequest, IlvMenu ilvMenu) {
        HttpSession httpSession;
        HttpSession httpSession2 = httpSession = httpServletRequest.getSession();
        synchronized (httpSession2) {
            httpSession.setAttribute(MENU_SESSION_KEY, (Object)ilvMenu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlvMenu getPopupMenuFromSession(HttpServletRequest httpServletRequest) {
        HttpSession httpSession;
        HttpSession httpSession2 = httpSession = httpServletRequest.getSession();
        synchronized (httpSession2) {
            return (IlvMenu)httpSession.getAttribute(MENU_SESSION_KEY);
        }
    }

    protected abstract Object getGraphicComponent(HttpServletRequest var1) throws ServletException;

    protected abstract Object getSelectedObject(HttpServletRequest var1, int var2, int var3) throws ServletException;

    protected IlvMenuFactory getMenuFactory(HttpServletRequest httpServletRequest) throws ServletException {
        return this.b;
    }

    public void setMenuFactory(IlvMenuFactory ilvMenuFactory) {
        this.b = ilvMenuFactory;
    }

    protected abstract String getMenuModelId(HttpServletRequest var1) throws ServletException;

    protected IlvPopupMenuEncoder getMenuEncoder(HttpServletRequest httpServletRequest) throws ServletException {
        return new IlvDefaultPopupMenuEncoder();
    }

    public ServletContext getServletContext() {
        return this.a;
    }

    public void setServletContext(ServletContext servletContext) {
        this.a = servletContext;
    }
}

