/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d.internal;

import ilog.views.util.java2d.internal.IlvGradientUtil;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.lang.ref.WeakReference;

public abstract class IlvMultipleGradientPaintContext
implements PaintContext {
    public static final short SPREAD_PAD = 1;
    public static final short SPREAD_REFLECT = 2;
    public static final short SPREAD_REPEAT = 3;
    protected ColorModel _model;
    private static final ColorModel a = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static final ColorModel b = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static final ColorModel c = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    private static final ColorModel d = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    protected static ColorModel _cachedModel;
    protected static WeakReference _cached;
    protected Raster _saved;
    protected short _spreadMethod;
    protected short _colorSpace;
    protected float _a00;
    protected float _a01;
    protected float _a10;
    protected float _a11;
    protected float _a02;
    protected float _a12;
    protected boolean _isSimpleLookup = true;
    protected int _fastGradientArraySize;
    protected int[] _gradient;
    private int[][] e;
    private int f;
    private int g;
    protected float[] _normalizedIntervals;
    protected float[] _fractions;
    private Color[] h;
    private int i;
    private static final int j = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int k = 5000;

    public IlvMultipleGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float[] fArray, Color[] colorArray, short s2, short s3) throws NoninvertibleTransformException {
        boolean bl = false;
        boolean bl2 = false;
        if (fArray[0] != 0.0f) {
            bl = true;
        }
        if (fArray[fArray.length - 1] != 1.0f) {
            bl2 = true;
        }
        if (bl && bl2) {
            this._fractions = new float[fArray.length + 2];
            System.arraycopy(fArray, 0, this._fractions, 1, fArray.length);
            this._fractions[0] = 0.0f;
            this._fractions[this._fractions.length - 1] = 1.0f;
            this.h = new Color[colorArray.length + 2];
            System.arraycopy(colorArray, 0, this.h, 1, colorArray.length);
            this.h[0] = colorArray[0];
            this.h[this.h.length - 1] = colorArray[colorArray.length - 1];
        } else if (bl) {
            this._fractions = new float[fArray.length + 1];
            System.arraycopy(fArray, 0, this._fractions, 1, fArray.length);
            this._fractions[0] = 0.0f;
            this.h = new Color[colorArray.length + 1];
            System.arraycopy(colorArray, 0, this.h, 1, colorArray.length);
            this.h[0] = colorArray[0];
        } else if (bl2) {
            this._fractions = new float[fArray.length + 1];
            System.arraycopy(fArray, 0, this._fractions, 0, fArray.length);
            this._fractions[this._fractions.length - 1] = 1.0f;
            this.h = new Color[colorArray.length + 1];
            System.arraycopy(colorArray, 0, this.h, 0, colorArray.length);
            this.h[this.h.length - 1] = colorArray[colorArray.length - 1];
        } else {
            this._fractions = new float[fArray.length];
            System.arraycopy(fArray, 0, this._fractions, 0, fArray.length);
            this.h = new Color[colorArray.length];
            System.arraycopy(colorArray, 0, this.h, 0, colorArray.length);
        }
        this._normalizedIntervals = new float[this._fractions.length - 1];
        float f2 = this._fractions[0];
        float f3 = 0.0f;
        for (int i2 = 1; i2 < this._fractions.length; ++i2) {
            f3 = f2;
            f2 = this._fractions[i2];
            this._normalizedIntervals[i2 - 1] = f2 - f3;
        }
        AffineTransform affineTransform2 = affineTransform.createInverse();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this._a00 = (float)dArray[0];
        this._a10 = (float)dArray[1];
        this._a01 = (float)dArray[2];
        this._a11 = (float)dArray[3];
        this._a02 = (float)dArray[4];
        this._a12 = (float)dArray[5];
        this._spreadMethod = s2;
        this._colorSpace = s3;
        if (colorModel.getColorSpace() == c.getColorSpace()) {
            this._model = c;
        } else if (colorModel.getColorSpace() == d.getColorSpace()) {
            this._model = d;
        } else {
            throw new IllegalArgumentException("Unsupported ColorSpace for interpolation");
        }
    }

    protected final void calculateGradientFractions() {
        int n2;
        int n3;
        if (this._colorSpace == 1) {
            for (n3 = 0; n3 < this.h.length; ++n3) {
                this.h[n3] = new Color(IlvGradientUtil.SRGBtoLinearRGB[this.h[n3].getRed()], IlvGradientUtil.SRGBtoLinearRGB[this.h[n3].getGreen()], IlvGradientUtil.SRGBtoLinearRGB[this.h[n3].getBlue()]);
            }
        }
        this.i = -16777216;
        this.e = new int[this._fractions.length - 1][];
        this.g = this.e.length;
        n3 = this._normalizedIntervals.length;
        float f2 = 1.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            float f3 = f2 = f2 > this._normalizedIntervals[n2] ? this._normalizedIntervals[n2] : f2;
            if (f2 == 0.0f) break;
        }
        n2 = 0;
        if (f2 != 0.0f) {
            for (int i2 = 0; i2 < this._normalizedIntervals.length; ++i2) {
                n2 = (int)((float)n2 + this._normalizedIntervals[i2] / f2 * 256.0f);
            }
        } else {
            n2 = Integer.MAX_VALUE;
        }
        if (n2 > 5000) {
            this.a();
        } else {
            this.a(f2);
        }
        if (this.i >>> 24 == 255) {
            if (this._model.getColorSpace() == a.getColorSpace()) {
                this._model = a;
            } else if (this._model.getColorSpace() == b.getColorSpace()) {
                this._model = b;
            }
        }
    }

    private void a(float f2) {
        int n2;
        int n3;
        this._isSimpleLookup = true;
        int n4 = 1;
        for (n3 = 0; n3 < this.e.length; ++n3) {
            n2 = (int)(this._normalizedIntervals[n3] / f2 * 255.0f);
            n4 += n2;
            this.e[n3] = new int[n2];
            int n5 = this.h[n3].getRGB();
            int n6 = this.h[n3 + 1].getRGB();
            IlvGradientUtil.interpolate(n5, n6, this.e[n3]);
            this.i &= n5;
            this.i &= n6;
        }
        this._gradient = new int[n4];
        n3 = 0;
        for (n2 = 0; n2 < this.e.length; ++n2) {
            System.arraycopy(this.e[n2], 0, this._gradient, n3, this.e[n2].length);
            n3 += this.e[n2].length;
        }
        this._gradient[this._gradient.length - 1] = this.h[this.h.length - 1].getRGB();
        if (this._colorSpace == 1) {
            if (this._model.getColorSpace() == ColorSpace.getInstance(1000)) {
                for (n2 = 0; n2 < this._gradient.length; ++n2) {
                    this._gradient[n2] = IlvGradientUtil.convertEntireColorLinearRGBtoSRGB(this._gradient[n2]);
                }
            }
        } else if (this._model.getColorSpace() == ColorSpace.getInstance(1004)) {
            for (n2 = 0; n2 < this._gradient.length; ++n2) {
                this._gradient[n2] = IlvGradientUtil.convertEntireColorSRGBtoLinearRGB(this._gradient[n2]);
            }
        }
        this._fastGradientArraySize = this._gradient.length - 1;
    }

    private void a() {
        int n2;
        this._isSimpleLookup = false;
        for (n2 = 0; n2 < this.e.length; ++n2) {
            this.e[n2] = new int[256];
            int n3 = this.h[n2].getRGB();
            int n4 = this.h[n2 + 1].getRGB();
            IlvGradientUtil.interpolate(n3, n4, this.e[n2]);
            this.i &= n3;
            this.i &= n4;
        }
        if (this._colorSpace == 1) {
            if (this._model.getColorSpace() == ColorSpace.getInstance(1000)) {
                for (n2 = 0; n2 < this.e.length; ++n2) {
                    for (int i2 = 0; i2 < this.e[n2].length; ++i2) {
                        this.e[n2][i2] = IlvGradientUtil.convertEntireColorLinearRGBtoSRGB(this.e[n2][i2]);
                    }
                }
            }
        } else if (this._model.getColorSpace() == ColorSpace.getInstance(1004)) {
            for (n2 = 0; n2 < this.e.length; ++n2) {
                for (int i3 = 0; i3 < this.e[n2].length; ++i3) {
                    this.e[n2][i3] = IlvGradientUtil.convertEntireColorSRGBtoLinearRGB(this.e[n2][i3]);
                }
            }
        }
        this.f = this.e[this.e.length - 1][255];
    }

    protected final int indexIntoGradientsArrays(float f2) {
        int n2;
        if (this._spreadMethod == 1) {
            if (f2 > 1.0f) {
                f2 = 1.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
        } else if (this._spreadMethod == 3) {
            if ((f2 -= (float)((int)f2)) > 1.0f || f2 < -1.0f) {
                f2 = 0.0f;
            } else if (f2 < 0.0f) {
                f2 += 1.0f;
            }
        } else {
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            if ((f2 -= (float)(n2 = (int)f2)) > 1.0f) {
                f2 = 0.0f;
            } else if ((n2 & 1) != 0) {
                f2 = 1.0f - f2;
            }
        }
        if (this._isSimpleLookup) {
            return this._gradient[(int)(f2 * (float)this._fastGradientArraySize)];
        }
        for (n2 = 0; n2 < this.g; ++n2) {
            if (!(f2 < this._fractions[n2 + 1])) continue;
            float f3 = f2 - this._fractions[n2];
            int n3 = (int)(f3 / this._normalizedIntervals[n2] * 255.0f);
            return this.e[n2][n3];
        }
        return this.f;
    }

    public final Raster getRaster(int n2, int n3, int n4, int n5) {
        Raster raster = this._saved;
        if (raster == null || raster.getWidth() < n4 || raster.getHeight() < n5) {
            this._saved = raster = IlvMultipleGradientPaintContext.getCachedRaster(this._model, n4, n5);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n6 = dataBufferInt.getOffset();
        int n7 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n8 = n7 - n4;
        this.fillRaster(nArray, n6, n8, n2, n3, n4, n5);
        return raster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final synchronized Raster getCachedRaster(ColorModel colorModel, int n2, int n3) {
        Raster raster;
        if (colorModel == _cachedModel && _cached != null && (raster = (Raster)_cached.get()) != null && raster.getWidth() >= n2 && raster.getHeight() >= n3) {
            _cached = null;
            return raster;
        }
        return colorModel.createCompatibleWritableRaster(n2, n3);
    }

    protected static final synchronized void putCachedRaster(ColorModel colorModel, Raster raster) {
        Raster raster2;
        if (_cached != null && (raster2 = (Raster)_cached.get()) != null) {
            int n2 = raster2.getWidth();
            int n3 = raster2.getHeight();
            int n4 = raster.getWidth();
            int n5 = raster.getHeight();
            if (n2 >= n4 && n3 >= n5) {
                return;
            }
            if (n2 * n3 >= n4 * n5) {
                return;
            }
        }
        _cachedModel = colorModel;
        _cached = new WeakReference<Raster>(raster);
    }

    public final void dispose() {
        if (this._saved != null) {
            IlvMultipleGradientPaintContext.putCachedRaster(this._model, this._saved);
            this._saved = null;
        }
    }

    public final ColorModel getColorModel() {
        return this._model;
    }
}

