/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import ilog.views.util.collections.internal.IlvArrayIterator;
import ilog.views.util.internal.IlvInternalError;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IlvHashTreeList<E>
extends AbstractList<E>
implements Cloneable,
RandomAccess {
    private static final boolean a = false;
    private static final boolean b = true;
    private transient Entry<E> c = null;
    private transient int d = 0;
    private transient HashMap<E, Object> e = new HashMap();
    private transient int f = 0;
    private static Comparator<Entry> g = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry, Entry entry2) {
            int n2;
            int n3 = IlvHashTreeList.b(entry);
            return n3 > (n2 = IlvHashTreeList.b(entry2)) ? 1 : (n3 < n2 ? -1 : 0);
        }
    };

    public IlvHashTreeList() {
    }

    public IlvHashTreeList(Collection<? extends E> collection) {
        this.a(collection.size(), collection.iterator());
    }

    public IlvHashTreeList(E[] EArray) {
        this.a(EArray.length, new IlvArrayIterator(EArray));
    }

    private static int b(Entry entry) {
        if (entry == null) {
            return -1;
        }
        int n2 = 0;
        if (entry.c != null) {
            n2 += entry.c.b;
        }
        Entry entry2;
        while ((entry2 = entry.e) != null) {
            if (entry2.d == entry) {
                ++n2;
                if (entry2.c != null) {
                    n2 += entry2.c.b;
                }
            }
            entry = entry2;
        }
        return n2;
    }

    private void a(E e2, Entry<E> entry) {
        Object object = this.e.get(entry.a);
        if (object == null) {
            this.e.put(e2, entry);
        } else if (object instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)object;
            treeSet.add(entry);
        } else if (object instanceof Entry) {
            TreeSet<Entry> treeSet = new TreeSet<Entry>(g);
            treeSet.add((Entry)object);
            treeSet.add(entry);
            this.e.put(e2, treeSet);
        } else {
            throw new IlvInternalError("IlvHashTreeList inconsistency");
        }
    }

    private void b(E e2, Entry<E> entry) {
        Object object = this.e.get(entry.a);
        if (object instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)object;
            treeSet.remove(entry);
            if (treeSet.size() == 1) {
                this.e.put(entry.a, treeSet.first());
            }
        } else if (object == entry) {
            this.e.remove(entry.a);
        } else {
            throw new IlvInternalError("IlvHashTreeList inconsistency - did the hash code of an element change?");
        }
    }

    private Entry<E> a(Object object) {
        Object object2 = this.e.get(object);
        if (object2 instanceof TreeSet) {
            object2 = ((TreeSet)object2).first();
        }
        return (Entry)object2;
    }

    private Entry<E> b(Object object) {
        Object object2 = this.e.get(object);
        if (object2 instanceof TreeSet) {
            object2 = ((TreeSet)object2).last();
        }
        return (Entry)object2;
    }

    private Entry<E> a(int n2) {
        Entry<Object> entry = this.c;
        if (entry == null || entry.b <= n2) {
            throw new IndexOutOfBoundsException();
        }
        while (true) {
            if (entry.c != null) {
                if (entry.c.b > n2) {
                    entry = entry.c;
                    continue;
                }
                n2 -= entry.c.b;
            }
            if (n2 == 0) {
                return entry;
            }
            --n2;
            entry = entry.d;
        }
    }

    private Entry<E> a() {
        Entry<Object> entry = this.c;
        if (entry != null) {
            while (entry.c != null) {
                entry = entry.c;
            }
        }
        return entry;
    }

    private Entry<E> b() {
        Entry<Object> entry = this.c;
        if (entry != null) {
            while (entry.d != null) {
                entry = entry.d;
            }
        }
        return entry;
    }

    public E getFirstElement() {
        Entry<Object> entry = this.c;
        if (entry == null) {
            throw new NoSuchElementException();
        }
        while (entry.c != null) {
            entry = entry.c;
        }
        return (E)entry.a;
    }

    public E getLastElement() {
        Entry<Object> entry = this.c;
        if (entry == null) {
            throw new NoSuchElementException();
        }
        while (entry.d != null) {
            entry = entry.d;
        }
        return (E)entry.a;
    }

    private Entry<E> c(Entry<E> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.d != null) {
            Entry entry2 = entry.d;
            while (entry2.c != null) {
                entry2 = entry2.c;
            }
            return entry2;
        }
        Entry entry3 = entry.e;
        Entry<Object> entry4 = entry;
        while (entry3 != null && entry4 == entry3.d) {
            entry4 = entry3;
            entry3 = entry3.e;
        }
        return entry3;
    }

    private Entry<E> d(Entry<E> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.c != null) {
            Entry entry2 = entry.c;
            while (entry2.d != null) {
                entry2 = entry2.d;
            }
            return entry2;
        }
        Entry entry3 = entry.e;
        Entry<Object> entry4 = entry;
        while (entry3 != null && entry4 == entry3.c) {
            entry4 = entry3;
            entry3 = entry3.e;
        }
        return entry3;
    }

    private void c() {
        ++this.f;
        ++this.d;
    }

    private void d() {
        ++this.f;
        --this.d;
    }

    private static <T> boolean e(Entry<T> entry) {
        return entry == null ? true : entry.f;
    }

    private static <T> Entry<T> f(Entry<T> entry) {
        return entry == null ? null : entry.e;
    }

    private static <T> void a(Entry<T> entry, boolean bl) {
        if (entry != null) {
            entry.f = bl;
        }
    }

    private static <T> Entry<T> g(Entry<T> entry) {
        return entry == null ? null : entry.c;
    }

    private static <T> Entry<T> h(Entry<T> entry) {
        return entry == null ? null : entry.d;
    }

    private static <T> int i(Entry<T> entry) {
        return entry == null ? 0 : entry.b;
    }

    private void j(Entry<E> entry) {
        Entry entry2 = entry.d;
        entry.d = entry2.c;
        if (entry2.c != null) {
            entry2.c.e = entry;
        }
        entry2.e = entry.e;
        if (entry.e == null) {
            this.c = entry2;
        } else if (entry.e.c == entry) {
            entry.e.c = entry2;
        } else {
            entry.e.d = entry2;
        }
        entry2.c = entry;
        entry.e = entry2;
        entry2.b = entry.b;
        entry.b = 1 + IlvHashTreeList.i(entry.c) + IlvHashTreeList.i(entry.d);
    }

    private void k(Entry<E> entry) {
        Entry entry2 = entry.c;
        entry.c = entry2.d;
        if (entry2.d != null) {
            entry2.d.e = entry;
        }
        entry2.e = entry.e;
        if (entry.e == null) {
            this.c = entry2;
        } else if (entry.e.d == entry) {
            entry.e.d = entry2;
        } else {
            entry.e.c = entry2;
        }
        entry2.d = entry;
        entry.e = entry2;
        entry2.b = entry.b;
        entry.b = 1 + IlvHashTreeList.i(entry.c) + IlvHashTreeList.i(entry.d);
    }

    private void l(Entry<E> entry) {
        entry.f = false;
        while (entry != null && entry != this.c && !entry.e.f) {
            Entry entry2;
            Entry entry3;
            Entry entry4 = entry.e;
            if (entry4 == IlvHashTreeList.g(entry4.e)) {
                entry3 = entry4.e.d;
                if (entry3 != null && !entry3.f) {
                    entry4.f = true;
                    entry3.f = true;
                    entry4.e.f = false;
                    entry = entry4.e;
                    continue;
                }
                if (entry == entry4.d) {
                    entry = entry4;
                    this.j(entry);
                    entry4 = entry.e;
                }
                entry4.f = true;
                entry2 = entry4.e;
                if (entry2 == null) continue;
                entry2.f = false;
                this.k(entry2);
                continue;
            }
            entry3 = IlvHashTreeList.g(entry4.e);
            if (entry3 != null && !entry3.f) {
                entry4.f = true;
                entry3.f = true;
                entry4.e.f = false;
                entry = entry4.e;
                continue;
            }
            if (entry == entry4.c) {
                entry = entry4;
                this.k(entry);
                entry4 = entry.e;
            }
            entry4.f = true;
            entry2 = entry4.e;
            if (entry2 == null) continue;
            entry2.f = false;
            this.j(entry2);
        }
        this.c.f = true;
    }

    private void m(Entry<E> entry) {
        while (entry != this.c && entry.f) {
            Entry entry2;
            Entry entry3 = entry.e;
            if (entry == entry3.c) {
                entry2 = entry3.d;
                if (entry2 != null && !entry2.f) {
                    entry2.f = true;
                    entry3.f = false;
                    this.j(entry3);
                    entry2 = entry3.d;
                }
                if (IlvHashTreeList.e(IlvHashTreeList.g(entry2)) && IlvHashTreeList.e(IlvHashTreeList.h(entry2))) {
                    IlvHashTreeList.a(entry2, false);
                    entry = entry3;
                    continue;
                }
                if (IlvHashTreeList.e(entry2.d)) {
                    IlvHashTreeList.a(entry2.c, true);
                    entry2.f = false;
                    this.k(entry2);
                    entry2 = entry3.d;
                }
                entry2.f = entry3.f;
                entry3.f = true;
                IlvHashTreeList.a(entry2.d, true);
                this.j(entry3);
                entry = this.c;
                continue;
            }
            entry2 = entry3.c;
            if (entry2 != null && !entry2.f) {
                entry2.f = true;
                entry3.f = false;
                this.k(entry3);
                entry2 = entry3.c;
            }
            if (IlvHashTreeList.e(IlvHashTreeList.h(entry2)) && IlvHashTreeList.e(IlvHashTreeList.g(entry2))) {
                IlvHashTreeList.a(entry2, false);
                entry = entry3;
                continue;
            }
            if (IlvHashTreeList.e(entry2.c)) {
                IlvHashTreeList.a(entry2.d, true);
                entry2.f = false;
                this.j(entry2);
                entry2 = entry3.c;
            }
            entry2.f = entry3.f;
            entry3.f = true;
            IlvHashTreeList.a(entry2.c, true);
            this.k(entry3);
            entry = this.c;
        }
        IlvHashTreeList.a(entry, true);
    }

    private void n(Entry<E> entry) {
        Entry entry2;
        Entry entry3;
        this.b(entry.a, entry);
        this.d();
        if (entry.c != null && entry.d != null) {
            entry3 = entry.d;
            while (entry3.c != null) {
                entry3 = entry3.c;
            }
            entry2 = entry.c;
            Entry entry4 = entry.d;
            Entry entry5 = entry.e;
            Entry entry6 = entry3.d;
            Entry entry7 = entry3.e;
            entry.c = null;
            entry.d = entry6;
            if (entry6 != null) {
                entry6.e = entry;
            }
            entry3.c = entry2;
            if (entry2 != null) {
                entry2.e = entry3;
            }
            if (entry7 == entry) {
                entry3.d = entry;
                entry.e = entry3;
            } else {
                entry3.d = entry4;
                entry4.e = entry3;
                entry7.c = entry;
                entry.e = entry7;
            }
            entry3.e = entry5;
            if (entry5 == null) {
                this.c = entry3;
            } else if (entry == entry5.c) {
                entry5.c = entry3;
            } else {
                entry5.d = entry3;
            }
            int n2 = entry.b;
            entry.b = entry3.b;
            entry3.b = n2;
            boolean bl = entry.f;
            entry.f = entry3.f;
            entry3.f = bl;
        }
        Entry entry8 = entry3 = entry.c != null ? entry.c : entry.d;
        if (entry3 != null) {
            entry3.e = entry.e;
            if (entry.e == null) {
                this.c = entry3;
            } else if (entry == entry.e.c) {
                entry.e.c = entry3;
            } else {
                entry.e.d = entry3;
            }
            entry.c = null;
            entry.d = null;
            entry.e = null;
            entry2 = entry3.e;
            while (entry2 != null) {
                --entry2.b;
                entry2 = entry2.e;
            }
            if (entry.f) {
                this.m(entry3);
            }
        } else if (entry.e == null) {
            this.c = null;
        } else {
            if (entry.f) {
                this.m(entry);
            }
            entry2 = entry.e;
            while (entry2 != null) {
                --entry2.b;
                entry2 = entry2.e;
            }
            if (entry.e != null) {
                if (entry == entry.e.c) {
                    entry.e.c = null;
                } else if (entry == entry.e.d) {
                    entry.e.d = null;
                }
                entry.e = null;
            }
        }
    }

    @Override
    public int size() {
        return this.d;
    }

    @Override
    public boolean contains(Object object) {
        return this.e.get(object) != null;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int a;
            private Entry<E> b;
            private Entry<E> c;
            {
                this.a = IlvHashTreeList.this.f;
                this.b = null;
                this.c = IlvHashTreeList.this.a();
            }

            @Override
            public boolean hasNext() {
                return this.c != null;
            }

            @Override
            public E next() {
                if (this.c == null) {
                    throw new NoSuchElementException();
                }
                if (IlvHashTreeList.this.f != this.a) {
                    throw new ConcurrentModificationException();
                }
                this.b = this.c;
                this.c = IlvHashTreeList.this.c(this.c);
                return this.b.a;
            }

            @Override
            public void remove() {
                if (this.b == null) {
                    throw new IllegalStateException();
                }
                if (IlvHashTreeList.this.f != this.a) {
                    throw new ConcurrentModificationException();
                }
                IlvHashTreeList.this.n(this.b);
                ++this.a;
                this.b = null;
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        Entry<E> entry = this.a(object);
        if (entry != null) {
            this.n(entry);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.f;
        this.d = 0;
        this.c = null;
        this.e.clear();
    }

    @Override
    public E get(int n2) {
        Entry<E> entry = this.a(n2);
        return (E)entry.a;
    }

    private E a(Entry<E> entry, E e2) {
        Object t2 = entry.a;
        if (e2 != t2) {
            this.b(t2, entry);
            entry.a = e2;
            this.a(e2, entry);
        }
        return (E)t2;
    }

    @Override
    public E set(int n2, E e2) {
        Entry<E> entry = this.a(n2);
        return this.a(entry, e2);
    }

    @Override
    public void add(int n2, E e2) {
        Entry<E> entry;
        if (n2 < 0 || n2 > this.d) {
            throw new IndexOutOfBoundsException();
        }
        Entry<Object> entry2 = this.c;
        if (entry2 == null) {
            this.c();
            entry = new Entry<E>(e2, null);
            this.c = entry;
        } else {
            while (true) {
                int n3;
                int n4 = n3 = entry2.c != null ? entry2.c.b : 0;
                if (n2 <= n3) {
                    if (entry2.c == null) {
                        this.c();
                        entry = new Entry<E>(e2, entry2);
                        entry2.c = entry;
                        Entry<Object> entry3 = entry2;
                        while (entry3 != null) {
                            ++entry3.b;
                            entry3 = entry3.e;
                        }
                        this.l(entry2.c);
                        break;
                    }
                    entry2 = entry2.c;
                    continue;
                }
                if (entry2.d == null) {
                    this.c();
                    entry = new Entry<E>(e2, entry2);
                    entry2.d = entry;
                    Entry<Object> entry4 = entry2;
                    while (entry4 != null) {
                        ++entry4.b;
                        entry4 = entry4.e;
                    }
                    this.l(entry2.d);
                    break;
                }
                n2 -= n3;
                --n2;
                entry2 = entry2.d;
            }
        }
        this.a(e2, entry);
    }

    @Override
    public E remove(int n2) {
        Entry<E> entry = this.a(n2);
        Object t2 = entry.a;
        this.n(entry);
        return (E)t2;
    }

    @Override
    public int indexOf(Object object) {
        return IlvHashTreeList.b(this.a(object));
    }

    @Override
    public int lastIndexOf(Object object) {
        return IlvHashTreeList.b(this.b(object));
    }

    @Override
    public ListIterator<E> listIterator() {
        return new MyListIterator(0, this.a(), null);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        Entry<E> entry;
        Entry<E> entry2;
        if (n2 == 0) {
            entry2 = this.a();
            entry = null;
        } else if (n2 == this.d) {
            entry2 = null;
            entry = this.b();
        } else {
            entry2 = this.a(n2);
            entry = this.d(entry2);
        }
        return new MyListIterator(n2, entry2, entry);
    }

    private static int b(int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            ++n3;
            n4 = (n4 >> 1) - 1;
        }
        return n3;
    }

    private void a(int n2, Iterator<? extends E> iterator) {
        this.d = n2;
        this.c = this.a(0, 0, n2 - 1, IlvHashTreeList.b(n2), iterator);
        Entry<E> entry = this.a();
        while (entry != null) {
            this.a(entry.a, entry);
            entry = this.c(entry);
        }
    }

    private Entry<E> a(int n2, int n3, int n4, int n5, Iterator<? extends E> iterator) {
        if (n4 < n3) {
            return null;
        }
        int n6 = n3 + n4 >> 1;
        Entry<? extends E> entry = null;
        if (n3 < n6) {
            entry = this.a(n2 + 1, n3, n6 - 1, n5, iterator);
        }
        E e2 = iterator.next();
        Entry<E> entry2 = new Entry<E>(e2, null);
        if (n2 == n5) {
            entry2.f = false;
        }
        if (entry != null) {
            entry2.c = entry;
            entry.e = entry2;
            entry2.b += entry.b;
        }
        if (n6 < n4) {
            Entry<? extends E> entry3 = this.a(n2 + 1, n6 + 1, n4, n5, iterator);
            entry2.d = entry3;
            entry3.e = entry2;
            entry2.b += entry3.b;
        }
        return entry2;
    }

    public int binarySearch(E e2) {
        Entry<Object> entry = this.c;
        int n2 = 0;
        while (true) {
            if (entry == null) {
                return -n2 - 1;
            }
            int n3 = ((Comparable)entry.a).compareTo(e2);
            if (n3 < 0) {
                if (entry.c != null) {
                    n2 += entry.c.b;
                }
                ++n2;
                entry = entry.d;
                continue;
            }
            if (n3 <= 0) break;
            entry = entry.c;
        }
        return n2;
    }

    public int binarySearch(E e2, Comparator<? super E> comparator) {
        if (comparator == null) {
            return this.binarySearch(e2);
        }
        Entry<Object> entry = this.c;
        int n2 = 0;
        while (true) {
            if (entry == null) {
                return -n2 - 1;
            }
            int n3 = comparator.compare(entry.a, e2);
            if (n3 < 0) {
                if (entry.c != null) {
                    n2 += entry.c.b;
                }
                ++n2;
                entry = entry.d;
                continue;
            }
            if (n3 <= 0) break;
            entry = entry.c;
        }
        return n2;
    }

    public int limitedBinarySearch(E e2, int n2, int n3) {
        Entry<Object> entry = this.c;
        int n4 = 0;
        while (true) {
            int n5;
            if (entry == null) {
                return -n4 - 1;
            }
            int n6 = n5 = entry.c != null ? entry.c.b : 0;
            if (n2 > n5) {
                n2 -= n5 + 1;
                n3 -= n5 + 1;
                n4 += n5 + 1;
                entry = entry.d;
                continue;
            }
            if (n3 < n5) {
                entry = entry.c;
                continue;
            }
            int n7 = ((Comparable)entry.a).compareTo(e2);
            if (n7 < 0) {
                n2 -= n5 + 1;
                n3 -= n5 + 1;
                n4 += n5 + 1;
                entry = entry.d;
                continue;
            }
            if (n7 <= 0) break;
            entry = entry.c;
        }
        return n4;
    }

    public int limitedBinarySearch(E e2, Comparator<? super E> comparator, int n2, int n3) {
        if (comparator == null) {
            return this.limitedBinarySearch(e2, n2, n3);
        }
        Entry<Object> entry = this.c;
        int n4 = 0;
        while (true) {
            int n5;
            if (entry == null) {
                return -n4 - 1;
            }
            int n6 = n5 = entry.c != null ? entry.c.b : 0;
            if (n2 > n5) {
                n2 -= n5 + 1;
                n3 -= n5 + 1;
                n4 += n5 + 1;
                entry = entry.d;
                continue;
            }
            if (n3 < n5) {
                entry = entry.c;
                continue;
            }
            int n7 = comparator.compare(entry.a, e2);
            if (n7 < 0) {
                n2 -= n5 + 1;
                n3 -= n5 + 1;
                n4 += n5 + 1;
                entry = entry.d;
                continue;
            }
            if (n7 <= 0) break;
            entry = entry.c;
        }
        return n4;
    }

    public Object clone() {
        try {
            IlvHashTreeList ilvHashTreeList = (IlvHashTreeList)super.clone();
            ilvHashTreeList.c = null;
            ilvHashTreeList.d = 0;
            ilvHashTreeList.e = new HashMap();
            ilvHashTreeList.f = 0;
            ilvHashTreeList.a(this.size(), this.iterator());
            return ilvHashTreeList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListIterator
    implements ListIterator<E> {
        private int a;
        private Entry<E> b;
        private Entry<E> c;
        private Entry<E> d;
        private int e;

        MyListIterator(int n2, Entry<E> entry, Entry<E> entry2) {
            this.a = IlvHashTreeList.this.f;
            this.b = null;
            this.c = IlvHashTreeList.this.a();
            this.d = null;
            this.e = 0;
            this.e = n2;
            this.c = entry;
            this.d = entry2;
        }

        @Override
        public boolean hasNext() {
            return this.c != null;
        }

        @Override
        public E next() {
            if (this.c == null) {
                throw new NoSuchElementException();
            }
            if (IlvHashTreeList.this.f != this.a) {
                throw new ConcurrentModificationException();
            }
            this.b = this.c;
            this.d = this.c;
            this.c = IlvHashTreeList.this.c(this.c);
            ++this.e;
            return this.b.a;
        }

        @Override
        public boolean hasPrevious() {
            return this.d != null;
        }

        @Override
        public E previous() {
            if (this.d == null) {
                throw new NoSuchElementException();
            }
            if (IlvHashTreeList.this.f != this.a) {
                throw new ConcurrentModificationException();
            }
            this.b = this.d;
            this.c = this.d;
            this.d = IlvHashTreeList.this.d(this.d);
            --this.e;
            return this.b.a;
        }

        @Override
        public int nextIndex() {
            return this.e;
        }

        @Override
        public int previousIndex() {
            return this.e - 1;
        }

        @Override
        public void remove() {
            if (this.b == null) {
                throw new IllegalStateException();
            }
            if (IlvHashTreeList.this.f != this.a) {
                throw new ConcurrentModificationException();
            }
            if (this.b == this.d) {
                this.d = IlvHashTreeList.this.d(this.b);
                --this.e;
            } else {
                this.c = IlvHashTreeList.this.c(this.b);
            }
            IlvHashTreeList.this.n(this.b);
            ++this.a;
            this.b = null;
        }

        @Override
        public void set(E e2) {
            if (this.b == null) {
                throw new IllegalStateException();
            }
            if (IlvHashTreeList.this.f != this.a) {
                throw new ConcurrentModificationException();
            }
            IlvHashTreeList.this.a(this.b, e2);
        }

        @Override
        public void add(E e2) {
            if (IlvHashTreeList.this.f != this.a) {
                throw new ConcurrentModificationException();
            }
            IlvHashTreeList.this.add(this.e, e2);
            ++this.e;
            ++this.a;
            this.b = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<T> {
        T a;
        int b = 1;
        Entry<T> c;
        Entry<T> d;
        Entry<T> e;
        boolean f = true;

        Entry(T t2, Entry<T> entry) {
            this.a = t2;
            this.e = entry;
        }

        public String toString() {
            return "+" + this.a;
        }
    }
}

