/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.palettes.swing;

import ilog.views.event.IlvListenerList;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.event.PaletteAdapter;
import ilog.views.symbology.palettes.event.PaletteEvent;
import ilog.views.symbology.palettes.event.PaletteListener;
import ilog.views.symbology.palettes.event.PaletteViewerEvent;
import ilog.views.symbology.palettes.event.PaletteViewerListener;
import ilog.views.symbology.palettes.swing.IlvPaletteDragAndDropData;
import ilog.views.symbology.palettes.swing.IlvPaletteObjectTransferable;
import ilog.views.symbology.palettes.swing.IlvPaletteViewer;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class IlvPaletteToolbarViewer
extends JPanel
implements IlvPaletteViewer {
    private static final ImageIcon a = new ImageIcon(IlvPaletteToolbarViewer.class.getClassLoader().getResource("ilog/views/symbology/palettes/swing/images/back_up.gif"));
    private static final ImageIcon b = new ImageIcon(IlvPaletteToolbarViewer.class.getClassLoader().getResource("ilog/views/symbology/palettes/swing/images/back_down.gif"));
    private static final ImageIcon c = new ImageIcon(IlvPaletteToolbarViewer.class.getClassLoader().getResource("ilog/views/symbology/palettes/swing/images/forward_up.gif"));
    private static final ImageIcon d = new ImageIcon(IlvPaletteToolbarViewer.class.getClassLoader().getResource("ilog/views/symbology/palettes/swing/images/forward_down.gif"));
    private static final Color e = new Color(164, 172, 182);
    private DropTargetListener f = new DropTargetListener(){

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!IlvPaletteToolbarViewer.this.isEditable()) {
                return;
            }
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR)) {
                try {
                    IlvPaletteDragAndDropData ilvPaletteDragAndDropData = (IlvPaletteDragAndDropData)transferable.getTransferData(IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR);
                    if (!(ilvPaletteDragAndDropData.getPaletteObject() instanceof IlvPaletteSymbol)) {
                        dropTargetDropEvent.rejectDrop();
                        return;
                    }
                    IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)ilvPaletteDragAndDropData.getPaletteObject();
                    if (dropTargetDropEvent.getDropAction() == 1) {
                        if (ilvPaletteDragAndDropData.getPaletteViewer().getPalette() != IlvPaletteToolbarViewer.this.getPalette()) {
                            IlvPaletteObject ilvPaletteObject = ilvPaletteSymbol.copy();
                            IlvPaletteCategory ilvPaletteCategory = IlvPaletteToolbarViewer.this.getPalette().getRoot();
                            ilvPaletteCategory.add(ilvPaletteObject);
                        } else {
                            dropTargetDropEvent.rejectDrop();
                        }
                    } else {
                        ilvPaletteSymbol.getParent().remove(ilvPaletteSymbol);
                        IlvPaletteCategory ilvPaletteCategory = IlvPaletteToolbarViewer.this.getPalette().getRoot();
                        ilvPaletteCategory.add(ilvPaletteSymbol);
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    };
    private static final String g = " ";
    private IlvListenerList h = null;
    private IlvPalette i = null;
    private JPanel j = null;
    private JLabel k = null;
    private JButton l = null;
    private JButton m = null;
    private Timer n;
    private boolean o = false;

    public IlvPaletteToolbarViewer() {
        this.setLayout(new BorderLayout());
        this.j = new JPanel();
        this.j.setOpaque(false);
        this.j.setBackground(null);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(2);
        flowLayout.setHgap(3);
        this.j.setLayout(flowLayout);
        JScrollPane jScrollPane = new JScrollPane(this.j);
        jScrollPane.setOpaque(false);
        jScrollPane.setBackground(null);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getViewport().setBackground(null);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)jScrollPane, "Center");
        new DropTarget(this.j, 2, this.f, true, null);
        this.j.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IlvPaletteToolbarViewer.this.a();
            }
        });
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IlvPaletteToolbarViewer.this.a();
            }
        });
        this.l = new JButton();
        this.l.setOpaque(false);
        this.l.setBorderPainted(false);
        this.l.setContentAreaFilled(false);
        this.l.setIcon(c);
        this.l.setPressedIcon(d);
        this.l.setPreferredSize(new Dimension(c.getIconWidth(), c.getIconHeight()));
        this.add((Component)this.l, "East");
        this.l.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final Rectangle rectangle = IlvPaletteToolbarViewer.this.j.getVisibleRect();
                IlvPaletteToolbarViewer.this.n = new Timer(50, new ActionListener(){
                    int a;
                    int b;
                    int c;
                    {
                        this.a = rectangle.width;
                        this.b = this.a / 10;
                        this.c = 0;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Rectangle rectangle2 = new Rectangle();
                        if (this.c >= this.a) {
                            IlvPaletteToolbarViewer.this.a();
                            IlvPaletteToolbarViewer.this.n.stop();
                            IlvPaletteToolbarViewer.this.n = null;
                        }
                        rectangle2.setBounds(rectangle.x + this.c, 0, rectangle.width, 1);
                        IlvPaletteToolbarViewer.this.j.scrollRectToVisible(rectangle2);
                        this.c += this.b;
                    }
                });
                IlvPaletteToolbarViewer.this.l.setEnabled(false);
                IlvPaletteToolbarViewer.this.n.start();
            }
        });
        this.m = new JButton();
        this.m.setOpaque(false);
        this.m.setBorderPainted(false);
        this.m.setContentAreaFilled(false);
        this.m.setIcon(a);
        this.m.setPressedIcon(b);
        this.m.setPreferredSize(new Dimension(a.getIconWidth(), a.getIconHeight()));
        this.add((Component)this.m, "West");
        this.m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final Rectangle rectangle = IlvPaletteToolbarViewer.this.j.getVisibleRect();
                IlvPaletteToolbarViewer.this.n = new Timer(50, new ActionListener(){
                    int a;
                    int b;
                    int c;
                    {
                        this.a = rectangle.width;
                        this.b = this.a / 10;
                        this.c = 0;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Rectangle rectangle2 = new Rectangle();
                        if (this.c >= this.a) {
                            IlvPaletteToolbarViewer.this.a();
                            IlvPaletteToolbarViewer.this.n.stop();
                            IlvPaletteToolbarViewer.this.n = null;
                        }
                        rectangle2.setBounds(rectangle.x - this.c, 0, rectangle.width, 1);
                        IlvPaletteToolbarViewer.this.j.scrollRectToVisible(rectangle2);
                        this.c += this.b;
                    }
                });
                IlvPaletteToolbarViewer.this.m.setEnabled(false);
                IlvPaletteToolbarViewer.this.n.start();
            }
        });
        this.k = new JLabel(g);
        this.k.setOpaque(true);
        this.k.setBackground(e);
        this.add((Component)this.k, "South");
    }

    private void a() {
        boolean bl = this.j.getVisibleRect().getWidth() < (double)this.j.getWidth();
        this.l.setEnabled(bl);
        boolean bl2 = this.j.getX() < 0;
        boolean bl3 = (double)this.j.getX() > 0.0 - ((double)this.j.getWidth() - this.j.getVisibleRect().getWidth());
        this.m.setEnabled(bl && bl2);
        this.l.setEnabled(bl && bl3);
    }

    public void setPalette(IlvPalette ilvPalette) {
        Object object;
        Enumeration enumeration;
        if (ilvPalette == null) {
            this.j.removeAll();
            this.updateUI();
            return;
        }
        this.i = ilvPalette;
        this.j.removeAll();
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                SymbolLabel symbolLabel = (SymbolLabel)mouseEvent.getComponent();
                IlvPaletteToolbarViewer.this.k.setText(IlvPaletteToolbarViewer.g + symbolLabel.getSymbol().getShortDescription());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                IlvPaletteToolbarViewer.this.k.setText(IlvPaletteToolbarViewer.g);
            }
        };
        if (ilvPalette.getRoot() == null) {
            ilvPalette.setRootCategory("Symbols");
        }
        if ((enumeration = ilvPalette.getChildren(ilvPalette.getRoot())) != null) {
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!(object instanceof IlvPaletteSymbol)) continue;
                IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)object;
                SymbolLabel symbolLabel = new SymbolLabel(this, ilvPaletteSymbol);
                symbolLabel.addMouseListener(mouseAdapter);
                this.j.add(symbolLabel);
            }
        }
        this.updateUI();
        object = new PaletteAdapter(){

            public void symbolAdded(PaletteEvent paletteEvent) {
                IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)paletteEvent.getChild();
                if (paletteEvent.getParentCategory().equals(IlvPaletteToolbarViewer.this.i.getRoot())) {
                    SymbolLabel symbolLabel = new SymbolLabel(IlvPaletteToolbarViewer.this, ilvPaletteSymbol);
                    symbolLabel.addMouseListener(mouseAdapter);
                    IlvPaletteToolbarViewer.this.j.add(symbolLabel);
                    IlvPaletteToolbarViewer.this.updateUI();
                }
            }

            public void symbolRemoved(PaletteEvent paletteEvent) {
                for (int i2 = 0; i2 < IlvPaletteToolbarViewer.this.j.getComponentCount(); ++i2) {
                    Component component = IlvPaletteToolbarViewer.this.j.getComponent(i2);
                    if (!(component instanceof SymbolLabel) || !((SymbolLabel)component).getSymbol().equals(paletteEvent.getChild())) continue;
                    IlvPaletteToolbarViewer.this.j.remove(component);
                    IlvPaletteToolbarViewer.this.updateUI();
                    break;
                }
            }
        };
        ilvPalette.addPaletteListener((PaletteListener)object);
    }

    public IlvPalette getPalette() {
        return this.i;
    }

    public JComponent getComponent() {
        return this;
    }

    public void addPaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        if (this.h == null) {
            this.h = new IlvListenerList();
        }
        this.h.add(paletteViewerListener);
    }

    public void removePaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        if (this.h != null) {
            this.h.remove(paletteViewerListener);
            if (this.h.getListenerCount() == 0) {
                this.h = null;
            }
        }
    }

    protected void fireSymbolSelected(IlvPalette ilvPalette, IlvPaletteSymbol ilvPaletteSymbol) {
        if (this.h == null) {
            return;
        }
        Object[] objectArray = this.h.getListenerList();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        PaletteViewerEvent paletteViewerEvent = new PaletteViewerEvent(this, ilvPalette, null, ilvPaletteSymbol);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            PaletteViewerListener paletteViewerListener = (PaletteViewerListener)objectArray[i2];
            paletteViewerListener.symbolSelected(paletteViewerEvent);
        }
    }

    protected void fireCategorySelected(IlvPalette ilvPalette, IlvPaletteCategory ilvPaletteCategory) {
    }

    public void setEditable(boolean bl) {
        this.o = bl;
    }

    public boolean isEditable() {
        return this.o;
    }

    public void select(IlvPaletteObject ilvPaletteObject) {
        if (this.j == null) {
            return;
        }
        int n2 = this.j.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            SymbolLabel symbolLabel = (SymbolLabel)this.j.getComponent(i2);
            if (symbolLabel.getSymbol() == ilvPaletteObject) {
                symbolLabel.setSelected(true);
                this.j.scrollRectToVisible(symbolLabel.getBounds());
                continue;
            }
            symbolLabel.setSelected(false);
        }
    }

    private static class SymbolLabel
    extends JButton
    implements DragGestureListener,
    DragSourceListener,
    ActionListener {
        private static final ImageIcon a = new ImageIcon(IlvPaletteToolbarViewer.class.getClassLoader().getResource("ilog/views/symbology/palettes/swing/images/copyCursor.gif"));
        private static final ImageIcon b = new ImageIcon(IlvPaletteToolbarViewer.class.getClassLoader().getResource("ilog/views/symbology/palettes/swing/images/defaultsymbol.gif"));
        private static final Insets c = new Insets(0, 0, 0, 0);
        private static final Border d = new LineBorder(Color.red, 2);
        private IlvPaletteSymbol e = null;
        private IlvPaletteToolbarViewer f = null;
        private int g = 0;

        public SymbolLabel(IlvPaletteToolbarViewer ilvPaletteToolbarViewer, IlvPaletteSymbol ilvPaletteSymbol) {
            this.addActionListener(this);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setMargin(c);
            this.setOpaque(false);
            ImageIcon imageIcon = ilvPaletteSymbol.getIcon();
            if (imageIcon == null || imageIcon.getIconWidth() < 1 || imageIcon.getIconHeight() < 1) {
                this.setIcon(b);
            } else {
                this.setIcon(imageIcon);
            }
            this.setHorizontalAlignment(0);
            this.e = ilvPaletteSymbol;
            this.f = ilvPaletteToolbarViewer;
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        }

        public IlvPaletteSymbol getSymbol() {
            return this.e;
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (bl) {
                this.setBorder(d);
                this.setBorderPainted(true);
            } else {
                this.setBorder(null);
                this.setBorderPainted(false);
            }
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            this.g = dragGestureEvent.getDragAction();
            Cursor cursor = this.a(this.g);
            IlvPaletteObjectTransferable ilvPaletteObjectTransferable = new IlvPaletteObjectTransferable(this.getSymbol(), this.getViewer());
            dragGestureEvent.startDrag(cursor, ilvPaletteObjectTransferable, this);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.g = this.g == 1 ? 2 : 1;
            Cursor cursor = this.a(this.g);
            dragSourceDragEvent.getDragSourceContext().setCursor(cursor);
        }

        private Cursor a(int n2) {
            BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
            this.paint(graphics2D);
            Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(this.getWidth(), this.getHeight());
            if (n2 == 1) {
                double d2 = dimension.getWidth() / (double)this.getWidth();
                double d3 = dimension.getHeight() / (double)this.getHeight();
                graphics2D.translate((double)this.getWidth() - (double)a.getIconWidth() / d2, (double)this.getHeight() - (double)a.getIconHeight() / d3);
                graphics2D.scale(1.0 / d2, 1.0 / d3);
                graphics2D.drawImage(a.getImage(), 0, 0, this);
            }
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(dimension.width / 2, dimension.height / 2), "toto");
            return cursor;
        }

        public IlvPaletteViewer getViewer() {
            return this.f;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.f.fireSymbolSelected(this.f.getPalette(), this.getSymbol());
        }
    }
}

