/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.internal;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.util.collections.IlvCollections;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.NoSuchElementException;

public final class IlvIndexedSetGraphicVector
implements Cloneable,
Serializable {
    private static final String a = "The IlvIndexedSet was modified while enumerating its contents. If you are using multiple threads, probably some synchronization is missing. Synchronize adding, removing, accessing and enumerating over elements.\nIf you are using only a single thread, probably some objects were added or removed while enumerating over elements. In this case consider using ilog.views.IlvBufferedGraphicEnumeration.\nUse the flag IlvGraphicVector.DEBUG to debug this situation.";
    private static final String b = "Location of recent modification";
    private IlvGraphic[] c;
    private int d;
    private IdentityHashMap e = null;
    private long f = 0L;
    private long g = 3L;
    private boolean h = false;
    private transient int i = 0;
    private transient Exception j;

    public IlvIndexedSetGraphicVector(int n2, long l2) {
        this(n2, l2, false);
    }

    public IlvIndexedSetGraphicVector(int n2, long l2, boolean bl) {
        this.c = new IlvGraphic[n2];
        this.g = l2;
        this.h = bl;
    }

    public void setSubsequentRemoveThreshold(long l2) {
        this.handlePendingRemoves();
        this.g = l2 < 0L ? 0L : l2;
    }

    public long getSubsequentRemoveThreshold() {
        return this.g;
    }

    public void handlePendingRemoves() {
        int n2 = this.i;
        this.f = 0L;
        if (this.e == null) {
            return;
        }
        IlvGraphic[] ilvGraphicArray = new IlvGraphic[this.c.length];
        int n3 = this.d + this.e.size();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            IlvGraphic ilvGraphic = this.c[i2];
            if (this.e.get(ilvGraphic) == null) {
                ilvGraphicArray[n4++] = this.c[i2];
                continue;
            }
            if (!this.h) continue;
            this.c[i2].setZOrderIndex(-1);
        }
        if (n4 != this.d) {
            this.d = n4;
            if (IlvGraphicVector.checkConcurrentModification && n2 != this.i) {
                throw IlvCollections.concurrentModificationException(a, this.j);
            }
            throw new RuntimeException("IlvIndexedSet.removeObject: Some objects where not removed. Maybe you forgot to use IlvManager.applyToObject when changing the bbox of the object.\nUse IlvManager.setOptimizedLayerThreshold(Long.MAX_VALUE) to debug this situation, because it might then detect the potentual error earlier.");
        }
        this.c = ilvGraphicArray;
        this.e = null;
        this.a();
        if (IlvGraphicVector.checkConcurrentModification && n2 != this.i) {
            throw IlvCollections.concurrentModificationException(a, this.j);
        }
    }

    private void a(int n2) {
        assert (this.e == null);
        int n3 = this.i;
        int n4 = this.c.length;
        if (n2 > n4) {
            IlvGraphic[] ilvGraphicArray = this.c;
            int n5 = n4 * 3 / 2 + 1;
            if (n5 < n2) {
                n5 = n2;
            }
            this.c = new IlvGraphic[n5];
            System.arraycopy(ilvGraphicArray, 0, this.c, 0, this.d);
        }
        if (IlvGraphicVector.checkConcurrentModification && n3 != this.i) {
            throw IlvCollections.concurrentModificationException(a, this.j);
        }
    }

    public int size() {
        return this.d;
    }

    public boolean isEmpty() {
        return this.d == 0;
    }

    public IlvGraphicEnumeration elements() {
        this.handlePendingRemoves();
        return new IlvGraphicVectorEnumerator(this, this.i);
    }

    public boolean contains(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic) >= 0;
    }

    public int indexOf(IlvGraphic ilvGraphic) {
        this.handlePendingRemoves();
        return this.a(ilvGraphic);
    }

    private int a(IlvGraphic ilvGraphic) {
        if (this.h) {
            int n2 = ilvGraphic.getZOrderIndex();
            if (ilvGraphic == this.c[n2]) {
                return n2;
            }
        } else {
            for (int i2 = 0; i2 < this.d; ++i2) {
                if (ilvGraphic != this.c[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public boolean setIndex(IlvGraphic ilvGraphic, int n2) {
        int n3;
        if (n2 >= this.d) {
            n2 = this.d - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n3 = this.indexOf(ilvGraphic)) == -1) {
            return false;
        }
        if (n2 != n3) {
            this.b(n3);
            this.a(ilvGraphic, n2);
        }
        return true;
    }

    public IlvGraphic elementAt(int n2) {
        assert (this.e == null);
        if (n2 >= this.d) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.d);
        }
        try {
            return this.c[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
    }

    private void b(int n2) {
        int n3;
        assert (this.e == null);
        assert (n2 < this.d);
        if (this.h) {
            this.c[n2].setZOrderIndex(-1);
        }
        if ((n3 = this.d - n2 - 1) > 0) {
            System.arraycopy(this.c, n2 + 1, this.c, n2, n3);
        }
        --this.d;
        ++this.i;
        if (IlvGraphicVector.DEBUG) {
            this.j = new Exception(b);
        }
        this.c[this.d] = null;
        this.a();
    }

    private void a(IlvGraphic ilvGraphic, int n2) {
        assert (this.e == null);
        assert (n2 <= this.d);
        assert (ilvGraphic.getZOrderIndex() == -1);
        this.a(this.d + 1);
        System.arraycopy(this.c, n2, this.c, n2 + 1, this.d - n2);
        this.c[n2] = ilvGraphic;
        ++this.d;
        ++this.i;
        if (IlvGraphicVector.DEBUG) {
            this.j = new Exception(b);
        }
        this.a();
    }

    public void addElement(IlvGraphic ilvGraphic) {
        this.handlePendingRemoves();
        assert (ilvGraphic.getZOrderIndex() == -1);
        this.a(this.d + 1);
        this.c[this.d++] = ilvGraphic;
        ++this.i;
        if (IlvGraphicVector.DEBUG) {
            this.j = new Exception(b);
        }
        this.a();
    }

    public boolean removeElement(IlvGraphic ilvGraphic) {
        ++this.f;
        if (this.e == null && (this.d < 100 || this.f < this.g)) {
            int n2 = this.a(ilvGraphic);
            if (n2 >= 0) {
                this.b(n2);
                return true;
            }
            return false;
        }
        if (this.e == null) {
            this.e = new IdentityHashMap();
        }
        this.e.put(ilvGraphic, Boolean.TRUE);
        --this.d;
        ++this.i;
        if (IlvGraphicVector.DEBUG) {
            this.j = new Exception(b);
        }
        return true;
    }

    private void a() {
        if (!this.h) {
            return;
        }
        for (int i2 = this.d - 1; i2 >= 0 && this.c[i2].getZOrderIndex() != i2; --i2) {
            this.c[i2].setZOrderIndex(i2);
        }
    }

    public void setZOrderUpdating(boolean bl) {
        if (bl == this.h) {
            return;
        }
        this.h = bl;
        if (bl) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                this.c[i2].setZOrderIndex(i2);
            }
        } else {
            for (int i3 = 0; i3 < this.d; ++i3) {
                this.c[i3].setZOrderIndex(-1);
            }
        }
    }

    public boolean isZOrderUpdating() {
        return this.h;
    }

    final class IlvGraphicVectorEnumerator
    implements IlvGraphicEnumeration {
        private IlvIndexedSetGraphicVector a;
        private int b;
        private int c;

        IlvGraphicVectorEnumerator(IlvIndexedSetGraphicVector ilvIndexedSetGraphicVector2, int n2) {
            this.a = ilvIndexedSetGraphicVector2;
            this.c = n2;
        }

        public boolean hasMoreElements() {
            return this.b < this.a.d;
        }

        public IlvGraphic nextElement() {
            if (IlvGraphicVector.checkConcurrentModification && this.c != IlvIndexedSetGraphicVector.this.i) {
                throw IlvCollections.concurrentModificationException(IlvIndexedSetGraphicVector.a, IlvIndexedSetGraphicVector.this.j);
            }
            if (this.b < this.a.d) {
                return this.a.c[this.b++];
            }
            throw new NoSuchElementException("IlvGraphicVectorEnumerator");
        }
    }
}

