/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.interactor.IlvDragRectangleInteractor;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import ilog.views.util.swing.IlvCursorFactory;
import java.awt.Dimension;
import java.awt.event.MouseEvent;

public class IlvUnZoomViewInteractor
extends IlvDragRectangleInteractor
implements IlvPermanentInteractorInterface {
    private boolean a = false;

    public IlvUnZoomViewInteractor() {
        this.setCursor(IlvCursorFactory.getCursor(18));
        this.setScrollTiming(100);
        this.setMaximumScrollDistance(30.0f);
        this.setProgressiveScroll(false);
    }

    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        if (ilvManagerView.isKeepingAspectRatio()) {
            Dimension dimension = ilvManagerView.getSize();
            if (dimension.height != 0 && dimension.width != 0) {
                this.setRectangleAspectRatio((float)dimension.width / (float)dimension.height);
            }
        } else {
            this.setRectangleAspectRatio(0.0f);
        }
    }

    protected void fireRectangleDraggedEvent(IlvRect ilvRect, MouseEvent mouseEvent) {
        IlvManagerView ilvManagerView = this.getManagerView();
        Dimension dimension = ilvManagerView.getSize();
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        this.getTransformer().apply(ilvRect2);
        double d2 = Math.min(dimension.width, dimension.height);
        if (d2 == 0.0 || ilvRect2.width < 10.0f || ilvRect2.height < 10.0f) {
            ilvRect2.width = 0.0f;
            super.fireRectangleDraggedEvent(ilvRect, mouseEvent);
            if (!this.a && this.getManagerView() != null) {
                this.getManagerView().popInteractor();
            }
            return;
        }
        IlvTransformer ilvTransformer = new IlvTransformer();
        double d3 = (double)ilvRect2.width / (double)dimension.width;
        double d4 = (double)ilvRect2.height / (double)dimension.height;
        if (ilvManagerView.isKeepingAspectRatio()) {
            d3 = d4 = Math.min(d3, d4);
        }
        double d5 = -d3 * ((double)ilvRect2.x + (double)ilvRect2.width / 2.0) + (double)dimension.width / 2.0;
        double d6 = -d4 * ((double)ilvRect2.y + (double)ilvRect2.height / 2.0) + (double)dimension.height / 2.0;
        ilvTransformer.setValues(d3, 0.0, 0.0, d4, d5, d6);
        ilvManagerView.addTransformer(ilvTransformer);
        super.fireRectangleDraggedEvent(ilvRect, mouseEvent);
        if (!this.a && this.getManagerView() != null) {
            this.getManagerView().popInteractor();
        }
        ilvManagerView.repaint();
    }

    public final boolean isPermanent() {
        return this.a;
    }

    public final void setPermanent(boolean bl) {
        this.a = bl;
    }
}

