/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.linkpolicy;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractCrossingGraphic;
import ilog.views.graphic.linkpolicy.IlvCrossingAwareLinkImage;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvBridgeCrossings
extends IlvAbstractCrossingGraphic {
    private float a = 3.0f;

    public IlvBridgeCrossings(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage) {
        super(ilvCrossingAwareLinkImage);
    }

    public IlvBridgeCrossings(IlvBridgeCrossings ilvBridgeCrossings) {
        super(ilvBridgeCrossings);
        this.a = ilvBridgeCrossings.a;
    }

    public IlvBridgeCrossings(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readFloat("bridgeLengthFactor");
    }

    public IlvGraphic copy() {
        return new IlvBridgeCrossings(this);
    }

    public void setBridgeLengthFactor(float f2) {
        this.a = f2;
    }

    public final float getBridgeLengthFactor() {
        return this.a;
    }

    public void drawCrossing(Graphics graphics, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2, float f3, float f4) {
        graphics.setColor(ilvLinkImage.getForeground());
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f4, false);
        if (!drawingParameters.e) {
            return;
        }
        IlvGraphicUtil.DrawPolyline(graphics, drawingParameters.a, 2, 0.0f, 0, 1, null, ilvTransformer, true);
        IlvGraphicUtil.DrawPolyline(graphics, drawingParameters.b, 2, 0.0f, 0, 1, null, ilvTransformer, true);
    }

    public boolean containsAtCrossing(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, float f2, float f3, float f4) {
        return false;
    }

    public IlvRect expandLinkBoundingBox(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        float f2;
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = this.getRelatedLinkImage();
        float f3 = ilvCrossingAwareLinkImage.getGap();
        if (ilvCrossingAwareLinkImage.isGapZoomable()) {
            f3 = (float)((double)f3 * d2);
        }
        if ((f2 = ilvCrossingAwareLinkImage.getLineWidth()) != 0.0f) {
            float f4 = ilvCrossingAwareLinkImage.getMaximumLineWidth();
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, f4, ilvTransformer, true);
        }
        f2 = (float)((double)f2 * d2);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f * f3 + f2, f3);
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(2.0f * f3 + f2, 0.0f);
        this.addCrossingBound(ilvRect2, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f3);
        IlvRect ilvRect3 = new IlvRect(0.0f, 0.0f, f3, 2.0f * f3 + f2);
        ilvPoint.move(0.0f, 0.0f);
        ilvPoint2.move(0.0f, 2.0f * f3 + f2);
        this.addCrossingBound(ilvRect3, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f3);
        IlvRect ilvRect4 = new IlvRect(ilvRect);
        ilvRect4.x -= 1.5f * ilvRect3.width;
        ilvRect4.y -= 1.5f * ilvRect2.height;
        ilvRect4.width += 3.0f * ilvRect3.width;
        ilvRect4.height += 3.0f * ilvRect2.height;
        return ilvRect4;
    }

    public void addCrossingBound(IlvRect ilvRect, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2, float f3, float f4) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f4, true);
        if (!drawingParameters.e) {
            return;
        }
        ilvRect.add(IlvGraphicUtil.PolylineBBox(drawingParameters.a, 2, 0.0f, 0, 1, null));
        ilvRect.add(IlvGraphicUtil.PolylineBBox(drawingParameters.b, 2, 0.0f, 0, 1, null));
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("bridgeLengthFactor", this.a);
    }

    class DrawingParameters {
        IlvPoint[] a;
        IlvPoint[] b;
        float c;
        float d;
        boolean e = true;

        DrawingParameters(IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2, boolean bl) {
            float f3;
            double d2;
            this.d = ilvLinkImage.getLineWidth();
            int n2 = ilvLinkImage.getEndCap();
            double d3 = d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (this.d != 0.0f) {
                f3 = ilvLinkImage.getMaximumLineWidth();
                this.d = IlvStrokeInfo.zoomedLineWidth(this.d, f3, ilvTransformer, bl);
            }
            this.c = (float)((double)this.d * d2);
            f3 = ilvPoint3.x - ilvPoint2.x;
            float f4 = ilvPoint3.y - ilvPoint2.y;
            double d4 = Math.sqrt(f3 * f3 + f4 * f4);
            if (d4 == 0.0) {
                this.e = false;
                return;
            }
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (n2 != 0 && (d4 = Math.sqrt((f3 -= 2.0f * (f5 = (float)((double)(0.5f * this.c * f3) / d4))) * f3 + (f4 -= 2.0f * (f6 = (float)((double)(0.5f * this.c * f4) / d4))) * f4)) == 0.0) {
                this.e = false;
                return;
            }
            float f7 = IlvBridgeCrossings.this.a / 2.0f * Math.max(this.c, 1.0f);
            this.a = new IlvPoint[2];
            this.b = new IlvPoint[2];
            float f8 = ilvPoint2.x + f5;
            float f9 = ilvPoint2.y + f6;
            float f10 = ilvPoint3.x - f5;
            float f11 = ilvPoint3.y - f6;
            float f12 = -((float)((double)(f7 * f4) / d4));
            float f13 = (float)((double)(f7 * f3) / d4);
            this.a[0] = new IlvPoint(f8 + f12, f9 + f13);
            this.a[1] = new IlvPoint(f8 - f12, f9 - f13);
            this.b[0] = new IlvPoint(f10 + f12, f11 + f13);
            this.b[1] = new IlvPoint(f10 - f12, f11 - f13);
        }
    }
}

