/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvGraphicHandle;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvTransformedGraphic
extends IlvGraphicHandle {
    private IlvTransformer a = new IlvTransformer();

    public IlvTransformedGraphic(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, boolean bl) {
        super(ilvGraphic, bl);
        this.setTransformer(ilvTransformer);
    }

    public IlvTransformedGraphic(IlvTransformedGraphic ilvTransformedGraphic) {
        super(ilvTransformedGraphic);
        this.setTransformer(ilvTransformedGraphic.getTransformer());
    }

    public IlvGraphic copy() {
        IlvTransformedGraphic ilvTransformedGraphic = new IlvTransformedGraphic(this);
        if (ilvTransformedGraphic.getObject() != null) {
            return ilvTransformedGraphic;
        }
        return null;
    }

    public IlvTransformedGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setTransformer(ilvInputStream.readTransformer("transformer"));
    }

    public IlvTransformer getTransformer() {
        return new IlvTransformer(this.a);
    }

    public void setTransformer(IlvTransformer ilvTransformer) {
        this.a = ilvTransformer == null ? new IlvTransformer() : new IlvTransformer(ilvTransformer);
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        this.getObject().callDraw(graphics, ilvTransformer2);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return this.getObject().boundingBox(ilvTransformer2);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        this.a.compose(ilvTransformer);
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint2);
        ilvTransformer2.inverse(ilvPoint3);
        return this.getObject().contains(ilvPoint3, ilvPoint2, ilvTransformer2);
    }

    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().intersects(ilvRect3, ilvRect2, ilvTransformer2);
    }

    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().inside(ilvRect3, ilvRect2, ilvTransformer2);
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return this.getObject().getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer2);
    }

    public void move(float f2, float f3) {
        IlvRect ilvRect = this.boundingBox(null);
        this.translate(f2 - ilvRect.x, f3 - ilvRect.y);
    }

    public void move(IlvPoint ilvPoint) {
        this.move(ilvPoint.x, ilvPoint.y);
    }

    public void moveResize(IlvRect ilvRect) {
        IlvRect ilvRect2 = this.boundingBox(null);
        IlvTransformer ilvTransformer = new IlvTransformer();
        IlvTransformer.computeTransformer(ilvRect2, ilvRect, ilvTransformer);
        this.applyTransform(ilvTransformer);
    }

    public void translate(float f2, float f3) {
        IlvTransformer ilvTransformer = new IlvTransformer(1.0, 0.0, 0.0, 1.0, f2, f3);
        this.applyTransform(ilvTransformer);
    }

    public void rotate(IlvPoint ilvPoint, double d2) {
        d2 = IlvUtil.degreesToRadians(d2);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        IlvTransformer ilvTransformer = new IlvTransformer(d3, -d4, d4, d3, (double)ilvPoint.x * (1.0 - d3) + d4 * (double)ilvPoint.y, -((double)ilvPoint.x * d4) + (double)ilvPoint.y * (1.0 - d3));
        this.applyTransform(ilvTransformer);
    }

    public void scale(double d2, double d3) {
        IlvRect ilvRect = this.boundingBox(null);
        double d4 = (1.0 - d2) * (double)ilvRect.x;
        double d5 = (1.0 - d3) * (double)ilvRect.y;
        IlvTransformer ilvTransformer = new IlvTransformer(d2, 0.0, 0.0, d3, d4, d5);
        this.applyTransform(ilvTransformer);
    }

    public void resize(float f2, float f3) {
        IlvRect ilvRect = this.boundingBox(null);
        float f4 = ilvRect.width == 0.0f ? 1.0f : ilvRect.width;
        float f5 = ilvRect.height == 0.0f ? 1.0f : ilvRect.height;
        this.scale((double)f2 / (double)f4, (double)f3 / (double)f5);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("transformer", this.a);
    }
}

