/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.internal.IlvUtility;
import ilog.views.util.text.IlvAttributedStringUtil;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class IlvLayoutTextRenderer
implements IlvText.Renderer {
    private transient boolean a = false;
    private transient Rectangle2D b;
    private transient Rectangle2D c;
    private transient float d;
    private transient int e;
    private transient TextLayout[] f;
    private transient FontRenderContext g = null;
    private transient TextLayout h = null;
    private transient InfoForFRCDependentTreatment i;
    private transient Integer[] j;
    private IlvText k;

    public IlvLayoutTextRenderer(IlvText ilvText) {
        this.k = ilvText;
        this.i = IlvText.IsTransformerDependentRendering() ? new InfoForFRCDependentTreatment() : null;
    }

    public Shape getCaretShape(IlvTextSelection.Range range, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2;
        TextLayout textLayout;
        double d2;
        if ((this.k.getWrappingMode() & 2) == 2) {
            return null;
        }
        double d3 = this.k.getAnchorPoint().x;
        double d4 = d2 = (double)this.k.getAnchorPoint().y;
        this.i();
        Path2D path2D = null;
        this.c();
        int n2 = this.e;
        if (n2 == 0) {
            return null;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d3 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d3 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d3 -= this.b.getWidth() / 2.0;
                d2 -= this.b.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d3 -= (double)this.d;
            }
        }
        double d7 = this.k.getRotationAlignmentThresholdAngle();
        double d8 = 0.0;
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            textLayout = this.f[i2];
            if (textLayout == null) continue;
            d6 = 0.0;
            if (i2 > 0) {
                d2 += (double)textLayout.getAscent();
            }
            switch (this.k.getAlignment()) {
                case 256: {
                    d5 = textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
                    break;
                }
                case 257: {
                    d5 = textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
                    break;
                }
                case 16: {
                    d5 = (this.d - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                case 1: {
                    d5 = 0.0;
                    break;
                }
                case 2: {
                    d5 = this.d - textLayout.getAdvance();
                }
            }
            if (d7 > 0.0 && this.e > 0) {
                IlvPoint ilvPoint = new IlvPoint(0.0f, (float)d4);
                IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d2);
                object = this.k.getTransformer();
                IlvTransformer ilvTransformer3 = null;
                if (this.k.getRotationAlignmentAngle() != 0.0f) {
                    ilvTransformer3 = new IlvTransformer(ilvPoint, this.k.getRotationAlignmentAngle());
                }
                if (object != null) {
                    ((IlvTransformer)object).apply(ilvPoint);
                    ((IlvTransformer)object).apply(ilvPoint2);
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.inverse(ilvPoint);
                    ilvTransformer3.inverse(ilvPoint2);
                }
                if (!bl && d2 != d4) {
                    for (d8 = Math.atan2(ilvPoint2.y - ilvPoint.y, ilvPoint2.x - ilvPoint.x) / Math.PI * 180.0; d8 < 0.0; d8 += 180.0) {
                    }
                    while (d8 > 180.0) {
                        d8 -= 180.0;
                    }
                    bl = true;
                }
                if (d8 < 90.0 - d7 || d8 > 90.0 + d7) {
                    if (Math.abs(ilvPoint.x - ilvPoint2.x) > 0.0f) {
                        float f2 = ilvPoint2.x - ilvPoint.x;
                        float f3 = ilvPoint2.y - ilvPoint.y;
                        ilvPoint2.y = ilvPoint.y;
                        ilvPoint2.x += f3 * f3 / f2;
                    }
                } else if (Math.abs(ilvPoint.y - ilvPoint2.y) > 0.0f) {
                    float f4 = ilvPoint2.y - ilvPoint.y;
                    float f5 = ilvPoint2.x - ilvPoint.x;
                    ilvPoint2.x = ilvPoint.x;
                    ilvPoint2.y += f5 * f5 / f4;
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.apply(ilvPoint2);
                }
                if (object != null) {
                    ((IlvTransformer)object).inverse(ilvPoint2);
                }
                d5 += (double)ilvPoint2.x;
                d6 += (double)ilvPoint2.y - d2;
            }
            int n3 = this.j[i2];
            int n4 = this.a(i2);
            object = null;
            int n5 = textLayout.getCharacterCount();
            if (range.isCollapsed()) {
                if (range.from >= n3 && range.from <= n4) {
                    object = textLayout.getCaretShapes(Math.min(range.from - n3, n5))[0];
                }
            } else {
                int n6 = Math.max(range.from - n3, 0);
                int n7 = Math.min(n5, range.to - n3);
                if (n6 >= 0 && n6 < n7) {
                    object = textLayout.getLogicalHighlightShape(n6, n7);
                }
            }
            if (object != null) {
                AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, d3 + d5, d2 + d6);
                object = affineTransform.createTransformedShape((Shape)object);
                if (path2D == null) {
                    path2D = new GeneralPath();
                }
                path2D.append((Shape)object, false);
                if (range.isCollapsed()) break;
            }
            d2 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
        if ((ilvTransformer2 = this.k.getTransformer()) != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        textLayout = ilvTransformer2 != null ? IlvUtility.IlvToJava2DTransformer(ilvTransformer2, null) : null;
        if (textLayout != null & path2D != null) {
            return path2D.createTransformedShape((AffineTransform)((Object)textLayout));
        }
        return path2D;
    }

    private int a(int n2) {
        if (n2 < this.j.length - 1) {
            return this.j[n2 + 1] - 1;
        }
        return this.k.getLabel().length();
    }

    public int pickCharacter(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        double d2;
        double d3 = this.k.getAnchorPoint().x;
        double d4 = d2 = (double)this.k.getAnchorPoint().y;
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint);
        }
        if (this.k.getTransformer() != null) {
            this.k.getTransformer().inverse(ilvPoint);
        }
        this.i();
        this.c();
        int n2 = this.e;
        if (n2 == 0) {
            return -1;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d3 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d3 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d3 -= this.b.getWidth() / 2.0;
                d2 -= this.b.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d3 -= (double)this.d;
            }
        }
        double d7 = this.k.getRotationAlignmentThresholdAngle();
        double d8 = 0.0;
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Object object;
            TextLayout textLayout = this.f[i2];
            if (textLayout == null) continue;
            d6 = 0.0;
            if (i2 > 0) {
                d2 += (double)textLayout.getAscent();
            }
            switch (this.k.getAlignment()) {
                case 256: {
                    d5 = textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
                    break;
                }
                case 257: {
                    d5 = textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
                    break;
                }
                case 16: {
                    d5 = (this.d - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                case 1: {
                    d5 = 0.0;
                    break;
                }
                case 2: {
                    d5 = this.d - textLayout.getAdvance();
                }
            }
            if (d7 > 0.0 && this.e > 0) {
                float f2;
                float f3;
                IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d4);
                object = new IlvPoint(0.0f, (float)d2);
                IlvTransformer ilvTransformer2 = this.k.getTransformer();
                IlvTransformer ilvTransformer3 = null;
                if (this.k.getRotationAlignmentAngle() != 0.0f) {
                    ilvTransformer3 = new IlvTransformer(ilvPoint2, this.k.getRotationAlignmentAngle());
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.apply(ilvPoint2);
                    ilvTransformer2.apply((IlvPoint)object);
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.inverse(ilvPoint2);
                    ilvTransformer3.inverse((IlvPoint)object);
                }
                if (!bl && d2 != d4) {
                    for (d8 = Math.atan2(((Point2D.Float)object).y - ilvPoint2.y, ((Point2D.Float)object).x - ilvPoint2.x) / Math.PI * 180.0; d8 < 0.0; d8 += 180.0) {
                    }
                    while (d8 > 180.0) {
                        d8 -= 180.0;
                    }
                    bl = true;
                }
                if (d8 < 90.0 - d7 || d8 > 90.0 + d7) {
                    if (Math.abs(ilvPoint2.x - ((Point2D.Float)object).x) > 0.0f) {
                        f3 = ((Point2D.Float)object).x - ilvPoint2.x;
                        f2 = ((Point2D.Float)object).y - ilvPoint2.y;
                        ((Point2D.Float)object).y = ilvPoint2.y;
                        ((Point2D.Float)object).x += f2 * f2 / f3;
                    }
                } else if (Math.abs(ilvPoint2.y - ((Point2D.Float)object).y) > 0.0f) {
                    f3 = ((Point2D.Float)object).y - ilvPoint2.y;
                    f2 = ((Point2D.Float)object).x - ilvPoint2.x;
                    ((Point2D.Float)object).x = ilvPoint2.x;
                    ((Point2D.Float)object).y += f2 * f2 / f3;
                }
                if (ilvTransformer3 != null) {
                    ilvTransformer3.apply((IlvPoint)object);
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.inverse((IlvPoint)object);
                }
                d5 += (double)((Point2D.Float)object).x;
                d6 += (double)((Point2D.Float)object).y - d2;
            }
            int n4 = textLayout.getCharacterCount();
            if ((double)ilvPoint.y >= d2 - (double)textLayout.getAscent() && (double)ilvPoint.y <= d2 + (double)textLayout.getDescent() && (n3 = ((TextHitInfo)(object = textLayout.hitTestChar((float)((double)ilvPoint.x - d3 - d5), (float)((double)ilvPoint.y - d2 - d6)))).getInsertionIndex()) >= 0 && n3 <= n4) {
                if (this.a()) {
                    return this.lineOffset(i2);
                }
                return this.lineOffset(i2) + n3;
            }
            d2 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
        return -1;
    }

    boolean a() {
        return this.k.getLabel() == null || this.k.getLabel().length() == 0;
    }

    public int lineCount() {
        this.i();
        return this.j.length;
    }

    public int lineOffset(int n2) {
        this.i();
        if (n2 < 0 || n2 >= this.lineCount()) {
            return -1;
        }
        return this.j[n2];
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        AffineTransform affineTransform;
        IlvTransformer ilvTransformer2;
        this.i();
        graphics = graphics.create();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.k.isAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.k.isFractionalMetrics()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        if ((ilvTransformer2 = this.k.getTransformer()) != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        AffineTransform affineTransform2 = affineTransform = ilvTransformer2 != null ? IlvUtility.IlvToJava2DTransformer(ilvTransformer2, null) : null;
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        graphics2D.setFont(this.k.getFont());
        TextLayout[] textLayoutArray = this.f;
        if (this.i != null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            this.f = this.a(fontRenderContext);
        }
        if (this.e > 0) {
            if (this.e > 1) {
                this.b(graphics2D, this.k.ae.x, this.k.ae.y);
            } else {
                this.a(graphics2D, this.k.ae.x, this.k.ae.y);
            }
        }
        if (this.i != null) {
            this.f = textLayoutArray;
        }
        graphics.dispose();
    }

    private static BasicStroke a(IlvText ilvText) {
        if (ilvText.getOutlineMode() == 0) {
            return null;
        }
        return new BasicStroke(ilvText.getOutlineThickness(), 1, 1);
    }

    private static void a(Graphics2D graphics2D, IlvText ilvText, TextLayout textLayout, float f2, float f3) {
        Shape shape = null;
        switch (ilvText.getOutlineMode()) {
            case 2048: 
            case 4096: 
            case 6144: {
                shape = textLayout.getOutline(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, f2, f3));
            }
        }
        if (shape == null) {
            graphics2D.setColor(ilvText.getForeground());
            textLayout.draw(graphics2D, f2, f3);
            return;
        }
        if (ilvText.getOutlineMode() == 2048) {
            graphics2D.setColor(ilvText.getOutlineColor());
            graphics2D.draw(shape);
            return;
        }
        if (ilvText.a() != null) {
            switch (ilvText.getOutlineMode()) {
                case 4096: {
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                    graphics2D.setColor(ilvText.getForeground());
                    textLayout.draw(graphics2D, f2, f3);
                    break;
                }
                case 6144: {
                    graphics2D.setColor(ilvText.getForeground());
                    textLayout.draw(graphics2D, f2, f3);
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                }
            }
        } else {
            switch (ilvText.getOutlineMode()) {
                case 4096: {
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                    graphics2D.setPaint(ilvText.getForeground());
                    graphics2D.fill(shape);
                    break;
                }
                case 6144: {
                    graphics2D.setPaint(ilvText.getForeground());
                    graphics2D.fill(shape);
                    graphics2D.setColor(ilvText.getOutlineColor());
                    graphics2D.draw(shape);
                }
            }
        }
    }

    private void a(Graphics2D graphics2D, double d2, double d3) {
        TextLayout textLayout = this.f[0];
        if (textLayout == null) {
            return;
        }
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d2 -= textLayout.isLeftToRight() ? 0.0 : (double)textLayout.getAdvance();
                break;
            }
            case 257: {
                d2 -= textLayout.isLeftToRight() ? (double)textLayout.getAdvance() : 0.0;
                break;
            }
            case 16: {
                d2 -= this.b().getWidth() / 2.0;
                d3 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
                break;
            }
            case 2: {
                d2 -= (double)textLayout.getAdvance();
            }
        }
        if (this.k.getOutlineMode() == 0) {
            IlvLayoutTextRenderer.a(graphics2D, this.k, textLayout, (float)d2, (float)d3);
        } else {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(IlvLayoutTextRenderer.a(this.k));
            IlvLayoutTextRenderer.a(graphics2D, this.k, textLayout, (float)d2, (float)d3);
            graphics2D.setStroke(stroke);
        }
    }

    private void b(Graphics2D graphics2D, double d2, double d3) {
        this.c();
        int n2 = this.e;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d3;
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d2 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d2 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d2 -= this.b.getWidth() / 2.0;
                d3 -= this.b.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d2 -= (double)this.d;
            }
        }
        Stroke stroke = null;
        if (this.k.getOutlineMode() != 0) {
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(IlvLayoutTextRenderer.a(this.k));
        }
        double d7 = this.k.getRotationAlignmentThresholdAngle();
        double d8 = 0.0;
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextLayout textLayout = this.f[i2];
            if (textLayout == null) continue;
            d5 = 0.0;
            if (i2 > 0) {
                d3 += (double)textLayout.getAscent();
            }
            switch (this.k.getAlignment()) {
                case 256: {
                    d4 = textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
                    break;
                }
                case 257: {
                    d4 = textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
                    break;
                }
                case 16: {
                    d4 = (this.d - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                case 1: {
                    d4 = 0.0;
                    break;
                }
                case 2: {
                    d4 = this.d - textLayout.getAdvance();
                }
            }
            if (d7 > 0.0 && this.e > 0) {
                float f2;
                float f3;
                IlvPoint ilvPoint = new IlvPoint(0.0f, (float)d6);
                IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d3);
                IlvTransformer ilvTransformer = this.k.getTransformer();
                IlvTransformer ilvTransformer2 = null;
                if (this.k.getRotationAlignmentAngle() != 0.0f) {
                    ilvTransformer2 = new IlvTransformer(ilvPoint, this.k.getRotationAlignmentAngle());
                }
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint);
                    ilvTransformer.apply(ilvPoint2);
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.inverse(ilvPoint);
                    ilvTransformer2.inverse(ilvPoint2);
                }
                if (!bl && d3 != d6) {
                    for (d8 = Math.atan2(ilvPoint2.y - ilvPoint.y, ilvPoint2.x - ilvPoint.x) / Math.PI * 180.0; d8 < 0.0; d8 += 180.0) {
                    }
                    while (d8 > 180.0) {
                        d8 -= 180.0;
                    }
                    bl = true;
                }
                if (d8 < 90.0 - d7 || d8 > 90.0 + d7) {
                    if (Math.abs(ilvPoint.x - ilvPoint2.x) > 0.0f) {
                        f3 = ilvPoint2.x - ilvPoint.x;
                        f2 = ilvPoint2.y - ilvPoint.y;
                        ilvPoint2.y = ilvPoint.y;
                        ilvPoint2.x += f2 * f2 / f3;
                    }
                } else if (Math.abs(ilvPoint.y - ilvPoint2.y) > 0.0f) {
                    f3 = ilvPoint2.y - ilvPoint.y;
                    f2 = ilvPoint2.x - ilvPoint.x;
                    ilvPoint2.x = ilvPoint.x;
                    ilvPoint2.y += f2 * f2 / f3;
                }
                if (ilvTransformer2 != null) {
                    ilvTransformer2.apply(ilvPoint2);
                }
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(ilvPoint2);
                }
                d4 += (double)ilvPoint2.x;
                d5 += (double)ilvPoint2.y - d3;
            }
            IlvLayoutTextRenderer.a(graphics2D, this.k, textLayout, (float)(d2 + d4), (float)(d3 + d5));
            d3 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
        if (this.k.getOutlineMode() != 0) {
            graphics2D.setStroke(stroke);
        }
    }

    public final Rectangle2D getBounds() {
        this.i();
        this.c();
        double d2 = this.k.getRotationAlignmentThresholdAngle();
        if (d2 > 0.0 && this.e > 1) {
            this.d();
            return this.c;
        }
        return this.b;
    }

    private final Rectangle2D b() {
        this.i();
        this.c();
        return this.b;
    }

    private void c() {
        if (this.b != null) {
            return;
        }
        this.b = this.i != null ? this.a(false) : this.b(false);
    }

    private void d() {
        if (this.c != null) {
            return;
        }
        this.c = this.i != null ? this.a(true) : this.b(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle2D a(boolean bl) {
        Rectangle2D rectangle2D = this.b(bl);
        AffineTransform affineTransform = new AffineTransform(100.0f, 0.0f, 0.0f, 100.0f, 0.0f, 0.0f);
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, this.k.isAntialiasing(), this.k.isFractionalMetrics());
        TextLayout[] textLayoutArray = this.f;
        try {
            this.f = this.a(fontRenderContext);
            Rectangle2D rectangle2D2 = this.b(bl);
            rectangle2D = rectangle2D.createUnion(rectangle2D2);
        }
        finally {
            this.f = textLayoutArray;
        }
        return rectangle2D;
    }

    private Rectangle2D b(boolean bl) {
        if (bl) {
            return this.f();
        }
        return this.e();
    }

    private Rectangle2D e() {
        TextLayout textLayout;
        this.d = 0.0f;
        int n2 = this.e;
        for (int i2 = 0; i2 < n2; ++i2) {
            textLayout = this.f[i2];
            if (textLayout == null) continue;
            this.d = Math.max(this.d, textLayout.getAdvance());
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i3 = 0; i3 < n2; ++i3) {
            textLayout = this.f[i3];
            if (textLayout == null) continue;
            if (i3 == 0) {
                d4 = Math.min(d4, (double)(-textLayout.getAscent()));
            } else {
                d6 += (double)textLayout.getAscent();
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            d2 = Math.min(d2, rectangle2D.getX());
            d3 = Math.max(d3, rectangle2D.getX() + rectangle2D.getWidth());
            d4 = Math.min(d4, d6 + rectangle2D.getY());
            d5 = Math.max(d5, d6 + rectangle2D.getY() + rectangle2D.getHeight());
            d6 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
        d3 = Math.max(d3, (double)this.d);
        d5 = Math.max(d5, d6);
        double d7 = d3 - d2;
        double d8 = d5 - d4;
        d2 += (double)this.k.ae.x;
        d4 += (double)this.k.ae.y;
        TextLayout textLayout2 = textLayout = this.f.length == 0 ? null : this.f[0];
        if (textLayout != null) {
            switch (this.k.getAnchorPosition()) {
                case 256: {
                    d2 -= textLayout.isLeftToRight() ? 0.0 : (double)this.d;
                    break;
                }
                case 257: {
                    d2 -= textLayout.isLeftToRight() ? (double)this.d : 0.0;
                    break;
                }
                case 16: {
                    if (n2 == 1) {
                        d2 -= d7 / 2.0;
                        d4 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
                        break;
                    }
                    d2 -= d7 / 2.0;
                    d4 -= d8 / 2.0 - (double)this.f[0].getAscent();
                    break;
                }
                case 2: {
                    d2 -= (double)this.d;
                }
            }
        }
        return new Rectangle2D.Double(d2, d4, d7, d8);
    }

    private Rectangle2D f() {
        TextLayout textLayout;
        if (this.b == null) {
            throw new RuntimeException("Illegal situation");
        }
        double d2 = this.k.getRotationAlignmentThresholdAngle();
        double d3 = 0.0;
        boolean bl = false;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n2 = this.e;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2;
            float f3;
            textLayout = this.f[i2];
            if (textLayout == null) continue;
            if (i2 == 0) {
                d6 = Math.min(d6, (double)(-textLayout.getAscent()));
            } else {
                d8 += (double)textLayout.getAscent();
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            double d9 = 0.0;
            double d10 = 0.0;
            switch (this.k.getAlignment()) {
                case 256: {
                    d10 = textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
                    break;
                }
                case 257: {
                    d10 = textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
                    break;
                }
                case 16: {
                    d10 = (this.d - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                case 1: {
                    d10 = 0.0;
                    break;
                }
                case 2: {
                    d10 = this.d - textLayout.getAdvance();
                }
            }
            IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
            IlvPoint ilvPoint2 = new IlvPoint(0.0f, (float)d8);
            IlvTransformer ilvTransformer = this.k.getTransformer();
            IlvTransformer ilvTransformer2 = null;
            if (this.k.getRotationAlignmentAngle() != 0.0f) {
                ilvTransformer2 = new IlvTransformer(ilvPoint, this.k.getRotationAlignmentAngle());
            }
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
                ilvTransformer.apply(ilvPoint2);
            }
            if (ilvTransformer2 != null) {
                ilvTransformer2.inverse(ilvPoint);
                ilvTransformer2.inverse(ilvPoint2);
            }
            if (!bl && d8 != 0.0) {
                for (d3 = Math.atan2(ilvPoint2.y - ilvPoint.y, ilvPoint2.x - ilvPoint.x) / Math.PI * 180.0; d3 < 0.0; d3 += 180.0) {
                }
                while (d3 > 180.0) {
                    d3 -= 180.0;
                }
                bl = true;
            }
            if (d3 < 90.0 - d2 || d3 > 90.0 + d2) {
                if (Math.abs(ilvPoint.x - ilvPoint2.x) > 0.0f) {
                    f3 = ilvPoint2.x - ilvPoint.x;
                    f2 = ilvPoint2.y - ilvPoint.y;
                    ilvPoint2.y = ilvPoint.y;
                    ilvPoint2.x += f2 * f2 / f3;
                }
            } else if (Math.abs(ilvPoint.y - ilvPoint2.y) > 0.0f) {
                f3 = ilvPoint2.y - ilvPoint.y;
                f2 = ilvPoint2.x - ilvPoint.x;
                ilvPoint2.x = ilvPoint.x;
                ilvPoint2.y += f2 * f2 / f3;
            }
            if (ilvTransformer2 != null) {
                ilvTransformer2.apply(ilvPoint2);
            }
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint2);
            }
            d4 = Math.min(d4, (d10 += (double)ilvPoint2.x) + rectangle2D.getX());
            d5 = Math.max(d5, d10 + rectangle2D.getX() + rectangle2D.getWidth());
            d6 = Math.min(d6, (d9 += (double)ilvPoint2.y - d8) + d8 + rectangle2D.getY());
            d7 = Math.max(d7, d9 + d8 + rectangle2D.getY() + rectangle2D.getHeight());
            d8 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
        d5 = Math.max(d5, (double)this.d);
        d7 = Math.max(d7, d8);
        double d11 = d5 - d4;
        double d12 = d7 - d6;
        d4 += (double)this.k.ae.x;
        d6 += (double)this.k.ae.y;
        TextLayout textLayout2 = textLayout = this.f.length == 0 ? null : this.f[0];
        if (textLayout != null) {
            switch (this.k.getAnchorPosition()) {
                case 256: {
                    d4 -= textLayout.isLeftToRight() ? 0.0 : (double)this.d;
                    break;
                }
                case 257: {
                    d4 -= textLayout.isLeftToRight() ? (double)this.d : 0.0;
                    break;
                }
                case 16: {
                    if (n2 == 1) {
                        d4 -= d11 / 2.0;
                        d6 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
                        break;
                    }
                    d4 -= d11 / 2.0;
                    d6 -= d12 / 2.0 - (double)this.f[0].getAscent();
                    break;
                }
                case 2: {
                    d4 -= (double)this.d;
                }
            }
        }
        return new Rectangle2D.Double(d4, d6, d11, d12);
    }

    private final FontRenderContext g() {
        if (this.g == null) {
            this.g = new FontRenderContext(null, this.k.isAntialiasing(), this.k.isFractionalMetrics());
        }
        return this.g;
    }

    private final TextLayout h() {
        if (this.h == null) {
            this.h = new TextLayout("\u2026", this.k.getFont(), this.g());
        }
        return this.h;
    }

    private void i() {
        if (this.a) {
            return;
        }
        int n2 = 0;
        boolean bl = this.k.a() == null;
        HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>();
        hashMap.put(TextAttribute.FONT, this.k.getFont());
        if (this.k.isStrikethrough()) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.k.isUnderline()) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        Object[] objectArray = IlvLayoutTextRenderer.a(this.k.getLabel(), this.k.a());
        String[] stringArray = (String[])objectArray[0];
        AttributedString[] attributedStringArray = (AttributedString[])objectArray[1];
        int n3 = stringArray.length;
        FontRenderContext fontRenderContext = this.g();
        float f2 = this.k.getWrappingWidth();
        if (Float.isNaN(f2)) {
            f2 = 100.0f;
        }
        switch (this.k.getWrappingMode()) {
            case 1: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList2 = this.i != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                for (int i2 = 0; i2 < n3; ++i2) {
                    String string = stringArray[i2];
                    AttributedString attributedString = attributedStringArray[i2];
                    IlvLayoutTextRenderer.a(attributedString, hashMap);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), breakIterator, fontRenderContext);
                    int n4 = string.length();
                    int n5 = 0;
                    while (n5 < n4) {
                        TextLayout textLayout;
                        int n6;
                        int n7 = lineBreakMeasurer.nextOffset(f2, n4, true);
                        if (n7 == n5) {
                            n7 = n6 = breakIterator.following(n5);
                        }
                        n6 = n7;
                        while (--n6 > n5 && Character.isSpaceChar(string.charAt(n6))) {
                        }
                        if (arrayList2 != null) {
                            TextLayoutCreationInfo textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string.substring(n5, n6 + 1), hashMap) : new TextLayoutCreationInfo(attributedString.getIterator(null, n5, n6 + 1));
                            textLayout = textLayoutCreationInfo.a(fontRenderContext);
                            arrayList2.add(textLayoutCreationInfo);
                        } else {
                            textLayout = bl ? new TextLayout(string.substring(n5, n6 + 1), hashMap, fontRenderContext) : new TextLayout(attributedString.getIterator(null, n5, n6 + 1), fontRenderContext);
                        }
                        arrayList.add(textLayout);
                        arrayList3.add(new Integer(n2 + n5));
                        lineBreakMeasurer.setPosition(n7);
                        n5 = n7;
                    }
                    n2 += n4 + 1;
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                this.j = arrayList3.toArray(new Integer[this.e]);
                if (arrayList2 == null) break;
                this.i.a = arrayList2.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            case 2: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList4 = this.i != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                TextLayout textLayout = this.h();
                TextLayout textLayout2 = null;
                TextLayoutCreationInfo textLayoutCreationInfo = null;
                String string = null;
                AttributedString attributedString = null;
                float f3 = 0.0f;
                boolean bl2 = false;
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n8;
                    TextMeasurer textMeasurer;
                    if (i3 > 0) {
                        f3 += textLayout2.getAscent();
                    }
                    String string2 = stringArray[i3];
                    AttributedString attributedString2 = attributedStringArray[i3];
                    IlvLayoutTextRenderer.a(attributedString2, hashMap);
                    if (arrayList4 != null) {
                        textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string2, hashMap) : new TextLayoutCreationInfo(attributedString2.getIterator());
                        textLayout2 = textLayoutCreationInfo.a(fontRenderContext);
                    } else {
                        textLayout2 = bl ? new TextLayout(string2, hashMap, fontRenderContext) : new TextLayout(attributedString2.getIterator(), fontRenderContext);
                    }
                    boolean bl3 = false;
                    if (textLayout2.getAdvance() > f2) {
                        bl3 = true;
                        textMeasurer = new TextMeasurer(attributedString2.getIterator(), fontRenderContext);
                        n8 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                        if (n8 == -1) {
                            attributedString2 = new AttributedString(" ");
                            string2 = " ";
                        } else {
                            attributedString2 = IlvLayoutTextRenderer.a(string2, attributedString2, n8);
                            string2 = IlvLayoutTextRenderer.a(string2, n8);
                        }
                        if (arrayList4 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string2, hashMap) : new TextLayoutCreationInfo(attributedString2.getIterator());
                            textLayout2 = textLayoutCreationInfo.a(fontRenderContext);
                        } else {
                            TextLayout textLayout3 = textLayout2 = bl ? new TextLayout(string2, hashMap, fontRenderContext) : new TextLayout(attributedString2.getIterator(), fontRenderContext);
                        }
                    }
                    if ((f3 += textLayout2.getDescent() + this.a(textLayout2)) < this.k.getWrappingHeight()) {
                        arrayList.add(textLayout2);
                        if (arrayList4 != null) {
                            arrayList4.add(textLayoutCreationInfo);
                        }
                    } else {
                        if (bl2 || string == null) break;
                        string2 = string;
                        attributedString2 = attributedString;
                        textMeasurer = new TextMeasurer(attributedString2.getIterator(), fontRenderContext);
                        n8 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                        if (n8 == -1) {
                            attributedString2 = new AttributedString(" ");
                            string2 = " ";
                        } else {
                            attributedString2 = bl ? null : IlvLayoutTextRenderer.a(string2, attributedString2, n8);
                            string2 = IlvLayoutTextRenderer.a(string2, n8);
                        }
                        if (arrayList4 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string2, hashMap) : new TextLayoutCreationInfo(attributedString2.getIterator());
                            textLayout2 = textLayoutCreationInfo.a(fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout2);
                            arrayList4.set(arrayList4.size() - 1, textLayoutCreationInfo);
                        } else {
                            textLayout2 = bl ? new TextLayout(string2, hashMap, fontRenderContext) : new TextLayout(attributedString2.getIterator(), fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout2);
                        }
                        bl2 = true;
                        break;
                    }
                    bl2 = bl3;
                    string = string2;
                    attributedString = attributedString2;
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                if (arrayList4 == null) break;
                this.i.a = arrayList4.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            case 3: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList5 = this.i != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                TextLayout textLayout = this.h();
                TextLayout textLayout4 = null;
                TextLayoutCreationInfo textLayoutCreationInfo = null;
                String string = null;
                AttributedString attributedString = null;
                float f4 = 0.0f;
                boolean bl4 = false;
                block9: for (int i4 = 0; i4 < n3; ++i4) {
                    String string3 = stringArray[i4];
                    AttributedString attributedString3 = attributedStringArray[i4];
                    IlvLayoutTextRenderer.a(attributedString3, hashMap);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString3.getIterator(), breakIterator, fontRenderContext);
                    int n9 = string3.length();
                    int n10 = 0;
                    int n11 = -1;
                    while (n10 < n9) {
                        int n12;
                        TextMeasurer textMeasurer;
                        int n13;
                        if (i4 > 0 || n11 != -1) {
                            f4 += textLayout4.getAscent();
                        }
                        if ((n13 = lineBreakMeasurer.nextOffset(f2, n9, true)) == n10) {
                            n13 = n11 = breakIterator.following(n10);
                        }
                        n11 = n13;
                        while (--n11 > n10 && Character.isSpaceChar(string3.charAt(n11))) {
                        }
                        String string4 = string3.substring(n10, n11 + 1);
                        AttributedString attributedString4 = new AttributedString(attributedString3.getIterator(null, n10, n11 + 1));
                        if (arrayList5 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string4, hashMap) : new TextLayoutCreationInfo(attributedString4.getIterator());
                            textLayout4 = textLayoutCreationInfo.a(fontRenderContext);
                        } else {
                            textLayout4 = bl ? new TextLayout(string4, hashMap, fontRenderContext) : new TextLayout(attributedString4.getIterator(), fontRenderContext);
                        }
                        boolean bl5 = false;
                        if (textLayout4.getAdvance() > f2) {
                            bl5 = true;
                            textMeasurer = new TextMeasurer(attributedString4.getIterator(), fontRenderContext);
                            n12 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                            if (n12 == -1) {
                                attributedString4 = new AttributedString(" ");
                                string4 = " ";
                            } else {
                                attributedString4 = IlvLayoutTextRenderer.a(string4, attributedString4, n12);
                                string4 = IlvLayoutTextRenderer.a(string4, n12);
                            }
                            if (arrayList5 != null) {
                                textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string4, hashMap) : new TextLayoutCreationInfo(attributedString4.getIterator());
                                textLayout4 = textLayoutCreationInfo.a(fontRenderContext);
                            } else {
                                TextLayout textLayout5 = textLayout4 = bl ? new TextLayout(string4, hashMap, fontRenderContext) : new TextLayout(attributedString4.getIterator(), fontRenderContext);
                            }
                        }
                        if ((f4 += textLayout4.getDescent() + this.a(textLayout4)) < this.k.getWrappingHeight()) {
                            arrayList.add(textLayout4);
                            if (arrayList5 != null) {
                                arrayList5.add(textLayoutCreationInfo);
                            }
                            bl4 = bl5;
                            string = string4;
                            attributedString = attributedString4;
                            lineBreakMeasurer.setPosition(n13);
                            n10 = n13;
                            continue;
                        }
                        i4 = n3;
                        if (bl4 || string == null) continue block9;
                        string3 = string;
                        attributedString3 = attributedString;
                        textMeasurer = new TextMeasurer(attributedString3.getIterator(), fontRenderContext);
                        n12 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                        if (n12 == -1) {
                            attributedString3 = new AttributedString(" ");
                            string3 = " ";
                        } else {
                            attributedString3 = IlvLayoutTextRenderer.a(string3, attributedString3, n12);
                            string3 = IlvLayoutTextRenderer.a(string3, n12);
                        }
                        if (arrayList5 != null) {
                            textLayoutCreationInfo = bl ? new TextLayoutCreationInfo(string3, hashMap) : new TextLayoutCreationInfo(attributedString3.getIterator());
                            textLayout4 = textLayoutCreationInfo.a(fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout4);
                            arrayList5.set(arrayList5.size() - 1, textLayoutCreationInfo);
                        } else {
                            textLayout4 = bl ? new TextLayout(string3, hashMap, fontRenderContext) : new TextLayout(attributedString3.getIterator(), fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout4);
                        }
                        bl4 = true;
                        continue block9;
                    }
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                if (arrayList5 == null) break;
                this.i.a = arrayList5.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            default: {
                this.e = stringArray.length;
                this.f = new TextLayout[n3];
                this.j = new Integer[n3];
                if (this.i != null) {
                    this.i.a = new TextLayoutCreationInfo[n3];
                }
                for (int i5 = 0; i5 < n3; ++i5) {
                    AttributedString attributedString;
                    String string = stringArray[i5];
                    if (bl) {
                        attributedString = null;
                    } else {
                        attributedString = attributedStringArray[i5];
                        IlvLayoutTextRenderer.a(attributedString, hashMap);
                    }
                    if (string.length() > 0) {
                        if (this.i != null) {
                            this.i.a[i5] = bl ? new TextLayoutCreationInfo(string, hashMap) : new TextLayoutCreationInfo(attributedString.getIterator());
                        }
                        this.f[i5] = bl ? new TextLayout(string, hashMap, fontRenderContext) : new TextLayout(attributedString.getIterator(), fontRenderContext);
                    } else {
                        if (this.i != null) {
                            this.i.a[i5] = null;
                        }
                        this.f[i5] = null;
                    }
                    this.j[i5] = new Integer(n2);
                    n2 += string.length() + 1;
                }
            }
        }
        this.a = true;
        this.b = null;
    }

    private static void a(AttributedString attributedString, Map map) {
        int n2;
        if (map == null || attributedString == null || map.size() == 0) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n3 = attributedCharacterIterator.getBeginIndex();
        if (n3 < (n2 = attributedCharacterIterator.getEndIndex())) {
            Set set = map.keySet();
            int n4 = n3;
            while (true) {
                attributedCharacterIterator.setIndex(n4);
                int n5 = attributedCharacterIterator.getRunLimit(set);
                Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
                if (map2 == null) {
                    attributedString.addAttributes(map, n4, n5);
                } else {
                    HashMap hashMap = null;
                    for (Map.Entry entry : map.entrySet()) {
                        AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)entry.getKey();
                        if (map2.containsKey(attribute)) continue;
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        hashMap.put(attribute, entry.getValue());
                    }
                    if (hashMap != null) {
                        attributedString.addAttributes(hashMap, n4, n5);
                    }
                }
                if (n5 >= n2) break;
                n4 = n5;
            }
        }
    }

    private static String a(String string, int n2) {
        return string.substring(0, n2) + "\u2026";
    }

    private static AttributedString a(String string, AttributedString attributedString, int n2) {
        if (n2 > 0) {
            return IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n2), "\u2026");
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        attributedCharacterIterator.first();
        return new AttributedString("\u2026", attributedCharacterIterator.getAttributes());
    }

    private static Object[] a(String string, AttributedString attributedString) {
        int n2;
        int n3 = string.length();
        int n4 = 1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (string.charAt(n2) != '\n') continue;
            ++n4;
        }
        String[] stringArray = new String[n4];
        AttributedString[] attributedStringArray = new AttributedString[n4];
        if (n4 == 1) {
            if (string.length() == 0) {
                stringArray[0] = " ";
                attributedStringArray[0] = new AttributedString(" ");
            } else {
                stringArray[0] = string;
                attributedStringArray[0] = attributedString == null ? new AttributedString(stringArray[0]) : new AttributedString(attributedString.getIterator());
            }
        } else {
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = string.indexOf(10, n5);
                if (n6 == -1) {
                    n6 = n3;
                }
                if (n6 == n5) {
                    stringArray[n2] = " ";
                    attributedStringArray[n2] = new AttributedString(" ");
                } else {
                    stringArray[n2] = string.substring(n5, n6);
                    attributedStringArray[n2] = attributedString == null ? new AttributedString(stringArray[n2]) : new AttributedString(attributedString.getIterator(), n5, n6);
                }
                n5 = n6 + 1;
            }
        }
        return new Object[]{stringArray, attributedStringArray};
    }

    private float a(TextLayout textLayout) {
        if (this.k.getInterlineSpacing() != -1.0f) {
            return this.k.getInterlineSpacing();
        }
        return textLayout.getLeading();
    }

    public void invalidate(boolean bl, boolean bl2) {
        this.b = null;
        this.c = null;
        if (bl2) {
            this.a = false;
            this.j();
        }
        if (bl) {
            this.h = null;
            this.g = null;
        }
    }

    private TextLayout[] a(FontRenderContext fontRenderContext) {
        InfoForFRCDependentTreatment infoForFRCDependentTreatment = this.i;
        if (fontRenderContext.equals(infoForFRCDependentTreatment.b[0])) {
            infoForFRCDependentTreatment.d = true;
            return infoForFRCDependentTreatment.c[0];
        }
        if (fontRenderContext.equals(infoForFRCDependentTreatment.b[1])) {
            infoForFRCDependentTreatment.d = false;
            return infoForFRCDependentTreatment.c[1];
        }
        int n2 = infoForFRCDependentTreatment.d ? 1 : 0;
        infoForFRCDependentTreatment.b[n2] = fontRenderContext;
        TextLayout[] textLayoutArray = new TextLayout[infoForFRCDependentTreatment.a.length];
        for (int i2 = 0; i2 < textLayoutArray.length; ++i2) {
            if (infoForFRCDependentTreatment.a[i2] == null) continue;
            textLayoutArray[i2] = infoForFRCDependentTreatment.a[i2].a(fontRenderContext);
        }
        infoForFRCDependentTreatment.c[n2] = textLayoutArray;
        return textLayoutArray;
    }

    private void j() {
        InfoForFRCDependentTreatment infoForFRCDependentTreatment = this.i;
        if (infoForFRCDependentTreatment == null) {
            return;
        }
        infoForFRCDependentTreatment.b[1] = null;
        infoForFRCDependentTreatment.b[0] = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextLayoutCreationInfo {
        private String a;
        private Map<? extends AttributedCharacterIterator.Attribute, ?> b;
        private AttributedString c;

        TextLayoutCreationInfo(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
            this.a = string;
            this.b = map;
            this.c = null;
        }

        TextLayoutCreationInfo(AttributedCharacterIterator attributedCharacterIterator) {
            this.a = null;
            this.b = null;
            this.c = new AttributedString(attributedCharacterIterator);
        }

        TextLayout a(FontRenderContext fontRenderContext) {
            if (this.a != null) {
                return new TextLayout(this.a, this.b, fontRenderContext);
            }
            return new TextLayout(this.c.getIterator(), fontRenderContext);
        }
    }

    static class InfoForFRCDependentTreatment {
        transient TextLayoutCreationInfo[] a;
        transient FontRenderContext[] b = new FontRenderContext[2];
        transient TextLayout[][] c = new TextLayout[2][];
        transient boolean d;

        InfoForFRCDependentTreatment() {
        }
    }
}

