/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.IlvTransformer;
import ilog.views.event.GraphicBagHierarchyEvent;
import ilog.views.event.GraphicBagHierarchyEventReceiver;
import ilog.views.event.GraphicBagHierarchyListener;
import ilog.views.event.IlvListenerList;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.event.ManagerViewsHierarchyEventReceiver;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JPopupMenu;

public class IlvGraphicSet
extends IlvGraphic
implements IlvGraphicBag,
GraphicBagHierarchyEventReceiver,
ManagerViewsHierarchyEventReceiver {
    private HashMap a;
    private float b = 1.0f;
    private boolean c;
    private boolean d;
    private IlvListenerList e;
    private IlvListenerList f;
    private int g = 0;
    protected IlvGraphicVector list = new IlvGraphicVector(10);

    public IlvGraphicSet() {
    }

    public IlvGraphicSet(IlvGraphicSet ilvGraphicSet) {
        this(ilvGraphicSet, true);
    }

    public IlvGraphicSet(IlvGraphicSet ilvGraphicSet, boolean bl) {
        super(ilvGraphicSet);
        if (bl) {
            int n2 = ilvGraphicSet.list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvGraphic ilvGraphic = ilvGraphicSet.list.elementAt(i2);
                IlvGraphic ilvGraphic2 = ilvGraphic.copy();
                if (ilvGraphic2 == null) continue;
                this.addObject(ilvGraphic2, false);
                String string = ilvGraphicSet.getObjectName(ilvGraphic);
                if (string == null) continue;
                this.setObjectName(ilvGraphic2, string);
            }
        }
        this.setClip(ilvGraphicSet.getClip());
        this.setAlpha(ilvGraphicSet.getAlpha());
    }

    public IlvGraphicSet(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        IlvGraphic[] ilvGraphicArray = ilvInputStream.readObjects("objects");
        for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
            this.addObject(ilvGraphicArray[i2], false);
        }
        try {
            this.setClip(ilvInputStream.readShape("clip", "clipRule"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setAlpha(ilvInputStream.readFloat("alpha"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        Object object;
        this.a(this.getGraphicBag(), 2);
        IlvGraphicBag ilvGraphicBag2 = null;
        if (this.needsGraphicBagHierarchyEvent()) {
            ilvGraphicBag2 = this.a();
        }
        super.setGraphicBag(ilvGraphicBag);
        if (ilvGraphicBag instanceof GraphicBagHierarchyEventReceiver && this.needsGraphicBagHierarchyEvent()) {
            object = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag);
            object.enableGraphicBagHierarchyEventForwarding();
        }
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver && this.needsManagerViewsHierarchyEvent()) {
            object = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            object.enableManagerViewsHierarchyEventForwarding();
        }
        this.a(this.getGraphicBag(), 1);
        this.a(ilvGraphicBag2);
    }

    public void addObject(IlvGraphic ilvGraphic, boolean bl) {
        this.addObjectAt(ilvGraphic, -1, bl);
    }

    public void addObjectAt(IlvGraphic ilvGraphic, int n2, boolean bl) {
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("cannot add null");
        }
        if (ilvGraphic == this || this.getTopLevelGraphicBag() == ilvGraphic) {
            throw new IllegalArgumentException("cannot create circularity");
        }
        if (ilvGraphic.getGraphicBag() != null) {
            throw new IllegalArgumentException("object already in a bag");
        }
        if (this.getGraphicBag() != null && this.g == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            final int n3 = n2;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, n3, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, n2, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, int n2, boolean bl) {
        ilvGraphic.setGraphicBag(this);
        if (n2 < 0) {
            this.list.addElement(ilvGraphic);
        } else {
            this.list.insertElementAt(ilvGraphic, n2);
        }
        String string = ilvGraphic.getName();
        if (string != null) {
            this.setObjectName(ilvGraphic, string);
        }
        this.invalidateBBoxCache();
        if (bl) {
            this.reDrawObj(ilvGraphic);
        }
    }

    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic.getGraphicBag() != this) {
            throw new IllegalArgumentException("object not in this bag");
        }
        if (this.getGraphicBag() != null && this.g == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, boolean bl) {
        Object object;
        IlvRegion ilvRegion = null;
        if (bl && ilvGraphic.isVisible() && this.getGraphicBag() != null) {
            object = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add((IlvRect)object);
        }
        ilvGraphic.setGraphicBag(null);
        if (this.a != null && (object = this.getObjectName(ilvGraphic)) != null) {
            this.a.remove(object);
        }
        this.list.removeElement(ilvGraphic);
        this.invalidateBBoxCache();
        if (ilvRegion != null && this.getGraphicBag() != null) {
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public void removeObjectAt(int n2, boolean bl) {
        this.removeObject(this.getObject(n2), bl);
    }

    public void removeAll(boolean bl) {
        if (this.getGraphicBag() != null && this.g == 0) {
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(false);
                }
            }, null, bl);
        } else {
            this.a(bl);
        }
    }

    private void a(boolean bl) {
        IlvRect ilvRect = bl && this.getGraphicBag() != null && this.isVisible() ? this.boundingBox(null) : null;
        this.a = null;
        if (this.list != null) {
            this.list.removeAllElements();
        }
        this.invalidateBBoxCache();
        if (ilvRect != null) {
            IlvRegion ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public final IlvGraphic getObject(int n2) {
        return this.list.elementAt(n2);
    }

    public final int getIndex(IlvGraphic ilvGraphic) {
        return this.list.indexOf(ilvGraphic);
    }

    public final boolean contains(IlvGraphic ilvGraphic) {
        return ilvGraphic.getGraphicBag() == this;
    }

    public final IlvGraphicEnumeration getObjects() {
        return this.list.elements();
    }

    public final int getCardinal() {
        return this.list.size();
    }

    public void reDrawObj(IlvGraphic ilvGraphic) {
        if (!ilvGraphic.isVisible()) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag != null) {
            IlvRect ilvRect = ilvGraphic.boundingBox(null);
            IlvRegion ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
            ilvGraphicBag.reDrawRegion(ilvRegion);
        }
    }

    public void reDrawRegion(IlvRegion ilvRegion) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag != null) {
            ilvGraphicBag.reDrawRegion(ilvRegion);
        }
    }

    public void reshapeObject(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        if (this.getGraphicBag() != null && this.g == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            final IlvRect ilvRect2 = ilvRect;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, ilvRect2, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, ilvRect, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        IlvRect ilvRect2;
        IlvRegion ilvRegion = null;
        if (ilvGraphic.isVisible() && bl && this.getGraphicBag() != null) {
            ilvRect2 = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect2);
        }
        ilvGraphic.move(ilvRect.x, ilvRect.y);
        ilvGraphic.resize(ilvRect.width, ilvRect.height);
        this.invalidateBBoxCache();
        if (ilvRegion != null) {
            ilvRect2 = ilvGraphic.boundingBox(null);
            ilvRegion.add(ilvRect2);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public void moveObject(IlvGraphic ilvGraphic, float f2, float f3, boolean bl) {
        if (this.getGraphicBag() != null && this.g == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            final float f4 = f2;
            final float f5 = f3;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, f4, f5, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, f2, f3, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, float f2, float f3, boolean bl) {
        IlvRect ilvRect;
        IlvRegion ilvRegion = null;
        if (ilvGraphic.isVisible() && bl && this.getGraphicBag() != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
        }
        ilvGraphic.move(f2, f3);
        this.invalidateBBoxCache();
        if (ilvRegion != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion.add(ilvRect);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyToObject(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        boolean bl2 = ilvGraphic.setInApplyToObject(true);
        try {
            if (bl2 && this.getGraphicBag() != null) {
                final IlvGraphic ilvGraphic2 = ilvGraphic;
                final IlvApplyObject ilvApplyObject2 = ilvApplyObject;
                this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        IlvGraphicSet.this.a(ilvGraphic2, ilvApplyObject2, object, false);
                    }
                }, object, bl);
            } else {
                this.a(ilvGraphic, ilvApplyObject, object, bl);
            }
        }
        finally {
            ilvGraphic.setInApplyToObject(false);
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        IlvRect ilvRect;
        IlvRegion ilvRegion = null;
        boolean bl2 = ilvGraphic.isVisible();
        if (bl2 && bl && this.getGraphicBag() != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
        }
        ilvApplyObject.apply(ilvGraphic, object);
        this.invalidateBBoxCache();
        if ((bl2 || bl2 != ilvGraphic.isVisible()) && bl && this.getGraphicBag() != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            if (ilvRegion == null) {
                ilvRegion = new IlvRegion();
            }
            ilvRegion.add(ilvRect);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public IlvGraphic copy() {
        return new IlvGraphicSet(this);
    }

    public IlvGraphic getObject(String string) {
        if (this.a == null) {
            return null;
        }
        return (IlvGraphic)this.a.get(string);
    }

    public String getObjectName(IlvGraphic ilvGraphic) {
        return ilvGraphic.getName();
    }

    public boolean setObjectName(IlvGraphic ilvGraphic, String string) {
        String string2 = ilvGraphic.getName();
        if (string != null) {
            IlvGraphic ilvGraphic2;
            IlvGraphic ilvGraphic3 = ilvGraphic2 = this.a == null ? null : (IlvGraphic)this.a.get(string);
            if (ilvGraphic2 != null) {
                if (ilvGraphic2 == ilvGraphic) {
                    if (string.equals(string2)) {
                        return true;
                    }
                    ilvGraphic.setNameImpl(string);
                    return true;
                }
                if (string2 != null) {
                    if (string.equals(string2)) {
                        ilvGraphic.setNameImpl(null);
                        return false;
                    }
                    IlvGraphic ilvGraphic4 = ilvGraphic2 = this.a == null ? null : (IlvGraphic)this.a.get(string2);
                    if (ilvGraphic2 != null) {
                        if (ilvGraphic2 == ilvGraphic) {
                            return false;
                        }
                        ilvGraphic.setNameImpl(null);
                    }
                }
                return false;
            }
            if (string2 != null && this.a != null && (ilvGraphic2 = (IlvGraphic)this.a.get(string2)) == ilvGraphic) {
                this.a.remove(string2);
                if (this.a.size() == 0) {
                    this.a = null;
                }
            }
            ilvGraphic.setNameImpl(string);
            if (this.a == null) {
                this.a = new HashMap(10);
            }
            this.a.put(string, ilvGraphic);
        } else {
            if (string2 != null && this.a != null && this.a.get(string2) == ilvGraphic) {
                if (this.a.size() == 0) {
                    this.a = null;
                }
                this.a.remove(string2);
            }
            ilvGraphic.setNameImpl(null);
        }
        return true;
    }

    public void setClip(Shape shape) {
        this.setProperty("__ClipProperty", shape);
    }

    public Shape getClip() {
        return (Shape)this.getProperty("__ClipProperty");
    }

    public void setAlpha(float f2) {
        if (f2 > 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0,1.0]");
        }
        this.b = f2;
    }

    public float getAlpha() {
        return this.b;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getAlpha();
        boolean bl = false;
        Composite composite = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f2 != 1.0f) {
            composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite && composite != AlphaComposite.Xor) {
                bl = true;
            }
            if (bl) {
                IlvUtility2D.SetAlphaComposite(graphics, f2);
            }
        }
        if (bl) {
            this.b = 1.0f;
            IlvDrawWithBufferedImage.drawWithBufferedImage(this, graphics2D, ilvTransformer);
            this.b = f2;
        } else {
            this.drawCore(graphics2D, ilvTransformer);
        }
        if (bl && f2 != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    protected void drawCore(Graphics2D graphics2D, IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        Shape shape;
        Shape shape2 = null;
        Shape shape3 = this.getClip();
        if (shape3 != null) {
            shape2 = IlvGraphicUtil.AddClip(graphics2D, IlvGraphicUtil.CreateTransformedShape(shape3, ilvTransformer));
        }
        Rectangle rectangle = (shape = graphics2D.getClip()) != null ? shape.getBounds() : null;
        IlvRect ilvRect2 = ilvRect = rectangle != null ? new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : null;
        if (ilvRect != null) {
            IlvRect ilvRect3 = new IlvRect(ilvRect);
            if (ilvTransformer != null) {
                ilvTransformer.boundingBox(ilvRect3, true);
            }
            int n2 = this.list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvGraphic ilvGraphic = this.list.elementAt(i2);
                if (!ilvGraphic.isVisible() || !ilvGraphic.intersects(ilvRect3, ilvRect, ilvTransformer)) continue;
                ilvGraphic.callDraw(graphics2D, ilvTransformer);
            }
        } else {
            int n3 = this.list.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                IlvGraphic ilvGraphic = this.list.elementAt(i3);
                if (!ilvGraphic.isVisible()) continue;
                ilvGraphic.callDraw(graphics2D, ilvTransformer);
            }
        }
        if (shape3 != null) {
            graphics2D.setClip(shape2);
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.getClip() != null) {
            this.setClip(IlvGraphicUtil.CreateTransformedShape(this.getClip(), ilvTransformer));
        }
        int n2 = this.list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            ilvGraphic.applyTransform(ilvTransformer);
        }
        this.invalidateBBoxCache();
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = null;
        int n2 = this.list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (!ilvGraphic.isVisible()) continue;
            IlvRect ilvRect2 = ilvGraphic.boundingBox(ilvTransformer);
            if (ilvRect == null) {
                ilvRect = ilvRect2;
                continue;
            }
            ilvRect.add(ilvRect2);
        }
        if (ilvRect == null) {
            ilvRect = new IlvRect();
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    public boolean zoomable() {
        int n2 = this.list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (ilvGraphic.zoomable()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.getClip() != null && !IlvGraphicUtil.PointInShape(ilvPoint, this.getClip())) {
            return false;
        }
        return this.firstContains(ilvPoint, ilvPoint2, ilvTransformer) != null;
    }

    public IlvGraphic firstContains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        int n2 = this.list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
            return ilvGraphic;
        }
        return null;
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        int n2 = this.list.size();
        if (n2 == 0) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint[] ilvPointArray = new IlvPoint[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (!ilvGraphic.isVisible()) continue;
            ilvPointArray[n3++] = ilvGraphic.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
        }
        if (n3 == 0) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint ilvPoint3 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n3);
        Shape shape = this.getClip();
        if (shape == null) {
            return ilvPoint3;
        }
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint3);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint4);
        }
        if (IlvGraphicUtil.PointInShape(ilvPoint4, shape)) {
            return ilvPoint3;
        }
        return IlvClippingUtil.getClippedPoint(shape.getPathIterator(null), ilvTransformer, 0.0f, ilvPoint, ilvPoint2);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float f2;
        super.write(ilvOutputStream);
        ilvOutputStream.write("objects", this.getObjects());
        if (this.getClip() != null) {
            ilvOutputStream.write("clip", "clipRule", this.getClip());
        }
        if ((f2 = this.getAlpha()) != 1.0f) {
            ilvOutputStream.write("alpha", f2);
        }
    }

    public boolean isPersistent() {
        int n2 = this.list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (ilvGraphic.isPersistent()) continue;
            return false;
        }
        return true;
    }

    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        ilvTransformer.inverse(ilvPoint2);
        int n2 = this.list.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            String string;
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint2, ilvPoint, ilvTransformer) || (string = ilvGraphic.getToolTipText(ilvPoint, ilvTransformer)) == null) continue;
            return string;
        }
        return this.getToolTipText();
    }

    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        ilvTransformer.inverse(ilvPoint2);
        int n2 = this.list.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            JPopupMenu jPopupMenu;
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint2, ilvPoint, ilvTransformer) || (jPopupMenu = ilvGraphic.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager)) == null) continue;
            return jPopupMenu;
        }
        return this.getOriginalPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    protected JPopupMenu getOriginalPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        return super.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    IlvGraphic a(int n2, int n3, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint(n2, n3);
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint2);
        }
        int n4 = this.list.size();
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            IlvGraphic ilvGraphic = this.list.elementAt(i2);
            if (!ilvGraphic.contains(ilvPoint2, ilvPoint, ilvTransformer)) continue;
            return ilvGraphic;
        }
        return null;
    }

    public void addGraphicBagHierarchyListener(GraphicBagHierarchyListener graphicBagHierarchyListener) {
        if (this.e == null) {
            this.e = new IlvListenerList();
        }
        this.e.add(graphicBagHierarchyListener);
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof GraphicBagHierarchyEventReceiver) {
            GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag);
            graphicBagHierarchyEventReceiver.enableGraphicBagHierarchyEventForwarding();
        }
    }

    public void removeGraphicBagHierarchyListener(GraphicBagHierarchyListener graphicBagHierarchyListener) {
        if (this.e != null) {
            this.e.remove(graphicBagHierarchyListener);
            if (this.e.getListenerCount() == 0) {
                this.e = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableGraphicBagHierarchyEventForwarding() {
        if (this.c) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.a();
        synchronized (ilvGraphicBag) {
            this.c = true;
            IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
            if (ilvGraphicBag2 instanceof GraphicBagHierarchyEventReceiver) {
                GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag2);
                graphicBagHierarchyEventReceiver.enableGraphicBagHierarchyEventForwarding();
            }
        }
    }

    public boolean needsGraphicBagHierarchyEvent() {
        return this.e != null || this.c;
    }

    private IlvGraphicBag a() {
        IlvGraphicBag ilvGraphicBag = this;
        while (ilvGraphicBag.getGraphicBag() != null) {
            if (ilvGraphicBag instanceof IlvManager) {
                return (IlvGraphicBag)((IlvManager)ilvGraphicBag).getTreeLock();
            }
            ilvGraphicBag = ilvGraphicBag.getGraphicBag();
        }
        return ilvGraphicBag;
    }

    private void a(IlvGraphicBag ilvGraphicBag) {
        if (!this.needsGraphicBagHierarchyEvent()) {
            return;
        }
        IlvGraphicBag ilvGraphicBag2 = this.a();
        GraphicBagHierarchyEvent graphicBagHierarchyEvent = new GraphicBagHierarchyEvent(this, ilvGraphicBag, ilvGraphicBag2);
        this.fireGraphicBagHierarchyEvent(graphicBagHierarchyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireGraphicBagHierarchyEvent(GraphicBagHierarchyEvent graphicBagHierarchyEvent) {
        int n2;
        Object object;
        if (this.e != null) {
            object = this.e.getListenerList();
            n2 = ((Object[])object).length;
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                ((GraphicBagHierarchyListener)object[i2]).hierarchyChanged(graphicBagHierarchyEvent);
            }
        }
        if (this.c) {
            object = this.getObjects();
            while (object.hasMoreElements()) {
                GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver;
                IlvGraphic ilvGraphic = object.nextElement();
                if (!(ilvGraphic instanceof GraphicBagHierarchyEventReceiver) || !(graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphic)).needsGraphicBagHierarchyEvent()) continue;
                graphicBagHierarchyEventReceiver.fireGraphicBagHierarchyEvent(graphicBagHierarchyEvent);
            }
            object = graphicBagHierarchyEvent.getNewRootBag();
            synchronized (object) {
                n2 = 0;
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver;
                    IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                    if (!(ilvGraphic instanceof GraphicBagHierarchyEventReceiver) || !(graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphic)).needsGraphicBagHierarchyEvent()) continue;
                    n2 = 1;
                }
                this.c = n2;
            }
        }
    }

    public void addManagerViewsHierarchyListener(ManagerViewsChangedListener managerViewsChangedListener) {
        if (this.f == null) {
            this.f = new IlvListenerList();
        }
        this.f.add(managerViewsChangedListener);
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver) {
            ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            managerViewsHierarchyEventReceiver.enableManagerViewsHierarchyEventForwarding();
        }
    }

    public void removeManagerViewsHierarchyListener(ManagerViewsChangedListener managerViewsChangedListener) {
        if (this.f != null) {
            this.f.remove(managerViewsChangedListener);
            if (this.f.getListenerCount() == 0) {
                this.f = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableManagerViewsHierarchyEventForwarding() {
        if (this.d) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.a();
        synchronized (ilvGraphicBag) {
            this.d = true;
            IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
            if (ilvGraphicBag2 instanceof ManagerViewsHierarchyEventReceiver) {
                ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag2);
                managerViewsHierarchyEventReceiver.enableManagerViewsHierarchyEventForwarding();
            }
        }
    }

    public boolean needsManagerViewsHierarchyEvent() {
        return this.f != null || this.d;
    }

    private void a(IlvGraphicBag ilvGraphicBag, int n2) {
        if (ilvGraphicBag == null || !this.needsManagerViewsHierarchyEvent()) {
            return;
        }
        while (ilvGraphicBag != null) {
            if (ilvGraphicBag instanceof IlvManager) {
                IlvManager ilvManager = (IlvManager)ilvGraphicBag;
                Enumeration enumeration = ilvManager.getViews();
                while (enumeration.hasMoreElements()) {
                    IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                    if (ilvManagerView == null) continue;
                    ManagerViewsChangedEvent managerViewsChangedEvent = new ManagerViewsChangedEvent(ilvManager, ilvManagerView, n2);
                    this.fireManagerViewsHierarchyEvent(managerViewsChangedEvent);
                }
            }
            ilvGraphicBag = ilvGraphicBag.getGraphicBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireManagerViewsHierarchyEvent(ManagerViewsChangedEvent managerViewsChangedEvent) {
        int n2;
        Object object;
        if (this.f != null) {
            object = this.f.getListenerList();
            n2 = ((Object[])object).length;
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                ((ManagerViewsChangedListener)object[i2]).viewChanged(managerViewsChangedEvent);
            }
        }
        if (this.d) {
            object = this.getObjects();
            while (object.hasMoreElements()) {
                ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver;
                IlvGraphic ilvGraphic = object.nextElement();
                if (!(ilvGraphic instanceof ManagerViewsHierarchyEventReceiver) || !(managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphic)).needsManagerViewsHierarchyEvent()) continue;
                managerViewsHierarchyEventReceiver.fireManagerViewsHierarchyEvent(managerViewsChangedEvent);
            }
            object = this.a();
            synchronized (object) {
                n2 = 0;
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver;
                    IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                    if (!(ilvGraphic instanceof ManagerViewsHierarchyEventReceiver) || !(managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphic)).needsManagerViewsHierarchyEvent()) continue;
                    n2 = 1;
                }
                this.d = n2;
            }
        }
    }

    protected void invalidateBBoxCache() {
    }

    protected void setInsideApply(boolean bl) {
        this.g = bl ? ++this.g : --this.g;
    }

    public static class DelegateObjectInteractor
    extends IlvObjectInteractor {
        private transient IlvGraphic a;
        private transient boolean b;
        private transient boolean c;
        private transient int d;
        private transient int e;

        public boolean processEvent(IlvGraphic ilvGraphic, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
            IlvObjectInteractor ilvObjectInteractor;
            if (!(ilvGraphic instanceof IlvGraphicSet)) {
                return false;
            }
            IlvGraphicSet ilvGraphicSet = (IlvGraphicSet)ilvGraphic;
            if (this.a != null && this.a.getGraphicBag() != ilvGraphicSet) {
                this.a = null;
            }
            IlvGraphic ilvGraphic2 = this.a;
            switch (aWTEvent.getID()) {
                case 501: {
                    if (((MouseEvent)aWTEvent).getClickCount() <= 1) {
                        this.b = false;
                    }
                    if (this.b && this.a != null) break;
                    this.b = true;
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                    ilvGraphic2 = this.a = ilvGraphicSet.a(this.d, this.e, ilvObjectInteractorContext.getTransformer());
                    break;
                }
                case 502: {
                    if (!this.b || !this.c) break;
                    this.c = false;
                    this.b = false;
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                    this.a = null;
                    break;
                }
                case 500: {
                    if (!this.b) break;
                    this.b = false;
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                    this.a = null;
                    break;
                }
                case 506: {
                    if (!this.b) break;
                    this.c = true;
                    break;
                }
                case 503: {
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                }
                case 401: 
                case 402: {
                    if (ilvGraphic2 != null) break;
                    ilvGraphic2 = ilvGraphicSet.a(this.d, this.e, ilvObjectInteractorContext.getTransformer());
                }
            }
            if (ilvGraphic2 != null && (ilvObjectInteractor = ilvGraphic2.getObjectInteractor()) != null) {
                return ilvObjectInteractor.processEvent(ilvGraphic2, aWTEvent, ilvObjectInteractorContext);
            }
            return false;
        }

        public void handleExpose(IlvGraphic ilvGraphic, Graphics graphics, IlvObjectInteractorContext ilvObjectInteractorContext) {
            IlvObjectInteractor ilvObjectInteractor;
            IlvGraphic ilvGraphic2;
            if (!(ilvGraphic instanceof IlvGraphicSet)) {
                return;
            }
            if (this.a != null && this.a.getGraphicBag() != ilvGraphic) {
                this.a = null;
            }
            if ((ilvGraphic2 = this.a) != null && (ilvObjectInteractor = ilvGraphic2.getObjectInteractor()) != null) {
                ilvObjectInteractor.handleExpose(ilvGraphic2, graphics, ilvObjectInteractorContext);
            }
        }
    }
}

