/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.graphic.IlvPolyline;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvArrowPolyline
extends IlvPolyline {
    private boolean a = false;
    private float b = 1.0f;
    static final Boolean c = new Boolean(true);
    static final IlvPoint d = new IlvPoint();
    static final IlvPoint[] e = new IlvPoint[3];

    public IlvArrowPolyline(IlvPoint[] ilvPointArray, boolean bl, float f2) {
        this(ilvPointArray, bl, f2, true);
    }

    public IlvArrowPolyline(IlvPoint[] ilvPointArray, boolean bl, float f2, boolean bl2) {
        super(ilvPointArray, bl2);
        this.a = bl;
        this.setArrowPosition(f2);
    }

    public IlvArrowPolyline(IlvPoint[] ilvPointArray, boolean bl) {
        this(ilvPointArray, bl, 1.0f);
    }

    public IlvArrowPolyline(IlvPoint[] ilvPointArray) {
        this(ilvPointArray, false);
    }

    public IlvArrowPolyline(IlvArrowPolyline ilvArrowPolyline) {
        super(ilvArrowPolyline);
        this.a = ilvArrowPolyline.a;
        this.b = ilvArrowPolyline.b;
    }

    public IlvArrowPolyline(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setUsingAllLines(ilvInputStream.readBoolean("usingAllLines"));
        this.setArrowPosition(ilvInputStream.readFloat("arrowPosition"));
    }

    public IlvGraphic copy() {
        return new IlvArrowPolyline(this);
    }

    public void setArrowPosition(float f2) {
        this.b = f2;
        this.b = Math.min(1.0f, this.b);
        this.b = Math.max(0.0f, this.b);
    }

    public float getArrowPosition() {
        return this.b;
    }

    public boolean isUsingAllLines() {
        return this.a;
    }

    public void setUsingAllLines(boolean bl) {
        this.a = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getArrowSize(this.a(ilvTransformer, false), ilvTransformer);
        int n2 = ((IlvPolyPoints)this).a.length;
        Boolean bl = c;
        synchronized (bl) {
            int n3;
            if (f2 > 4.0f && this.b == 1.0f) {
                if (n2 > 1) {
                    n3 = this.getEndCap();
                    float f3 = ((IlvPolyPoints)this).a[n2 - 1].x;
                    float f4 = ((IlvPolyPoints)this).a[n2 - 1].y;
                    IlvArrowPolyline.d.x = f3;
                    IlvArrowPolyline.d.y = f4;
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    double d2 = IlvArrowPolyline.d.x;
                    double d3 = IlvArrowPolyline.d.y;
                    IlvArrowPolyline.d.x = ((IlvPolyPoints)this).a[n2 - 2].x;
                    IlvArrowPolyline.d.y = ((IlvPolyPoints)this).a[n2 - 2].y;
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    double d4 = IlvArrowPolyline.d.x;
                    double d5 = IlvArrowPolyline.d.y;
                    double d6 = d2 - d4;
                    double d7 = d3 - d5;
                    double d8 = Math.sqrt(d6 * d6 + d7 * d7);
                    double d9 = n3 != 0 ? 2.0 * (double)f2 : 1.5 * (double)f2;
                    double d10 = 0.0;
                    double d11 = 0.0;
                    if (d8 != 0.0) {
                        d10 = -d9 * d7 / d8;
                        d11 = d9 * d6 / d8;
                    }
                    IlvArrowPolyline.d.x = (float)(d2 - d11);
                    IlvArrowPolyline.d.y = (float)(d3 + d10);
                    if (ilvTransformer != null) {
                        ilvTransformer.inverse(d);
                    }
                    ((IlvPolyPoints)this).a[n2 - 1].x = IlvArrowPolyline.d.x;
                    ((IlvPolyPoints)this).a[n2 - 1].y = IlvArrowPolyline.d.y;
                    super.draw(graphics, ilvTransformer);
                    ((IlvPolyPoints)this).a[n2 - 1].x = f3;
                    ((IlvPolyPoints)this).a[n2 - 1].y = f4;
                }
            } else {
                super.draw(graphics, ilvTransformer);
            }
            graphics.setColor(this.getForeground());
            if (this.a) {
                for (int i2 = 1; i2 < n2; ++i2) {
                    d.move(((IlvPolyPoints)this).a[i2 - 1].x, ((IlvPolyPoints)this).a[i2 - 1].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    n3 = (int)Math.floor(IlvArrowPolyline.d.x);
                    int n4 = (int)Math.floor(IlvArrowPolyline.d.y);
                    d.move(((IlvPolyPoints)this).a[i2].x, ((IlvPolyPoints)this).a[i2].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    int n5 = (int)Math.floor(IlvArrowPolyline.d.x);
                    int n6 = (int)Math.floor(IlvArrowPolyline.d.y);
                    IlvUtility.drawArrow(graphics, n3, n4, n5, n6, this.b, f2);
                }
            } else if (n2 >= 2) {
                d.move(((IlvPolyPoints)this).a[n2 - 2].x, ((IlvPolyPoints)this).a[n2 - 2].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                n3 = (int)Math.floor(IlvArrowPolyline.d.x);
                int n7 = (int)Math.floor(IlvArrowPolyline.d.y);
                d.move(((IlvPolyPoints)this).a[n2 - 1].x, ((IlvPolyPoints)this).a[n2 - 1].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                int n8 = (int)Math.floor(IlvArrowPolyline.d.x);
                int n9 = (int)Math.floor(IlvArrowPolyline.d.y);
                IlvUtility.drawArrow(graphics, n3, n7, n8, n9, this.b, f2);
            }
        }
    }

    protected float getArrowSize(float f2, IlvTransformer ilvTransformer) {
        return IlvUtility.arrowSize(f2, ilvTransformer);
    }

    private static IlvRect a(IlvPoint[] ilvPointArray) {
        IlvRect ilvRect = new IlvRect();
        IlvUtil.BoundingBox(ilvRect, ilvPointArray, 3);
        return ilvRect;
    }

    private float a(IlvTransformer ilvTransformer, boolean bl) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        int n2 = ((IlvPolyPoints)this).a.length;
        float f2 = this.getArrowSize(this.a(ilvTransformer, true), ilvTransformer);
        Boolean bl = c;
        synchronized (bl) {
            if (this.a) {
                for (int i2 = 1; i2 < n2; ++i2) {
                    d.move(((IlvPolyPoints)this).a[i2 - 1].x, ((IlvPolyPoints)this).a[i2 - 1].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    float f3 = IlvArrowPolyline.d.x;
                    float f4 = IlvArrowPolyline.d.y;
                    d.move(((IlvPolyPoints)this).a[i2].x, ((IlvPolyPoints)this).a[i2].y);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(d);
                    }
                    float f5 = IlvArrowPolyline.d.x;
                    float f6 = IlvArrowPolyline.d.y;
                    IlvUtility.ComputeArrow(f3, f4, f5, f6, this.b, e, f2);
                    ilvRect.add(IlvArrowPolyline.a(e));
                }
            } else if (n2 >= 2) {
                d.move(((IlvPolyPoints)this).a[n2 - 2].x, ((IlvPolyPoints)this).a[n2 - 2].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                float f7 = IlvArrowPolyline.d.x;
                float f8 = IlvArrowPolyline.d.y;
                d.move(((IlvPolyPoints)this).a[n2 - 1].x, ((IlvPolyPoints)this).a[n2 - 1].y);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(d);
                }
                float f9 = IlvArrowPolyline.d.x;
                float f10 = IlvArrowPolyline.d.y;
                IlvUtility.ComputeArrow(f7, f8, f9, f10, this.b, e, f2);
                ilvRect.add(IlvArrowPolyline.a(e));
            }
        }
        return ilvRect;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("usingAllLines", this.isUsingAllLines());
        ilvOutputStream.write("arrowPosition", this.getArrowPosition());
    }

    static {
        for (int i2 = 0; i2 < 3; ++i2) {
            IlvArrowPolyline.e[i2] = new IlvPoint();
        }
    }
}

