/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.css.model;

import ilog.views.css.model.AbstractNode;
import ilog.views.css.model.IlvConfigNode;
import ilog.views.css.model.IlvMessagesSupport;
import ilog.views.css.model.IlvNode;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleImpl;
import ilog.views.css.model.IlvRuleModel;
import ilog.views.css.model.IlvRuleModelStrategy;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.IlvSelector;
import ilog.views.css.model.event.CSSChangeEvent;
import ilog.views.css.model.event.CSSChangeListener;
import ilog.views.css.model.event.IlvCSSChangeSupport;
import ilog.views.css.model.internal.IlvRuleHelper;
import ilog.views.css.model.internal.SubRuleMethods;
import ilog.views.util.css.IlvCSSDOMImplementation;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.event.RuleSetEvent;
import ilog.views.util.css.event.RuleSetListener;
import ilog.views.util.css.parser.AttributeSelector;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.css.parser.Parser;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.styling.IlvCSSAttributeSelector;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvCSSparseException;
import ilog.views.util.styling.IlvStylingException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IlvRuleModelImpl
implements IlvRuleModel,
RuleSetListener {
    private IlvRuleModelStrategy a;
    private IlvRule b;
    private IlvConfigNode c;
    private IlvCSSChangeSupport d;
    private int e;
    private SharpRuleUsageMap f;
    private boolean g = false;
    private Map<String, Object> h = new HashMap<String, Object>();
    private PropertyChangeSupport i;

    public IlvRuleModelImpl(IlvRuleModelStrategy ilvRuleModelStrategy) {
        this.a = ilvRuleModelStrategy;
        this.i = new PropertyChangeSupport(this);
        this.d = new IlvCSSChangeSupport(this);
        if (this.getCSSBeans() != null) {
            this.getCSSEngine().addRuleSetListener(this);
        }
    }

    @Override
    public final IlvCSSBeans getCSSBeans() {
        return this.a.getCSSBeans();
    }

    protected final IlvCSSEngine getCSSEngine() {
        return this.getCSSBeans().getCSSengine();
    }

    public final IlvCSSDOMImplementation getDOMImplementation() {
        return this.getCSSEngine().getDOMImplementation();
    }

    @Override
    public IlvRule[] getAllRules(boolean bl) {
        Rule[] ruleArray = this.getCSSEngine().getRules(bl);
        IlvRule[] ilvRuleArray = new IlvRule[ruleArray.length];
        for (int i2 = 0; i2 < ruleArray.length; ++i2) {
            ilvRuleArray[i2] = this.getWrappedRule(ruleArray[i2]);
        }
        return ilvRuleArray;
    }

    public IlvRule getWrappedRule(Rule rule) {
        if (rule.getRuleWrapper() == null) {
            IlvRule ilvRule = this.createRule(rule);
            ilvRule.setConfigurationRule(this.a.isConfigurationRule(ilvRule));
            return ilvRule;
        }
        return (IlvRule)rule.getRuleWrapper();
    }

    public IlvRule createRule(Rule rule) {
        return new IlvRuleImpl(rule);
    }

    protected IlvRule[] getRules(boolean bl) {
        IlvRule[] ilvRuleArray = this.getAllRules(bl);
        return this.a.getVisibleRules(ilvRuleArray);
    }

    @Override
    public synchronized void setRules(IlvRule[] ilvRuleArray) {
        Rule[] ruleArray = new Rule[ilvRuleArray.length];
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ruleArray[i2] = ((IlvRuleImpl)ilvRuleArray[i2]).getRule();
        }
        this.getCSSEngine().setRules(ruleArray);
    }

    @Override
    public synchronized void rulesChanged(RuleSetEvent ruleSetEvent) {
        this.f = null;
    }

    @Override
    public void buildTree() {
        IlvRule[] ilvRuleArray;
        int n2;
        this.f = this.getSharpRuleUsageMap(this.getAllRules(true));
        this.a();
        IlvRule[] ilvRuleArray2 = this.getRules(true);
        for (n2 = 0; n2 < ilvRuleArray2.length; ++n2) {
            ilvRuleArray2[n2].resetTreeNode();
        }
        ilvRuleArray2 = this.getRootRules(true, false);
        n2 = 0;
        for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
            ilvRuleArray = ilvRuleArray2[i2];
            if (!ilvRuleArray.isConfigurationRule()) continue;
            ++n2;
        }
        IlvRule[] ilvRuleArray3 = new IlvRule[ilvRuleArray2.length - n2];
        ilvRuleArray = new IlvRule[n2];
        int n3 = 0;
        n2 = 0;
        for (int i3 = 0; i3 < ilvRuleArray2.length; ++i3) {
            IlvRule ilvRule = ilvRuleArray2[i3];
            if (ilvRule.isConfigurationRule()) {
                ilvRuleArray[n2++] = ilvRule;
                continue;
            }
            ilvRuleArray3[n3++] = ilvRule;
        }
        ilvRuleArray2 = ilvRuleArray3;
        this.b = (IlvRule)((Object)this.makePartialTree(ilvRuleArray2, new IlvRuleImpl(this.getDOMImplementation().createRule())));
        this.c = (IlvConfigNode)this.makePartialTree(ilvRuleArray, new IlvConfigNode());
    }

    protected AbstractNode makePartialTree(IlvRule[] ilvRuleArray, AbstractNode abstractNode) {
        Object object;
        IlvSelector ilvSelector;
        IlvRule ilvRule;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        arrayList.addAll(Arrays.asList(ilvRuleArray));
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            ilvSelector = ilvRule.getSelector();
            object = (AttributeSelector[])ilvSelector.getAttributes();
            String[] stringArray = ilvSelector.getPseudoClasses();
            if ((object == null || ((AttributeSelector[])object).length <= 0) && (stringArray == null || stringArray.length <= 0)) continue;
            listIterator.remove();
            IlvRule ilvRule2 = this.findParent(arrayList, ilvSelector.getType(), ilvSelector.getID(), ilvSelector.getCSSclasses());
            if (ilvRule2 == null) {
                abstractNode.addChild(ilvRule);
                continue;
            }
            ilvRule2.addChild(ilvRule);
        }
        listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            ilvSelector = ilvRule.getSelector();
            if (this.isEmpty(ilvSelector.getCSSclasses())) continue;
            listIterator.remove();
            object = this.findParent(arrayList, ilvSelector.getType(), ilvSelector.getID(), null);
            if (object == null) {
                abstractNode.addChild(ilvRule);
                continue;
            }
            object.addChild(ilvRule);
        }
        listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = (IlvRule)listIterator.next();
            abstractNode.addChild(ilvRule);
        }
        return abstractNode;
    }

    @Override
    public IlvRule[] getRootRules(boolean bl) {
        return this.getRootRules(bl, true);
    }

    @Override
    public IlvRule[] getRootRules(boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray = bl2 ? this.getAllRules(bl) : this.getRules(bl);
        SharpRuleUsageMap sharpRuleUsageMap = this.getSharpRuleUsageMap(ilvRuleArray);
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            if (ilvRuleArray[i2].getSelector() != null && ilvRuleArray[i2].getSelector().getID() != null) {
                if (sharpRuleUsageMap.getUsageCount(ilvRuleArray[i2].getSelector().getID()) != 0) continue;
                arrayList.add(ilvRuleArray[i2]);
                continue;
            }
            arrayList.add(ilvRuleArray[i2]);
        }
        return arrayList.toArray(new IlvRule[arrayList.size()]);
    }

    protected boolean softEquals(String string, String string2) {
        return string != null && string.equals(string2);
    }

    protected boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private boolean a(String[] stringArray, String[] stringArray2) {
        if (this.isEmpty(stringArray2)) {
            return true;
        }
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            String string = stringArray2[i2];
            boolean bl = false;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String string2 = stringArray[i3];
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean a(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    protected IlvRule findParent(ArrayList<IlvRule> arrayList, String string, String string2, String[] stringArray) {
        IlvSelector ilvSelector;
        IlvRule ilvRule;
        ListIterator<IlvRule> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = listIterator.next();
            ilvSelector = ilvRule.getSelector();
            if (!this.isEmpty(ilvSelector.getAttributes()) || !this.a(string, ilvSelector.getType()) || !this.a(string2, ilvSelector.getID()) || !this.a(ilvSelector.getCSSclasses(), stringArray)) continue;
            return ilvRule;
        }
        listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            ilvRule = listIterator.next();
            ilvSelector = ilvRule.getSelector();
            if (!this.isEmpty(ilvSelector.getAttributes()) || !this.a(string, ilvSelector.getType()) || !this.a(string2, ilvSelector.getID())) continue;
            return ilvRule;
        }
        return null;
    }

    @Override
    public IlvRule getRootRule() {
        return this.b;
    }

    @Override
    public IlvConfigNode getConfig() {
        return this.c;
    }

    public IlvRuleModelStrategy getCSSStrategy() {
        return this.a;
    }

    @Override
    public void updateInheritanceIcons(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray;
        this.resetOldIcons(this.getConfig());
        this.resetOldIcons(this.getRootRule());
        IlvRule[] ilvRuleArray2 = ilvRule.getSelector();
        for (IlvRule ilvRule2 : ilvRuleArray = this.getAllRules(false)) {
            if (ilvRule2 == ilvRule || !IlvRuleHelper.selectorIncluded((IlvSelector)ilvRuleArray2, ilvRule2.getSelector())) continue;
            ilvRule2.setInheritedStatus(4);
        }
        ilvRuleArray2 = this.getParentRules(ilvRule, false);
        for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
            ilvRuleArray2[i2].setInheritedStatus(2);
        }
        ilvRule.setInheritedStatus(3);
    }

    public void resetOldIcons(IlvNode ilvNode) {
        if (ilvNode instanceof IlvRule) {
            IlvRule ilvRule = (IlvRule)ilvNode;
            ilvRule.setInheritedStatus(3);
            ilvRule.setUsed(true);
        }
        for (int i2 = 0; i2 < ilvNode.getChildCount(); ++i2) {
            this.resetOldIcons(ilvNode.getChildAt(i2));
        }
    }

    @Override
    public IlvRule[] getParentRules(IlvRule ilvRule) {
        return this.getParentRules(ilvRule, false);
    }

    @Override
    public IlvRule[] getParentRules(IlvRule ilvRule, boolean bl) {
        if (ilvRule == null) {
            return new IlvRule[0];
        }
        ArrayList<IlvRule> arrayList = this.getRelatedRules(ilvRule);
        int n2 = arrayList.indexOf(ilvRule);
        if (n2 != -1) {
            int n3;
            int n4 = n3 = bl ? n2 + 1 : n2;
            while (n3 < arrayList.size()) {
                arrayList.remove(n3);
            }
        } else if (bl) {
            arrayList.add(ilvRule);
        }
        return arrayList.toArray(new IlvRule[arrayList.size()]);
    }

    @Override
    public IlvRule getParentRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        if (ilvRuleArray.length > 0) {
            return ilvRuleArray[ilvRuleArray.length - 1];
        }
        return null;
    }

    public ArrayList<IlvRule> getRelatedRules(IlvRule ilvRule) {
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        if (ilvRule == null) {
            return arrayList;
        }
        boolean bl = true;
        IlvSelector ilvSelector = ilvRule.getSelector();
        IlvRule[] ilvRuleArray = this.getAllRules(false);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule2 = ilvRuleArray[i2];
            if (ilvRule == ilvRule2) {
                bl = false;
                arrayList.add(ilvRule);
                continue;
            }
            IlvSelector ilvSelector2 = ilvRule2.getSelector();
            if ((!bl || !IlvRuleHelper.selectorIncluded(ilvSelector2, ilvSelector)) && (bl || !IlvRuleHelper.selectorIncluded(ilvSelector, ilvSelector2))) continue;
            arrayList.add(ilvRule2);
        }
        return arrayList;
    }

    @Override
    public Object[] getMatchingObjects(IlvRule ilvRule) {
        return this.a.getMatchingObjects(ilvRule);
    }

    @Override
    public HashSet<IlvRule> getAdditionalRules(IlvRule ilvRule, IlvRule[] ilvRuleArray, HashSet<IlvRule> hashSet, boolean bl) {
        IlvRule[] ilvRuleArray2 = this.getAllRules(false);
        SubRuleMethods subRuleMethods = new SubRuleMethods(ilvRuleArray2);
        IlvRule[] ilvRuleArray3 = subRuleMethods.getLocalRules(ilvRule, ilvRuleArray, bl);
        if (hashSet == null) {
            hashSet = new HashSet<IlvRule>(Arrays.asList(ilvRuleArray3));
        } else {
            hashSet.addAll(Arrays.asList(ilvRuleArray3));
        }
        return hashSet;
    }

    @Override
    public IlvRule[] getAdditionalRules(IlvRule[] ilvRuleArray) {
        HashSet<IlvRule> hashSet = this.getAdditionalRules(ilvRuleArray[ilvRuleArray.length - 1], ilvRuleArray, null, true);
        return hashSet.toArray(new IlvRule[hashSet.size()]);
    }

    @Override
    public IlvRule getRuleWithDeclaration(IlvRule ilvRule, String string) {
        if (ilvRule.getCSSDeclarations() == null) {
            return null;
        }
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        if (declaration != null) {
            return ilvRule;
        }
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            String string2 = ilvRuleArray[i2 - 1].getDeclarationValue(string);
            if (string2 == null) continue;
            return ilvRuleArray[i2 - 1];
        }
        return null;
    }

    @Override
    public final IlvRule getSameRule(IlvRule ilvRule) {
        return this.getSameRule(ilvRule, false);
    }

    @Override
    public final IlvRule getSameRule(IlvRule ilvRule, boolean bl) {
        return this.getSameRule(ilvRule, bl, false);
    }

    @Override
    public IlvRule getSameRule(IlvRule ilvRule, boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = ilvRuleArray = bl2 ? this.getAllRules(bl) : this.getRules(false);
        if (ilvRule == null || ilvRuleArray == null || ilvRuleArray.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule2 = ilvRuleArray[i2];
            if (!ilvRule.isIdentical(ilvRule2)) continue;
            return ilvRuleArray[i2];
        }
        return null;
    }

    @Override
    public IlvRule getToplevelRule(IlvRule ilvRule) {
        String string;
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = this.getAllRules(false);
        String string2 = ilvRule.toString();
        for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
            ilvRuleArray = ilvRuleArray2[i2];
            if (!string2.equals(ilvRuleArray.getSelectorString())) continue;
            ilvRule = ilvRuleArray;
            break;
        }
        if ((string = ilvRule.getSelector().getID()) != null) {
            ilvRuleArray = this.getRootRules(false, false);
            for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
                IlvRule ilvRule2 = ilvRuleArray[i3];
                IlvRule[] ilvRuleArray3 = this.getAdditionalRules(new IlvRule[]{ilvRule2});
                IlvRule[] ilvRuleArray4 = IlvRuleUtils.getRulesFromId(ilvRuleArray3, string);
                for (int i4 = 0; i4 < ilvRuleArray4.length; ++i4) {
                    IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray;
                    IlvRule ilvRule3 = ilvRuleArray4[i4];
                    if (ilvRule3 != ilvRule || (ilvCSSAttributeSelectorArray = (AttributeSelector[])ilvRule.getSelector().getAttributes()) == null) continue;
                    IlvRule ilvRule4 = ilvRule2.copy();
                    ilvRule4.getSelector().setAttributes(ilvCSSAttributeSelectorArray);
                    IlvRule ilvRule5 = this.getSameRule(ilvRule4);
                    if (ilvRule5 != null) {
                        return ilvRule5;
                    }
                    return ilvRule2;
                }
            }
        }
        return ilvRule;
    }

    @Override
    public Map<String, String> getDeclarations(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule, true);
        return IlvRuleUtils.getDeclarationsAsMap(ilvRuleArray, false);
    }

    @Override
    public String getDeclarationValue(IlvRule ilvRule, String string) {
        if (ilvRule.getCSSDeclarations() == null) {
            return null;
        }
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        if (declaration != null) {
            return declaration.getValue();
        }
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            String string2 = ilvRuleArray[i2 - 1].getDeclarationValue(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeclarationValueAndUpdateUnusedSharpRules(IlvRule ilvRule, String string, String string2) {
        this.setAdjusting(true);
        try {
            if (this.f == null) {
                this.f = this.getSharpRuleUsageMap(this.getAllRules(true));
            }
            this.a(string2, this.f);
            String string3 = ilvRule.getDeclarationValue(string);
            this.a(string3);
            this.setDeclarationValue(ilvRule, string, string2);
        }
        finally {
            this.setAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeclarationAndUpdateUnusedSharpRules(IlvRule ilvRule, String string) {
        this.setAdjusting(true);
        try {
            String string2 = ilvRule.getDeclarationValue(string);
            this.a(string2);
            this.removeDeclaration(ilvRule, string);
        }
        finally {
            this.setAdjusting(false);
        }
    }

    @Override
    public void setDeclarationValue(IlvRule ilvRule, String string, String string2) {
        ilvRule.setModified(string);
        ilvRule.setModified(true);
        ilvRule.setDeclaration(string, string2);
        this.validateRules(this.getAllRules(true), !this.isAdjusting());
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        CSSChangeEvent.Add add = new CSSChangeEvent.Add(this, ilvRule, null, new Declaration[]{declaration}, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(add);
    }

    @Override
    public void removeDeclaration(IlvRule ilvRule, String string) {
        Declaration declaration = (Declaration)ilvRule.getDeclaration(string);
        if (declaration == null) {
            return;
        }
        ilvRule.setModified(true);
        ilvRule.removeDeclaration(string);
        this.validateRules(this.getAllRules(true), !this.isAdjusting());
        CSSChangeEvent.Remove remove = new CSSChangeEvent.Remove(this, ilvRule, null, new Declaration[]{declaration}, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(remove);
    }

    @Override
    public void removeMetaDeclaration(IlvRule ilvRule, String string) {
        Declaration declaration = (Declaration)ilvRule.getMetaDeclaration(string);
        CSSChangeEvent.Remove remove = new CSSChangeEvent.Remove(this, ilvRule, null, new Declaration[]{declaration}, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(remove);
    }

    public void setSelector(IlvRule ilvRule, IlvSelector ilvSelector) {
        ilvRule.setModified(true);
        IlvSelector ilvSelector2 = ilvRule.getSelector();
        ilvRule.setSelector(ilvSelector);
        this.validateRules(this.getAllRules(true), !this.isAdjusting());
        CSSChangeEvent.SelectorChange selectorChange = new CSSChangeEvent.SelectorChange(this, ilvRule, ilvSelector2, this.isAdjusting());
        this.d.fireStyleChangeEvent(selectorChange);
    }

    @Override
    public String getDeclarationValue(IlvRule ilvRule, String string, boolean bl) {
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule, true);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            String string2 = ilvRuleArray[i2 - 1].getDeclarationValue(string, bl);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    @Override
    public String getLayoutId(IlvRule ilvRule) {
        String string = this.getDeclarationValue(ilvRule, "layout");
        if (string != null) {
            return string.substring(2);
        }
        return null;
    }

    @Override
    public IlvRule getTopCompositeRule(IlvRule ilvRule) {
        IlvRule ilvRule2 = ilvRule;
        IlvRule[] ilvRuleArray = this.getParentRules(ilvRule);
        for (int i2 = ilvRuleArray.length; i2 > 0; --i2) {
            if (!ilvRuleArray[i2 - 1].isCompositeRule(this)) continue;
            ilvRule2 = ilvRuleArray[i2 - 1];
        }
        return ilvRule2;
    }

    @Override
    public String getAttachmentIdFromIndex(int n2, IlvRule ilvRule) {
        String string = "constraints[" + n2 + "]";
        Map<String, String> map = this.getDeclarations(ilvRule);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (!string2.equals(string)) continue;
            String string3 = entry.getValue();
            return string3.substring(2);
        }
        return null;
    }

    @Override
    public String getDecoAvailableId() {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        int n2 = 0;
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            String string;
            int n3;
            int n4;
            int n5;
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvSelector ilvSelector = ilvRule.getSelector();
            String string2 = ilvSelector.getID();
            if (string2 == null || (n5 = string2.lastIndexOf("__child__")) == -1 || (n4 = string2.lastIndexOf("__id__")) == -1 || (n3 = Integer.parseInt(string = string2.substring(n5 += "__child__".length(), n4))) <= n2) continue;
            n2 = n3;
        }
        return "__child__" + (n2 + 1) + "__id__";
    }

    @Override
    public String getAttachmentAvailableId() {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        int n2 = 0;
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            String string;
            int n3;
            int n4;
            int n5;
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvSelector ilvSelector = ilvRule.getSelector();
            String string2 = ilvSelector.getID();
            if (string2 == null || (n5 = string2.lastIndexOf("__attachment__")) == -1 || (n4 = string2.lastIndexOf("__id__")) == -1 || (n3 = Integer.parseInt(string = string2.substring(n5 += "__attachment__".length(), n4))) <= n2) continue;
            n2 = n3;
        }
        return "__attachment__" + (n2 + 1) + "__id__";
    }

    @Override
    public Object makeBeanFromRule(IlvRule ilvRule) {
        return this.a.makeBeanFromRule(this, ilvRule);
    }

    @Override
    public Collection<IlvRule> getMoreSpecificRules(IlvRule ilvRule, boolean bl) {
        ArrayList<IlvRule> arrayList = this.getRelatedRules(ilvRule);
        int n2 = arrayList.indexOf(ilvRule);
        if (n2 == -1) {
            arrayList.clear();
            if (bl) {
                arrayList.add(ilvRule);
            }
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.remove(0);
            }
            if (!bl) {
                arrayList.remove(0);
            }
        }
        return arrayList;
    }

    @Override
    public IlvRule[] withoutOverridingRules(IlvRule ilvRule) {
        Collection<IlvRule> collection = this.getMoreSpecificRules(ilvRule, false);
        IlvRule[] ilvRuleArray = this.getAllRules(false);
        if (collection.size() > 0) {
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>(Arrays.asList(ilvRuleArray));
            arrayList.removeAll(collection);
            ilvRuleArray = arrayList.toArray(new IlvRule[arrayList.size()]);
        }
        return ilvRuleArray;
    }

    @Override
    public Object setProperty(String string, Object object) {
        if (string == null) {
            return null;
        }
        Object object2 = this.h.get(string);
        if (object == null) {
            this.h.remove(string);
        } else {
            this.h.put(string, object);
        }
        this.a(string, object2, object);
        return object2;
    }

    @Override
    public Object getProperty(String string) {
        return this.h.get(string);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.i.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.i.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addStyleChangeListener(CSSChangeListener cSSChangeListener) {
        this.d.addStyleChangeListener(cSSChangeListener);
    }

    @Override
    public void removeStyleChangeListener(CSSChangeListener cSSChangeListener) {
        this.d.removeStyleChangeListener(cSSChangeListener);
    }

    private void a(String string, Object object, Object object2) {
        this.i.firePropertyChange(string, object, object2);
    }

    public IlvRule[] getMatchedRules(Object object) {
        return this.a.getMatchedRules(this, object);
    }

    private void a() {
        HashSet<IlvRule> hashSet = this.getSharpRules(this.getAllRules(false));
        for (IlvRule ilvRule : hashSet) {
            ilvRule.setMetaDeclaration("_EDITABLE", "true");
        }
        hashSet = this.getSharpRules(this.getRules(false));
        for (IlvRule ilvRule : hashSet) {
            String string = ilvRule.getSelector().getID();
            if (this.getSharpRuleUsageCount(string) != 0) continue;
            ilvRule.setMetaDeclaration("_EDITABLE", "false");
            Object[] objectArray = this.getMatchingObjects(ilvRule);
            if (objectArray == null || objectArray.length <= 0) continue;
            ilvRule.setMetaDeclaration("_EDITABLE", "true");
        }
    }

    public HashSet<IlvRule> getSharpRules(Collection<IlvRule> collection) {
        HashSet<IlvRule> hashSet = new HashSet<IlvRule>();
        for (IlvRule ilvRule : collection) {
            if (ilvRule.getSelector() == null || ilvRule.getSelector().getID() == null) continue;
            String string = ilvRule.getSelector().getID();
            if (hashSet.contains(ilvRule)) continue;
            hashSet.add(ilvRule);
        }
        return hashSet;
    }

    public HashSet<IlvRule> getSharpRules(IlvRule[] ilvRuleArray) {
        HashSet<IlvRule> hashSet = new HashSet<IlvRule>();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule = ilvRuleArray[i2];
            if (ilvRule.getSelector() == null || ilvRule.getSelector().getID() == null) continue;
            String string = ilvRule.getSelector().getID();
            if (hashSet.contains(ilvRule)) continue;
            hashSet.add(ilvRule);
        }
        return hashSet;
    }

    public SharpRuleUsageMap getSharpRuleUsageMap(Collection<IlvRule> collection) {
        SharpRuleUsageMap sharpRuleUsageMap = new SharpRuleUsageMap();
        for (IlvRule object2 : collection) {
            if (this.a(object2)) continue;
            this.a(object2, sharpRuleUsageMap);
        }
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        Stack<IlvRule> stack = new Stack<IlvRule>();
        for (IlvRule ilvRule : collection) {
            if (!this.a(ilvRule)) continue;
            String string = ilvRule.getSelector().getID();
            if (sharpRuleUsageMap.getUsageCount(string) == 0) {
                arrayList.add(ilvRule);
                continue;
            }
            stack.push(ilvRule);
        }
        this.a(sharpRuleUsageMap, stack, arrayList);
        return sharpRuleUsageMap;
    }

    public SharpRuleUsageMap getSharpRuleUsageMap(IlvRule[] ilvRuleArray) {
        SharpRuleUsageMap sharpRuleUsageMap = new SharpRuleUsageMap();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            if (this.a(ilvRuleArray[i2])) continue;
            this.a(ilvRuleArray[i2], sharpRuleUsageMap);
        }
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        Stack<IlvRule> stack = new Stack<IlvRule>();
        for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
            if (!this.a(ilvRuleArray[i3])) continue;
            String string = ilvRuleArray[i3].getSelector().getID();
            if (sharpRuleUsageMap.getUsageCount(string) == 0) {
                arrayList.add(ilvRuleArray[i3]);
                continue;
            }
            stack.push(ilvRuleArray[i3]);
        }
        this.a(sharpRuleUsageMap, stack, arrayList);
        return sharpRuleUsageMap;
    }

    private void a(SharpRuleUsageMap sharpRuleUsageMap, Stack<IlvRule> stack, ArrayList<IlvRule> object) {
        while (!stack.isEmpty()) {
            Object object2;
            while (!stack.isEmpty()) {
                object2 = stack.pop();
                this.a((IlvRule)object2, sharpRuleUsageMap);
            }
            object2 = new ArrayList();
            Iterator<IlvRule> iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                IlvRule ilvRule = iterator.next();
                String string = ilvRule.getSelector().getID();
                if (sharpRuleUsageMap.getUsageCount(string) != 0) {
                    stack.add(ilvRule);
                    continue;
                }
                ((ArrayList)object2).add(ilvRule);
            }
            object = object2;
        }
    }

    private boolean a(IlvRule ilvRule) {
        IlvSelector ilvSelector = ilvRule.getSelector();
        return ilvSelector != null && ilvSelector.getID() != null;
    }

    private void a(IlvRule ilvRule, SharpRuleUsageMap sharpRuleUsageMap) {
        Declaration[] declarationArray = (Declaration[])ilvRule.getCSSDeclarations();
        for (int i2 = 0; i2 < declarationArray.length; ++i2) {
            Declaration declaration = declarationArray[i2];
            this.a(declaration.getValue(), sharpRuleUsageMap);
        }
    }

    private void a(String string, SharpRuleUsageMap sharpRuleUsageMap) {
        ArrayList<String> arrayList = IlvRuleUtils.getSharpRuleReferences(string);
        if (arrayList != null) {
            for (String string2 : arrayList) {
                sharpRuleUsageMap.markUsed(string2);
            }
        }
    }

    @Override
    public int getSharpRuleUsageCount(String string) {
        if (this.f == null) {
            this.f = this.getSharpRuleUsageMap(this.getAllRules(true));
        }
        return this.f.getUsageCount(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSharpRule(String string) {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        SharpRuleUsageMap sharpRuleUsageMap = this.f;
        if (sharpRuleUsageMap == null) {
            sharpRuleUsageMap = this.getSharpRuleUsageMap(ilvRuleArray);
        }
        sharpRuleUsageMap.markUnused(string);
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        HashSet<String> hashSet = new HashSet<String>();
        this.a(string, ilvRuleArray, sharpRuleUsageMap, arrayList, hashSet);
        this.setAdjusting(true);
        try {
            for (IlvRule ilvRule : arrayList) {
                this.removeRule(ilvRule);
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    private void a(String string) {
        ArrayList<String> arrayList;
        if (string != null && (arrayList = IlvRuleUtils.getSharpRuleReferences(string)) != null) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                String string2 = arrayList.get(i2);
                if (this.getSharpRuleUsageCount(string2) != 1) continue;
                this.removeSharpRule(string2);
            }
        }
    }

    private void a(String string, IlvRule[] ilvRuleArray, SharpRuleUsageMap sharpRuleUsageMap, ArrayList<IlvRule> arrayList, HashSet<String> hashSet) {
        ArrayList<IlvRule> arrayList2 = IlvRuleUtils.getRulesFromIdAsList(ilvRuleArray, string);
        arrayList.addAll(arrayList2);
        hashSet.add(string);
        for (IlvRule ilvRule : arrayList2) {
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
            for (int i2 = 0; i2 < ilvCSSDeclarationArray.length; ++i2) {
                ArrayList<String> arrayList3 = IlvRuleUtils.getSharpRuleReferences(ilvCSSDeclarationArray[i2]);
                if (arrayList3 == null) continue;
                for (String string2 : arrayList3) {
                    sharpRuleUsageMap.markUnused(string2);
                    if (sharpRuleUsageMap.getUsageCount(string2) != 0 || hashSet.contains(string2)) continue;
                    this.a(string2, ilvRuleArray, sharpRuleUsageMap, arrayList, hashSet);
                }
            }
        }
    }

    private void a(String string, IlvRule[] ilvRuleArray, SharpRuleUsageMap sharpRuleUsageMap) {
        ArrayList<IlvRule> arrayList = IlvRuleUtils.getRulesFromIdAsList(ilvRuleArray, string);
        for (IlvRule ilvRule : arrayList) {
            this.removeRule(ilvRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRulesUsingAttributeName(String string) {
        List<IlvRule> list = this.getRulesUsingAttributeName(string);
        try {
            this.setAdjusting(true);
            Iterator<IlvRule> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.removeRule(iterator.next());
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    @Override
    public List<IlvRule> getRulesUsingAttributeName(String string) {
        LinkedList<IlvRule> linkedList = new LinkedList<IlvRule>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        block0: for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvSelector ilvSelector = ilvRule.getSelector();
            IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray = ilvSelector.getAttributes();
            for (int i3 = 0; i3 < ilvCSSAttributeSelectorArray.length; ++i3) {
                if (!string.equals(ilvCSSAttributeSelectorArray[i3].getAttributeName())) continue;
                linkedList.add(ilvRule);
                continue block0;
            }
        }
        return linkedList;
    }

    @Override
    public List<IlvCSSDeclaration> getDeclarationsUsingAttributeName(String string) {
        LinkedList<IlvCSSDeclaration> linkedList = new LinkedList<IlvCSSDeclaration>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        block0: for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
            for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                if (!string.equals(ilvCSSDeclarationArray[i3].getValue())) continue;
                linkedList.add(ilvCSSDeclarationArray[i3]);
                continue block0;
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeclarationsUsingAttributeName(String string) {
        this.setAdjusting(true);
        try {
            IlvRule[] ilvRuleArray = this.getAllRules(true);
            block3: for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                IlvRule ilvRule = ilvRuleArray[i2];
                IlvSelector ilvSelector = ilvRule.getSelector();
                IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
                for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                    if (!string.equals(ilvCSSDeclarationArray[i3].getValue())) continue;
                    this.removeDeclaration(ilvRule, ilvCSSDeclarationArray[i3].getProperty());
                    continue block3;
                }
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    @Override
    public void addRule(IlvRule ilvRule) {
        this.getCSSBeans().clear();
        ilvRule.setConfigurationRule(this.a.isConfigurationRule(ilvRule));
        this.addRemoveRuleImpl(ilvRule, true, !this.isAdjusting());
        ilvRule.setModified(true);
        CSSChangeEvent.Add add = new CSSChangeEvent.Add(this, ilvRule, null, null, null, this.isAdjusting());
        this.d.fireStyleChangeEvent(add);
    }

    @Override
    public void removeRule(IlvRule ilvRule) {
        this.getCSSBeans().clear();
        if (this.addRemoveRuleImpl(ilvRule, false, !this.isAdjusting())) {
            CSSChangeEvent.Remove remove = new CSSChangeEvent.Remove(this, ilvRule, null, null, null, this.isAdjusting());
            this.d.fireStyleChangeEvent(remove);
        }
    }

    protected boolean addRemoveRuleImpl(IlvRule ilvRule, boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = this.getAllRules(true);
        if (bl) {
            ilvRuleArray = new IlvRule[ilvRuleArray2.length + 1];
            ilvRuleArray[ilvRuleArray2.length] = ilvRule;
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, ilvRuleArray2.length);
        } else {
            int n2 = -1;
            for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
                IlvRule ilvRule2 = ilvRuleArray2[i2];
                if (ilvRule2 != ilvRule) continue;
                n2 = i2;
                break;
            }
            if (n2 == -1) {
                return false;
            }
            ilvRuleArray = new IlvRule[ilvRuleArray2.length - 1];
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, n2);
            System.arraycopy(ilvRuleArray2, n2 + 1, ilvRuleArray, n2, ilvRuleArray2.length - n2 - 1);
        }
        this.validateRules(ilvRuleArray, bl2);
        return true;
    }

    private void a(IlvRule[] ilvRuleArray, IlvRule ilvRule, IlvRule[] ilvRuleArray2) {
        int n2;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>(Arrays.asList(ilvRuleArray2));
        for (n2 = 0; n2 < ilvRuleArray.length; ++n2) {
            IlvRule ilvRule2 = ilvRuleArray[n2];
            arrayList.remove(ilvRule2);
        }
        n2 = arrayList.indexOf(ilvRule);
        if (n2 == -1) {
            arrayList.addAll(Arrays.asList(ilvRuleArray));
        } else {
            arrayList.addAll(n2, Arrays.asList(ilvRuleArray));
        }
        ilvRuleArray2 = arrayList.toArray(new IlvRule[arrayList.size()]);
        this.validateRules(ilvRuleArray2, true);
    }

    protected void validateRules(IlvRule[] ilvRuleArray, boolean bl) {
        this.getCSSBeans().clear();
        Rule[] ruleArray = new Rule[ilvRuleArray.length];
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ruleArray[i2] = ((IlvRuleImpl)ilvRuleArray[i2]).getRule();
        }
        if (bl && this.g) {
            this.debugPrintRules("validateRules(reload=" + bl + ")", ilvRuleArray);
        }
        this.getCSSEngine().setRules(ruleArray);
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.g = bl;
    }

    protected void debugPrintRules(String string, IlvRule[] ilvRuleArray) {
        System.err.println("=====================================");
        System.err.println(string);
        PrintWriter printWriter = new PrintWriter(System.err, true);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ilvRuleArray[i2].printCSS(printWriter);
        }
    }

    @Override
    public final IlvRule getRule(String string, boolean bl) throws IlvStylingException {
        return this.getRule(string, false, bl);
    }

    @Override
    public IlvRule getRule(String string, boolean bl, boolean bl2) throws IlvStylingException {
        String string2 = string + "{}";
        Parser parser = new Parser(new StringReader(string2), this.getDOMImplementation());
        boolean bl3 = Parser.isOptimized();
        Parser.setOptimized(false);
        try {
            Rule[] ruleArray = parser.parse();
            if (ruleArray.length != 1) {
                String string3 = MessageFormat.format(IlvMessagesSupport.getMessage("Exception.NotUniqueRule"), string);
                throw new IlvStylingException(string3);
            }
            IlvRule ilvRule = this.getWrappedRule(ruleArray[0]);
            IlvRule ilvRule2 = this.getSameRule(ilvRule, true, bl);
            if (ilvRule2 == null && bl2) {
                ilvRule2 = ilvRule;
                this.addRule(ilvRule2);
            }
            IlvRule ilvRule3 = ilvRule2;
            return ilvRule3;
        }
        catch (IlvCSSparseException ilvCSSparseException) {
            String string4 = MessageFormat.format(IlvMessagesSupport.getMessage("Exception.InvalidSelector"), string);
            throw new IlvStylingException(string4, ilvCSSparseException);
        }
        finally {
            Parser.setOptimized(bl3);
        }
    }

    @Override
    public void setAdjusting(boolean bl) {
        boolean bl2 = this.isAdjusting();
        this.e = bl ? ++this.e : --this.e;
        if (this.e < 0) {
            this.e = 0;
        }
        if (bl2 && !this.isAdjusting()) {
            if (this.d.wasChangeDuringAdjusting()) {
                this.validateRules(this.getAllRules(true), true);
            }
            this.d.fireStyleChangeAdjustmentEndEventIfNeeded();
        }
    }

    @Override
    public boolean isAdjusting() {
        return this.e > 0;
    }

    private static class Counter {
        int a = 0;

        private Counter() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SharpRuleUsageMap
    extends HashMap<String, Counter> {
        SharpRuleUsageMap() {
        }

        public void markUsed(String string) {
            Counter counter = (Counter)this.get(string);
            if (counter == null) {
                counter = new Counter();
                this.put(string, counter);
            }
            ++counter.a;
        }

        public void markUnused(String string) {
            Counter counter = (Counter)this.get(string);
            if (counter == null) {
                return;
            }
            --counter.a;
        }

        public int getUsageCount(String string) {
            Counter counter = (Counter)this.get(string);
            if (counter == null) {
                return 0;
            }
            return counter.a;
        }
    }
}

