/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class IlvSemiTransparentLabel
extends JLabel {
    protected TexturePaint tp;
    protected boolean hasFocus;
    protected boolean paintSemiTransparency = true;

    public IlvSemiTransparentLabel() {
        this.setOpaque(false);
    }

    public void paintComponent(Graphics graphics) {
        if (this.paintSemiTransparency) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n2 = this.getSize().width;
            int n3 = this.getSize().height;
            graphics2D.setPaint(this.tp);
            graphics2D.fill(new Rectangle(0, 0, n2, n3));
            if (this.hasFocus) {
                graphics2D.setColor(Color.gray);
                BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawRect(0, 0, n2 - 1, n3 - 1);
            }
        }
        super.paintComponent(graphics);
    }

    public void setBackground(Color color) {
        BasicStroke basicStroke = new BasicStroke(3.0f, 1, 1);
        color = this.setAlpha(color, 0.4f);
        super.setBackground(color);
        this.updateTexture();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.updateTexture();
    }

    protected Color setAlpha(Color color, float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Alpha value must be in the range [0,1]");
        }
        int n2 = (int)(f2 * 255.0f + 0.5f);
        if (color.getAlpha() == n2) {
            return color;
        }
        return new Color(color.getRGB() & 0xFFFFFF | n2 << 24, true);
    }

    protected void updateTexture() {
        BufferedImage bufferedImage = this.createImage();
        this.tp = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    protected BufferedImage createImage() {
        int n2 = 4;
        int n3 = 4;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        if (this.getBackground() != null) {
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n2, n3);
        }
        return bufferedImage;
    }
}

