/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.treetable;

import ilog.views.appframe.swing.treetable.IlvTreeTableModel;
import ilog.views.appframe.swing.treetable.IlvTreeTableModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class IlvTreeTable
extends JTable {
    TreeTableCellRenderer a;
    IlvTreeTableModel b;
    IlvTreeTableModelAdapter c;
    TreeCellRenderer d;

    public IlvTreeTable() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n2;
                Point point;
                int n3;
                if (mouseEvent.getClickCount() == 2 && (n3 = IlvTreeTable.this.columnAtPoint(point = mouseEvent.getPoint())) == 0 && (n2 = IlvTreeTable.this.rowAtPoint(point)) != -1) {
                    IlvTreeTable.this.expandRow(n2, !IlvTreeTable.this.isRowExpanded(n2));
                }
            }
        });
    }

    public void setTreeTableModel(IlvTreeTableModel ilvTreeTableModel) {
        this.b = ilvTreeTableModel;
        this.a = new TreeTableCellRenderer(ilvTreeTableModel);
        if (this.d != null) {
            this.a.setCellRenderer(this.d);
        }
        this.setBackground(this.a.getBackground());
        this.c = new IlvTreeTableModelAdapter(ilvTreeTableModel, this.a);
        super.setModel(this.c);
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.a.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.a());
        this.setDefaultRenderer(IlvTreeTableModel.class, this.a);
        this.setDefaultEditor(IlvTreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.a.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    public void insertNodeInto(Object object, Object object2, int n2) {
        this.b.insertNodeInto(object, object2, n2);
    }

    public void removeNode(Object object) {
        Object object2 = this.b.getParent(object);
        if (object2 != null) {
            int n2 = -1;
            int n3 = this.b.getChildCount(object2);
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.b.getChild(object2, i2) != object) continue;
                n2 = i2;
                break;
            }
            if (n2 != -1) {
                this.b.removeNode(object, object2, n2);
            }
        } else {
            this.b.removeNode(object, null, 0);
        }
    }

    public void tableContentChanged() {
        this.c.fireTableDataChanged();
    }

    public Object getNodeForRow(int n2) {
        return this.c == null ? null : this.c.nodeForRow(n2);
    }

    public int getRowForNode(Object object) {
        return this.c == null ? -1 : this.c.rowForNode(object);
    }

    public IlvTreeTableModel getTreeTableModel() {
        return this.b;
    }

    public void updateUI() {
        super.updateUI();
        if (this.a != null) {
            this.a.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == IlvTreeTableModel.class ? -1 : this.editingRow;
    }

    public void setRowHeight(int n2) {
        super.setRowHeight(n2);
        if (this.a != null && this.a.getRowHeight() != n2) {
            this.a.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.a;
    }

    public boolean expandRow(int n2, boolean bl) {
        TreePath treePath = this.a.getPathForRow(n2);
        if (treePath != null) {
            if (bl == this.a.isExpanded(treePath)) {
                return false;
            }
            if (bl) {
                this.a.expandPath(treePath);
            } else {
                this.a.collapsePath(treePath);
            }
            return true;
        }
        return false;
    }

    public boolean isRowExpanded(int n2) {
        return this.a.isExpanded(n2);
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (this.d == treeCellRenderer) {
            return;
        }
        this.d = treeCellRenderer;
        if (this.a != null) {
            this.a.setCellRenderer(treeCellRenderer);
            this.a.updateUI();
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.d;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        boolean a;

        public ListToTreeSelectionModelWrapper() {
            this.a().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel a() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.a) {
                this.a = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.a = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.a) {
                this.a = true;
                try {
                    int n2 = this.listSelectionModel.getMinSelectionIndex();
                    int n3 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n2 != -1 && n3 != -1) {
                        for (int i2 = n2; i2 <= n3; ++i2) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i2) || (treePath = IlvTreeTable.this.a.getPathForRow(i2)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.a = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Object getCellEditorValue() {
            return null;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
            return IlvTreeTable.this.a;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int i2 = IlvTreeTable.this.getColumnCount() - 1; i2 >= 0; --i2) {
                    if (IlvTreeTable.this.getColumnClass(i2) != IlvTreeTableModel.class) continue;
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(IlvTreeTable.this.a, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - IlvTreeTable.this.getCellRect((int)0, (int)i2, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    IlvTreeTable.this.a.dispatchEvent(mouseEvent2);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n2) {
            if (n2 > 0) {
                super.setRowHeight(n2);
                if (IlvTreeTable.this != null && IlvTreeTable.this.getRowHeight() != n2) {
                    IlvTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n2, int n3, int n4, int n5) {
            super.setBounds(n2, 0, n4, IlvTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n2;
            return this;
        }
    }
}

