/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.treetable;

import ilog.views.appframe.swing.treetable.IlvTreeTableModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class IlvAbstractTreeTableModel
implements IlvTreeTableModel {
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public IlvAbstractTreeTableModel(Object object) {
        this.root = object;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        for (int i2 = 0; i2 < this.getChildCount(object); ++i2) {
            if (!this.getChild(object, i2).equals(object2)) continue;
            return i2;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public Class getColumnClass(int n2) {
        return Object.class;
    }

    public boolean isCellEditable(Object object, int n2) {
        return this.getColumnClass(n2) == IlvAbstractTreeTableModel.class;
    }

    public void setValueAt(Object object, Object object2, int n2) {
    }

    public void insertNodeInto(Object object, Object object2, int n2) {
        int[] nArray = new int[]{n2};
        this.nodesWereInserted(object2, nArray);
    }

    public void nodesWereInserted(Object object, int[] nArray) {
        if (this.listenerList != null && object != null && nArray != null && nArray.length > 0) {
            int n2 = nArray.length;
            Object[] objectArray = new Object[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = this.getChild(object, nArray[i2]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(object), nArray, objectArray);
        }
    }

    public Object[] getPathToRoot(Object object) {
        return this.getPathToRoot(object, 0);
    }

    protected Object[] getPathToRoot(Object object, int n2) {
        Object[] objectArray;
        if (object == null) {
            if (n2 == 0) {
                return null;
            }
            objectArray = new TreeNode[n2];
        } else {
            objectArray = object == this.root ? new Object[n2] : this.getPathToRoot(this.getParent(object), ++n2);
            objectArray[objectArray.length - n2] = object;
        }
        return objectArray;
    }

    public void removeNode(Object object, Object object2, int n2) {
        if (object2 == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        this.nodesWereRemoved(object2, new int[]{n2}, new Object[]{object});
    }

    public void nodesWereRemoved(Object object, int[] nArray, Object[] objectArray) {
        if (object != null && nArray != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(object), nArray, objectArray);
        }
    }

    public abstract int getChildCount(Object var1);

    public abstract Object getChild(Object var1, int var2);

    public abstract Object getParent(Object var1);
}

