/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.event.IlvComponentVisibilityActionHandler;
import ilog.views.appframe.swing.bars.IlvDockingBarAreaHandler;
import ilog.views.appframe.swing.util.IlvSwingUtil;
import ilog.views.appframe.swing.util.LookAndFeelManager;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class IlvDockingBarArea
extends JPanel {
    private transient boolean a;
    private transient IlvDockingBarAreaHandler b = new IlvDockingBarAreaHandler(this);
    private transient Frame c;
    private static final String d = "DockingBarAreaUI";
    public static final String MENU_TYPE = "menu";
    public static final String TOOLBAR_TYPE = "toolbar";

    public IlvDockingBarArea() {
        DockingBarAreaListener dockingBarAreaListener = new DockingBarAreaListener();
        this.addComponentListener(dockingBarAreaListener);
        this.addHierarchyListener(dockingBarAreaListener);
    }

    public String getUIClassID() {
        return d;
    }

    public Container getClientContainer() {
        return this.b.getClientContainer();
    }

    public void setClientContainer(Container container) {
        this.b.setClientContainer(container);
    }

    public IlvApplication getApplication() {
        return this.b.getApplication();
    }

    public void setApplication(IlvApplication ilvApplication) {
        if (ilvApplication != null && !IlvSwingUtil.IsMainWindowInitialized(ilvApplication)) {
            IlvSwingUtil.LockMainWindowInitialized(ilvApplication);
        }
        this.b.setApplication(ilvApplication);
        this.b();
    }

    public void setConfiguration(String string) {
        String string2 = this.getConfiguration();
        if (string2 != null && string2.equals(string)) {
            return;
        }
        if (this.b.hasWorkspace(string)) {
            IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Logging.BarDocking.CannotFindWorkspace", new Object[]{string});
            return;
        }
        if (!this.a) {
            this.b.setCurrentWorkspace(string);
            return;
        }
        this.b.applyWorkspace(string);
    }

    public String getConfiguration() {
        return this.b.getWorkspaceConfiguration();
    }

    public JComponent getBar(String string) {
        return this.b.getBar(string);
    }

    public JComponent createBar(String string, String string2) {
        return this.b.createBar(string, string2);
    }

    Frame a() {
        if (this.c != null) {
            return this.c;
        }
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            this.c = (Frame)container;
            return this.c;
        }
        return null;
    }

    void b() {
        if (this.a || this.b.getCurrentWorkspace() == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        this.b.applyWorkspace(this.b.getWorkspaceConfiguration());
        this.a = true;
        IlvApplication ilvApplication = this.getApplication();
        if (ilvApplication != null && !IlvSwingUtil.IsMainWindowInitialized(ilvApplication)) {
            IlvSwingUtil.UnLockMainWindowInitialized(ilvApplication);
        }
    }

    public DockingBarInfo getDockingInfo(String string) {
        return this.b.getDockingInfo(string);
    }

    public void registerBar(String string, JComponent jComponent, boolean bl, boolean bl2, String string2) {
        this.b.registerBar(string, jComponent, bl, bl2, string2);
    }

    public DockingBarInfo dock(String string, int n2) {
        if (string == null || string.length() == 0) {
            IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Logging.BarDocking.MustNotSpecifyNullBarName");
            return null;
        }
        return this.b.dock(string, n2);
    }

    public DockingBarInfo undock(String string, Point point) {
        return this.b.undock(string, point);
    }

    public DockingBarInfo setBarVisible(String string, boolean bl) {
        return this.b.setBarVisible(string, bl);
    }

    public boolean isBarVisible(String string) {
        return this.b.isBarVisible(string);
    }

    public boolean isBarExtensible(String string) {
        return this.b.isBarExtensible(string);
    }

    public IlvComponentVisibilityActionHandler getBarVisibilityActionHandler(String string, String string2) {
        return this.b.getBarVisibilityActionHandler(string, string2);
    }

    public boolean isBarDockable(String string) {
        return this.b.isBarDockable(string);
    }

    public void addNotify() {
        this.b.setParentFrame(this.a());
        this.b();
        super.addNotify();
    }

    public JComponent[] getBarComponents() {
        return this.b.getBarComponents();
    }

    private void c() {
        int n2 = this.b.getFloatingWindowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Container container = this.b.getFloatableWindow(i2);
            SwingUtilities.updateComponentTreeUI(container);
        }
    }

    static {
        LookAndFeelManager.RegisterUIClassName(d, "Windows", "ilog.views.appframe.swing.plaf.windows.WindowsXPDockingBarAreaUI");
        LookAndFeelManager.RegisterUIClassName(d, null, "ilog.views.appframe.swing.plaf.basic.BasicDockingBarAreaUI");
    }

    private class DockingBarAreaListener
    implements ComponentListener,
    HierarchyListener {
        private transient PropertyChangeListener a;
        private transient boolean b;

        private DockingBarAreaListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (hierarchyEvent.getID() == 1400 && (hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getComponent().isShowing()) {
                IlvDockingBarArea.this.b();
                this.a();
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.a();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.a();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (this.b) {
                UIManager.removePropertyChangeListener(this.a);
                this.b = false;
            }
        }

        private void a() {
            if (this.b) {
                return;
            }
            if (this.a == null) {
                this.a = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (!propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                            return;
                        }
                        IlvDockingBarArea.this.c();
                    }
                };
            }
            UIManager.addPropertyChangeListener(this.a);
            this.b = true;
        }
    }

    public static interface DockingBarInfo {
        public String getName();

        public boolean isVisible();

        public boolean isDocked();

        public boolean isUndocked();

        public int getDockingSide();

        public Point getFloatingLocation();
    }
}

