/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.beans.editor;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.util.IlvURLResolver;
import ilog.views.util.IlvResourceUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JTextField;

public class URLEditor
extends Panel
implements PropertyEditor {
    protected URL currentValue = null;
    protected PropertyChangeSupport support = null;
    protected JTextField textfield;
    protected FileDialog fileDialog;
    protected Button selectURLButton;
    private static final ResourceBundle a = IlvResourceUtil.getBundle("ilog.views.util.beans.editor.editors");
    protected String fileDialogTitle = a.getString("URLStringPropertyEditor.ChooseURL");
    protected IlvApplication application = null;
    protected Label labelComponent = null;
    protected IlvURLResolver urlResolver = null;

    public URLEditor() {
        this.setLayout(new BorderLayout(0, 0));
        this.support = new PropertyChangeSupport(this);
        this.textfield = new JTextField(20);
        this.labelComponent = new Label(a.getString("URLStringPropertyEditor.EnterURL"));
        this.add((Component)this.labelComponent, "Before");
        this.add((Component)this.textfield, "Center");
        this.selectURLButton = new Button("...");
        this.add((Component)this.selectURLButton, "After");
        this.selectURLButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URLEditor.this.selectURL();
            }
        });
        this.textfield.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = URLEditor.this.textfield.getText();
                if (string != null && string.length() != 0) {
                    URL uRL = (URL)URLEditor.this.getValue();
                    try {
                        URL uRL2;
                        IlvURLResolver ilvURLResolver = URLEditor.this.getURLResolver();
                        URL uRL3 = uRL2 = ilvURLResolver != null ? ilvURLResolver.resolveURL(string) : null;
                        if (uRL2 == null) {
                            uRL2 = new URL(string);
                        }
                        URLEditor.this.currentValue = uRL2;
                        URLEditor.this.support.firePropertyChange(null, uRL, uRL2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public boolean selectURL(String string, String string2, String string3) {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(new Frame(), string);
        } else {
            this.fileDialog.setTitle(string);
        }
        if (string2 != null && string2.length() > 0) {
            this.fileDialog.setDirectory(string2);
        }
        if (string3 != null && string3.length() > 0) {
            this.fileDialog.setFile(string3);
        }
        return this.selectURL();
    }

    public boolean selectURL() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(new Frame(), this.fileDialogTitle);
        }
        this.fileDialog.setVisible(true);
        if (this.fileDialog.getFile() != null) {
            try {
                this.setURL(new URL("file:" + this.fileDialog.getDirectory() + this.fileDialog.getFile()));
            }
            catch (MalformedURLException malformedURLException) {
                this.textfield.setText("");
            }
            this.textfield.requestFocus();
            return true;
        }
        return false;
    }

    public void setValue(Object object) {
        this.setURL((URL)object);
    }

    public void setURL(URL uRL) {
        if (this.currentValue == uRL) {
            return;
        }
        URL uRL2 = this.currentValue;
        this.currentValue = uRL;
        this.firePropertyChange(uRL2, this.currentValue);
        if (this.currentValue != null) {
            IlvURLResolver ilvURLResolver = this.getURLResolver();
            if (ilvURLResolver != null) {
                String string = ilvURLResolver.getAbbreviateForm(this.currentValue);
                if (string != null) {
                    this.textfield.setText(string);
                } else {
                    this.textfield.setText(this.currentValue.toExternalForm());
                }
            } else {
                this.textfield.setText(this.currentValue.toExternalForm());
            }
        } else {
            this.textfield.setText("");
        }
    }

    public URL getURL() {
        return this.currentValue;
    }

    public Object getValue() {
        return this.currentValue;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        int n2;
        if (this.currentValue == null) {
            return "null";
        }
        String string = this.currentValue.toExternalForm().trim();
        int n3 = 0;
        while ((n2 = string.indexOf("\\", n3)) != -1) {
            string = string.substring(0, n2) + "\\" + string.substring(n2);
            n3 = n2 + 2;
        }
        return "new java.net.URL(\"" + string + "\")";
    }

    public String getAsText() {
        if (this.currentValue != null) {
            return this.currentValue.toExternalForm();
        }
        return "";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            URL uRL = null;
            IlvURLResolver ilvURLResolver = this.getURLResolver();
            if (ilvURLResolver != null) {
                uRL = ilvURLResolver.resolveURL(string);
            }
            if (uRL == null) {
                uRL = new URL(string);
            }
            this.setValue(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            this.setValue(null);
        }
    }

    public String[] getTags() {
        return null;
    }

    public void firePropertyChange(URL uRL, URL uRL2) {
        this.support.firePropertyChange(null, uRL, uRL2);
    }

    public Component getCustomEditor() {
        if (this.currentValue != null) {
            this.textfield.setText(this.currentValue.toExternalForm());
        } else {
            this.textfield.setText("");
        }
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setApplication(IlvApplication ilvApplication) {
        this.application = ilvApplication;
        if (ilvApplication != null) {
            this.labelComponent.setText(ilvApplication.getString(this.labelComponent.getText()));
        }
    }

    public IlvApplication getApplication() {
        return this.application;
    }

    public String getLabel() {
        return this.labelComponent.getText();
    }

    public void setLabel(String string) {
        this.labelComponent.setText(string);
    }

    public Button getFileDialogButton() {
        return this.selectURLButton;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textfield.setOpaque(bl);
        this.selectURLButton.setEnabled(bl);
        this.labelComponent.setEnabled(bl);
    }

    public JTextField getTextField() {
        return this.textfield;
    }

    public void setURLResolver(IlvURLResolver ilvURLResolver) {
        this.urlResolver = ilvURLResolver;
    }

    public IlvURLResolver getURLResolver() {
        return this.urlResolver == null ? this.application.getURLResolverManager() : this.urlResolver;
    }
}

