/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.util.collections.IlvCollections;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class IlvGraphicVector
implements Cloneable,
Serializable {
    private static final String a = "The IlvGraphicVector was modified while enumerating its contents. If you are using multiple threads, probably some synchronization is missing. Synchronize adding, removing, accessing and enumerating over elements.\nIf you are using only a single thread, probably some objects were added or removed while enumerating over elements. In this case consider using ilog.views.IlvBufferedGraphicEnumeration.\nUse the flag IlvGraphicVector.DEBUG to debug this situation.";
    private static final String b = "Location of recent modification";
    public static boolean DEBUG = false;
    public static boolean checkConcurrentModification = true;
    protected IlvGraphic[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private transient int c = 0;
    private transient Exception d;

    public IlvGraphicVector(int n2, int n3) {
        this.elementData = new IlvGraphic[n2];
        this.capacityIncrement = n3;
    }

    public IlvGraphicVector(int n2) {
        this(n2, 0);
    }

    public IlvGraphicVector() {
        this(10);
    }

    public final void copyInto(IlvGraphic[] ilvGraphicArray) {
        System.arraycopy(this.elementData, 0, ilvGraphicArray, 0, this.elementCount);
    }

    public final void trimToSize() {
        int n2 = this.elementData.length;
        if (this.elementCount < n2) {
            IlvGraphic[] ilvGraphicArray = this.elementData;
            this.elementData = new IlvGraphic[this.elementCount];
            System.arraycopy(ilvGraphicArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int n2) {
        int n3 = this.c;
        int n4 = this.elementData.length;
        if (n2 > n4) {
            int n5;
            IlvGraphic[] ilvGraphicArray = this.elementData;
            int n6 = n5 = this.capacityIncrement > 0 ? n4 + this.capacityIncrement : n4 * 3 / 2 + 1;
            if (n5 < n2) {
                n5 = n2;
            }
            this.elementData = new IlvGraphic[n5];
            System.arraycopy(ilvGraphicArray, 0, this.elementData, 0, this.elementCount);
        }
        if (checkConcurrentModification && n3 != this.c) {
            throw IlvCollections.concurrentModificationException(a, this.d);
        }
    }

    public final void setSize(int n2) {
        if (n2 > this.elementCount) {
            this.ensureCapacity(n2);
        } else {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
        }
        this.elementCount = n2;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final IlvGraphicEnumeration elements() {
        return new IlvGraphicVectorEnumerator(this, this.c);
    }

    public final boolean contains(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0) >= 0;
    }

    public final int indexOf(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0);
    }

    public final int indexOf(IlvGraphic ilvGraphic, int n2) {
        for (int i2 = n2; i2 < this.elementCount; ++i2) {
            if (!ilvGraphic.equals(this.elementData[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic) {
        return this.lastIndexOf(ilvGraphic, this.elementCount);
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic, int n2) {
        int n3 = n2;
        while (--n3 >= 0) {
            if (!ilvGraphic.equals(this.elementData[n3])) continue;
            return n3;
        }
        return -1;
    }

    public final IlvGraphic elementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
    }

    public final IlvGraphic firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final IlvGraphic lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final IlvGraphic setElementAt(IlvGraphic ilvGraphic, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        IlvGraphic ilvGraphic2 = this.elementData[n2];
        this.elementData[n2] = ilvGraphic;
        ++this.c;
        if (DEBUG) {
            this.d = new Exception(b);
        }
        return ilvGraphic2;
    }

    public final void removeElementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        --this.elementCount;
        ++this.c;
        if (DEBUG) {
            this.d = new Exception(b);
        }
        this.elementData[this.elementCount] = null;
    }

    public final void insertElementAt(IlvGraphic ilvGraphic, int n2) {
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount + 1);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = ilvGraphic;
        ++this.elementCount;
        ++this.c;
        if (DEBUG) {
            this.d = new Exception(b);
        }
    }

    public final void addElement(IlvGraphic ilvGraphic) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = ilvGraphic;
        ++this.c;
        if (DEBUG) {
            this.d = new Exception(b);
        }
    }

    public final boolean removeElement(IlvGraphic ilvGraphic) {
        int n2 = this.indexOf(ilvGraphic);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
        ++this.c;
        if (DEBUG) {
            this.d = new Exception(b);
        }
    }

    public Object clone() {
        try {
            IlvGraphicVector ilvGraphicVector = (IlvGraphicVector)super.clone();
            ilvGraphicVector.elementData = new IlvGraphic[this.elementCount];
            System.arraycopy(this.elementData, 0, ilvGraphicVector.elementData, 0, this.elementCount);
            ilvGraphicVector.c = 0;
            ilvGraphicVector.d = null;
            return ilvGraphicVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    final void a(Comparator comparator) {
        this.trimToSize();
        Arrays.sort(this.elementData, comparator);
        ++this.c;
        if (DEBUG) {
            this.d = new Exception(b);
        }
    }

    public final String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        IlvGraphicEnumeration ilvGraphicEnumeration = this.elements();
        stringBuffer.append("[");
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = ilvGraphicEnumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    final class IlvGraphicVectorEnumerator
    implements IlvGraphicEnumeration {
        private IlvGraphicVector a;
        private int b;
        private int c;

        IlvGraphicVectorEnumerator(IlvGraphicVector ilvGraphicVector2, int n2) {
            this.a = ilvGraphicVector2;
            this.c = n2;
        }

        public boolean hasMoreElements() {
            return this.b < this.a.elementCount;
        }

        public IlvGraphic nextElement() {
            if (checkConcurrentModification && this.c != IlvGraphicVector.this.c) {
                throw IlvCollections.concurrentModificationException(IlvGraphicVector.a, IlvGraphicVector.this.d);
            }
            if (this.b < this.a.elementCount) {
                return this.a.elementData[this.b++];
            }
            throw new NoSuchElementException("IlvGraphicVectorEnumerator");
        }
    }
}

