/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvAList;
import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvNamedProperty;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvQuadtree;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.event.IlvListenerList;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.event.ManagerViewsHierarchyEventReceiver;
import ilog.views.event.NamedPropertyEvent;
import ilog.views.event.NamedPropertyListener;
import ilog.views.graphic.IlvGraphicHandleBag;
import ilog.views.internal.IlvBlinkingUtil;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.java2d.IlvBlinkingAction;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.swing.IlvPopupMenuContext;
import ilog.views.swing.IlvPopupMenuManager;
import ilog.views.util.java2d.IlvBlinkingDrawingResource;
import ilog.views.util.java2d.IlvBlinkingObject;
import ilog.views.util.java2d.IlvBlinkingObjectOwner;
import ilog.views.util.java2d.internal.IlvBlinkingManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IlvGraphic
implements Serializable,
Transferable,
IlvPersistentObject,
IlvBlinkingObject {
    private static final String a = "__ilvObjectInteractorProperty";
    IlvGraphicBag b;
    private IlvAList c;
    private static final short d = 1;
    private static final short e = 2;
    private static final short f = 4;
    private static final short g = 8;
    private short h = (short)15;
    private transient int i = -1;
    private transient int j = -10000;
    private transient Listener k;
    private BlinkingInfo l;
    private transient IlvQuadtree m;
    private IlvObjectProperty n;
    private transient int o;
    private static final String p = "__IlvGraphicName";
    private static final String q = "__ActionListener";
    private static final String r = "__IlvNamedProps";
    private static final String s = "__IlvGraphicToolTipText";
    private static final String t = "__IlvGraphicPopupMenu";
    private static final DataFlavor[] u = new DataFlavor[]{DataFlavor.stringFlavor};

    public IlvGraphic() {
    }

    public IlvGraphic(IlvGraphic ilvGraphic) {
        HashMap hashMap = ilvGraphic.f(false);
        if (hashMap != null) {
            for (IlvNamedProperty ilvNamedProperty : hashMap.values()) {
                IlvNamedProperty ilvNamedProperty2 = ilvNamedProperty.copy();
                if (ilvNamedProperty2 == null) continue;
                this.setNamedProperty(ilvNamedProperty2);
            }
        }
        this.setToolTipText(ilvGraphic.getToolTipText());
        this.setProperty(t, ilvGraphic.getProperty(t));
        this.setBlinkingAction(ilvGraphic.getBlinkingAction());
        this.setBlinkingOnPeriod(ilvGraphic.getBlinkingOnPeriod());
        this.setBlinkingOffPeriod(ilvGraphic.getBlinkingOffPeriod());
        this.h = ilvGraphic.h;
        this.i = -1;
    }

    public abstract IlvGraphic copy();

    public boolean zoomable() {
        return true;
    }

    public IlvGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        Object object;
        ilvInputStream.registerGraphic(this);
        try {
            String string = ilvInputStream.readString("name");
            this.setName(string);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            boolean bl = ilvInputStream.readBoolean("visible");
            this.setVisible(bl);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            long l2 = ilvInputStream.readLong("blinkingOnPeriod");
            this.setBlinkingOnPeriod(l2);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            long l3 = ilvInputStream.readLong("blinkingOffPeriod");
            this.setBlinkingOffPeriod(l3);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            object = ilvInputStream.readPersistentObject("blinkingAction");
            this.setBlinkingAction((IlvBlinkingAction)object);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            object = ilvInputStream.readString("toolTip");
            this.setToolTipText((String)object);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            object = ilvInputStream.readString("popupMenuName");
            this.setPopupMenuName((String)object);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        object = IlvNamedProperty.a(ilvInputStream);
        if (object != null) {
            HashMap hashMap = this.f(true);
            hashMap.clear();
            hashMap.putAll(object);
        }
        this.i = -1;
    }

    final void a(IlvQuadtree ilvQuadtree) {
        this.m = ilvQuadtree;
    }

    final IlvQuadtree h() {
        return this.m;
    }

    public final void setZOrderIndex(int n2) {
        this.i = n2;
    }

    public final int getZOrderIndex() {
        return this.i;
    }

    public abstract void draw(Graphics var1, IlvTransformer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void callDraw(Graphics graphics, IlvTransformer ilvTransformer) {
        int n2;
        int n3;
        boolean bl = IlvBlinkingUtil.isBlinkingAllowed(graphics);
        ArrayList<IlvBlinkingDrawingResource> arrayList = null;
        if (bl) {
            if (!this.j()) {
                return;
            }
        } else {
            arrayList = this.a();
            if (arrayList != null) {
                n3 = arrayList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    arrayList.get(n2).setTemporarilyDisabled(true);
                }
            }
        }
        try {
            this.draw(graphics, ilvTransformer);
        }
        finally {
            if (!bl && arrayList != null) {
                n3 = arrayList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    arrayList.get(n2).setTemporarilyDisabled(false);
                }
            }
        }
    }

    public abstract IlvRect boundingBox(IlvTransformer var1);

    public final IlvRect boundingBox() {
        return this.boundingBox(null);
    }

    public IlvPoint getCenter(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
    }

    public abstract void applyTransform(IlvTransformer var1);

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer).inside(ilvPoint2.x, ilvPoint2.y);
    }

    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer).intersects(ilvRect2);
    }

    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        return ilvRect2.contains(this.boundingBox(ilvTransformer));
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return IlvClippingUtil.getClippedPoint(this.boundingBox(ilvTransformer), ilvPoint, ilvPoint2);
    }

    public void move(float f2, float f3) {
        IlvRect ilvRect = this.boundingBox(null);
        this.translate(f2 - ilvRect.x, f3 - ilvRect.y);
    }

    public void move(IlvPoint ilvPoint) {
        this.move(ilvPoint.x, ilvPoint.y);
    }

    public void moveResize(IlvRect ilvRect) {
        IlvRect ilvRect2 = this.boundingBox(null);
        if (!ilvRect2.equals(ilvRect)) {
            ilvRect2 = this.a(ilvRect2);
            ilvRect = this.a(ilvRect);
            IlvTransformer ilvTransformer = new IlvTransformer();
            IlvTransformer.computeTransformer(ilvRect2, ilvRect, ilvTransformer);
            if (!ilvTransformer.isBad()) {
                this.applyTransform(ilvTransformer);
            }
        }
    }

    private IlvRect a(IlvRect ilvRect) {
        if (ilvRect.width >= 1.0E-20f && ilvRect.height >= 1.0E-20f) {
            return ilvRect;
        }
        ilvRect = new IlvRect(ilvRect);
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    public void translate(float f2, float f3) {
        IlvTransformer ilvTransformer = new IlvTransformer(1.0, 0.0, 0.0, 1.0, f2, f3);
        this.applyTransform(ilvTransformer);
    }

    public void rotate(IlvPoint ilvPoint, double d2) {
        double d3;
        double d4 = Math.cos(d2 = IlvUtil.degreesToRadians(d2));
        IlvTransformer ilvTransformer = new IlvTransformer(d4, -(d3 = Math.sin(d2)), d3, d4, (double)ilvPoint.x * (1.0 - d4) + d3 * (double)ilvPoint.y, -((double)ilvPoint.x * d3) + (double)ilvPoint.y * (1.0 - d4));
        if (!ilvTransformer.isBad()) {
            this.applyTransform(ilvTransformer);
        }
    }

    public void scale(double d2, double d3) {
        IlvRect ilvRect = this.boundingBox(null);
        double d4 = (1.0 - d2) * (double)ilvRect.x;
        double d5 = (1.0 - d3) * (double)ilvRect.y;
        IlvTransformer ilvTransformer = new IlvTransformer(d2, 0.0, 0.0, d3, d4, d5);
        if (!ilvTransformer.isBad()) {
            this.applyTransform(ilvTransformer);
        }
    }

    public void resize(float f2, float f3) {
        IlvRect ilvRect = this.boundingBox(null);
        this.scale((double)f2 / (double)Math.max(1.0E-20f, ilvRect.width), (double)f3 / (double)Math.max(1.0E-20f, ilvRect.height));
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        if (this.needsViewNotification()) {
            this.c(false);
        }
        this.b = ilvGraphicBag;
        if (this.needsViewNotification()) {
            this.c(true);
        }
    }

    public final IlvGraphicBag getGraphicBag() {
        return this.b;
    }

    public final synchronized IlvGraphicBag getTopLevelGraphicBag() {
        IlvGraphicBag ilvGraphicBag;
        for (ilvGraphicBag = this.b; ilvGraphicBag != null && ilvGraphicBag.getGraphicBag() != null; ilvGraphicBag = ilvGraphicBag.getGraphicBag()) {
        }
        return ilvGraphicBag;
    }

    final void a(IlvObjectProperty ilvObjectProperty) {
        IlvObjectProperty ilvObjectProperty2 = this.n;
        this.n = ilvObjectProperty;
        if (ilvObjectProperty != null) {
            ilvObjectProperty.a(this, ilvObjectProperty2, ilvObjectProperty);
        } else if (ilvObjectProperty2 != null) {
            ilvObjectProperty2.a(this, ilvObjectProperty2, ilvObjectProperty);
        }
    }

    final IlvObjectProperty i() {
        return this.n;
    }

    public void setForeground(Color color) {
    }

    public void setBackground(Color color) {
    }

    public void setFillOn(boolean bl) {
    }

    public void setStrokeOn(boolean bl) {
    }

    @Override
    public void reDraw() {
        if (this.b != null) {
            this.b.reDrawObj(this);
        }
    }

    public void setName(String string) {
        if (this.getGraphicBag() != null) {
            this.getGraphicBag().setObjectName(this, string);
        } else {
            this.setNameImpl(string);
        }
    }

    public void setNameImpl(String string) {
        this.setProperty(p, string);
    }

    public String getName() {
        return (String)this.getProperty(p);
    }

    public boolean removeProperty(String string) {
        return this.c != null ? this.c.a(string) : false;
    }

    public void setProperty(String string, Object object) {
        if (object != null) {
            if (!this.replaceProperty(string, object)) {
                if (this.c == null) {
                    this.c = new IlvAList();
                }
                this.c.a(string, object);
            }
        } else {
            this.removeProperty(string);
        }
    }

    public boolean replaceProperty(String string, Object object) {
        if (object == null) {
            return false;
        }
        return this.c != null ? this.c.b(string, object) : false;
    }

    public Object getProperty(String string) {
        return this.c != null ? this.c.b(string) : null;
    }

    public boolean hasProperty(String string, Object object) {
        return this.c != null ? this.c.b(string) == object : false;
    }

    public boolean isVisible() {
        return (this.h & 1) != 0;
    }

    public final void setVisible(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.h & 1) != 0;
        if (bl != bl2) {
            IlvManagerLayer ilvManagerLayer;
            this.h = bl ? (short)(this.h | 1) : (short)(this.h & 0xFFFFFFFE);
            if (this.n != null && (ilvManagerLayer = this.n.g()) != null) {
                ilvManagerLayer.b(this);
            }
        }
    }

    public boolean isMovable() {
        return (this.h & 8) != 0;
    }

    public final void setMovable(boolean bl) {
        this.h = bl ? (short)(this.h | 8) : (short)(this.h & 0xFFFFFFF7);
    }

    public final boolean isEditable() {
        return (this.h & 2) != 0;
    }

    public final void setEditable(boolean bl) {
        this.h = bl ? (short)(this.h | 2) : (short)(this.h & 0xFFFFFFFD);
    }

    public boolean isSelectable() {
        return (this.h & 4) != 0;
    }

    public final void setSelectable(boolean bl) {
        this.h = bl ? (short)(this.h | 4) : (short)(this.h & 0xFFFFFFFB);
    }

    public final void addActionListener(ActionListener actionListener) {
        IlvListenerList ilvListenerList = (IlvListenerList)this.getProperty(q);
        if (ilvListenerList == null) {
            ilvListenerList = new IlvListenerList();
            this.setProperty(q, ilvListenerList);
        }
        ilvListenerList.add(actionListener);
    }

    public final void removeActionListener(ActionListener actionListener) {
        IlvListenerList ilvListenerList = (IlvListenerList)this.getProperty(q);
        if (ilvListenerList == null) {
            return;
        }
        ilvListenerList.remove(actionListener);
        if (ilvListenerList.getListenerCount() == 0) {
            this.setProperty(q, null);
        }
    }

    public void processActionEvent(ActionEvent actionEvent) {
        IlvListenerList ilvListenerList = (IlvListenerList)this.getProperty(q);
        if (ilvListenerList == null) {
            return;
        }
        Object[] objectArray = ilvListenerList.getListenerList();
        for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
            ((ActionListener)objectArray[i2]).actionPerformed(actionEvent);
        }
    }

    public IlvSelection makeSelection() {
        return new IlvDrawSelection(this);
    }

    public String getDefaultInteractor() {
        return null;
    }

    public final IlvObjectInteractor getObjectInteractor() {
        return (IlvObjectInteractor)this.getProperty(a);
    }

    public final void setObjectInteractor(IlvObjectInteractor ilvObjectInteractor) {
        this.setProperty(a, ilvObjectInteractor);
        this.notifyObjectInteractorToManager(ilvObjectInteractor);
    }

    protected void notifyObjectInteractorToManager(IlvObjectInteractor ilvObjectInteractor) {
        if (ilvObjectInteractor == null) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        while (ilvGraphicBag instanceof IlvGraphicHandleBag) {
            IlvGraphicHandleBag ilvGraphicHandleBag = (IlvGraphicHandleBag)ilvGraphicBag;
            IlvObjectInteractor ilvObjectInteractor2 = ilvGraphicHandleBag.getObjectInteractor();
            if (!ilvGraphicHandleBag.isDelegateObjectInteractor(ilvObjectInteractor2)) {
                return;
            }
            ilvGraphicBag = ilvGraphicHandleBag.getGraphicBag();
        }
        if (ilvGraphicBag instanceof IlvManager) {
            ((IlvManager)ilvGraphicBag).e();
        }
    }

    public final IlvObjectInteractor getAndAssociateObjectInteractor() {
        IlvObjectInteractor ilvObjectInteractor = this.getObjectInteractor();
        if (ilvObjectInteractor != null) {
            return ilvObjectInteractor;
        }
        ilvObjectInteractor = IlvObjectInteractor.Get(this.getDefaultInteractor());
        if (ilvObjectInteractor != null) {
            this.setObjectInteractor(ilvObjectInteractor);
        }
        return ilvObjectInteractor;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        String string;
        String string2;
        if (ilvOutputStream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        String string3 = this.getName();
        if (string3 != null) {
            ilvOutputStream.write("name", string3);
        }
        if (!this.isVisible()) {
            ilvOutputStream.write("visible", false);
        }
        if (this.getBlinkingOnPeriod() != 0L) {
            ilvOutputStream.write("blinkingOnPeriod", this.getBlinkingOnPeriod());
        }
        if (this.getBlinkingOffPeriod() != 0L) {
            ilvOutputStream.write("blinkingOffPeriod", this.getBlinkingOffPeriod());
        }
        if (this.getBlinkingAction() instanceof IlvPersistentObject) {
            ilvOutputStream.write("blinkingAction", (IlvPersistentObject)((Object)this.getBlinkingAction()));
        }
        if ((string2 = this.getToolTipText()) != null) {
            ilvOutputStream.write("toolTip", string2);
        }
        if ((string = this.getPopupMenuName()) != null) {
            ilvOutputStream.write("popupMenuName", string);
        }
        IlvNamedProperty.a(ilvOutputStream, this.f(false));
    }

    public boolean isPersistent() {
        return true;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return u;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.stringFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            String string = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IlvOutputStream ilvOutputStream = new IlvOutputStream(byteArrayOutputStream);
            try {
                ilvOutputStream.write("transfer", (IlvPersistentObject)this);
                ilvOutputStream.flush();
                string = ((Object)byteArrayOutputStream).toString();
            }
            finally {
                ((OutputStream)byteArrayOutputStream).close();
            }
            return string;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static IlvGraphic GetGraphicObject(Transferable transferable) throws IOException {
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String string = null;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            IlvInputStream ilvInputStream = new IlvInputStream(byteArrayInputStream);
            IlvGraphic ilvGraphic = null;
            try {
                ilvGraphic = (IlvGraphic)ilvInputStream.readPersistentObject("transfer");
            }
            catch (IlvReadFileException ilvReadFileException) {
                IOException iOException = new IOException(ilvReadFileException.getMessage());
                iOException.initCause(ilvReadFileException);
                throw iOException;
            }
            finally {
                ((InputStream)byteArrayInputStream).close();
            }
            return ilvGraphic;
        }
        return null;
    }

    public String toString() {
        String string = this.getName();
        return super.toString() + (string != null ? " Name: " + string : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlinkingAction(IlvBlinkingAction ilvBlinkingAction) {
        IlvBlinkingAction ilvBlinkingAction2 = this.getBlinkingAction();
        if (ilvBlinkingAction != ilvBlinkingAction2) {
            if (ilvBlinkingAction2 != null) {
                ilvBlinkingAction2.setTemporarilyDisabled(true);
            }
            try {
                this.a((boolean)true).a = ilvBlinkingAction;
                this.a(ilvBlinkingAction2, ilvBlinkingAction, false);
            }
            finally {
                if (ilvBlinkingAction2 != null) {
                    ilvBlinkingAction2.setTemporarilyDisabled(false);
                }
            }
        }
    }

    public IlvBlinkingAction getBlinkingAction() {
        BlinkingInfo blinkingInfo = this.a(false);
        return blinkingInfo == null ? null : blinkingInfo.a;
    }

    private ArrayList<IlvBlinkingDrawingResource> a() {
        BlinkingInfo blinkingInfo = this.a(false);
        return blinkingInfo == null ? null : blinkingInfo.b;
    }

    protected void registerBlinkingResource(Object object, Object object2) {
        this.a(object, object2, true);
    }

    private void a(Object object, Object object2, boolean bl) {
        BlinkingInfo blinkingInfo;
        IlvBlinkingDrawingResource ilvBlinkingDrawingResource;
        boolean bl2;
        if (object == object2) {
            return;
        }
        boolean bl3 = bl2 = this.c() > 0;
        if (object instanceof IlvBlinkingDrawingResource) {
            ilvBlinkingDrawingResource = (IlvBlinkingDrawingResource)object;
            if (bl2) {
                ilvBlinkingDrawingResource.notifyUsed(this, false);
            }
            if (bl && (blinkingInfo = this.a(false)) != null && blinkingInfo.b != null) {
                int n2 = blinkingInfo.b.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (blinkingInfo.b.get(i2) != ilvBlinkingDrawingResource) continue;
                    blinkingInfo.b.remove(i2);
                    break;
                }
                if (blinkingInfo.b.size() == 0) {
                    blinkingInfo.b = null;
                }
            }
        }
        if (object2 instanceof IlvBlinkingDrawingResource) {
            ilvBlinkingDrawingResource = (IlvBlinkingDrawingResource)object2;
            if (bl2) {
                ilvBlinkingDrawingResource.notifyUsed(this, true);
            }
            if (bl) {
                blinkingInfo = this.a(true);
                if (blinkingInfo.b == null) {
                    blinkingInfo.b = new ArrayList(2);
                }
                blinkingInfo.b.add(ilvBlinkingDrawingResource);
            }
        }
        this.updateNeedsViewNotification();
    }

    public void setBlinkingOnPeriod(long l2) {
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 == this.getBlinkingOnPeriod()) {
            return;
        }
        if (this.b() && this.c() > 0) {
            IlvBlinkingManager.unregisterObject(this);
        }
        this.a((boolean)true).c = l2;
        if (this.b() && this.c() > 0) {
            IlvBlinkingManager.registerObject(this);
        }
        this.updateNeedsViewNotification();
        if (!this.b()) {
            this.a((boolean)true).e = true;
        }
    }

    @Override
    public long getBlinkingOnPeriod() {
        BlinkingInfo blinkingInfo = this.a(false);
        if (blinkingInfo == null) {
            return 0L;
        }
        return blinkingInfo.c;
    }

    public void setBlinkingOffPeriod(long l2) {
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 == this.getBlinkingOffPeriod()) {
            return;
        }
        if (this.b() && this.c() > 0) {
            IlvBlinkingManager.unregisterObject(this);
        }
        this.a((boolean)true).d = l2;
        if (this.b() && this.c() > 0) {
            IlvBlinkingManager.registerObject(this);
        }
        this.updateNeedsViewNotification();
        if (!this.b()) {
            this.a((boolean)true).e = true;
        }
    }

    @Override
    public long getBlinkingOffPeriod() {
        BlinkingInfo blinkingInfo = this.a(false);
        if (blinkingInfo == null) {
            return 0L;
        }
        return blinkingInfo.d;
    }

    private boolean b() {
        return this.getBlinkingOnPeriod() > 0L && this.getBlinkingOffPeriod() > 0L;
    }

    @Override
    public final void blinkingStateOn(boolean bl) {
        this.a((boolean)true).e = bl;
    }

    @Override
    public IlvBlinkingObjectOwner getBlinkingObjectOwner() {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        while (ilvGraphicBag != null) {
            if (ilvGraphicBag instanceof IlvManager) {
                return (IlvManager)ilvGraphicBag;
            }
            if (!(ilvGraphicBag instanceof IlvGraphic)) {
                return null;
            }
            ilvGraphicBag = ((IlvGraphic)((Object)ilvGraphicBag)).getGraphicBag();
        }
        return null;
    }

    final boolean j() {
        BlinkingInfo blinkingInfo = this.a(false);
        if (blinkingInfo == null) {
            return true;
        }
        return blinkingInfo.e;
    }

    private BlinkingInfo a(boolean bl) {
        if (this.l == null && bl) {
            this.l = new BlinkingInfo();
            this.l.e = true;
            this.l.c = 0L;
            this.l.d = 0L;
        }
        return this.l;
    }

    public void setToolTipText(String string) {
        this.setProperty(s, string);
    }

    public String getToolTipText() {
        return (String)this.getProperty(s);
    }

    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getToolTipText();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.setProperty(t, jPopupMenu);
    }

    public JPopupMenu getPopupMenu() {
        Object object = this.getProperty(t);
        if (object instanceof JPopupMenu) {
            return (JPopupMenu)object;
        }
        return null;
    }

    public void setPopupMenuName(String string) {
        this.setProperty(t, string);
    }

    public String getPopupMenuName() {
        Object object = this.getProperty(t);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (jPopupMenu == null) {
            jPopupMenu = IlvPopupMenuManager.getRegisteredMenu(this.getPopupMenuName());
        }
        if (jPopupMenu != null) {
            IlvPopupMenuManager.setPopupMenuContext(jPopupMenu, new IlvPopupMenuContext(ilvPoint, null, this, ilvTransformer, ilvManagerView));
        }
        return jPopupMenu;
    }

    NamedProperties d(boolean bl) {
        NamedProperties namedProperties = (NamedProperties)this.getProperty(r);
        if (bl && namedProperties == null) {
            namedProperties = new NamedProperties();
            this.setProperty(r, namedProperties);
        }
        return namedProperties;
    }

    final HashMap f(boolean bl) {
        NamedProperties namedProperties = this.d(bl);
        if (namedProperties == null) {
            return null;
        }
        if (bl && namedProperties.a == null) {
            namedProperties.a = new HashMap(4);
        }
        return namedProperties.a;
    }

    private IlvListenerList b(boolean bl) {
        NamedProperties namedProperties = this.d(bl);
        if (namedProperties == null) {
            return null;
        }
        if (bl && namedProperties.b == null) {
            namedProperties.b = new IlvListenerList();
        }
        return namedProperties.b;
    }

    public void addNamedPropertyListener(NamedPropertyListener namedPropertyListener) {
        IlvListenerList ilvListenerList = this.b(true);
        ilvListenerList.add(namedPropertyListener);
    }

    public void removeNamedPropertyListener(NamedPropertyListener namedPropertyListener) {
        IlvListenerList ilvListenerList = this.b(false);
        if (ilvListenerList != null) {
            ilvListenerList.remove(namedPropertyListener);
            if (ilvListenerList.getListenerCount() == 0) {
                NamedProperties namedProperties = this.d(false);
                namedProperties.b = null;
            }
        }
    }

    private void a(IlvNamedProperty ilvNamedProperty, IlvNamedProperty ilvNamedProperty2) {
        if (ilvNamedProperty == null && ilvNamedProperty2 == null) {
            return;
        }
        IlvListenerList ilvListenerList = this.b(false);
        if (ilvListenerList != null) {
            NamedPropertyEvent namedPropertyEvent = new NamedPropertyEvent(this, ilvNamedProperty, ilvNamedProperty2);
            Object[] objectArray = ilvListenerList.getListenerList();
            int n2 = objectArray.length;
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                ((NamedPropertyListener)objectArray[i2]).propertyChanged(namedPropertyEvent);
            }
        }
    }

    public IlvNamedProperty setNamedProperty(IlvNamedProperty ilvNamedProperty) {
        HashMap hashMap = this.f(true);
        IlvNamedProperty ilvNamedProperty2 = (IlvNamedProperty)hashMap.get(ilvNamedProperty.getName());
        hashMap.put(ilvNamedProperty.getName(), ilvNamedProperty);
        this.a(ilvNamedProperty2, ilvNamedProperty);
        return ilvNamedProperty2;
    }

    public IlvNamedProperty getNamedProperty(String string) {
        HashMap hashMap = this.f(false);
        return hashMap != null ? (IlvNamedProperty)hashMap.get(string) : null;
    }

    public void removeNamedProperty(String string) {
        HashMap hashMap = this.f(false);
        if (hashMap != null) {
            IlvNamedProperty ilvNamedProperty = (IlvNamedProperty)hashMap.remove(string);
            this.a(ilvNamedProperty, null);
        }
    }

    public final boolean isInApplyToObject() {
        return this.o > 0;
    }

    public final boolean setInApplyToObject(boolean bl) {
        boolean bl2;
        boolean bl3 = bl ? ++this.o == 1 : (bl2 = --this.o == 0);
        if (this.o < 0) {
            this.o = 0;
        }
        return bl2;
    }

    private void c(boolean bl) {
        if (bl) {
            if (this.j == -10000) {
                this.j = 0;
                this.d();
                this.g();
            }
        } else if (this.j != -10000) {
            this.allViewsRemoved();
            this.j = -10000;
            this.k();
        }
    }

    protected void updateNeedsViewNotification() {
        this.c(this.needsViewNotification());
    }

    protected boolean needsViewNotification() {
        if (this.getBlinkingAction() != null) {
            return true;
        }
        if (this.a() != null) {
            return true;
        }
        return this.b();
    }

    private int c() {
        return this.j;
    }

    private void d() {
        this.j = 0;
        for (IlvGraphicBag ilvGraphicBag = this.getGraphicBag(); ilvGraphicBag != null; ilvGraphicBag = ilvGraphicBag.getGraphicBag()) {
            if (!(ilvGraphicBag instanceof IlvManager)) continue;
            IlvManager ilvManager = (IlvManager)ilvGraphicBag;
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                if (ilvManagerView == null) continue;
                this.viewAddedOrRemoved(ilvManagerView, true);
            }
        }
    }

    protected void viewAddedOrRemoved(IlvManagerView ilvManagerView, boolean bl) {
        if (bl) {
            if (ilvManagerView.c()) {
                ++this.j;
                if (this.j == 1) {
                    this.e();
                }
            }
        } else if (ilvManagerView.c()) {
            --this.j;
            if (this.j == 0) {
                this.f();
            }
        }
    }

    protected void allViewsRemoved() {
        boolean bl = this.j > 0;
        this.j = 0;
        if (bl) {
            this.f();
        }
    }

    private void e() {
        ArrayList<IlvBlinkingDrawingResource> arrayList;
        IlvBlinkingAction ilvBlinkingAction;
        if (this.b()) {
            IlvBlinkingManager.registerObject(this);
        }
        if ((ilvBlinkingAction = this.getBlinkingAction()) != null) {
            ilvBlinkingAction.notifyUsed(this, true);
        }
        if ((arrayList = this.a()) != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.get(i2).notifyUsed(this, true);
            }
        }
    }

    private void f() {
        ArrayList<IlvBlinkingDrawingResource> arrayList;
        IlvBlinkingAction ilvBlinkingAction;
        if (this.b()) {
            IlvBlinkingManager.unregisterObject(this);
        }
        if ((ilvBlinkingAction = this.getBlinkingAction()) != null) {
            ilvBlinkingAction.notifyUsed(this, false);
        }
        if ((arrayList = this.a()) != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.get(i2).notifyUsed(this, false);
            }
        }
    }

    private void g() {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver) {
            if (this.k == null) {
                this.k = new Listener();
            }
            if (this.k.a) {
                return;
            }
            ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            managerViewsHierarchyEventReceiver.addManagerViewsHierarchyListener(this.k);
            this.k.a = true;
        }
    }

    private void k() {
        if (this.k == null) {
            return;
        }
        if (!this.k.a) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver) {
            ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            managerViewsHierarchyEventReceiver.removeManagerViewsHierarchyListener(this.k);
            this.k.a = false;
            this.k.a();
        }
    }

    private static class BlinkingInfo {
        IlvBlinkingAction a;
        ArrayList<IlvBlinkingDrawingResource> b;
        long c;
        long d;
        transient boolean e;

        private BlinkingInfo() {
        }
    }

    private class Listener
    implements ManagerViewsChangedListener {
        boolean a = false;

        private Listener() {
        }

        public void viewChanged(ManagerViewsChangedEvent managerViewsChangedEvent) {
            IlvManagerView ilvManagerView = managerViewsChangedEvent.getManagerView();
            if (managerViewsChangedEvent.getType() == 1) {
                IlvGraphic.this.viewAddedOrRemoved(ilvManagerView, true);
            } else if (managerViewsChangedEvent.getType() == 2) {
                IlvGraphic.this.viewAddedOrRemoved(ilvManagerView, false);
            }
        }

        void a() {
            if (this.a) {
                return;
            }
            IlvGraphic.this.k = null;
        }
    }

    static final class NamedProperties {
        HashMap a;
        IlvListenerList b;

        NamedProperties() {
        }
    }
}

