/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvResizableManagerFrame;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.java2d.IlvG2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class IlvDefaultManagerFrame
implements IlvResizableManagerFrame,
Serializable,
IlvPersistentObject {
    private static final float a = 5.0f;
    private static final boolean b = true;
    private static final boolean c = false;
    private static final float d = 1.0f;
    private static final float e = 2.0f;
    private static final Color f = Color.white;
    private static final Color g = Color.white;
    private static final Color h = Color.black;
    private static final Font i = new Font("Dialog", 0, 12);
    private static final double j = 0.0;
    private static final double k = Double.MAX_VALUE;
    private static final float l = 0.0f;
    private static final Color m = Color.darkGray;
    private static final int n = 10;
    private static final float o = IlvUtil.GetDeltaLine();
    public static final int LEFT = 1;
    public static final int CENTER = 16;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int WRAPPED = 128;
    private static final int p = 1;
    private float q = 5.0f;
    private float r = 5.0f;
    private float s = 5.0f;
    private float t = 5.0f;
    private boolean u = true;
    private Color v = h;
    private Paint w = g;
    private Paint x = m;
    private float y = 0.0f;
    private int z = 10;
    private boolean aa = false;
    private Font ab = i;
    private Color ac = f;
    private int ad = 1;
    private double ae = 0.0;
    private double af = Double.MAX_VALUE;
    private String ag = null;
    private transient float ah = -1.0f;
    private transient String ai = null;
    private transient double aj = 0.0;
    private transient float ak = -1.0f;
    private static IlvTransformer al = new IlvTransformer();

    public IlvDefaultManagerFrame() {
    }

    public IlvDefaultManagerFrame(IlvDefaultManagerFrame ilvDefaultManagerFrame) {
        this.q = ilvDefaultManagerFrame.q;
        this.r = ilvDefaultManagerFrame.r;
        this.s = ilvDefaultManagerFrame.s;
        this.t = ilvDefaultManagerFrame.t;
        this.u = ilvDefaultManagerFrame.u;
        this.v = ilvDefaultManagerFrame.v;
        this.w = ilvDefaultManagerFrame.w;
        this.x = ilvDefaultManagerFrame.x;
        this.y = ilvDefaultManagerFrame.y;
        this.z = ilvDefaultManagerFrame.z;
        this.aa = ilvDefaultManagerFrame.aa;
        this.ab = ilvDefaultManagerFrame.ab;
        this.ac = ilvDefaultManagerFrame.ac;
        this.ad = ilvDefaultManagerFrame.ad;
        this.ag = ilvDefaultManagerFrame.ag;
        this.ae = ilvDefaultManagerFrame.ae;
        this.af = ilvDefaultManagerFrame.af;
    }

    public IlvManagerFrame copy() {
        return new IlvDefaultManagerFrame(this);
    }

    public IlvDefaultManagerFrame(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        try {
            this.q = ilvInputStream.readFloat("topMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.s = ilvInputStream.readFloat("leftMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.r = ilvInputStream.readFloat("bottomMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.t = ilvInputStream.readFloat("rightMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.w = IlvUtility2D.readPaint(ilvInputStream);
        try {
            this.v = ilvInputStream.readColor("foreground");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.aa = ilvInputStream.readBoolean("showingTitle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ac = ilvInputStream.readColor("titleColor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ab = ilvInputStream.readFont("font");
        }
        catch (IlvReadFileException ilvReadFileException) {
            // empty catch block
        }
        try {
            this.ad = ilvInputStream.readInt("justification");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.u = ilvInputStream.readBoolean("opaque");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ag = ilvInputStream.readString("title");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.ae = ilvInputStream.readDouble("minTitle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.af = ilvInputStream.readDouble("maxTitle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.x = IlvUtility2D.readPaint(ilvInputStream, "shadowPaint", "shadow");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.y = ilvInputStream.readFloat("shadowThickness");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.z = ilvInputStream.readInt("shadowPosition");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        if (this.q != 5.0f) {
            ilvOutputStream.write("topMargin", this.q);
        }
        if (this.s != 5.0f) {
            ilvOutputStream.write("leftMargin", this.s);
        }
        if (this.r != 5.0f) {
            ilvOutputStream.write("bottomMargin", this.r);
        }
        if (this.t != 5.0f) {
            ilvOutputStream.write("rightMargin", this.t);
        }
        IlvUtility2D.writePaint(ilvOutputStream, this.w);
        if (!h.equals(this.v)) {
            ilvOutputStream.write("foreground", this.v);
        }
        if (this.aa) {
            ilvOutputStream.write("showingTitle", this.aa);
        }
        if (!f.equals(this.ac)) {
            ilvOutputStream.write("titleColor", this.ac);
        }
        if (!i.equals(this.ab)) {
            ilvOutputStream.write("font", this.ab);
        }
        if (this.ad != 1) {
            ilvOutputStream.write("justification", this.ad);
        }
        if (!this.u) {
            ilvOutputStream.write("opaque", this.u);
        }
        if (this.ag != null) {
            ilvOutputStream.write("title", this.ag);
        }
        if (this.ae != 0.0) {
            ilvOutputStream.write("minTitle", this.ae);
        }
        if (this.af != Double.MAX_VALUE) {
            ilvOutputStream.write("maxTitle", this.af);
        }
        if (!m.equals(this.x)) {
            IlvUtility2D.writePaint(ilvOutputStream, this.x, "shadowPaint", "shadow", m);
        }
        if (this.y != 0.0f) {
            ilvOutputStream.write("shadowThickness", this.y);
        }
        if (this.z != 10) {
            ilvOutputStream.write("shadowPosition", this.z);
        }
    }

    public float getTopMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        float f2 = (float)(ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor());
        float f3 = this.getTopMargin() * f2;
        if ((this.getTitleJustification() & 8) == 0) {
            f3 += this.getTitleHeight(ilvManager, ilvTransformer);
        }
        if ((this.getShadowPosition() & 4) != 0) {
            f3 += this.getShadowThickness() * f2;
        }
        return f3;
    }

    void a() {
        this.ah = -1.0f;
    }

    public boolean moveResize(IlvManager ilvManager, IlvRect ilvRect) {
        this.a();
        return false;
    }

    public void managerChanged(IlvManager ilvManager) {
        this.a();
    }

    protected double checkZoomFactor(IlvTransformer ilvTransformer) {
        double d2;
        double d3 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        if (d3 > (d2 = this.getMaxTitleZoomFactor())) {
            d3 = d2;
        } else {
            double d4 = this.getMinTitleZoomFactor();
            if (d3 < d4) {
                d3 = d4;
            }
        }
        return d3;
    }

    public float getTitleHeight(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        Object object;
        Cloneable cloneable;
        float f2;
        if (!this.isShowingTitle()) {
            return 0.0f;
        }
        double d2 = this.checkZoomFactor(ilvTransformer);
        String string = this.getTitle(ilvManager);
        if (string == null || string.length() == 0) {
            return 2.0f;
        }
        float f3 = 0.0f;
        if (!this.b()) {
            if (this.ah != -1.0f && string.equals(this.ai) && this.aj == d2) {
                return this.ah;
            }
        } else {
            f2 = (float)(ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor());
            cloneable = ilvManager.getTransformer();
            cloneable.compose(ilvTransformer);
            object = ilvManager.computeBBox((IlvTransformer)cloneable, true);
            f3 = ((Rectangle2D.Float)object).width + this.getLeftMargin(ilvManager, ilvTransformer) + this.getRightMargin(ilvManager, ilvTransformer) - this.getShadowThickness() * f2 - 1.0f;
            f3 = Math.max(2.0f, f3 - 4.0f - 2.0f);
            if (this.ah != -1.0f && string.equals(this.ai) && this.aj == d2 && this.ak == f3) {
                return this.ah;
            }
        }
        f2 = 0.0f;
        cloneable = new AffineTransform(d2, 0.0, 0.0, d2, 0.0, 0.0);
        object = new FontRenderContext((AffineTransform)cloneable, true, false);
        Font font = this.getFont().deriveFont((AffineTransform)cloneable);
        if (this.b()) {
            Paragraph paragraph = new Paragraph(string, font, (FontRenderContext)object, f3);
            f2 = 2.0f;
            TextLayout textLayout = paragraph.a();
            while (textLayout != null) {
                f2 += textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
                textLayout = paragraph.a();
            }
        } else {
            TextLayout textLayout = new TextLayout(string, font, (FontRenderContext)object);
            f2 += textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            f2 += 2.0f;
        }
        this.ah = f2;
        this.ai = string;
        this.aj = d2;
        this.ak = f3;
        return f2;
    }

    public float getTopMargin() {
        return this.q;
    }

    public void setTopMargin(float f2) {
        this.q = f2;
    }

    public float getBottomMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        float f2 = (float)(ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor());
        float f3 = this.getBottomMargin() * f2;
        if ((this.getTitleJustification() & 8) == 8) {
            f3 += this.getTitleHeight(ilvManager, ilvTransformer);
        }
        if ((this.getShadowPosition() & 8) != 0) {
            f3 += this.getShadowThickness() * f2;
        }
        return f3;
    }

    public float getBottomMargin() {
        return this.r;
    }

    public void setBottomMargin(float f2) {
        this.r = f2;
    }

    public float getRightMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        float f2 = (float)(ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor());
        float f3 = this.getRightMargin() * f2;
        if ((this.getShadowPosition() & 2) != 0) {
            f3 += this.getShadowThickness() * f2;
        }
        return f3;
    }

    public float getRightMargin() {
        return this.t;
    }

    public void setRightMargin(float f2) {
        this.t = f2;
        this.a();
    }

    public float getLeftMargin(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        float f2 = (float)(ilvTransformer == null ? 1.0 : ilvTransformer.zoomFactor());
        float f3 = this.getLeftMargin() * f2;
        if ((this.getShadowPosition() & 1) != 0) {
            f3 += this.getShadowThickness() * f2;
        }
        return f3;
    }

    public float getLeftMargin() {
        return this.s;
    }

    public void setLeftMargin(float f2) {
        this.s = f2;
        this.a();
    }

    public boolean isOpaque(IlvManager ilvManager) {
        return this.u;
    }

    public boolean isOpaque() {
        return this.u;
    }

    public void setOpaque(boolean bl) {
        this.u = bl;
    }

    public Color getTitleColor() {
        return this.ac;
    }

    public void setTitleColor(Color color) {
        this.ac = color;
    }

    public Font getFont() {
        return this.ab;
    }

    public void setFont(Font font) {
        this.ab = font;
        this.a();
    }

    public Paint getBackground() {
        return this.w;
    }

    public void setBackground(Paint paint) {
        this.w = paint;
    }

    public Color getForeground() {
        return this.v;
    }

    public void setForeground(Color color) {
        this.v = color;
    }

    public boolean isShowingTitle() {
        return this.aa;
    }

    public void setShowingTitle(boolean bl) {
        this.aa = bl;
    }

    public void setTitleJustification(int n2) {
        int n3 = n2 & 0xFFFFFF73;
        if (n3 != 16 && n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("bad value");
        }
        if (((this.ad ^ n2) & 0x80) != 0) {
            this.a();
        }
        this.ad = n2;
    }

    public int getTitleJustification() {
        return this.ad;
    }

    boolean b() {
        return (this.getTitleJustification() & 0x80) == 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        Shape shape = graphics.getClip();
        this.drawShadow(ilvManager, ilvRect, graphics, ilvTransformer);
        ilvRect = this.a(ilvRect, ilvTransformer);
        if (this.getShadowThickness() > 0.0f) {
            graphics.clipRect((int)ilvRect.x - 2, (int)ilvRect.y - 2, (int)ilvRect.width + 4, (int)ilvRect.height + 4);
        }
        IlvRect ilvRect2 = new IlvRect();
        IlvTransformer ilvTransformer2 = null;
        IlvTransformer ilvTransformer3 = al;
        synchronized (ilvTransformer3) {
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvRect2.setRect(ilvRect);
                ilvTransformer.inverse(ilvRect2);
                ilvTransformer2 = al;
                IlvTransformer.computeTransformer(ilvRect2, ilvRect, ilvTransformer2);
            } else {
                al.setValues(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                ilvTransformer2 = al;
            }
            if (this.isShowingTitle()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                float f2 = this.getTitleHeight(ilvManager, ilvTransformer);
                if (this.isOpaque(ilvManager)) {
                    if ((this.getTitleJustification() & 8) == 8) {
                        ilvRect2.setRect(ilvRect.x + 1.0f, ilvRect.y + 1.0f, ilvRect.width - 1.0f, ilvRect.height - f2 - 1.0f);
                    } else {
                        ilvRect2.setRect(ilvRect.x + 1.0f, ilvRect.y + f2 + 1.0f, ilvRect.width - 1.0f, ilvRect.height - f2 - 1.0f);
                    }
                    this.drawBackground(ilvManager, ilvRect2, graphics2D, ilvTransformer2);
                }
                float f3 = ilvRect.y;
                f3 = (this.getTitleJustification() & 8) == 8 ? (f3 += ilvRect.height - f2) : (f3 += 1.0f);
                ilvRect2.setRect(ilvRect.x + 1.0f, f3, ilvRect.width - 1.0f, f2);
                this.drawTitleBackground(ilvManager, ilvRect2, graphics2D, ilvTransformer2);
                this.drawTitleText(ilvManager, ilvRect2, graphics2D, ilvTransformer2);
            } else if (this.isOpaque(ilvManager)) {
                ilvRect2.setRect(ilvRect.x + 1.0f, ilvRect.y + 1.0f, ilvRect.width - 1.0f, ilvRect.height - 1.0f);
                this.drawBackground(ilvManager, ilvRect2, graphics, ilvTransformer);
            }
            this.drawOutline(ilvManager, ilvRect, graphics, ilvTransformer);
        }
        graphics.setClip(shape);
    }

    private float a(float f2, float f3, float f4) {
        float f5 = f2;
        switch (this.getTitleJustification() & 0x13) {
            case 1: {
                f5 += 2.0f;
                break;
            }
            case 2: {
                f5 += f3 - f4 - 2.0f;
                break;
            }
            case 16: {
                f5 += 2.0f + (f3 - f4) / 2.0f;
            }
        }
        return f5;
    }

    protected void drawTitleText(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        double d2 = this.checkZoomFactor(ilvTransformer);
        AffineTransform affineTransform = new AffineTransform(d2, 0.0, 0.0, d2, 0.0, 0.0);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.getTitleColor());
        Font font = this.getFont().deriveFont(affineTransform);
        String string = this.getTitle(ilvManager);
        if (string == null || string.length() == 0) {
            return;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, false);
        double d3 = font.getStringBounds(string, fontRenderContext).getWidth();
        float f2 = ilvRect.width - 4.0f - 2.0f;
        if (!this.b() || d3 <= (double)f2) {
            float f3 = this.a(ilvRect.x, ilvRect.width, (float)d3);
            graphics2D.setFont(font);
            float f4 = font.getLineMetrics(string, fontRenderContext).getAscent();
            graphics2D.drawString(string, f3, ilvRect.y + f4);
        } else {
            float f5 = Math.max(2.0f, f2);
            Paragraph paragraph = new Paragraph(string, font, fontRenderContext, f5);
            float f6 = ilvRect.y + 1.0f;
            TextLayout textLayout = paragraph.a();
            while (textLayout != null) {
                float f7 = this.a(ilvRect.x, f5, textLayout.getAdvance());
                textLayout.draw(graphics2D, f7, f6 += textLayout.getAscent());
                f6 += textLayout.getLeading() + textLayout.getDescent();
                textLayout = paragraph.a();
            }
        }
    }

    protected void drawTitleBackground(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        int n2 = ilvRect.xFloor();
        int n3 = ilvRect.yFloor();
        int n4 = ilvRect.widthFloor();
        int n5 = ilvRect.heightFloor();
        graphics.setColor(this.getForeground());
        graphics.fillRect(n2, n3, n4, n5);
    }

    protected void drawBackground(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        int n2 = ilvRect.xFloor();
        int n3 = ilvRect.yFloor();
        int n4 = ilvRect.widthFloor();
        int n5 = ilvRect.heightFloor();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = this.getBackground();
        if (paint instanceof Color) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(IlvUtility2D.AdaptPaint(ilvRect, paint));
        }
        IlvG2D.fillRect(graphics2D, n2, n3, n4, n5);
    }

    protected void drawOutline(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        int n2 = ilvRect.xFloor();
        int n3 = ilvRect.yFloor();
        int n4 = ilvRect.widthFloor();
        int n5 = ilvRect.heightFloor();
        graphics.setColor(this.getForeground());
        graphics.drawRect(n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawShadow(IlvManager ilvManager, IlvRect ilvRect, Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getShadowThickness();
        if (f2 <= 0.0f) {
            return;
        }
        if (ilvTransformer != null) {
            f2 = (float)((double)f2 * ilvTransformer.zoomFactor());
        }
        Paint paint = IlvUtility2D.AdaptPaint(ilvRect, this.getShadowPaint());
        IlvRect ilvRect2 = this.a(ilvRect, f2);
        IlvRect ilvRect3 = this.b(ilvRect, f2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint2 = graphics2D.getPaint();
        try {
            graphics2D.setPaint(paint);
            IlvG2D.fill(graphics2D, ilvRect2);
            IlvG2D.fill(graphics2D, ilvRect3);
        }
        finally {
            graphics2D.setPaint(paint2);
        }
    }

    private IlvRect a(IlvRect ilvRect, float f2) {
        IlvRect ilvRect2 = null;
        switch (this.getShadowPosition()) {
            case 5: {
                ilvRect2 = new IlvRect(ilvRect.x, ilvRect.y, ilvRect.width - f2, f2);
                break;
            }
            case 6: {
                ilvRect2 = new IlvRect(ilvRect.x + f2, ilvRect.y, ilvRect.width - f2, f2);
                break;
            }
            case 9: {
                ilvRect2 = new IlvRect(ilvRect.x, ilvRect.y + ilvRect.height - f2, ilvRect.width - f2, f2);
                break;
            }
            case 10: {
                ilvRect2 = new IlvRect(ilvRect.x + f2, ilvRect.y + ilvRect.height - f2, ilvRect.width - f2, f2);
            }
        }
        return ilvRect2;
    }

    private IlvRect b(IlvRect ilvRect, float f2) {
        IlvRect ilvRect2 = null;
        switch (this.getShadowPosition()) {
            case 5: {
                ilvRect2 = new IlvRect(ilvRect.x, ilvRect.y, f2, ilvRect.height - f2);
                break;
            }
            case 6: {
                ilvRect2 = new IlvRect(ilvRect.x + ilvRect.width - f2, ilvRect.y, f2, ilvRect.height - f2);
                break;
            }
            case 9: {
                ilvRect2 = new IlvRect(ilvRect.x, ilvRect.y + f2, f2, ilvRect.height - f2);
                break;
            }
            case 10: {
                ilvRect2 = new IlvRect(ilvRect.x + ilvRect.width - f2, ilvRect.y + f2, f2, ilvRect.height - f2);
            }
        }
        return ilvRect2;
    }

    private IlvRect a(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        float f2 = this.getShadowThickness();
        if (f2 <= 0.0f) {
            return ilvRect;
        }
        if (ilvTransformer != null) {
            f2 = (float)((double)f2 * ilvTransformer.zoomFactor());
        }
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        ilvRect2.width -= f2;
        ilvRect2.height -= f2;
        switch (this.getShadowPosition()) {
            case 5: {
                ilvRect2.x += f2;
                ilvRect2.y += f2;
                break;
            }
            case 6: {
                ilvRect2.y += f2;
                break;
            }
            case 9: {
                ilvRect2.x += f2;
                break;
            }
        }
        return ilvRect2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(IlvManager ilvManager, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = ilvManager.boundingBox(ilvTransformer);
        float f2 = this.getShadowThickness();
        if (f2 > 0.0f) {
            if (ilvTransformer != null) {
                f2 *= (float)ilvTransformer.zoomFactor();
            }
            IlvRect ilvRect2 = this.a(ilvRect, f2);
            IlvRect ilvRect3 = this.b(ilvRect, f2);
            if (ilvRect2.inside(ilvPoint2.x, ilvPoint2.y)) {
                return true;
            }
            if (ilvRect3.inside(ilvPoint2.x, ilvPoint2.y)) {
                return true;
            }
            ilvRect = this.a(ilvRect, ilvTransformer);
        }
        ilvRect.expand(o);
        if (!ilvRect.inside(ilvPoint2.x, ilvPoint2.y)) {
            return false;
        }
        ilvRect.expand(-2.0f * o);
        float f3 = this.isShowingTitle() ? this.getTitleHeight(ilvManager, ilvTransformer) : 0.0f;
        boolean bl = (this.getTitleJustification() & 8) == 0;
        boolean bl2 = (this.getTitleJustification() & 8) == 8;
        if (ilvPoint2.x < ilvRect.x) return true;
        if (ilvPoint2.x > ilvRect.x + ilvRect.width) return true;
        if (ilvPoint2.y < ilvRect.y + (bl ? f3 : 0.0f)) return true;
        float f4 = ilvPoint2.y;
        float f5 = ilvRect.y + ilvRect.height;
        float f6 = bl2 ? f3 : 0.0f;
        if (!(f4 > f5 - f6)) return false;
        return true;
    }

    protected String getTitle(IlvManager ilvManager) {
        if (this.ag != null) {
            return this.ag;
        }
        String string = ilvManager.getName();
        if (string != null) {
            return string;
        }
        return IlvResourceUtil.getString("IlvDefaultManagerFrame.untitled", IlvDefaultManagerFrame.class);
    }

    public void setTitle(String string) {
        this.ag = string;
    }

    public String getTitle() {
        return this.ag;
    }

    public double getMinTitleZoomFactor() {
        return this.ae;
    }

    public void setMinTitleZoomFactor(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Zoom Factor can't be negative");
        }
        if (d2 > this.getMaxTitleZoomFactor()) {
            throw new IllegalArgumentException("Minimum have to be smaller than Maximum");
        }
        this.ae = d2;
    }

    public double getMaxTitleZoomFactor() {
        return this.af;
    }

    public void setMaxTitleZoomFactor(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Zoom Factor can't be negative");
        }
        if (d2 < this.getMinTitleZoomFactor()) {
            throw new IllegalArgumentException("Maximum have to be greater than Minimum");
        }
        this.af = d2;
    }

    public float getShadowThickness() {
        return this.y;
    }

    public void setShadowThickness(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Shadow thickness can't be negative");
        }
        this.y = f2;
    }

    public int getShadowPosition() {
        return this.z;
    }

    public void setShadowPosition(int n2) {
        if (n2 != 5 && n2 != 9 && n2 != 6 && n2 != 10) {
            throw new IllegalArgumentException("bad position");
        }
        this.z = n2;
    }

    public Paint getShadowPaint() {
        return this.x;
    }

    public void setShadowPaint(Paint paint) {
        if (paint == null) {
            paint = m;
        }
        this.x = paint;
    }

    private static class Paragraph {
        transient float a;
        transient LineBreakMeasurer b;
        transient int c;

        Paragraph(String string, Font font, FontRenderContext fontRenderContext, float f2) {
            this.a = f2;
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            int n2 = attributedCharacterIterator.getBeginIndex();
            this.c = attributedCharacterIterator.getEndIndex();
            this.b = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            this.b.setPosition(n2);
        }

        TextLayout a() {
            if (this.b.getPosition() < this.c) {
                return this.b.nextLayout(this.a);
            }
            return null;
        }
    }
}

