/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSchemaObjAccessor;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.NodeList;

public class XMLTriggerAccessor
extends XMLSchemaObjAccessor {
    private static final short BEFORE_TRIGGER = 0;
    private static final short AFTER_TRIGGER = 1;
    private static final short INSTEADOF_TRIGGER = 2;
    private static String TRIGGER = "TRIGGER";
    private static String BEFORE = "BEFORE";
    private static String AFTER = "AFTER";
    private static String INSTEAD_OF = "INSTEAD OF";
    private static String X_SCHEMA = "sxml:SCHEMA";
    private static String X_OBJECT_NAME = "sxml:DML_EVENT/sxml:NAME";
    private static String X_OBJECT_OWNER = "sxml:DML_EVENT/sxml:SCHEMA";
    private static String X_DML_EVENT_LIST_ITEM = "sxml:DML_EVENT/sxml:EVENT_LIST/sxml:EVENT_LIST_ITEM";
    private static String X_TRIGGER_BODY = "sxml:PLSQL_BLOCK";
    private static String X_TRIGGER_TYPE = "sxml:TRIGGER_TYPE";
    private static String X_CONDITION = "sxml:WHEN_CONDITION";
    private static String X_FOR_EACH_ROW = "sxml:DML_EVENT/sxml:REFERENCING/sxml:FOR_EACH_ROW";
    private static String X_DISABLE = "sxml:DISABLE";
    private static String X_OLD_REFERENCE = "sxml:DML_EVENT/sxml:REFERENCING/sxml:OLD_AS";
    private static String X_NEW_REFERENCE = "sxml:DML_EVENT/sxml:REFERENCING/sxml:NEW_AS";
    private static String X_COL_LIST = "sxml:DML_EVENT/sxml:EVENT_LIST/sxml:EVENT_LIST_ITEM/sxml:COL_LIST/sxml:COL_LIST_ITEM";
    private static String X_EVENT = "sxml:EVENT";

    protected XMLTriggerAccessor() {
    }

    protected XMLTriggerAccessor(XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        super(xmlNode, client);
    }

    public Vector getSQLVector() throws XMLAccessorException {
        Vector<String> sqlVector = new Vector<String>();
        int flags = this.getAccessorClient().getSXMLToDDLTransformParamFlags(this.getObjType());
        String[] sqls = this.generateDDLs(flags);
        for (int i = 0; sqls != null && i < sqls.length; ++i) {
            sqlVector.add(sqls[i]);
        }
        return sqlVector;
    }

    @Override
    public void applySchemaMap(HashMap schemaMap, int changeMode) {
        super.applySchemaMap(schemaMap, changeMode);
        String onSchema = this.getOnSchema();
        if (onSchema != null && schemaMap.containsKey(onSchema)) {
            this.setOnSchema((String)schemaMap.get(onSchema), changeMode);
        }
    }

    public String getSchemaName() {
        return this.getSchema();
    }

    public String getOnSchema() {
        return this.selectTextValue(X_OBJECT_OWNER);
    }

    public void setOnSchema(String schema) {
        this.setTextValue(X_OBJECT_OWNER, schema);
    }

    private void setOnSchema(String schema, int changeMode) {
        this.setTextValue(X_OBJECT_OWNER, schema, changeMode);
    }

    public String getOnObject() {
        return this.selectTextValue(X_OBJECT_NAME);
    }

    public void setOnObject(String onObject) {
        this.setTextValue(X_OBJECT_NAME, onObject);
    }

    public String getOnObjectType() {
        return null;
    }

    public boolean isEnable() {
        return !this.nodeExists(X_DISABLE);
    }

    public boolean getEnabled() {
        return this.isEnable();
    }

    public String getTriggerBody() {
        return this.selectTextValue(X_TRIGGER_BODY);
    }

    public short getBeforeAfterInsteadof() {
        String sn = this.selectTextValue(X_TRIGGER_TYPE);
        if (BEFORE.equals(sn)) {
            return 0;
        }
        if (AFTER.equals(sn)) {
            return 1;
        }
        if (INSTEAD_OF.equals(sn)) {
            return 2;
        }
        return -1;
    }

    public String getSource() {
        return null;
    }

    public boolean isForEachRow() {
        return this.nodeExists(X_FOR_EACH_ROW);
    }

    public String getOldRef() {
        return this.selectTextValue(X_OLD_REFERENCE);
    }

    public String getNewRef() {
        return this.selectTextValue(X_NEW_REFERENCE);
    }

    public String getCondition() {
        return this.selectTextValue(X_CONDITION);
    }

    public String getUpdateInsertDelete() {
        StringBuffer events = new StringBuffer();
        NodeList eventList = this.selectNodes(X_DML_EVENT_LIST_ITEM);
        if (eventList != null && eventList.getLength() > 0) {
            boolean first = true;
            for (int i = 0; i < eventList.getLength(); ++i) {
                if (!first) {
                    events.append(" OR ");
                }
                events.append(XMLTriggerAccessor.selectTextValue((XMLNode)eventList.item(i), X_EVENT));
                first = false;
            }
        }
        return events.toString();
    }

    public String getColumnList() {
        String cols = null;
        NodeList colList = this.selectNodes(X_COL_LIST);
        if (colList != null && colList.getLength() > 0) {
            StringBuffer colSB = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < colList.getLength(); ++i) {
                if (!first) {
                    colSB.append(", ");
                }
                colSB.append(XMLTriggerAccessor.selectTextValue((XMLNode)colList.item(i), X_NAME));
                first = false;
            }
            cols = colSB.toString();
        }
        return cols;
    }

    @Override
    protected String getTypePathElement() {
        return TRIGGER;
    }

    @Override
    protected boolean isPLSQLType() {
        return true;
    }

    @Override
    public String toString() {
        String tTypeStr;
        short tType = this.getBeforeAfterInsteadof();
        switch (tType) {
            case 0: {
                tTypeStr = BEFORE;
                break;
            }
            case 1: {
                tTypeStr = AFTER;
                break;
            }
            case 2: {
                tTypeStr = INSTEAD_OF;
                break;
            }
            default: {
                tTypeStr = "Unknown";
            }
        }
        return super.toString() + "  Trigger Type: " + tTypeStr + "\n" + "  Action(s): " + this.getUpdateInsertDelete() + "\n" + "  Column(s): " + this.nin(this.getColumnList()) + "\n" + "  OnObject Schema: " + this.getOnSchema() + "\n" + "  OnObject Name: " + this.getOnObject() + "\n" + "  Referencing old as: " + this.nin(this.getOldRef()) + "\n" + "  Referencing nex as: " + this.nin(this.getNewRef()) + "\n" + "  For each row: " + XMLTriggerAccessor.YorN(this.isForEachRow()) + "\n" + "  Condition: " + this.nin(this.getCondition()) + "\n" + "  Body: " + this.getTriggerBody() + "\n";
    }
}

